Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../graph".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun tuple.


Require Export Cover.
Require Export Prog.
Require Export Ccpo.


Require Import my_alea.
Require Import my_ssr.
Require Import labelling.


Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

Open Local Scope U_scope.
Open Local Scope O_scope.

(** * Introduction
  
           Proof of termination of a randomised distributed algorithm (not necessarily a Las Vegas). 
           Part of this proof is from Alea Library of C. Paulin. 
   *)

Section termfglobal.
Variable (V: finType) (VLabel: eqType).
Variables (Locat:finType) (LLabel:eqType).

Let VState := LabelFunc V VLabel.
Let LState := LabelFunc Locat LLabel.

Variable rd  : VState * LState -> distr (VState*LState).

Hypothesis localTerm : forall s,
   Term (rd s).

Variable termB : VState * LState  -> bool.

Instance FGlobal_mon  :
 monotonic (fun f (s:VState*LState) =>
   if (termB s) then Munit (s)
   else Mlet (rd s) (fun r => f r)).
Proof.
 red; intros x y h s.
case (termB s);auto.
Qed.

Definition FGlobal  :=
 mon (fun f (s:VState*LState) =>
  if (termB s) then (Munit s) else
  (Mlet (rd s) (fun r => f r))).

Lemma FGlobal_simpl : forall f (s:VState *LState),
 FGlobal f s =
 if (termB s) then Munit s 
 else Mlet (rd s) (fun r => f r).
Proof.
 trivial.
Qed.

Definition fglobal :  (VState*LState) -> distr (VState*LState) :=
 Mfix (FGlobal).





Variable cardTermB : VState * LState  -> nat.

Variable c: U. 
Definition k := [1-]c. 

Hypothesis hcard1 : forall s, (cardTermB s) = O -> termB s = true.

Hypothesis hcard2: 0 < c.

Lemma hcard2' : k < 1. 
Proof. 
now apply Uinv_lt_one.
Qed. 

Variable (PR : VState*LState -> bool). 

Hypothesis hcard3 :  forall (s:VState*LState), 
 (0 < (cardTermB s))%nat ->
 PR s ->  
 c <= mu (rd s) 
   (fun x => B2U (lt_dec (cardTermB x) (cardTermB s))).

Lemma hcard3' : forall (s:VState*LState), 
  (0 < (cardTermB s))%nat ->
 PR s ->
 mu (rd s)
  (finv (fun x:VState*LState => B2U (lt_dec (cardTermB x)  (cardTermB s)))) <= k.
Proof. 
intros.
apply Uinv_le_perm_right.
rewrite <-mu_one_inv;auto.
rewrite feq_finv_finv;auto.
Qed.

Hypothesis hcard4 :  forall (s:VState*LState), PR s ->
 mu (rd s)
  (fun x => B2U (lt_dec (cardTermB s) (cardTermB x))) ==  0.

Lemma hcard4' : forall (s:VState*LState ), PR s -> 
 mu (rd s) 
  (finv (fun x => B2U(lt_dec (cardTermB s) (cardTermB x)))) == 1.
Proof. 
intros.
apply Uinv_eq_perm_right.
rewrite <-mu_one_inv;auto.
rewrite feq_finv_finv.
by apply hcard4. 
Qed. 


Lemma hcardmu :  forall s, PR s -> 
 (mu (rd s)
    (finv (fun x => B2U (eq_nat_dec (cardTermB x) (cardTermB s))))) <= 
  (mu (rd s)
     (fun x  => B2U (lt_dec (cardTermB x) (cardTermB s)))).
Proof.
intros s HP. 
assert ( (mu (rd s))
 (fun x => B2U (lt_dec (cardTermB x) (cardTermB s))) ==
(mu (rd s))
 (fun x => (B2U (lt_dec  (cardTermB x) (cardTermB s))) +
    (B2U (lt_dec (cardTermB s)  (cardTermB x))))).
 setoid_rewrite mu_stable_plus. 
   rewrite hcard4=>//. now auto.  
 unfold fplusok;intro x.
 unfold finv.
 case ( lt_dec (cardTermB x) (cardTermB s));auto.
 case (lt_dec (cardTermB s) (cardTermB x));auto.
  intros h h';now destruct (lt_asym _ _ h).
rewrite H;clear H. 
apply mu_le_compat;auto. 
intro. unfold finv.
case  (eq_nat_dec (cardTermB x) (cardTermB s));auto. 
case  (lt_dec (cardTermB x) (cardTermB s));auto. 
case (lt_dec (cardTermB s) (cardTermB x));auto. 
move=>h h' h''. 
destruct (lt_eq_lt_dec  (cardTermB x) (cardTermB s)). 
destruct s0.
now destruct h.
now destruct h''.
now destruct h'.
Qed.

Lemma hcardmu' :  forall s, PR s -> 
(mu (rd s))
   (fun x  => B2U (eq_nat_dec (cardTermB x) (cardTermB s))) <=
 (mu (rd s))
   (finv (fun x => B2U (lt_dec (cardTermB x) (cardTermB s)))).
Proof.
intros. 
assert ( (mu (rd s)
 (finv (fun x => B2U (lt_dec (cardTermB x) (cardTermB s))))) ==
(mu (rd s)
     (fun x  => (B2U (eq_nat_dec (cardTermB x) (cardTermB s))) +
     (B2U (lt_dec (cardTermB s) (cardTermB x)))))).
 apply mu_eq_compat;auto.
 intro x;unfold finv.
 case ( lt_dec (cardTermB x) (cardTermB s))=>/=;auto;intro h.
 case (eq_nat_dec (cardTermB x) (cardTermB s))=>/=;intro h'.
  rewrite h' in h. now destruct (lt_irrefl (cardTermB s)).
 case (lt_dec (cardTermB s) (cardTermB x))=>/=;auto;intro h''.
 now (destruct (lt_asym _ _ h)).
 case (eq_nat_dec (cardTermB x) (cardTermB s));auto;intro h'.
 case (lt_dec (cardTermB s) (cardTermB x));auto;intro h''.
 destruct (lt_eq_lt_dec  (cardTermB x) (cardTermB s)). 
destruct s0.
now destruct h.
now destruct h''.
now destruct h'.
rewrite H0;clear H0.
apply mu_le_compat;auto.
Qed.


Lemma hcard5 : forall s a b, 
  (0 < (cardTermB s))%nat ->
 a <= b -> PR s ->
 k * a + [1-]k * b <= 
 mu (rd s) 
  (fun x=>B2U (eq_nat_dec (cardTermB x) (cardTermB s))) * a +
 mu (rd s) 
  (fun x => B2U (lt_dec (cardTermB x) (cardTermB s))) * b.
Proof. 
intros;
rewrite (bary_le_compat (mu (rd s)
  (fun x => B2U (eq_nat_dec (cardTermB x)(cardTermB s)))) k a b);  
auto.
apply Uplus_le_compat;auto.
rewrite <-mu_one_inv;auto.
Usimpl. apply hcardmu=>//. 
rewrite <-hcard3'.
apply hcardmu'.
done. done. done.   
Qed.


Fixpoint pw_ (x n : nat) : U := 
  match n with O => 0 
            | (S n) => match x with 
                         O => 1
                     | S y => k * pw_ x n + ([1-] k) * pw_ y n 
                       end
  end.

Lemma pw_decrS_x : forall n x, pw_ (S x) n <= pw_ x n.
induction n; simpl; intros; auto.
destruct x; auto.
Save.
Hint Resolve pw_decrS_x.

Lemma pw_decr_x : forall n x y, (x <= y)%nat -> pw_ y n <= pw_ x n.
induction n; simpl; intros; auto.
destruct x; auto. 
destruct y;auto. 
by move:H;rewrite ltn0.
Save.
Hint Resolve pw_decr_x.

Lemma pw_incr : forall x n, pw_ x n <= pw_ x (S n).
simpl; intros.
case x; auto.
Save.

Hint Resolve pw_incr.

Definition pw : nat -> nat -m> U 
    := fun x => fnatO_intro (pw_ x) (pw_incr x).

Lemma pw_pw_ : forall x n, pw x n = pw_ x n.
trivial.
Save.

Lemma pw_simpl : forall x n, pw x n = 
    match n with O => 0 
             | (S n) => match x with 
                          O => 1
                        | S y => k * pw x n + ([1-] k) * pw y n
                        end
    end.
destruct n; auto.
Save.

Lemma pwS_simpl : forall x n, pw (S x) (S n) = k * pw (S x) n + [1-]k * (pw x n).
trivial.
Save.


Lemma lim_pw_one : forall x, lub (pw x) == 1.
induction x.
apply Uge_one_eq.
transitivity (pw O (S O)); auto.
apply Umult_simpl_one with k; auto.
apply hcard2'. 
transitivity (mlub (seq_lift_left (pw (S x)) (S 0))).
transitivity (k * lub (pw (S x)) + [1-] k * lub (pw x)).
rewrite IHx; auto.
do 2 rewrite <- lub_eq_mult.
rewrite <- lub_eq_plus.
apply mlub_le_compat; intro n; auto.
rewrite <- mlub_lift_left; trivial.
Save.

Lemma termglobal : forall (s: VState*LState),
 PR s ->
(forall s f, PR s ->(mu (rd s))(fun x : VState * LState =>
           B2U (PR x) * (f x)) == (mu (rd s)) f) ->
 Term (fglobal s).
Proof.
intros s HPR HPRy.   
assert ( forall x : VState * LState, PR x -> 
   ok (lub (pw (cardTermB x))) (Mfix FGlobal x)
     (fun y : VState * LState => 1)); last first. 
 unfold Term;apply Uge_one_eq. 
 rewrite <- (lim_pw_one (cardTermB s)) at 1.
 exact (H s HPR).

apply Pfixrule;auto.
intros. unfold ok. 
rewrite FGlobal_simpl.
rewrite pw_simpl. 
case_eq (cardTermB x);intros. 
 apply hcard1 in H1. rewrite H1//=.
case_eq  (termB x);auto;intro htermB=>/=.
rewrite (@hcard5 x)=>//.

transitivity 
 (mu (rd x) (fplus (fun x0 => (B2U (eq_nat_dec (cardTermB x0) (cardTermB x))) * 
                   (mu (f x0) (fun _ => 1)))
  (fun x0 => (B2U (lt_dec (cardTermB x0) (cardTermB x))) *
  (mu (f x0)) (fun _ => 1))));last first.

apply mu_le_compat;auto.
 unfold fplus;intro y.  
 do 2 rewrite <-mu_stable_mult.
 rewrite <-mu_stable_plus; auto.
 unfold fplusok,ok.
  case (lt_dec (cardTermB y) (cardTermB x))=>/=;auto;intro h.
 case (eq_nat_dec (cardTermB y)  (cardTermB x))=>/=;auto;intro h'. 
  rewrite h' in h. 
  now destruct (lt_irrefl (cardTermB x)).

rewrite mu_stable_plus;last first.
 unfold fplusok,ok, Uprop.finv;intro y. 
 case (eq_nat_dec (cardTermB y) (cardTermB x))=>/=;auto;intro h. 
 rewrite h.
  case (lt_dec (cardTermB x) (cardTermB x));auto;intro h'.
 now destruct (lt_irrefl (cardTermB x)).

apply Uplus_le_compat;last first. 

 transitivity ((mu (rd x)
  (fun y => (B2U ( (lt_dec (cardTermB y) (cardTermB x)) 
   )) * (pw n i)))). 
 now rewrite mu_stable_mult_right. 

 rewrite <-HPRy=>//. 
 apply mu_le_compat;auto. 
 intro y. case hy : (PR y);unfold B2U; Usimpl;auto. 
  case (lt_dec (cardTermB y) (cardTermB x))=>/=;repeat Usimpl;auto;intro h. 
 rewrite <-H=>//.
 apply pw_decr_x.
  rewrite H1 in h. rewrite -ltnS. apply/ltP. done.   

transitivity ((mu (rd x))
     (fun y => (if (eq_nat_dec  (cardTermB y) (cardTermB x)) 
  then 1 else 0) * (pw (S n) i))). 
 now rewrite mu_stable_mult_right.

assert ((mu (rd x))
     (fun y => (if eq_nat_dec (cardTermB y) (cardTermB x) then 1 else 0) *
      (mu (f y)) (fun _  => 1)) ==
 (mu (rd x))
   (fun y => (if eq_nat_dec (cardTermB y) (cardTermB x) then 1 else 0) *
      (mu (f y)) (fun _  => 1) +
   (if lt_dec  (cardTermB x) (cardTermB y)then 1 else 0))). 
setoid_rewrite mu_stable_plus. rewrite hcard4;auto. 
unfold fplusok. intro y. 
unfold Uprop.finv. 
case (eq_nat_dec (cardTermB y) (cardTermB x));
simpl;repeat Usimpl;auto;intro h.
rewrite h.
case (lt_dec (cardTermB x) (cardTermB x));intro h';auto.
now destruct (lt_irrefl (cardTermB x)).
rewrite <-HPRy=>//.  
apply mu_le_compat;auto. 
intro y. 
case (eq_nat_dec (cardTermB y) (cardTermB x))=>/=;repeat Usimpl;auto;intro h.
rewrite <-H1. rewrite -h.
case hy : (PR y);unfold B2U;Usimpl;auto. 
by apply (H _ hy).
by rewrite H1.
Qed. 

End termfglobal.
