Require Import ssreflect ssrfun ssrbool eqtype ssrnat.
Require Import fintype finset fingraph seq finfun bigop choice tuple.
Import Prenex Implicits.

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".
Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Require Import Rplus.
Require Import my_alea.
Require Import my_ssr.
Require Import my_ssralea. 
Require Import graph.
Require Import labelling.
Require Import rdaTool_gen.
Require Import rdaTool_dist.
Set Implicit Arguments.
Unset Strict Implicit.


(** * Introduction 
 
       Definition and  analysis of the symmetry break over a graph composed of one edge.     
 
       State of a vertex: (Active/Inactive ; Sequence of drawn bits)
       State of a port : Drawn bit
       Local Computation : If the received message is different from the sent one then stop 
                                              Else draw a bit, record it in the state and send it
 *)


Section symBreak.

Definition V : finType := bool_finType.

Definition u1 := true.
Definition u2 := false. 

Definition Adj : (rel V) :=
 (fun x y => match x,y with
              |u1,u2 => true
              |u2,u1 => true
              |_,_ => false
             end).

Definition nu (v: V) : seq V :=
 match v with
  |u1 => (u2::nil)
  |u2 => (u1::nil)
 end.

Context `(NG: NGraph V Adj).

Definition VLabel : eqType := (prod_eqType bool_eqType 
 (seq_eqType bool_eqType)).

Definition Pt := (@port_finType V Adj). 
Definition PLabel : eqType := bool_eqType.

Definition VState := LabelFunc V VLabel.
Definition PState := LabelFunc Pt PLabel.


Lemma edge_ft : Adj (u2,u1).1 (u2,u1).2.
Proof. auto. Qed. 

Lemma edge_tf : Adj (u1,u2).1 (u1,u2).2.
Proof. auto. Qed. 

Definition pft:= Port edge_ft. 
Definition ptf:= Port edge_tf.


Lemma VtoPft : (VtoP u2 u1 pft) = pft.
Proof. 
pose pft2 := pft. 
change (VtoP u2 u1 pft) with (VtoP u2 u1 pft2). 
by rewrite -(VtoP1 pft pft).
Qed.

Lemma VtoPtf : (VtoP u1 u2 pft) = ptf.
Proof. 
by rewrite -(VtoP1 ptf pft).
Qed. 

Lemma enumbool1: (enum bool_finType) = (u1::u2::nil).
Proof. 
rewrite enumT. 
rewrite Finite.EnumDef.enumDef.
done. 
Qed. 

Lemma update1 (x0:VState) (x1 x2 :bool * seq bool): 
update [set u1]
  (update [set u2] x0 
       (Vwrite x1 u2))
                  (Vwrite x2 u1) =
  [ffun y => if y then x2 else x1].
Proof. 
apply ffunP.
intro a. repeat rewrite ffunE.
repeat rewrite in_set. 
case ha: a=>//=.
Qed.

Lemma update2  (x0: PState) 
 (x1 x2 : seq bool): 
 update (WriteArea u1)
   (update (WriteArea u2) x0 
(Pwrite nu false x1 u2))
                 (Pwrite nu false x2 u1)
 = [ffun y => 
 if (fstp y) then  (match x2 with
   | nil => false
   | x :: _ => x
   end) else ( match x1 with
   | nil => false
   | x :: _ => x
   end)].
Proof.
apply ffunP.
intro a. repeat rewrite ffunE.
repeat rewrite in_set. 
destruct a. destruct pval. unfold fstp,sndp. simpl.
move:PvalP. simpl. 
case:s;case s0=>//=. 
Qed.

Definition LocalComp (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  distr (VLabel * seq PLabel) :=
 if (head false lpin == head false lpout) then 
   Mif Flip
       (Munit ((false, (true::lv.2)), [::true]))
       (Munit ((false, (false::lv.2)), [::false]))
 else Munit ((true, lv.2), nil).

Lemma Local_total : forall lv lpout lpin,
 Term (LocalComp lv lpout lpin).
Proof.
move =>lv lp lp'. 
unfold LocalComp. 
case h: (head false lp' == head false lp)=>//. 
Qed.


Definition termB (s: VState * PState) : bool :=
 (s.1 true).1 && (s.1 false).1. 

Definition Fsb :=
 DPRoundLV nu false pft LocalComp termB (enum V).

Definition symBreak := 
DPRoundFixLV nu false pft LocalComp termB (enum V).


Open Local Scope U_scope.
Open Local Scope O_scope.

Definition Musb (q: VState * PState -> U) : 
 MF (VState * PState) -m> MF (VState * PState).
exists (fun sb (x: VState * PState)=> 
 if (termB x) then  q x
 else  if  ( x.2 pft == x.2 ptf) then  
 [1/4] * (sb
 ([ffun y => if y then (false, true :: (x.1 true).2)
     else (false, true :: (x.1 false).2)], [ffun=> true])) +
 [1/4] * (sb
 ([ffun y => if y then (false, false :: (x.1 true).2)
     else (false, true :: (x.1 false).2)],[ffun y => ~~ fstp y])) +
 [1/4] * (sb
 ([ffun y => if y then (false, true :: (x.1 true).2)
     else (false, false :: (x.1 false).2)],[ffun y => fstp y])) +
 [1/4] * (sb
 ([ffun y => if y then (false, false :: (x.1 true).2)
     else (false, false :: (x.1 false).2)], [ffun=> false])) 
else (sb
  ([ffun y => if y then (true, (x.1 true).2) else (true, (x.1 false).2)],
   [ffun=> false]))).
Proof.
red;auto.
intros. intro. case:(termB x0)=>//.
case:(x0.2 pft == x0.2 ptf)=>//. 
auto. 
Defined.

Lemma Musb_simpl : forall q f x,
  Musb q f x =  
 if (termB x) then  q x
 else if ( x.2 pft == x.2 ptf) then  
  [1/4] * (f
  ([ffun y => if y then (false, true :: (x.1 true).2)
     else (false, true :: (x.1 false).2)], [ffun=> true])) +
  [1/4] * (f
  ([ffun y => if y then (false, false :: (x.1 true).2)
     else (false, true :: (x.1 false).2)],[ffun y => ~~ fstp y])) +
  [1/4] * (f
  ([ffun y => if y then (false, true :: (x.1 true).2)
     else (false, false :: (x.1 false).2)],[ffun y => fstp y])) +
  [1/4] * (f
  ([ffun y => if y then (false, false :: (x.1 true).2)
     else (false, false :: (x.1 false).2)], [ffun=> false])) 
 else    (f
  ([ffun y => if y then (true, (x.1 true).2) else (true, (x.1 false).2)],
   [ffun=> false])).   
Proof.
trivial. 
Qed.

Lemma Musb_eq: forall (q: VState * PState -> U) f l1 l2,
 mu (Fsb f (l1,l2)) q == Musb q (fun y => mu (f y) q) (l1,l2).
Proof. 
intros;unfold Fsb,DPRoundLV. 
rewrite enumbool1.  
rewrite DRoundLV_simpl Musb_simpl/=.
case h1: (termB (l1,l2))=>//=. 
setoid_rewrite update1.
setoid_rewrite update2.
unfold LocalComp. 
simpl;rewrite eq_sym;unfold termB in h1.
rewrite VtoPtf VtoPft.  
case h2:(l2 pft== l2 ptf)=>//=;last first.

 unfold Vread;simpl.
 have h: [ffun y => if fstp y then false else false] =
       [ffun y => false].
 by intros;apply ffunP;intro;do 2 rewrite ffunE;case:(fstp x).
 by rewrite h. 

unfold Vread. 

have h': [ffun y => if fstp y then true else true] = 
       [ffun y => true]
 by intro;apply ffunP;intro;do 2 rewrite ffunE;case:(fstp x)=>//.
have h'': [ffun y => if fstp y then false else false] = 
       [ffun y => false].
 by intro;apply ffunP;intro;do 2 rewrite ffunE;case:(fstp x)=>//.
have h''': [ffun y => if fstp y then true else false] = 
       [ffun y => fstp y].
 by intro;apply ffunP;intro;do 2 rewrite ffunE;case:(fstp x)=>//.
have h'''': [ffun y => if fstp y then false else true] = 
       [ffun y => ~~ fstp y].
 by intro;apply ffunP;intro;rewrite ffunE;case:(fstp x)=>//.
repeat rewrite h' h'' h''' h''''.
repeat rewrite Udistr_plus_left;last first.
apply Uinv_mult_simpl;auto.  
apply Uinv_mult_simpl;auto.
repeat rewrite Umult_assoc. 
repeat rewrite half_square. 
done. 
Qed.

Lemma Sb_eq : forall q l, 
 mu (symBreak l) q ==  mufix (Musb q) l.
Proof.
intros; apply Oeq_sym.
unfold symBreak.
apply mufix_mu with (muF:=(Musb q)) 
 (q:=fun l=> q); auto.
intros. destruct x;apply Musb_eq. 
Qed.

Lemma Sb_commute : forall q,
   mu_muF_commute_le Fsb (fun _=>q) (Musb q).
Proof.
red; auto.
intros. destruct x;rewrite Musb_eq. 
done.
Qed. 


(** Terminaison
 *)

Lemma Sb_term1 n f: 
     (iter (Musb (fone (VState * PState)))) n.+2
        (f, [ffun y=> fstp y]) == 1.
Proof.
simpl. 
unfold termB. 
repeat rewrite ffunE. 
case h:((f true).1 && (f false).1)=>//=. 
Qed. 

Lemma Sb_term2 n f: 
     (iter (Musb (fone (VState * PState)))) n.+2
        (f, [ffun y=> ~~fstp y]) == 1.
Proof.
simpl. 
unfold termB. 
repeat rewrite ffunE. 
case h:((f true).1 && (f false).1)=>//=. 
Qed. 

Lemma Sb_term : forall l, ~termB l -> 
 l.2 pft = l.2 ptf ->
 Term (symBreak l).
Proof.
unfold Term. intros.
transitivity (mufix (Musb (fone _)) l).
 destruct l. by rewrite Sb_eq.
unfold mufix,fixp. 

transitivity (lub Pmin2);last first.
 by apply lubp2.
apply lub_eq_compat. 
intro n. 
transitivity (Ccpo.iter (D:=MF _) (Musb (fone _)) n l); auto.
move:l H H0. induction n. auto.
induction n. simpl. 
intros. case h:(termB l) H=>//= _.
 rewrite H0 eq_refl. repeat Usimpl. auto. 
intros. clear IHn0. 
case:n IHn.
 simpl;intros. case:(termB l) H=>//=_.
 rewrite H0 eq_refl;simpl. unfold termB. repeat rewrite ffunE. 
 simpl. repeat Usimpl. auto.
intros. 
rewrite iterS_simpl.
rewrite Musb_simpl.
move:H. 
case hterm:(termB l)=>//_. 
rewrite H0 eq_refl. rewrite Sb_term1 Sb_term2.
repeat rewrite IHn.
repeat Usimpl. rewrite Uplus_sym. 
 rewrite -Uplus_assoc. rewrite quarterUplus.
 rewrite Uplus_assoc. rewrite quarterUplusn.
 simpl.   
 have h:= (U1min_S n). auto. 
 unfold termB. repeat rewrite ffunE. done. 
 repeat rewrite ffunE.  done. 
 unfold termB. repeat rewrite ffunE. done. 
 repeat rewrite ffunE. done. 
Qed.

(** At the end , different labels
 *)

Definition neq_c (l: VState) := 
 (l true).2 <> (l false).2.

Lemma neq_c_dec : forall l : VState * PState, 
 {(neq_c l.1)} + {~ (neq_c l.1)}.
Proof. 
intros;unfold neq_c.
case:(l.1 true);case (l.1 false)=>//=;intros a sa b sb.
case ha: (sa == sb);move/eqP:ha;auto. 
Qed. 

Lemma Sb_breaks1: forall n (x:VState),
(iter (Musb (carac neq_c_dec))) n.+2
     ([ffun y => if y
                 then (false, false :: (x true).2)
                 else (false, true :: (x false).2)], [ffun y => 
     ~~ fstp y]) == 1.
Proof. 
intros. simpl. 
unfold termB. repeat rewrite ffunE. simpl. 
unfold carac;repeat rewrite ffunE.
case:(neq_c_dec
         ([ffun y => if y
                     then (true, false :: (x true).2)
                     else (true, true :: (x false).2)], [ffun=> false]));
unfold neq_c;repeat rewrite ffunE;simpl;auto.
 intro. destruct b. done.
Qed. 

Lemma Sb_breaks2: forall n (x:VState),
(iter (Musb (carac neq_c_dec))) n.+2
     ([ffun y => if y
                 then (false, true :: (x true).2)
                 else (false, false :: (x false).2)], [ffun y => 
     fstp y]) == 1.
Proof. 
intros. simpl. 
unfold termB. repeat rewrite ffunE. simpl. 
unfold carac;repeat rewrite ffunE.
case:(neq_c_dec
         ([ffun y => if y
                     then (true, true :: (x true).2)
                     else (true, false :: (x false).2)], [ffun=> false]));
unfold neq_c;repeat rewrite ffunE;simpl;auto.
 intro. destruct b. done.
Qed. 

Lemma Sb_breaks: forall (x:VState * PState),
 ~termB x -> 
 x.2 pft = x.2 ptf ->
 mu (symBreak x) (carac neq_c_dec)==1.
Proof.
intros.
transitivity (mufix (Musb (carac neq_c_dec)) x).
 destruct x;by rewrite Sb_eq.
unfold mufix,fixp.  

transitivity (lub Pmin2);last first.
 by rewrite lubp2.
apply lub_eq_compat. 
intro n. 
transitivity (Ccpo.iter (D:=MF _) (Musb (carac neq_c_dec) ) n x); auto.
move:x H H0. induction n. auto.
induction n. 
 simpl. 
 intros. case h:(termB x) H=>//= _.
 rewrite H0 eq_refl=>//. repeat Usimpl. done. 
intros. clear IHn0. 
case:n IHn.
 simpl;intros. case h:(termB x) H=>//=_.
 rewrite H0 eq_refl;simpl. unfold termB. repeat rewrite ffunE. 
 simpl. repeat Usimpl. auto.
intros. 
rewrite iterS_simpl.
rewrite Musb_simpl.
move:H. 
case hterm:(termB x)=>//_. 
rewrite H0 eq_refl. rewrite Sb_breaks1 Sb_breaks2.
repeat rewrite IHn.
repeat Usimpl. rewrite Uplus_sym. 
 rewrite -Uplus_assoc. rewrite quarterUplus.
 rewrite Uplus_assoc. rewrite quarterUplusn.
 simpl.   
 have h:= (U1min_S n). auto. 

unfold termB. repeat rewrite ffunE. done. 
repeat rewrite ffunE.  done.  
unfold termB. repeat rewrite ffunE. done. 
repeat rewrite ffunE. done. 
Qed.

Definition lg (l: VState) := (seq.size (l true).2).

Lemma ltlg_dec : forall (k:nat) (l : VState * PState), 
 {(k < (lg l.1))%nat} + {~(k <(lg l.1))%nat}.
Proof.
intros;unfold lg.
case h: ( k < seq.size (l.1 true).2)%nat.
left=>//. 
right=>//. 
Qed. 

Lemma fst_simpl : forall (T1 T2:Type) (l1:T1) (l2:T2),
(l1,l2).1 = l1. 
Proof.  auto.  Qed. 

Lemma snd_simpl : forall (T1 T2:Type) (l1:T1) (l2:T2),
(l1,l2).2 = l2. 
Proof.  auto.  Qed. 

  
Lemma continuousFsb :  continuous Fsb.
Proof. 
unfold Fsb.
apply DRoundLV_cont. 
Qed.

Lemma prob_ltlg01 n (x:VState*PState) l:
  (l <=  seq.size (x.1 true).2)%nat ->
 (iter (Musb (carac (ltlg_dec l))) n.+2
        ([ffun y => if y
                 then (false, false :: (x.1 true).2)
                 else (false, true :: (x.1 false).2)],
                   [ffun y=> ~~ fstp y])) 
 == 1.
Proof.
intros;simpl. 
unfold termB. repeat rewrite ffunE. simpl. 
unfold carac. 
case:(ltlg_dec l
         ([ffun y => if y
                     then (true, false :: (x.1 true).2)
              else (true, true :: (x.1 false).2)], [ffun=> false]))=>//.
unfold lg. rewrite ffunE. simpl. 
intro. destruct b. done. 
Qed. 

Lemma prob_ltlg02  n (x:VState * PState) l:   
     (l <=  seq.size (x.1 true).2)%nat ->
(iter (Musb (carac (ltlg_dec l))) n.+2
      ([ffun y => if y
                 then (false, true :: (x.1 true).2)
                 else (false, false :: (x.1 false).2)], [ffun y => 
     fstp y])) == 1.
Proof.
intros;simpl. 
unfold termB. 
repeat rewrite ffunE. simpl. 
unfold carac. 
case:(ltlg_dec l
         ([ffun y => if y
                     then (true, true :: (x.1 true).2)
                     else (true, false :: (x.1 false).2)], [ffun=> false])
 )=>//.
 unfold lg. rewrite ffunE. simpl. 
intro. destruct b. done. 
Qed. 


Lemma prob_ltlg0 (x:VState * PState):  
 ~termB x -> 
 x.2 pft = x.2 ptf ->
(mu (symBreak x)) (carac (ltlg_dec (0 + seq.size (x.1 true).2))) == 1.
Proof.
intros.
transitivity (mufix (Musb 
 (carac (ltlg_dec (0 + seq.size (x.1 true).2)))) x).
 destruct x;by rewrite Sb_eq.
unfold mufix,fixp.  

transitivity (lub Pmin2);last first.
 by rewrite lubp2.
apply lub_eq_compat. 
intro n.  
transitivity (Ccpo.iter (D:=MF _) 
 (Musb (carac (ltlg_dec (0 + seq.size (x.1 true).2))) ) n x); auto.
set l:= (0 + seq.size (x.1 true).2)%nat.
have : (l <=  seq.size (x.1 true).2)%nat by auto.
move:x l H H0.
 induction n. auto. 
induction n. 
 simpl. 
 intros. case h:(termB x) H=>//= _.
 rewrite H0 eq_refl=>//. repeat Usimpl. auto. 
intros. clear IHn0. 
case:n IHn.
 simpl;intros. case h:(termB x) H=>//=_.
 rewrite H0 eq_refl;simpl. unfold termB. repeat rewrite ffunE. 
 simpl. repeat Usimpl. auto.  
intros.   
rewrite iterS_simpl.
rewrite Musb_simpl.
move:H. 
case hterm:(termB x)=>//_. 
rewrite H0 eq_refl.
rewrite prob_ltlg01=>//. 
rewrite prob_ltlg02=>//. 
repeat rewrite IHn. simpl.   
 repeat Usimpl. rewrite Uplus_sym. 
 rewrite -Uplus_assoc. rewrite quarterUplus.
 rewrite Uplus_assoc. rewrite quarterUplusn.
 simpl.   
 have h:= (U1min_S n). auto. 

unfold termB. repeat rewrite ffunE. done. 
repeat rewrite ffunE.  done.  
 rewrite ffunE. simpl. 
 apply (leq_trans x0);done. 
unfold termB. repeat rewrite ffunE. done. 
repeat rewrite ffunE. done.
  rewrite ffunE. simpl. 
 apply (leq_trans x0);done. 
Qed.

Lemma prob_ltlg1 (x:VState *PState) k: 
(mu
       (Mfix Fsb
          ([ffun y => if y
                      then (false, false :: (x.1 true).2)
                      else (false, true :: (x.1 false).2)],
          [ffun y => if fstp y then false else true])))
      (carac (ltlg_dec (k + (seq.size (x.1 true).2).+1))) ==
carac (ltlg_dec (k + (seq.size (x.1 true).2).+1))
     ([ffun y => if y
                 then (true, false :: (x.1 true).2)
                 else (true, true :: (x.1 false).2)],
     [ffun y => if fstp y then false else false]).
Proof.
rewrite (@Mfix_eq _ _ Fsb (continuousFsb) ([ffun y => if y
                     then (false, false :: (x.1 true).2)
                     else (false, true :: (x.1 false).2)],
         [ffun y => if fstp y then false else true])).
simpl.
case hterm:(termB
            ([ffun y => if y
                       then (false, false :: (x.1 true).2)
                       else (false, true :: (x.1 false).2)],
            [ffun y => if fstp y then false else true])).
move:hterm. unfold termB. repeat rewrite ffunE. done. 
clear hterm.  
rewrite enumbool1. unfold DRound. 
unfold LocalComp.  simpl.  
repeat rewrite ffunE.
repeat rewrite VtoP2=>//=.
rewrite update1 update2. 
unfold Vread.  
repeat rewrite ffunE;simpl. 
have h := (@Mfix_eq _ _ Fsb continuousFsb). 
simpl in h;rewrite h.
simpl. unfold termB. repeat rewrite ffunE. simpl.
done.
Qed.


Lemma prob_ltlg2 (x:VState *PState) k: 
(mu
       (Mfix Fsb
          ([ffun y => if y
                      then (false, true :: (x.1 true).2)
                      else (false, false :: (x.1 false).2)],
          [ffun y => if fstp y then true else false])))
      (carac (ltlg_dec (k + (seq.size (x.1 true).2).+1))) ==
carac (ltlg_dec (k + (seq.size (x.1 true).2).+1))
     ([ffun y => if y
                 then (true, true :: (x.1 true).2)
                 else (true, false :: (x.1 false).2)],
     [ffun y => if fstp y then false else false]).
Proof. 
rewrite (@Mfix_eq _ _ Fsb (continuousFsb) ([ffun y => if y
                     then (false, true :: (x.1 true).2)
                     else (false, false :: (x.1 false).2)],
         [ffun y => if fstp y then true else false])).
simpl.
case hterm:(termB
            ([ffun y => if y
                       then (false, true :: (x.1 true).2)
                       else (false, false :: (x.1 false).2)],
            [ffun y => if fstp y then true else false])).
move:hterm. unfold termB. repeat rewrite ffunE. done. 
clear hterm.  
rewrite enumbool1. unfold DRound. 
unfold LocalComp.
simpl. repeat rewrite ffunE. 
repeat rewrite VtoP2=>//=. 
rewrite update1 update2.
unfold Vread. 
repeat rewrite ffunE;simpl. 
have h := (@Mfix_eq _ _ Fsb continuousFsb). 
simpl in h;rewrite h.
simpl. unfold termB. repeat rewrite ffunE. simpl.
done.
Qed.



Lemma prob_ltlg k: forall (x:VState * PState), 
 ~termB x -> 
 x.2 pft = x.2 ptf ->
mu (symBreak x) 
 (carac (ltlg_dec (k+ (seq.size (x.1 true).2))%nat)) == [1/2]^k.
Proof.
induction k;intros x h1 h2.
Usimpl. apply prob_ltlg0=>//.
have H := continuousFsb. 
unfold symBreak. 
have h := (@Mfix_eq _ _ Fsb H x). 
simpl.  simpl in h. rewrite h.  clear h.
case hterm:(termB x) h1=>//_.
rewrite enumbool1. unfold LocalComp. 
simpl.
have h2' : (x.2 (VtoP u1 u2 pft) == x.2 (VtoP u2 u1 pft)). 
 by rewrite VtoPtf VtoPft h2.
rewrite h2'. rewrite eq_sym in h2'. rewrite h2'. 
simpl. 
repeat rewrite update1.
repeat rewrite update2. 
unfold B2U. repeat Usimpl.
repeat rewrite fst_simpl.
repeat rewrite snd_simpl.
repeat rewrite addSnnS. 
unfold symBreak in IHk. 
have := (IHk ([ffun y0 => if y0
                              then (false, true :: (x.1 true).2)
                              else (false, true :: (x.1 false).2)],
                 [ffun y0 => if fstp y0 then true else true])).
rewrite ffunE.  
unfold termB. repeat rewrite ffunE. move=>h.
have h': true by auto.
apply h in h'=>//. 
rewrite enumbool1 in h'. simpl in h'. 
unfold Fsb,DPRoundLV. rewrite enumbool1. 
rewrite h'.  
clear h h'. 
have := (IHk ([ffun y0 => if y0
                              then (false, false :: (x.1 true).2)
                              else (false, false :: (x.1 false).2)],
                 [ffun y0 => if fstp y0 then false else false])).
rewrite ffunE.  
unfold termB. repeat rewrite ffunE. move=>h. 
have h' : ~ false by auto.
apply h in h'=>//.  rewrite enumbool1 in h'. 
simpl in h'. 
rewrite h'. clear h h'. 
have h1 := prob_ltlg1. 
unfold Fsb,DPRoundLV in h1. simpl in h1. rewrite enumbool1 in h1. rewrite h1. 
clear h1. have h1 := prob_ltlg2.
 unfold Fsb,DPRoundLV in h1. simpl in h1. rewrite enumbool1 in h1. rewrite h1.  clear h1.
unfold carac. case: (ltlg_dec (k + (seq.size (x.1 true).2).+1));
case:( ltlg_dec (k + (seq.size (x.1 true).2).+1));unfold lg;simpl;intros;
repeat Usimpl. 
2:move:b a;repeat rewrite ffunE;done.
2:move:b a;repeat rewrite ffunE;done.
move:a0;repeat rewrite ffunE;simpl.
have h: (k + (seq.size (x.1 true).2).+1)%nat =
 ((seq.size (x.1 true).2).+1 + k)%nat. 
 auto with arith. 
rewrite h. 
rewrite -ltn_subRL.
have h': ((seq.size (x.1 true).2).+1 - (seq.size (x.1 true).2).+1)%nat =
O. auto with arith. 
rewrite h'. done. 
done. 
Qed.

(*Set Printing Coercions.*)

Lemma sumgHalf :  
 islub (sumg [1/2]) 2.
Proof. 
intros. 
apply (islub_eq_compat _ _ _ (sumg [1/2]) _
 ([1/](1 - [1/2]))%Rp);auto;last first.
 rewrite U2Rp1_R1;apply (sumg_lim [1/2]).
 rewrite -U2Rp1_R1. apply U2Rp_lt_compat. auto.

rewrite <-Rpmult_one_left.
apply Rpmult_eq_perm_left;auto. 
assert ((R1 - U2Rp [1/2])%Rp == [1/2]).
 rewrite -(U2Rp_Uinv [1/2]); auto. 
rewrite U2Rp1_R1 H Rpmult_sym Rp_double1.
auto.
Qed.

Lemma expectancySb: forall (x:VState * PState), 
 ~termB x -> 
 x.2 pft = x.2 ptf ->
(islub (Rpsigma (fun k => mu (symBreak x) 
 (carac (ltlg_dec (k+ (seq.size (x.1 true).2))%nat)))) 
  2).
Proof. 
intros. 
apply (islub_eq_compat _ _ _ (sumg [1/2]) _ 2);auto.
intro n. apply Rpsigma_eq_compat.
intros. rewrite prob_ltlg=>//. 
by rewrite U2Rp_exp. 
apply sumgHalf. 
Qed. 

End symBreak.