Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.

Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import gen.
Require Import op. 
Require Import rdaTool_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction
   
          Tools to simulate randomised distributed algorithms.
  *)

Section port. 

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable (nu: V -> seq V). 
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v:V), uniq (nu v).

Variable  (VLab: eqType) (PLab: eqType).
Variable pl0:PLab. 

Variable (rand_t : Type)(get : nat -> rand_t -> nat * rand_t).
Context (rand : ORandom _ get).

Let Pt := (@port_finType V Adj). 
Let VSt := LabelFunc V VLab.
Let PSt := LabelFunc Pt PLab.

Variable p0: Pt. 

Let OLocT := VLab->(seq PLab)->(seq PLab)-> Op rand_t (VLab*seq PLab).

Section finfunState.

Section One. 

Fixpoint OPRound (seqV:seq V)(res:VSt*PSt) (LC:OLocT):Op rand_t (VSt*PSt):=
 match seqV with 
  |nil => Oreturn res
  |h::t => Obind (OPRound t res LC) 
         (fun s=>Obind (LC (Vread res.1 h)(Poutread nu p0 res.2 h)
                                          (Pinread nu p0 res.2 h))
          (fun p => Oreturn((update [set h] s.1 (Vwrite p.1 h)), 
                            (update (WriteArea h) s.2 (Pwrite nu pl0 p.2 h))))) 
 end.

Variable Lr:  OLocT. 
Variable Lr': GLocT VLab PLab.

Hypothesis LocalRule1: forall ls l1 l2, 
(Opsem rand_t get rand (Lr' ls l1 l2)) = 
(Lr ls l1 l2). 

Lemma OPG_eq1 : forall (seqV: seq V) (res: VSt*PSt),
  Opsem _ get rand (GPRound nu pl0 p0 seqV res Lr') = 
  OPRound seqV res Lr.
Proof. 
elim=>//=a l H res. 
by rewrite H LocalRule1.
Qed.

End One. 

Section iterated.
  
Fixpoint OPStep (LCs:seq OLocT)(seqV:seq V)(res:VSt*PSt):Op rand_t (VSt*PSt) :=
match LCs with 
 | nil => Oreturn res
 |a1::a2 => Obind (OPRound seqV res a1)(fun y =>OPStep a2 seqV y) 
end.

Fixpoint OPMC (n:nat) (LCs:seq OLocT)(seqV:seq V)(res:VSt*PSt)
 : Op rand_t (VSt*PSt):=
 match n with 
   |O => Oreturn res
   | S m => Obind (OPStep LCs seqV res) 
                  (fun y => OPMC m LCs seqV y)
 end.   


Variable LCs : seq OLocT. 
Variable LCs' : seq (GLocT VLab PLab). 

Fixpoint LocalRule2 (s1:seq OLocT)
 (s2:seq(VLab->(seq PLab)->(seq PLab)->gen(VLab*seq PLab))):= 
 match s1,s2 with 
  |t1::q1, t2 :: q2 => (forall ls l1 l2, 
                         (Opsem rand_t get rand (t2 ls l1 l2)) = (t1 ls l1 l2)) 
                       /\ (LocalRule2 q1 q2)
  |nil, nil => True
  | _ , _ => False
 end.
  
Hypothesis LocalRule3:LocalRule2 LCs LCs'. 

Lemma OPG_eq2 : forall (seqV:seq V)(res:VSt*PSt),
 Opsem _ get rand (GPStep nu pl0 p0 LCs' seqV res) =1 
 OPStep LCs seqV res.
Proof.
move:LocalRule3;set l1 := LCs;set l2 := LCs'. 
elim:l1 l2 =>//=.
 elim=>//=.
intros;case:l2 LocalRule0=>//. 
intros;destruct LocalRule0=>/=.
rewrite (@OPG_eq1 a)=>//x.
unfold Obind;by rewrite (H _ H1 seqV).
Qed.  

Lemma OPG_eq3 : forall (n:nat)(seqV:seq V)(res:VSt*PSt),
 Opsem _ get rand (GPMC nu pl0 p0 n LCs' seqV res) =1
 OPMC n LCs seqV res.
Proof. 
elim=>//=.
unfold Obind;intros;intro g.
by rewrite OPG_eq2 -H.
Qed.

End iterated. 

End finfunState.

Section funState.

Let PtF := (Datatypes.prod V V).
Let VStF := V -> VLab. 
Let PStF := PtF -> PLab.


Definition updateF (T1:finType)(T2:eqType)(A:seq T1) 
 (old new: T1 -> T2) : T1 -> T2 :=
 fun (x:T1) => if x \in A then (new x) else (old x).

Definition VwriteF (s:VLab)(v:V): VStF :=
 (fun x => s).

Definition PwriteF (s:seq PLab)(v:V) : PStF :=
 (fun x => nth pl0 s (index x.2 (nu v))).

Definition VreadF (s:VStF)(v:V) : VLab :=
 (s v). 

Definition PoutreadF (s:PStF)(v:V) : (seq PLab) :=
 map (fun (x:V) => s (v,x))  (nu v).

Definition PinreadF (s:PStF)(v:V) : (seq PLab)  :=
 map (fun x:V => s (x, v))  (nu v). 

Definition WriteAreaF (v: V) : seq (V * V) :=
 map (fun x => (v,x) ) (nu v). 


Lemma OPF_eq1 : forall (resL:PSt) (resLF:PStF) (u:V),
 (forall v w,  Adj v w -> resL (VtoP v w p0) = resLF (v,w)) ->
 [seq resL (VtoP x u p0) | x <- nu u] = [seq resLF (x, u) | x <- nu u].
Proof. 
intros;apply eq_in_map. 
intros x hx;rewrite H=>//.
by rewrite gsym Hnu.  
Qed.

Lemma OPF_eq2 : forall (resL:PSt)(resLF: PStF) (u:V),
 (forall v w,  Adj v w -> resL (VtoP v w p0) = resLF (v,w)) ->
 [seq resL (VtoP u x p0) | x <- nu u] = [seq resLF (u, x) | x <- nu u].
Proof. 
intros;apply eq_in_map. 
intros x hx;rewrite H=>//.
by rewrite Hnu.  
Qed.

Section one.

Fixpoint OPFRound (seqV:seq V)(res:VStF*PStF)(LC:OLocT): Op rand_t (VStF*PStF) :=
 match seqV with 
  |nil => Oreturn res
  |h::t => Obind (OPFRound t res LC) 
    (fun s => Obind (LC (VreadF res.1 h)(PoutreadF res.2 h)(PinreadF res.2 h))
      (fun p => Oreturn((updateF (h::nil) s.1 (VwriteF p.1 h)),
                        (updateF (WriteAreaF h) s.2 (PwriteF p.2 h))))) 
 end.

Variable LC : OLocT.

Lemma OPF_eq3 (seqV: seq V) : forall (n:rand_t)(res:VSt*PSt)(resF:VStF*PStF) ,
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OPRound  seqV res LC) n).2 =
   ((OPFRound seqV resF LC) n).2 .
Proof.
elim:(seqV)=>//=;intros. 
rewrite (H _ _ _ H0 H1). 
unfold Vread,Poutread,Pinread,VreadF,PoutreadF,PinreadF.
by rewrite H0 (OPF_eq1 _ H1) (OPF_eq2 _ H1).
Qed. 

Lemma OPF_eq4 (l: seq V): forall (u:V)(n:rand_t)(res: VSt* PSt)(resF:VStF*PStF),
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
  LC (Vread res.1 u) (Poutread nu p0 res.2 u)(Pinread nu p0 res.2 u) 
     (OPRound l res LC n).2 =
  LC (VreadF resF.1 u)(PoutreadF resF.2 u)(PinreadF resF.2 u) 
     (OPFRound l resF LC n).2.
Proof. 
unfold Vread,Poutread,Pinread,VreadF,PoutreadF,PinreadF;intros.   
by rewrite H (OPF_eq1 _ H0) (OPF_eq2 _ H0) (OPF_eq3 _ _ H H0).
Qed.   


Lemma OPF_eq5:forall (n:rand_t)(v:V)(seqV: seq V)(res:VSt*PSt)(resF:VStF*PStF),
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 (((OPRound  seqV res LC) n).1).1 v=
 (((OPFRound seqV resF LC) n).1).1 v. 
Proof. 
move=>n v seqV res resF;elim:seqV=>//=.
intros;unfold updateF. 
rewrite in_cons in_nil orbF update_Plocal_iff in_set. 
case hva:(v == a);last by apply H=>//.
unfold Vwrite,VwriteF;by rewrite ffunE (OPF_eq4 _ _ _ H0 H1).
Qed. 

Lemma OPF_eq6 : forall (n:rand_t)(v w:V)(seqV:seq V)
 (res:VSt*PSt)(resF:VStF*PStF) ,
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
 (((OPRound seqV res LC) n).1).2 (VtoP v w p0)=
 (((OPFRound seqV resF LC) n).1).2 (v,w). 
Proof. 
move=>n v w seqV res resF H0 H1. 
elim:seqV; first by intros;apply H1. 
intros;simpl;unfold updateF,WriteAreaF,WriteArea,outerport_set. 
rewrite update_Plocal_iff in_set VtoP2=>//.
case h:((v, w) \in [seq (a, x) | x <- nu a])=>//=. 
move/mapP:h=>[x hx1 hx2];injection hx2=>hx3 hx4.
 unfold Pwrite,PwriteF;rewrite hx4 eq_refl ffunE VtoP3;
 last by rewrite -hx4.
 by rewrite (OPF_eq4 _ _ _ H0 H1).
move/mapP:h=>hx. 
case ha:(v == a)=>//=.
  move/eqP:ha=>ha;subst a;destruct hx. 
  exists w=>//;by rewrite -Hnu.
by apply H.
Qed.
 
End one. 
 
Section iterated.

Fixpoint OPFStep (LCs:seq OLocT)(seqV:seq V)(res:VStF*PStF) 
 : Op rand_t (VStF*PStF) :=
match LCs with 
 | nil => Oreturn res
 |a1::a2 =>  Obind (OPFRound seqV res a1) (fun y => OPFStep a2 seqV y) 
end.

Fixpoint OPFMC (n:nat)(LCs : seq OLocT)(seqV: seq V)(res:VStF*PStF) 
 : Op rand_t (VStF*PStF) :=
 match n with 
   |O => Oreturn res
   | S m => Obind  (OPFStep LCs seqV res) 
                    (fun y => OPFMC m LCs seqV y)
 end.

   
Variable LCs : seq OLocT. 

Lemma OPF_eq7 : forall (n:rand_t)(seqV:seq V)(res:VSt*PSt)(resF:VStF*PStF) ,
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OPStep  LCs seqV res) n).2 =
   ((OPFStep LCs seqV resF) n).2 .
Proof.
elim:(LCs)=>//=;intros.
unfold Obind. 
rewrite(H _ seqV _ (OPFRound seqV resF a n).1).
 by rewrite (OPF_eq3 _ _ _ H0 H1).
 by move=>v;apply OPF_eq5. 
move=>v w h. apply OPF_eq6=>//. 
Qed. 

Lemma OPF_eq8 : forall (v:V)(n:rand_t)(seqV:seq V)(res:VSt*PSt)(resF:VStF*PStF),
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   (((OPStep  LCs seqV res) n).1).1 v =
   (((OPFStep LCs seqV resF) n).1).1 v .
Proof.
elim:(LCs)=>//=;intros.
unfold Obind. 
rewrite (H _  _ _ _ (OPFRound seqV resF a n).1).
 by rewrite (OPF_eq3 _ _ _ H0 H1).
 by move=>w;apply OPF_eq5. 
move=>u w h;apply OPF_eq6=>//. 
Qed. 

Lemma OPF_eq9 : forall (v w:V)(n:rand_t)(seqV:seq V)
 (res:VSt*PSt)(resF:VStF*PStF),
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
   (((OPStep  LCs seqV res) n).1).2 (VtoP v w p0)=
   (((OPFStep LCs seqV resF) n).1).2 (v,w).
Proof.
elim:(LCs)=>//=;intros.
 by apply H0. 
unfold Obind. 
rewrite (H  _ _ _ _ _ (OPFRound seqV resF a n).1)=>//.
 by rewrite (OPF_eq3 _ _ _ H0 H1).
 by move=>u;apply OPF_eq5. 
move=>u u' h;apply OPF_eq6=>//. 
Qed. 

Lemma OPF_eq10 : forall (m:nat)(n:rand_t)(seqV:seq V)
 (res:VSt*PSt)(resF:VStF*PStF) ,
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OPMC m  LCs seqV res) n).2 =
   ((OPFMC m LCs seqV resF) n).2 .
Proof.
elim=>//=;intros.
unfold Obind. 
rewrite (H _ _ _ (OPFStep LCs seqV resF n0).1).  
 by rewrite (OPF_eq7 _ _ H0 H1).
 by move=>v;rewrite (OPF_eq8 _ _ _ H0 H1).
by move=>v w h;rewrite (OPF_eq9 _ _ H0 H1).
Qed. 

Lemma OPF_eq11 : forall(m:nat)(v:V)(n:rand_t)(seqV:seq V)
 (res:VSt*PSt)(resF:VStF*PStF),
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   (((OPMC m LCs seqV res) n).1).1 v =
   (((OPFMC m LCs seqV resF) n).1).1 v .
Proof.
elim=>//=;intros.
unfold Obind.
rewrite (H  _ _ _ _ (OPFStep LCs seqV resF n0).1).  
 by rewrite (OPF_eq7 _ _ H0 H1).
 by move=>u;rewrite (OPF_eq8 _ _ _ H0 H1).
by move=>u u' h;rewrite (OPF_eq9 _ _ H0 H1).
Qed. 

Lemma OPF_eq12 : forall (m:nat) (v w:V)(n:rand_t)(seqV:seq V)
 (res:VSt*PSt)(resF:VStF*PStF),
 (forall v,  res.1 v = resF.1 v) ->
 (forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
   (((OPMC  m LCs seqV res) n).1).2 (VtoP v w p0)=
   (((OPFMC m LCs seqV resF) n).1).2 (v,w).
Proof.
elim=>//=;intros.
 by apply H0. 
unfold Obind.
rewrite (H  _ _ _ _ _ (OPFStep LCs seqV resF n0).1)=>//.  
 by rewrite (OPF_eq7 _ _ H0 H1).
 by move=>u;rewrite (OPF_eq8 _ _ _ H0 H1).
by move=>u u' h;rewrite (OPF_eq9 _ _ H0 H1).
Qed. 

End iterated.

Fixpoint displayOP (seqV: seq V) (m: VStF*PStF) :=
 match seqV with 
  |nil => nil
  |t::q => ( (t, m.1 t) ,
        map (fun x => (x ,  m.2 (t , x)))  (nu t)) :: (displayOP q m)
 end.

End funState.

End port.