Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Export Cover.
Require Export Prog.
Require Export Ccpo.
Require Export Rplus.
Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun tuple.


Require Import my_alea.
Require Import my_ssr.
Require Import labelling.
Require Import graph.
Require Import term.
Require Import gen.
Require Import dist.
Require Import rdaTool_gen.


Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

Open Local Scope U_scope.
Open Local Scope O_scope.
(** * Introduction
          
          This file gives tools to analyse randomised distributed algorithms
   *)

Section general.

(** * General
 *)

Variable (V: finType) (VLab: eqType).
Variables (L:finType) (LLab:eqType).

Definition VSt := LabelFunc V VLab.
Definition LSt := LabelFunc L LLab.

Variable WriteArea : V -> {set L}. 
Variable ReadArea : V -> {set L}. 

Variable Vwrite : VLab -> V -> VSt.
Variable Lwrite : (seq LLab) -> V -> LSt.

Variable Vread : VSt -> V -> VLab.
Variable Linread : LSt -> V -> (seq LLab).
Variable Loutread : LSt -> V -> (seq LLab).

Hypothesis Vread1 : forall v w resV f,
 v != w ->
(Vread resV v) = 
(Vread (update [set w] resV f) v).

Hypothesis Loutread1 : forall v w resL f,
 v != w ->
  (Loutread resL v) = 
  (Loutread (update (WriteArea w) resL f) v).

Definition DLocT:= VLab -> (seq LLab) -> (seq LLab) -> distr (VLab * seq LLab).

Section round.
(** ** Round
 *)
Fixpoint DRound (seqV:seq V)(res:VSt*LSt)(LR:DLocT) : distr (VSt*LSt) :=
match seqV with 
|nil => Munit res
|h::t => Mlet (DRound t res LR) 
        (fun s => Mlet (LR (Vread res.1 h) (Loutread res.2 h)(Linread res.2 h)) 
            (fun p => Munit((update [set h] s.1 (Vwrite p.1 h)),
                            (update (WriteArea h) s.2 (Lwrite p.2 h))))) 
end.

Section gen.
(** *** Lemmas: Gen
 *)
Variable DLr: DLocT. 
Variable GLr: GLocT VLab LLab.

Hypothesis LocalRule1: forall ls l1 l2, 
(Distsem (GLr ls l1 l2)) = 
(DLr ls l1 l2).

Lemma DG_eq1 : forall (seqV: seq V) (res: VSt*LSt),
 Distsem (GRound WriteArea Vwrite Lwrite Vread Linread Loutread seqV res GLr) = 
 DRound seqV res DLr.
Proof. 
elim=>//=a l H res. 
by rewrite H LocalRule1.
Qed.

End gen.

Section lemmas.

Variable Lr: DLocT. 

(** *** Lemmas: Simplification
 *)

Lemma DRoundcons1 : forall (v:V) (t:seq V) (res:VSt*LSt),
 DRound (v::t) res Lr = Mlet (DRound t res Lr)
             (fun s => Mlet (Lr (Vread res.1 v) 
                                       (Loutread res.2 v)
                                       (Linread res.2 v))
               (fun p => Munit ( (update [set v] s.1 (Vwrite p.1 v)),
                                 (update (WriteArea v) s.2 
                                    (Lwrite p.2 v))))).
Proof.
 reflexivity.
Qed.


Lemma DRoundcons2 : forall (v:V) (t:seq V) (res:VSt*LSt),
 is_discrete_s (Lr (Vread res.1 v)(Loutread res.2 v)(Linread res.2 v)) ->
 DRound (v::t) res Lr == 
       Mlet (Lr (Vread res.1 v)(Loutread res.2 v)(Linread res.2 v))
            (fun p => Mlet (DRound t res Lr)
                (fun s => Munit ((update [set v] s.1 (Vwrite p.1 v)),
                              (update (WriteArea v) s.2 (Lwrite p.2 v))))).
Proof.
move=>v t res h;rewrite DRoundcons1.
by rewrite (is_discrete_s_swap (DRound t res Lr)).
Qed.

Lemma DRoundcons3 : forall (v:V) (t:seq V) (res:VSt*LSt),
 (forall a b c d, Lr a b c = Lr a b d) ->
 (forall w, is_discrete_s 
             (Lr (Vread res.1 w)(Loutread res.2 w)(Linread res.2 w))) ->
 (forall v w, v != w -> disjoint (mem (WriteArea v))  (mem (WriteArea w)))->
 v \notin t -> 
 DRound (v::t) res Lr == 
 Mlet (Lr (Vread res.1 v) (Loutread res.2 v)(Linread res.2 v))
      (fun p => (DRound t ((update [set v] res.1 (Vwrite p.1 v)),
                (update (WriteArea v) res.2 (Lwrite p.2 v))) Lr)).
Proof.
move=>v t res heqloc hdisc hdisj h;rewrite DRoundcons2=>//.
apply Mlet_eq_compat=>// k.
elim:t k v h=> [k v h|v s hind k w] //.
rewrite in_cons;move/norP=>[h1 h2] h3.
have hlocalcomp : ((Lr (Vread (update [set w] res.1 
(Vwrite k.1 w)) v)
 (Loutread (update (WriteArea w) res.2 (Lwrite k.2 w)) v)
(Linread (update (WriteArea w) res.2 (Lwrite k.2 w)) v)) =
(Lr (Vread res.1 v) (Loutread res.2 v)
               (Linread res.2 v))).
 rewrite eq_sym in h1. 
 rewrite -Vread1=>//;  rewrite -Loutread1=>//.
do 2 rewrite DRoundcons2=>//;last first.
 by rewrite hlocalcomp.
rewrite Mlet_assoc;apply Mlet_eq_compat=>//. 
by rewrite hlocalcomp. 
intro k'. 
rewrite -(hind _ _ h2). 
intro ev;simpl. 

apply mu_eq_compat;auto. 
intro x. simpl. rewrite update_Pcomm.
rewrite (@update_Pcomm _ _ (WriteArea v))=>//. 
apply hdisj. rewrite eq_sym. done.
by apply disjoint_set;rewrite eq_sym.  
Qed.


(** *** Lemmas: Termination
 *)

Lemma DRound_total : forall(s: seq V) (res: VSt* LSt),
(forall w, Term (Lr (Vread res.1 w) (Loutread res.2 w)(Linread res.2 w))) -> 
 Term (DRound s res Lr).
Proof.
unfold Term;move=>s res h;elim: s res h=>[|t s hind]//.
move=> res h ;setoid_rewrite DRoundcons1=>//=.
setoid_rewrite h. 
by setoid_rewrite (hind _  h).
Qed.


(** *** Lemmas: Commutativity
 *)

Lemma DRoundCommute0 : forall (t:V) (s1 s2:seq V) (res:VSt*LSt),
is_discrete_s (Lr (Vread res.1 t) (Loutread res.2 t)(Linread res.2 t)) ->
 (forall k, Mlet (DRound s1 res Lr)
     (fun s : VSt * LSt =>
      Munit
        (update [set t] s.1 (Vwrite k.1 t),
        update (WriteArea t) s.2 (Lwrite k.2 t))) ==
   Mlet (DRound s2 res Lr)
     (fun s : VSt * LSt =>
      Munit
        (update [set t] s.1 (Vwrite k.1 t),
        update (WriteArea t) s.2 (Lwrite k.2 t)))) ->
   DRound (t::s1) res Lr == DRound (t::s2) res Lr.
Proof.
move=> t s1 s2 res hdisc h.
do 2 rewrite DRoundcons2=>//.
setoid_rewrite h=>//.
Qed.

Lemma DRoundCommute1 : forall (v t:V)  (s:seq V) (res:VSt*LSt),
is_discrete_s (Lr (Vread res.1 v) (Loutread res.2 v)(Linread res.2 v)) ->
is_discrete_s (Lr (Vread res.1 t) (Loutread res.2 t)(Linread res.2 t)) ->
 disjoint (mem  (WriteArea t)) (mem   (WriteArea v)) ->
 v != t ->
 DRound (v::t::s) res Lr == DRound (t::v::s) res Lr.
Proof.
move=>v t s res h1 h2  h3 h.
setoid_rewrite DRoundcons2 at 1=>//.
setoid_rewrite (DRoundcons2 _ h2) at 1. 
rewrite (is_discrete_s_swap _ _ h1).
setoid_rewrite DRoundcons2=>//;rewrite Mlet_assoc;apply Mlet_eq_compat=>//k.
setoid_rewrite DRoundcons1;intro ev.
simpl. 

apply mu_eq_compat;auto.
intro x;simpl.
apply mu_eq_compat;auto. 
intro y.  
rewrite update_Pcomm=>//.
rewrite (@update_Pcomm _ _ (WriteArea t)) =>//.
by apply disjoint_set; rewrite eq_sym. 
Qed. 


Lemma DRoundCommute2 : forall (s: seq V) (t:V) (res:VSt*LSt),
(forall v,is_discrete_s
          (Lr (Vread res.1 v) (Loutread res.2 v)(Linread res.2 v))) ->
 (forall v w, v != w -> disjoint (mem  (WriteArea v)) (mem   (WriteArea w))) ->
 t \in s -> 
 DRound s res Lr == DRound (t::(rem t s)) res Lr.
Proof.
elim. 
 move=> t;by rewrite in_nil.
move=> t s hind v res h1 h2 hv.
rewrite in_cons in hv;case hvt: (v==t).
 by move/eqP:hvt=>->/=;rewrite eq_refl.
rewrite hvt in hv;simpl in hv;rewrite eq_sym in hvt. 
replace (rem v (t :: s)) with (if t == v then s else t :: rem v s) =>//.
rewrite hvt;rewrite DRoundCommute1;first apply DRoundCommute0;auto;
 [apply h2| rewrite eq_sym];by rewrite hvt. 
Qed.

Lemma DRoundCommute3 : 
forall (s1 s2: (seq V)) (res:VSt*LSt),
  (forall v, is_discrete_s
   (Lr (Vread res.1 v) (Loutread res.2 v)(Linread res.2 v))) ->
 (forall v w, v != w -> disjoint (mem  (WriteArea v)) (mem   (WriteArea w))) ->
  perm_eq s1 s2 -> 
  (DRound s1) res Lr == (DRound s2) res Lr.
Proof.
elim. 
 elim=>// t s _ res h1 h2 hperm;have:=(perm_eq_mem hperm t);
  rewrite in_nil in_cons eq_refl;discriminate. 
move=> t s1 hind s2 res h1 h2 hperm. 
have hperm' := (perm_eq_mem hperm t). 
rewrite in_cons eq_refl in hperm';simpl in hperm';symmetry in hperm'. 
rewrite (DRoundCommute2 h1 h2 hperm'). 
apply DRoundCommute0=>// k. 
apply Mlet_eq_compat=>//;apply  hind=>//. 
apply perm_to_rem in hperm';rewrite -(perm_cons t).
apply (perm_eq_trans hperm hperm').
Qed. 

Section caraclocal.
(** *** Lemmas: Preservation local/global
    Preservation of the local probability to a global one
 *)

Variable carac_local : V -> VLab * seq LLab -> U.
Variable carac_global : V -> VSt * LSt -> U. 

Lemma FLocalGlobal :
 (forall a b c d, Lr a b c = Lr a b d) ->
 (forall v w y resV resL,
   (Lr (Vread resV w) (Loutread resL w) (Linread resL w)) = 
    Lr (Vread (update [set v] resV (Vwrite y.1 v)) w)
       (Loutread (update (WriteArea v) resL (Lwrite y.2 v)) w)
       (Linread (update (WriteArea v) resL (Lwrite y.2 v)) w)) ->

 forall (v: V) (res:VSt*LSt) (x:U),
 (forall w, Term (Lr (Vread res.1 w) (Loutread res.2 w)(Linread res.2 w))) ->
  (forall w, is_discrete_s 
             (Lr (Vread res.1 w) (Loutread res.2 w)(Linread res.2 w))) ->
 (forall u w, u != w -> disjoint (mem  (WriteArea u)) (mem   (WriteArea w))) ->
 (forall (v:V) (y:VLab * seq LLab) (res:VSt*LSt),
   carac_global v
     (update [set v] res.1 (Vwrite y.1 v),
     update (WriteArea v) res.2 (Lwrite y.2 v)) == 
   carac_local v y) ->
(mu (Lr(Vread res.1 v)(Loutread res.2 v)(Linread res.2 v)))(carac_local v)==x-> 
(mu (DRound (enum V) res Lr)) (carac_global v) == x.
Proof.
move=>hlocalcomp heq v res x hterm hdisc hdisj hcarac hlocal.
rewrite (@DRoundCommute2 _ v _ hdisc hdisj);last by rewrite mem_enum.
rewrite (DRoundcons3 _ hdisc hdisj)=>//;last by apply (rem_T V v).
rewrite Mlet_simpl -hlocal.
apply mu_eq_compat=>//=y.
have:=(@enumP V v);rewrite -enumT;have:=(enum_uniq V). 
move:res hterm hdisc hlocal;elim:(enum V)=>//. 
move=> t s hind res hterm hdisc hlocal.

have hdisc' : forall w, w != v -> is_discrete_s
   (Lr (Vread (update [set v] res.1 (Vwrite y.1 v)) w)
      (Loutread (update (WriteArea v) res.2 (Lwrite y.2 v)) w)
      (Linread (update (WriteArea v) res.2 (Lwrite y.2 v)) w)).
intros. 
rewrite -heq=>//. 

have hterm' : (forall w, w != v ->
Term 
(Lr (Vread (update [set v] res.1 (Vwrite y.1 v)) w)
         (Loutread (update (WriteArea v) res.2 (Lwrite y.2 v)) w)
         (Linread (update (WriteArea v) res.2 (Lwrite y.2 v)) w))).
intros.  rewrite  -Vread1=>//. rewrite -Loutread1=>//.
rewrite (hlocalcomp _ _ _ (Linread res.2 w))=>//. 

rewrite cons_uniq;move/andP=>[h1 h2];simpl.
case htv:(t==v).
 move/eqP:htv h1;move=>->htv _;move:res hterm hterm' 
 hdisc hdisc' hlocal h2 htv;elim s.
   move=> res hterm hterm' hdisc hdisc' hlocal _ _;simpl.
   by rewrite -hcarac.
 move=> t' s' hind' res hterm hterm' hdisc hdisc' hlocal.
 rewrite cons_uniq;move/andP=>[h1' h2'].
 rewrite in_cons;move/norP=>[h1 h2].

 rewrite (DRoundcons3)=>//. 
 rewrite Mlet_simpl.
setoid_rewrite (fun x0 => 
update_Pcomm res.2 (Lwrite y.2 v) (Lwrite x0.2 t') (hdisj _ _ h1)).
have hdisj2 := (disjoint_set _ _ _ h1).
setoid_rewrite (fun x0 => update_Pcomm res.1 (Vwrite y.1 v) 
 (Vwrite x0.1 t') (hdisj2)).

assert (forall x0, (mu
            (DRound s'
               ((update [set v] 
                  ((update [set t'] res.1 (Vwrite x0.1 t')),
                    (update (WriteArea t') res.2 (Lwrite x0.2 t'))).1
                  (Vwrite y.1 v)),
               (update (WriteArea v)
                 ((update [set t'] res.1 (Vwrite x0.1 t')),
                    (update (WriteArea t') res.2 (Lwrite x0.2 t'))).2
                  (Lwrite y.2 v))) Lr)) (carac_global v) == 
         carac_local v y) as hyp.
 intro. 
 apply hind';auto;intros;by rewrite -heq;try rewrite -heq.

 setoid_rewrite hyp. 
 rewrite mu_cte hterm'.  apply Umult_one_right.
 rewrite eq_sym. done.   
 intros. by rewrite -heq. 

rewrite (DRoundcons3)=>//;last by apply (rem_impl  _ _  _ _ h1).   
setoid_rewrite Mlet_simpl. 
move=>h;have htv':(v!=t) by rewrite eq_sym htv.
setoid_rewrite (fun x0 => 
update_Pcomm res.2 (Lwrite y.2 v) (Lwrite x0.2 t) (hdisj _ _ htv')).
have hdisj2 := (disjoint_set _ _ _ htv').
setoid_rewrite (fun x0 => update_Pcomm res.1 (Vwrite y.1 v) (Vwrite x0.1 t) 
 (hdisj2)).

assert (forall x0, (mu
         (DRound (rem v s)
            ((update [set v] 
           ((update [set t] res.1 (Vwrite x0.1 t)),
            (update (WriteArea t) res.2 (Lwrite x0.2 t))).1            
               (Vwrite y.1 v)),
            (update (WriteArea v)
               ((update [set t] res.1 (Vwrite x0.1 t)),
            (update (WriteArea t) res.2 (Lwrite x0.2 t))).2            
               (Lwrite y.2 v))) Lr)) (carac_global v) ==
   carac_local v y) as hyp.
intro. apply hind;auto;intros;by rewrite -heq;try rewrite -heq.
setoid_rewrite hyp.
rewrite mu_cte hterm'=>//.
rewrite eq_sym. done. 
intros;by rewrite -heq. 
Qed.

End caraclocal.

(** *** Lemmas: Independence
    Here is a generalization of the independence
    the probability to be computed has to have some properties
 *)
 
Definition indepProp (f1 f2:VSt * LSt -> bool) 
 (c c': VLab * seq LLab -> bool) :=
forall t:V,
( (forall x sn, f1 (update [set t] sn.1 (Vwrite x.1 t),
 update (WriteArea t) sn.2 (Lwrite x.2 t)) = f1 sn) /\
 (forall  x sn, f2 (update [set t] sn.1 (Vwrite x.1 t),
 update (WriteArea t) sn.2 (Lwrite x.2 t)) = f2 sn))
\/ 
( (forall x sn, f1 (update [set t] sn.1 (Vwrite x.1 t),
 update (WriteArea t) sn.2 (Lwrite x.2 t)) = c x) /\
 (forall x sn, f2 (update [set t] sn.1 (Vwrite x.1 t),
 update (WriteArea t) sn.2 (Lwrite x.2 t)) = f2 sn))
\/
( (forall x sn, f1 (update [set t] sn.1 (Vwrite x.1 t),
 update (WriteArea t) sn.2 (Lwrite x.2 t)) = f1 sn) /\
 (forall x sn, f2 (update [set t] sn.1 (Vwrite x.1 t),
 update (WriteArea t) sn.2 (Lwrite x.2 t)) = c' x)).


Lemma DRoundindepb : forall (sV:seq V) (sT:VSt*LSt)
 (f1 f2:VSt * LSt -> bool) (c c':VLab * seq LLab  -> bool),
 (forall w : V,
   Term (Lr (Vread sT.1 w) (Loutread sT.2 w)(Linread sT.2 w))) ->
 (indepProp f1 f2 c c') ->
 indepb (DRound sV sT Lr) f1 f2.
Proof.
unfold indepProp,indepb,indep,fconj. 
move=>sV sT f1 f2 c c' hterm hf.
elim:sV sT hterm=>// t sV hind1 sT' hterm.
have hind := (hind1 sT');clear hind1.
setoid_rewrite DRoundcons1. 
simpl.
move:hf (hf t)=> _ [[hf1 hf2] | [[hf1 hf2] | [hf1 hf2]]];
 unfold fB2U,B2U;setoid_rewrite hf1;setoid_rewrite hf2;
have := (mu_cte_eq  _ _ (@DRound_total sV  sT' hterm)) ;
unfold fcte;move=>hyp;try setoid_rewrite hyp;
  have:=(mu_cte_eq _ _ (hterm t));unfold fcte;move=>hyp';
 setoid_rewrite hyp';auto. 
+setoid_rewrite mu_stable_mult_right;setoid_rewrite <-fmult_def.
 by setoid_rewrite mu_stable_mult.
+setoid_rewrite <-fmult_def;setoid_rewrite mu_stable_mult.
 by setoid_rewrite mu_stable_mult_right.
Qed.

End lemmas.
End round.


Section roundlv.
(** ** Infinite iteration of Round
 *)

Variable Lr : DLocT. 
Variable termB : (VSt*LSt) -> bool.

(** *** DRoundLV
 *)

Instance DRoundLV_mon (seqV : seq V) :
 monotonic (fun f (s:VSt * LSt) =>
   if (termB s) then Munit s
   else Mlet (DRound seqV s Lr) (fun r => f r)). 
Proof.
red; intros. 
intro s;case:(termB s);auto.
Qed.

Definition DRoundLV  (seqV: seq V):=
 mon (fun f (s:VSt*LSt) =>
  if (termB s) then (Munit s) else
  (Mlet (DRound seqV s Lr) (fun r => f r))).

Lemma DRoundLV_simpl : forall f (seqV: seq V) (res:VSt*LSt),
 DRoundLV seqV f res =
 if (termB res) then Munit res
 else Mlet (DRound seqV res Lr) (fun r => f r).
Proof.
 trivial.
Qed.

Lemma DRoundLV_cont : forall (seqV : seq V),
 continuous (DRoundLV seqV).
Proof.
move=>seqV f x. rewrite DRoundLV_simpl.
case hb: (termB x).
 intro Mx. simpl.
 transitivity ( (mlub (fun _ : nat => Mx x))).
  apply (le_mlub (fun _ => Mx x) 0).
 apply mlub_le_compat. intro. rewrite hb. auto.
have h := (Mlet_lub_le_right (DRound seqV x Lr) f).
transitivity (lub ((MLet (VSt*LSt) (VSt*LSt)) 
 (DRound seqV x Lr) @ f));auto.
simpl. intro Mx. apply mlub_le_compat.
intro y. rewrite hb. auto.
Qed.


Lemma DRoundLVcons1 : forall (v:V) (t:seq V) f (res:VSt*LSt),
 DRoundLV (v::t) f res == if (termB res) then Munit res
 else Mlet (Mlet (DRound t res Lr)
         (fun s => Mlet (Lr (Vread res.1 v)(Loutread res.2 v)(Linread res.2 v))
            (fun p => Munit ((update [set v] s.1 (Vwrite p.1 v)),
                             (update (WriteArea v) s.2 (Lwrite p.2 v))))))
             (fun r => f r).
Proof.
 reflexivity.
Qed.


Lemma DRoundLVcons2 : forall (v:V) (t:seq V) f (res:VSt*LSt),
 is_discrete_s (Lr (Vread res.1 v)(Loutread res.2 v)(Linread res.2 v)) ->
 DRoundLV (v::t) f res == 
 if (termB res) then Munit res
 else Mlet (Mlet (Lr (Vread res.1 v)(Loutread res.2 v)(Linread res.2 v))
       (fun p => Mlet (DRound t res Lr)
          (fun s => Munit ((update [set v] s.1 (Vwrite p.1 v)),
                       (update (WriteArea v) s.2 (Lwrite p.2 v))))))
                  (fun r => f r).
Proof.
move=> v t f res H. 
rewrite DRoundLV_simpl.
case: (termB res)=>// .
by setoid_rewrite (DRoundcons2 _ H).
Qed.


Lemma DRoundLV_total : forall (s:seq V) (res: VSt*LSt) f,
(forall w, Term (Lr (Vread res.1 w)(Loutread res.2 w)(Linread res.2 w))) -> 
 (forall x, Term (f x)) ->
 Term (DRoundLV s f res).
Proof.
move=>s res f H H1;unfold Term. 
rewrite DRoundLV_simpl.
case h:(termB res)=>//.
rewrite Mlet_simpl. 
setoid_rewrite H1.
by apply DRound_total.
Qed.



(** *** DRoundFixLV
 *)

Definition DRoundFixLV (seqV: seq V) :  (VSt * LSt) -> distr (VSt*LSt) :=
 Mfix (DRoundLV seqV).

Hypothesis localTerm : forall res,
   Term (DRound (enum V) res Lr).

Variable cardTermB : (VSt*LSt) -> nat.

Variable c: U. 
Let k := [1-]c. 

Hypothesis hcard1 : forall r, (cardTermB r) = O -> termB r.

Hypothesis hcard2: 0 < c.

Lemma hcard2' : k < 1. 
Proof. 
by apply Uinv_lt_one.
Qed. 

Hypothesis hcard3 :  forall (res: VSt*LSt), 
  (0 < cardTermB res)%nat -> 
 c <= mu (DRound (enum V) res Lr) 
   (fun x => B2U (lt_dec  (cardTermB x) (cardTermB res))).

Hypothesis hcard4 :  forall (res: VSt*LSt), 
 mu (DRound (enum V) res Lr) 
   (fun x => B2U (lt_dec (cardTermB res) (cardTermB x))) == 0.

Lemma DRoundfix_total : forall (res: VSt * LSt),
 Term (DRoundFixLV (enum V) res).
Proof.
intro res;unfold Term. 
rewrite -(@termglobal _  _ _ _ _ 
  localTerm _ _ _ hcard1 hcard2 (fun _ => true) _ _ res)=>//;last first. 
  intros. unfold B2U. setoid_rewrite Umult_one_left.  done.
  intros. by apply hcard3.  
apply mu_eq_compat=>//. 
simpl. intro. apply mlub_eq_compat=>//. 
intro. 
elim:x0 res=>//=. 
intros. case h:(termB res)=>//=. 
apply mu_eq_compat=>//.
Qed.

End roundlv.

Section iteration.
(** ** Iteration
 *)

Fixpoint DStep (LCs : seq DLocT) (seqV: seq V)(res: VSt* LSt)  : distr (VSt*LSt) :=
match LCs with 
 | nil => Munit res
 |a1::a2 =>  Mlet (DRound seqV res a1)  (fun y =>  DStep a2 seqV y) 
end.

Fixpoint DMC (n:nat) (LCs:seq DLocT)(seqV:seq V)(res:VSt*LSt) : distr(VSt*LSt) :=
 match n with 
   |O => Munit res
   | S m => Mlet (DStep LCs seqV res) (fun y => DMC m LCs seqV y)
 end.   


(** *** Lemmas: Gen
 *)
Variable DLCs : seq DLocT. 
Variable GLCs : seq (GLocT VLab LLab).

Fixpoint LocalRule2 (s1:seq DLocT) (s2:seq(GLocT VLab LLab)) :=
 match s1,s2 with 
  |t1::q1, t2 :: q2 => (forall ls l1 l2,  (Distsem (t2 ls l1 l2)) = (t1 ls l1 l2)) 
                                    /\ (LocalRule2 q1 q2)
  |nil, nil => True
  | _ , _ => False
 end.
  
Hypothesis LocalRule3:LocalRule2 DLCs GLCs. 

Lemma DG_eq2 : forall (seqV:seq V)(res:VSt*LSt),
 Distsem (GStep WriteArea Vwrite Lwrite Vread Linread Loutread GLCs seqV res)  == 
 DStep DLCs seqV res.
Proof.
move:LocalRule3;set l1 := DLCs;set l2 := GLCs. 
elim:l1 l2 =>//=.
 elim=>//=.
intros;case:l2 LocalRule0=>//. 
intros;destruct LocalRule0=>/=.
rewrite (@DG_eq1 a)=>//.
setoid_rewrite (H _ H1 seqV).
done.
Qed.  

Lemma DG_eq3 : forall (n:nat)(seqV:seq V)(res:VSt*LSt),
 Distsem (GMC WriteArea Vwrite Lwrite Vread Linread Loutread n GLCs seqV res) 
 == DMC n DLCs seqV res.
Proof. 
elim=>//=;intros. 
rewrite DG_eq2.
by setoid_rewrite <-H.
Qed.

(** *** Infinite iteration of Steps
 *)

Variable termB : VSt * LSt -> bool.
Variable LCs: seq DLocT. 

Instance DStepLV_mon (seqV: seq V):
 monotonic (fun f (s:VSt * LSt) =>
   if (termB s) then Munit s
   else Mlet (DStep LCs seqV s) (fun r => f r)).
Proof.
 red; intros.
 intro s;case:(termB s);auto.
Qed.

Definition DStepLV (seqV: seq V):=
 mon (fun f (s:VSt*LSt) =>
  if (termB s) then (Munit s) else
  (Mlet (DStep LCs seqV s) (fun r => f r))).


Lemma DStepLV_simpl : forall f  (seqV : seq V)(res: VSt * LSt),
 DStepLV seqV f res =
 if (termB res) then Munit res
 else Mlet (DStep LCs seqV res) (fun r => f r).
Proof.
 trivial.
Qed.

Lemma DStepLV_cont : 
 forall seqV, continuous (DStepLV seqV).
Proof.
move=>seqV f x.
rewrite DStepLV_simpl.
case hb: (termB x).
 intro Mx. simpl.
 transitivity ( (mlub (fun _ : nat => Mx x))).
  apply (le_mlub (fun _ => Mx x) 0).
 apply mlub_le_compat. intro. rewrite hb. auto.
have h := (Mlet_lub_le_right (DStep LCs seqV x) f).
transitivity (lub ((MLet (VSt*LSt) (VSt*LSt)) 
 (DStep LCs seqV x) @ f));auto.
simpl. intro Mx. apply mlub_le_compat.
intro y. rewrite hb. auto.
Qed.

(** *** DStepFixLV 
 *)

Definition DLV (seqV: seq V):  (VSt * LSt) -> distr (VSt*LSt) :=
 Mfix (DStepLV seqV).

Hypothesis localTerm : forall seqV res,
   Term (DStep LCs seqV res).

Variable cardTermB : VSt * LSt -> nat.

Variable c: U. 
Let k := [1-]c. 

Hypothesis hcard1 : forall r, (cardTermB r) = O -> termB r.

Hypothesis hcard2: 0 < c.

Hypothesis hcard3 :  forall (seqV: seq V) (res: VSt* LSt), 
 (0 < cardTermB res)%nat ->
 c <= mu (DStep LCs seqV res) 
   (fun x => B2U (lt_dec  (cardTermB x) (cardTermB res))).

Hypothesis hcard4 :  forall (seqV: seq V) (res: VSt *LSt), 
 mu (DStep LCs seqV res) 
   (fun x => B2U (lt_dec (cardTermB res) (cardTermB x))) == 0.

Lemma DLV_total : forall (seqV: seq V)(res: VSt * LSt),
 Term (DLV  seqV res).
Proof.
intros seqV res. 
unfold Term. 
rewrite -(@termglobal _  _ _ _ _ 
  (localTerm seqV) _ _ _ hcard1 hcard2 (fun _ => true) _ _ res)=>//;last first.
  intros. setoid_rewrite Umult_one_left. done. 
intros. apply hcard3=>//. 
apply mu_eq_compat=>//. 
simpl. intro. apply mlub_eq_compat=>//. 
intro. 
elim:x0 res=>//=. 
intros. case h:(termB res)=>//=. 
apply mu_eq_compat=>//.
Qed.

End iteration. 
End general.

Section port.

(** * Port algorithms
 *)
Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable (nu: V -> seq V). 
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v:V), uniq (nu v). 

Variable  (VLab: eqType) (PLab: eqType).
Variable pl0:PLab. 

Let Pt := (@port_finType V Adj). 
Let VSt := LabelFunc V VLab.
Let PSt := LabelFunc  Pt PLab.

Variable p0: Pt. 


Let DLocT := VLab -> (seq PLab) -> (seq PLab) -> distr (VLab * seq PLab).

Section round. 

 
Definition DPRound (seqV: seq V) (res: VSt* PSt) (LC:DLocT)
: distr (VSt*PSt) :=
 DRound WriteArea (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) seqV res LC. 

Section gen.
(** *** Lemmas: Gen
 *)
Variable DLr: DLocT. 
Variable GLr: GLocT VLab PLab.

Hypothesis LocalRule1: forall ls l1 l2, 
(Distsem (GLr ls l1 l2)) = 
(DLr ls l1 l2).

Lemma DPG_eq1 : forall (seqV: seq V) (res: VSt*PSt),
 Distsem (GPRound nu pl0 p0 seqV res GLr) =
 DPRound seqV res DLr.
Proof. 
elim=>//=a l H res. 
by rewrite H LocalRule1.
Qed.

End gen.

Section lemmas.

Variable Lr: DLocT. 

(** *** Lemmas: Other
 *)

Lemma DPRound_total : forall(s: seq V) (res: VSt* PSt),
(forall w, Term (Lr (Vread res.1 w) (Poutread nu p0 res.2 w) (Pinread nu p0 res.2 w))) ->
 Term (DPRound s res Lr).
Proof.
move=>s res h. 
by apply DRound_total.
Qed.

Lemma DPRoundCommute : forall (s1 s2: (seq V)) (res: VSt* PSt),
  (forall v, is_discrete_s  
        (Lr (Vread res.1 v) (Poutread nu p0 res.2 v) (Pinread nu p0 res.2 v))) ->
  perm_eq s1 s2 -> 
  (DPRound s1) res Lr == (DPRound s2) res Lr.
Proof.
move=>s1 s2 res h1 h2.
apply DRoundCommute3=>//.
apply  disjoint_outerport.
Qed.

End lemmas. 
End round.

Section roundlv.

(** ** Infinite iteration of Round
 *)

Variable Lr : DLocT. 
Variable termB : (VSt*PSt) -> bool.

(** *** DPRoundLV
 *)
Definition DPRoundLV (seqV : seq V) :=
 DRoundLV WriteArea (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) Lr termB seqV.

(** *** DPRoundFixLV
 *)
Definition DPRoundFixLV (seqV: seq V) :  (VSt * PSt) -> distr (VSt*PSt) :=
DRoundFixLV WriteArea (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) Lr termB seqV.

End roundlv.

Section iteration.
(** ** Iteration
 *)

Definition DPStep (LCs : seq DLocT) (seqV: seq V)(res: VSt* PSt)  
 : distr (VSt*PSt) :=
DStep WriteArea  (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) LCs seqV res.

Definition DPMC (n:nat) (LCs:seq DLocT)(seqV:seq V)(res:VSt*PSt) 
 : distr(VSt*PSt) :=
DMC WriteArea  (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) n LCs seqV res.


(** *** Lemmas: Gen
 *)
Variable DLCs : seq DLocT. 
Variable GLCs : seq (GLocT VLab PLab).

Hypothesis LocalRule3:LocalRule2 DLCs GLCs. 

Lemma DPG_eq2 : forall (seqV:seq V)(res:VSt*PSt),
 Distsem (GPStep nu pl0 p0 GLCs seqV res)  ==  DPStep DLCs seqV res.
Proof.
move:LocalRule3;set l1 := DLCs;set l2 := GLCs. 
elim:l1 l2 =>//=.
 elim=>//=.
intros;case:l2 LocalRule0=>//. 
intros;destruct LocalRule0=>/=.
rewrite (@DPG_eq1 a)=>//.
apply mu_eq_compat=>//x0. 
apply (H _ H1 seqV).
Qed.  

Lemma DPG_eq3 : forall (n:nat)(seqV:seq V)(res:VSt*PSt),
 Distsem (GPMC nu pl0 p0 n GLCs seqV res) 
 == DPMC n DLCs seqV res.
Proof. 
elim=>//=;intros. 
rewrite DPG_eq2.
apply mu_eq_compat=>// x0. 
apply H.
Qed.

(** *** Infinite iteration of Steps
 *)

Variable termB : VSt * PSt -> bool.
Variable LCs: seq DLocT. 

Definition DPStepLV (seqV: seq V):=
DStepLV WriteArea  (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) termB LCs seqV.

(** *** DPStepFixLV 
 *)

Definition DPLV (seqV: seq V):  (VSt * PSt) -> distr (VSt*PSt) :=
 DLV WriteArea  (@Vwrite _ VLab) (Pwrite nu pl0) (@Vread _ VLab) 
                 (Pinread nu p0) (Poutread nu p0) termB LCs seqV.

Hypothesis localTerm : forall seqV res,
   Term (DPStep LCs seqV res).

Variable cardTermB : VSt * PSt -> nat.

Variable c: U. 
Let k := [1-]c. 

Hypothesis hcard1 : forall r, (cardTermB r) = O -> termB r.

Hypothesis hcard2: 0 < c.

Variable PR : VSt * PSt -> bool.
Variable seqV : seq V. 
Hypothesis hcard3 :  forall (res: VSt* PSt), 
(0 < (cardTermB res))%nat ->  
PR res -> 
c <= mu (DPStep LCs seqV res) 
   (fun x => B2U (lt_dec  (cardTermB x) (cardTermB res))).

Hypothesis hcard4 :  forall (res: VSt *PSt), 
PR res ->
 mu (DPStep LCs seqV res) 
   (fun x => B2U (lt_dec (cardTermB res) (cardTermB x))) == 0.

Lemma DPLV_total : forall (res: VSt * PSt),
 PR res -> 
 (forall s f, PR s ->(mu (DPStep LCs seqV s))(fun x : VSt * PSt =>
           B2U (PR x) * (f x)) == (mu (DPStep LCs seqV s)) f) ->
 Term (DPLV  seqV res).
Proof. 
intros res Hres1 Hres2. 
unfold Term. 
rewrite -(termglobal (localTerm seqV)  hcard1 hcard2 hcard3  hcard4 
 Hres1 Hres2)=>//.
apply mu_eq_compat=>//. 
simpl. intro. apply mlub_eq_compat=>//. 
intro. clear Hres1 Hres2. 
elim:x0 res  =>//=. 
intros. case h:(termB res)=>//=. 
apply mu_eq_compat=>//.
Qed.

End iteration.
End port.
