Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.


Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import op.
Require Import rdaTool_op.
Require Import mis_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.


(** * Introduction 

       This file contains the simulation if the MIS algorithm described in mis_gen.
  *)

Section MIS.

Variable (rand_t : Type)(get : nat -> rand_t -> nat * rand_t).
Context (rand : ORandom _ get).

Let VLabel : eqType := option_eqType bool_eqType.
Let PLabel : eqType := nat_eqType.

Variable (c: nat).

Fixpoint OgetRandSeq (l: seq PLabel) : Op rand_t (seq PLabel) :=
 match l with 
  |nil => Oreturn nil 
  |t ::q => Obind (OgetRandSeq q) (fun l' => Obind (Orandom c rand) (fun x=> Oreturn (x.+1::l')))
 end.

Definition OMISLoc1 (lv:VLabel) (lpout lpin: seq PLabel) 
 : Op rand_t (VLabel *seq PLabel) :=
 if (active lv) then
  Obind (OgetRandSeq lpin) (fun l => Oreturn (lv, l))
else Oreturn (lv, nseq (seq.size lpin) 0).

Definition OMISLoc2 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  Op rand_t (VLabel *seq PLabel) :=
if (active lv) then
   if (supNeigh lpout lpin) then 
       Oreturn (Some true, nseq (seq.size lpin) 1)
   else Oreturn (None, nseq (seq.size lpin) 0)
else Oreturn (lv, nseq (seq.size lpin) 0).

Definition OMISLoc3 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  Op rand_t (VLabel *seq PLabel) :=
if (active lv) then
   if (hasRec1 lpin) then 
       Oreturn  (Some false, nseq  (seq.size lpin) 0)
   else Oreturn  (None, nseq  (seq.size lpin) 1)
else Oreturn  (lv, nseq (seq.size lpin) 0).

Variables (V:finType) (Adj: rel V).
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.

Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

Definition OMISStep (seqV : seq V ) (res: VState*PState)   := 
 OPStep nu O p0  (OMISLoc1::OMISLoc2::OMISLoc3::nil) seqV res. 

Definition OMISMC (n:nat) (seqV : seq V ) (res: VState*PState)   := 
 OPMC nu O p0  n (OMISLoc1::OMISLoc2::OMISLoc3::nil) seqV res.

Section gen.

Lemma OgetRandSeq_eq1 : forall l, 
 Opsem rand_t get rand (getRandSeq c l)=
 OgetRandSeq l.
Proof. 
elim=>//=;intros. 
by rewrite H.
Qed.  

Lemma OPGMIS_eq1 : forall  (lv:VLabel) (lp1 lp2: seq PLabel) ,
 Opsem _ get rand (MISLoc1 c lv lp1 lp2) = 
 OMISLoc1 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MISLoc1,OMISLoc1.
case : (active lv)=>//=.
by rewrite OgetRandSeq_eq1.
Qed.

Lemma OPGMIS_eq2 : forall  (lv:VLabel) (lp1 lp2: seq PLabel) ,
 Opsem _ get rand (MISLoc2  lv lp1 lp2) = 
 OMISLoc2 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MISLoc2,OMISLoc2.
case : (active lv)=>//=.
case: (supNeigh lp1 lp2)=>//=. 
Qed.

Lemma OPGMIS_eq3 : forall  (lv:VLabel) (lp1 lp2: seq PLabel) ,
 Opsem _ get rand (MISLoc3  lv lp1 lp2) = 
 OMISLoc3 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MISLoc3,OMISLoc3.
case : (active lv)=>//=.
case: (hasRec1 lp2)=>//=. 
Qed.

Lemma OPGMIS_eq4 : forall  (seqV: seq V) (res:VState*PState),
 Opsem _ get rand (MISStep nu p0 c seqV res) =1 
 OMISStep seqV res.
Proof.
move=>seqV res;unfold MISStep,OMISStep.  
apply OPG_eq2. 
simpl;split;intros. 
apply OPGMIS_eq1.
split;intros=>//.
apply OPGMIS_eq2.
split=>//. 
apply OPGMIS_eq3.  
Qed. 

Lemma OPGMIS_eq5 : forall (n:nat) (seqV: seq V) (res:VState*PState),
 Opsem _ get rand (MISMC nu p0 c n seqV res) =1 
 OMISMC n seqV res.
Proof.
move=>n seqV res;unfold MISMC,OMISMC.  
apply OPG_eq3. 
simpl;split;intros. 
apply OPGMIS_eq1.
split;intros=>//.
apply OPGMIS_eq2.
split;intros=>//. 
apply OPGMIS_eq3.  
Qed. 

End gen.

Section simulation.

Definition OMISMCF (n:nat) (seqV: seq V) (res: (V -> VLabel) * (V *  V -> PLabel)) :=
 OPFMC nu O n (OMISLoc1::OMISLoc2::OMISLoc3::nil) seqV res.

Lemma OMISF_eq1 : forall (n:nat) (seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v r,
 seqV = seqVF ->
 (forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OMISMC n seqV res r).1).1 v = 
   ((OMISMCF n seqVF resF r).1).1 v.
Proof.
move=>n seqV seqVF res resF v r h0 h1 h2; unfold OMISMC,OMISMCF.
rewrite h0.
apply OPF_eq11=>//.
Qed. 

Lemma OMISF_eq2 : forall (n:nat) (seqV seqVF : seq V)(res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v w r,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
   ((OMISMC n seqV res r).1).2 (VtoP v w p0) = 
   ((OMISMCF n seqVF resF r).1).2 (v,w).
Proof.
move=>n seqV seqVF res resF v w r h0 h1 h2 h3; unfold OMISMC,OMISMCF.
rewrite h0. 
apply OPF_eq12=>//. 
Qed. 

 Lemma OMISF_eq3 : forall (n:nat)(seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) r,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   (OMISMC n seqV res r).2 = 
   (OMISMCF n seqVF resF r).2.
Proof.
move=>n seqV seqVF res resF r h0 h1 h2; unfold OMISMC,OMISMCF.
rewrite h0. 
apply OPF_eq10=>//. 
Qed. 

End simulation.


End MIS.

Section simulation.

(** Definition of the graph 
 *)

Inductive V : Type :=
 |v0 : V
 |v1 : V
 |v2 : V
 |v3 : V. 

Definition eqV := (fun x y : V =>
 match x,y with 
|v0,v0 => true
|v1,v1 => true
|v2,v2=>true
|v3,v3 => true
|_,_ => false
end). 

Lemma eqVP : Equality.axiom eqV. 
Proof. 
intros a b;unfold eqV. 
case:a;case b=>//=;constructor=>//=.
Qed. 


Canonical V_eqMixin := EqMixin eqVP. 
Canonical V_eqType:= Eval hnf in EqType V V_eqMixin.

Lemma V_pickleK : pcancel (fun v : V => match v with |v0 => O |v1 => 1%nat |v2 => 
2 |v3 => 3 end) 
 (fun x : nat => match x with |0 => Some v0 | 1 => Some v1 
     |2 => Some v2 | 3 => Some v3 | _ => None end).
Proof.
intro x. case:x=>//=. 
Qed. 

Fact V_choiceMixin : choiceMixin V.
Proof. 
apply (PcanChoiceMixin V_pickleK). 
Qed. 

Canonical V_choiceType :=  Eval hnf in ChoiceType V V_choiceMixin.

Definition V_countMixin := CountMixin V_pickleK.
Canonical V_countType := Eval hnf in CountType V V_countMixin.

Definition venum :=  (v0:: v1:: v2:: v3:: nil). 
Lemma V_enumP : Finite.axiom venum. 
Proof. 
by case. 
Qed.
 
Definition V_finMixin := Eval hnf in FinMixin  V_enumP.
Canonical V_finType := Eval hnf in FinType V V_finMixin.

Lemma card_V : #|{: V}| = 4. 
Proof. 
by rewrite cardT enumT unlock. 
Qed.

Definition Adj : rel V := (fun x y => match x, y with
 |v0,v1 |v0,v3 |v1,v0 |v1,v2 |v1,v3 |v2,v1 |v2,v3 |v3,v0 |v3,v1 |v3,v2 => true
 | _,_ => false
 end).

Lemma AdjSym : symmetric Adj.
Proof. 
intros m n.
case:m;case:n=>//=. 
Qed. 
   
Lemma AdjIrrefl : irreflexive Adj. 
Proof. 
intro n.
case:n=>//=.
Qed. 

Lemma enumV : (enum V_finType) = ([::v0;v1;v2;v3] ). 
Proof.
by rewrite enumT unlock. 
Qed.

Context `(NG: NGraph V_finType Adj).

Lemma Nb_enumv0 : Nb_enum Gr v0 = (v1::v3::nil). 
Proof.
unfold Nb_enum,Adj=>/=.
unfold enum_mem. 
by rewrite -enumT enumV.
Qed. 

Lemma degv0 : (deg Gr v0) = 2. 
Proof. 
unfold deg. 
by rewrite Nb_enumv0.
Qed.

Definition nu (v: V) : seq V :=
 match v with 
   |v0 => [::v1;v3] 
   |v1 => [::v0;v2;v3] 
   |v2 => [::v1;v3] 
   |v3 => [::v1;v2;v0] 
end.

Lemma nuAdj_eq : forall u w, 
Adj u w = (w \in nu u). 
Proof. 
move=>u w;unfold Adj, nu.
case:u;case:w=>//. 
Qed. 

Lemma hp0 : Adj (v0,v1).1 (v0,v1).2. 
Proof. auto. Qed.

Definition p0 := Port hp0. 

(** Definition of the labelling 
 *) 
Let VLabel : eqType := option_eqType bool_eqType.
Let PLabel : eqType := nat_eqType.

Definition initV : (LabelFunc V_finType VLabel) :=
finfun  (fun x:V => None).

Definition initP : (LabelFunc (@port_finType V_finType Adj)   PLabel) :=
 finfun (fun x => O).  

Definition init := (initV, initP). 

Definition initVF : (V ->  VLabel) :=
 (fun x:V => None).

Definition initPF : ((V*V) ->  PLabel) :=
 (fun x => O).

Definition initF := (initVF, initPF). 

Lemma init_eq1 : forall v,  init.1 v = initF.1 v.
Proof. 
move=>v. 
by rewrite ffunE.
Qed.

Lemma init_eq2 : forall v w,  
 Adj v w -> init.2 (VtoP v w p0) = initF.2 (v,w).
Proof. 
move=>v w h/=.
by rewrite ffunE.
Qed.

(** Equivalence
 *)

Definition c := 2^8.-1. 

Lemma OMMF_eq4 : forall n v r,
   ((OMISMC my_gen c nu p0 n (enum V_finType) init r).1).1 v = 
   ((OMISMCF my_gen c nu n [::v0;v1;v2;v3] initF r).1).1 v.
Proof.
move=>n v r. 
apply (OMISF_eq1 my_gen c NG). 
 by apply nuAdj_eq.
 by apply enumV.
 by apply init_eq1.
by apply init_eq2.
Qed. 

Lemma OMISF_eq5 : forall n v w r,
 Adj v w ->
   ((OMISMC my_gen c nu p0 n (enum V_finType) init r).1).2 (VtoP v w p0) = 
   ((OMISMCF my_gen c nu n [::v0;v1;v2;v3]  initF r).1).2 (v,w).
Proof.
move=>n v w r. 
apply (OMISF_eq2 my_gen c NG).
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

 Lemma OMISF_eq6 : forall n r,
   (OMISMC my_gen c nu p0 n (enum V_finType) init r).2 = 
   (OMISMCF my_gen c nu n [::v0;v1;v2;v3]  initF r).2.
Proof.
move=>n r. 
apply (OMISF_eq3 my_gen c NG). 
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

(** Computation
 *)

(* With seed equal to 6 *)

Let R1 := OMISLoc1 my_gen c.  
Let RR1 := (OPFRound nu O  [::v0;v1;v2;v3] initF R1).

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (RR1 6).1).
Eval vm_compute in ( (RR1 6).2). 

Let R2 := @OMISLoc2 nat.
Let RR2 := (OPFRound nu O  [::v0;v1;v2;v3] (RR1 6).1 R2).

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (RR2 12).1).
Eval vm_compute in ( (RR2 12).2).

 Let R3 := @OMISLoc3 nat. 
Let RR3 := (OPFRound nu O  [::v0;v1;v2;v3] (RR2 12).1 R3).

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (RR3 12).1).
Eval vm_compute in ( (RR3 12).2).

Let R (n:nat) :=  (OMISMCF my_gen c nu n [::v0;v1;v2;v3] initF) 6.

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (R 1).1).
Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (R 2).1).

End simulation.