Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.


Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import gen.
Require Import rdaTool_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction 

        We define the MIS algorithm according three local rules : sends draw numbers to neighbours, 
        if it is the maximal then enters the MIS and send 1, if received 1 then enters the complementary.
  *)

Section MIS.
  
(** * The graph
 *)

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.
 
Let VLabel : eqType := option_eqType bool_eqType.
Let PLabel : eqType := nat_eqType.


Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

Variable (c:nat). 

Definition active (lv: VLabel) : bool :=
 lv == None.

(** number between 1 and c+1 **)
Fixpoint getRandSeq (l: seq PLabel) : gen (seq PLabel) :=
 match l with 
  |nil => Greturn _ nil 
  |t ::q => Gbind _ _ (getRandSeq q) (fun l' => Grandom _ c (fun x => Greturn _ (x.+1::l')))
 end.

Definition MISLoc1 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  gen (VLabel * seq PLabel) :=
if (active lv) then
  Gbind _ _ (getRandSeq lpin) (fun l => Greturn _ (lv, l))
else Greturn _ (lv, nseq (seq.size lpin) 0).

Fixpoint supNeigh  (lpout:seq PLabel) (lpin:seq PLabel): bool :=
 match lpout,lpin with 
  |t::q, t'::q' => (t' < t)%nat && (supNeigh q q') 
  | nil , nil => true
  | _ , _ => false
end.

 Definition MISLoc2 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  gen (VLabel * seq PLabel) :=
if (active lv) then
   if (supNeigh lpout lpin) then 
       Greturn _ (Some true, nseq (seq.size lpin) 1)
   else Greturn _ (None, nseq (seq.size lpin) 0)
else Greturn _ (lv, nseq (seq.size lpin) 0).

Definition hasRec1 (l: seq PLabel) :=
 has (fun x => x == 1) l. 

 Definition MISLoc3 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  gen (VLabel * seq PLabel) :=
if (active lv) then
   if (hasRec1 lpin) then 
       Greturn _ (Some false, nseq  (seq.size lpin) 0)
   else Greturn _ (None, nseq  (seq.size lpin) 1)
else Greturn _ (lv, nseq  (seq.size lpin) 0).

Definition MISStep (seqV : seq V ) (res: VState*PState)   := 
 GPStep nu O p0  (MISLoc1::MISLoc2::MISLoc3::nil) seqV res. 

Definition MISMC (n:nat) (seqV : seq V ) (res: VState*PState)   := 
 GPMC nu O p0  n (MISLoc1::MISLoc2::MISLoc3::nil) seqV res. 

End MIS.
