Require Import ssreflect ssrfun ssrbool eqtype ssrnat.
Require Import fintype finset fingraph seq finfun bigop choice tuple.
Import Prenex Implicits.

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../ra".
Add LoadPath "../graph".
Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Require Import Rplus.
Require Import my_alea.
Require Import my_ssr.
Require Import my_ssralea. 
Require Import graph.
Require Import labelling.
Require Import gen.
Require Import dist. 
Require Import rdaTool_gen.
Require Import rdaTool_dist.
Require Import mis_gen.
Set Implicit Arguments.
Unset Strict Implicit.

(** * Introduction 
       
           This file contains the analysis of the MIS described in mis_gen
   *)

Section MIS.

(** * Definitions
 *)
Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Definition Pt := (@port_finType V Adj). 
Variable (p0: Pt). 

Let VLab : eqType := option_eqType bool_eqType.
Let PLab : eqType := nat_eqType.

Definition VState := LabelFunc V VLab.
Definition PState := LabelFunc  Pt PLab.

Variable (c: nat).

Fixpoint DgetRandSeq (l: seq PLab) : distr (seq PLab) :=
 match l with 
  |nil => Munit nil 
  |t ::q => Mlet (DgetRandSeq q) (fun l' => Mlet (Random c) (fun x=> Munit (x.+1::l')))
 end.

Definition DMISLoc1 (lv:VLab) (lpout:seq PLab) (lpin:seq PLab): 
  distr (VLab * seq PLab) :=
 if (active lv) then 
  Mlet (DgetRandSeq lpin) (fun l => Munit (lv, l))
else Munit (lv, nseq (seq.size lpin) O).

Definition DMISLoc2 (lv:VLab) (lpout:seq PLab) (lpin:seq PLab): 
  distr (VLab * seq PLab) :=
 if (active lv) then 
    if (supNeigh lpout lpin) then 
       Munit (Some true, nseq (seq.size lpin) 1)
   else Munit (None, nseq (seq.size lpin) O)
else Munit (lv, nseq (seq.size lpin) O).


Definition DMISLoc3 (lv:VLab) (lpout:seq PLab) (lpin:seq PLab): 
  distr (VLab * seq PLab) :=
 if (active lv) then 
   if (hasRec1 lpin) then 
       Munit  (Some false, nseq  (seq.size lpin) O)
   else Munit  (None, nseq  (seq.size lpin) 1)
else Munit  (lv, nseq (seq.size lpin) O).

Definition DMISStep (seqV : seq V ) (res: VState*PState)   := 
 DPStep nu O p0  (DMISLoc1::DMISLoc2::DMISLoc3::nil) seqV res. 

Definition DMISMC (n:nat) (seqV : seq V ) (res: VState*PState)   := 
 DPMC nu O p0  n (DMISLoc1::DMISLoc2::DMISLoc3::nil) seqV res.

(** * Equivalence 
 *) 

Lemma DgetRandSeq_eq1 : forall l, 
 Distsem (getRandSeq c l)=
 DgetRandSeq l.
Proof. 
elim=>//=;intros. 
by rewrite H.
Qed.  

Lemma DPGMIS_eq1 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem (MISLoc1 c lv lp1 lp2) = 
 DMISLoc1 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MISLoc1,DMISLoc1.
case : (active lv)=>//=.
by rewrite DgetRandSeq_eq1. 
Qed.

Lemma DPGMIS_eq2 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem (MISLoc2 lv lp1 lp2) = 
 DMISLoc2 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MISLoc2,DMISLoc2.
case : (active lv)=>//=.
case: (supNeigh lp1 lp2)=>//=. 
Qed.

Lemma DPGMIS_eq3 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem (MISLoc3 lv lp1 lp2) = 
 DMISLoc3 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MISLoc3,DMISLoc3.
case : (active lv)=>//=.
case: (hasRec1 lp2)=>//=. 
Qed.

Lemma DPGMIS_eq4 : forall  (seqV: seq V) (res:VState*PState),
 Distsem (MISStep nu p0 c seqV res) == 
 DMISStep seqV res.
Proof.
move=>seqV res;unfold MISStep,DMISStep.  
apply DPG_eq2=>/=.  
split;intros. 
apply DPGMIS_eq1.
split;intros=>//.
apply DPGMIS_eq2.
split=>//. 
apply DPGMIS_eq3.  
Qed. 

Lemma DPGMIS_eq5 : forall (n:nat) (seqV: seq V) (res:VState*PState),
 Distsem  (MISMC nu p0 c n seqV res) == 
 DMISMC n seqV res.
Proof.
move=>n seqV res;unfold MISMC,DMISMC.  
apply DPG_eq3. 
simpl;split;intros. 
apply DPGMIS_eq1.
split;intros=>//.
apply DPGMIS_eq2.
split;intros=>//. 
apply DPGMIS_eq3.  
Qed. 

End MIS.
