Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.


Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import op.
Require Import rdaTool_op.
Require Import handshake_gen.
Require Import hsAct_gen.
Require Import hsAct_op.
Require Import maxmatch_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction 

          This file contains a simulation of the maximal matching algorithm described in maxmatch_gen
   *)

Section HS.

Variable (rand_t : Type)(get : nat -> rand_t -> nat * rand_t).
Context (rand : ORandom _ get).

Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.

Definition OMMLoc1 (lv:VLabel) (lpout lpin: seq PLabel) 
 : Op rand_t (VLabel *seq PLabel) :=
 if (activeL lv) then 
   if (agreed lpout lpin) then 
       Oreturn ( Some (index true lpout) , nseq (seq.size lpout) false)
    else Oreturn (None, nseq (seq.size lpout) true)
 else (* inactif *) Oreturn (lv, lpout).

Definition OMMLoc2 (lv:VLabel) (lpout lpin: seq PLabel) 
 : Op rand_t (VLabel *seq PLabel) :=
 OHSLoc rand lv lpout lpin.

Variables (V:finType) (Adj: rel V).
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.

Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

Definition OMMStep (seqV: seq V)(res: VState * PState)  :=
 OPStep nu false p0 (OMMLoc2::OMMLoc1::nil) seqV res.

Definition OMMMC (n: nat) (seqV: seq V)(res: VState * PState)  :=
 OPMC nu false p0 n (OMMLoc2::OMMLoc1::nil) seqV res.

Section gen.

Lemma OPGMM_eq1 : forall  (lv:VLabel) (lp1 lp2: seq PLabel) ,
 Opsem _ get rand (MMLoc1 lv lp1 lp2) = 
 OMMLoc1 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MMLoc1,OMMLoc1.
case : (activeL lv)=>//=.
case:(agreed lp1 lp2)=>//=.
Qed.

Lemma OPGMM_eq2 : forall  (lv:VLabel) (lp1 lp2: seq PLabel) ,
 Opsem _ get rand (MMLoc2 lv lp1 lp2) = 
 OMMLoc2 lv lp1 lp2.
Proof.
apply OPGHS_eq1. 
Qed.

Lemma OPGMM_eq3 : forall  (seqV: seq V) (res:VState*PState),
 Opsem _ get rand (MMStep nu p0 seqV res) =1 
 OMMStep seqV res.
Proof.
move=>seqV res;unfold MMStep,OMMStep.  
apply OPG_eq2. 
simpl;split;intros. 
apply OPGMM_eq2.
split;intros=>//.
apply OPGMM_eq1. 
Qed. 

Lemma OPGMM_eq4 : forall (n:nat) (seqV: seq V) (res:VState*PState),
 Opsem _ get rand (MMMC nu p0 n seqV res) =1 
 OMMMC n seqV res.
Proof.
move=>n seqV res;unfold MMMC,OMMMC.  
apply OPG_eq3. 
simpl;split;intros. 
apply OPGMM_eq2.
split;intros=>//.
apply OPGMM_eq1. 
Qed. 

End gen.

Section simulation.

Definition OMMStepF (seqV: seq V) (res: (V -> VLabel) * (V *  V -> PLabel)) :=
 OPFStep nu false (OMMLoc2::OMMLoc1::nil) seqV res.

Lemma OMMF_eq1 : forall (seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v n,
 seqV = seqVF ->
 (forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OMMStep seqV res n).1).1 v = 
   ((OMMStepF seqVF resF n).1).1 v.
Proof.
move=>seqV seqVF res resF v n h0 h1 h2; unfold OMMStep,OMMStepF.
rewrite h0.
apply OPF_eq8=>//. 
Qed. 

Lemma OMMF_eq2 : forall  (seqV seqVF : seq V)(res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v w n,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
   ((OMMStep seqV res n).1).2 (VtoP v w p0) = 
   ((OMMStepF seqVF resF n).1).2 (v,w).
Proof.
move=>seqV seqVF res resF v w n h0 h1 h2 h3; unfold OMMStep,OMMStepF.
rewrite h0. 
apply OPF_eq9=>//. 
Qed. 

 Lemma OMMF_eq3 : forall (seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) n,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   (OMMStep seqV res n).2 = 
   (OMMStepF seqVF resF n).2.
Proof.
move=>seqV seqVF res resF n h0 h1 h2; unfold OMMStep,OMMStepF.
rewrite h0. 
apply OPF_eq7=>//. 
Qed. 

Definition OMMMCF (n:nat) (seqV: seq V) (res: (V -> VLabel) * (V *  V -> PLabel)) :=
 OPFMC nu false n (OMMLoc2::OMMLoc1::nil) seqV res.

Lemma OMMF_eq4 : forall (n:nat) (seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v r,
 seqV = seqVF ->
 (forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OMMMC n seqV res r).1).1 v = 
   ((OMMMCF n seqVF resF r).1).1 v.
Proof.
move=>n seqV seqVF res resF v r h0 h1 h2; unfold OMMMC,OMMMCF.
rewrite h0.
apply OPF_eq11=>//.
Qed. 

Lemma OMMF_eq5 : forall (n:nat) (seqV seqVF : seq V)(res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v w r,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
   ((OMMMC n seqV res r).1).2 (VtoP v w p0) = 
   ((OMMMCF n seqVF resF r).1).2 (v,w).
Proof.
move=>n seqV seqVF res resF v w r h0 h1 h2 h3; unfold OMMMC,OMMMCF.
rewrite h0. 
apply OPF_eq12=>//. 
Qed. 

 Lemma OMMF_eq6 : forall (n:nat)(seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) r,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   (OMMMC n seqV res r).2 = 
   (OMMMCF n seqVF resF r).2.
Proof.
move=>n seqV seqVF res resF r h0 h1 h2; unfold OMMMC,OMMMCF.
rewrite h0. 
apply OPF_eq10=>//. 
Qed. 

End simulation.


End HS.

Section simulation.

(** Definition of the graph 
 *)

Inductive V : Type :=
 |v0 : V
 |v1 : V
 |v2 : V
 |v3 : V. 

Definition eqV := (fun x y : V =>
 match x,y with 
|v0,v0 => true
|v1,v1 => true
|v2,v2=>true
|v3,v3 => true
|_,_ => false
end). 

Lemma eqVP : Equality.axiom eqV. 
Proof. 
intros a b;unfold eqV. 
case:a;case b=>//=;constructor=>//=.
Qed. 


Canonical V_eqMixin := EqMixin eqVP. 
Canonical V_eqType:= Eval hnf in EqType V V_eqMixin.

Lemma V_pickleK : pcancel (fun v : V => match v with |v0 => O |v1 => 1%nat |v2 => 
2 |v3 => 3 end) 
 (fun x : nat => match x with |0 => Some v0 | 1 => Some v1 
     |2 => Some v2 | 3 => Some v3 | _ => None end).
Proof.
intro x. case:x=>//=. 
Qed. 

Fact V_choiceMixin : choiceMixin V.
Proof. 
apply (PcanChoiceMixin V_pickleK). 
Qed. 

Canonical V_choiceType :=  Eval hnf in ChoiceType V V_choiceMixin.

Definition V_countMixin := CountMixin V_pickleK.
Canonical V_countType := Eval hnf in CountType V V_countMixin.

Definition venum :=  (v0:: v1:: v2:: v3:: nil). 
Lemma V_enumP : Finite.axiom venum. 
Proof. 
by case. 
Qed.
 
Definition V_finMixin := Eval hnf in FinMixin  V_enumP.
Canonical V_finType := Eval hnf in FinType V V_finMixin.

Lemma card_V : #|{: V}| = 4. 
Proof. 
by rewrite cardT enumT unlock. 
Qed.

Definition Adj : rel V := (fun x y => match x, y with
 |v0,v1 |v0,v3 |v1,v0 |v1,v2 |v1,v3 |v2,v1 |v2,v3 |v3,v0 |v3,v1 |v3,v2 => true
 | _,_ => false
 end).

Lemma AdjSym : symmetric Adj.
Proof. 
intros m n.
case:m;case:n=>//=. 
Qed. 
   
Lemma AdjIrrefl : irreflexive Adj. 
Proof. 
intro n.
case:n=>//=.
Qed. 

Lemma enumV : (enum V_finType) = ([::v0;v1;v2;v3] ). 
Proof.
by rewrite enumT unlock. 
Qed.

Context `(NG: NGraph V_finType Adj).

Lemma Nb_enumv0 : Nb_enum Gr v0 = (v1::v3::nil). 
Proof.
unfold Nb_enum,Adj=>/=.
unfold enum_mem. 
by rewrite -enumT enumV.
Qed. 

Lemma degv0 : (deg Gr v0) = 2. 
Proof. 
unfold deg. 
by rewrite Nb_enumv0.
Qed.

Definition nu (v: V) : seq V :=
 match v with 
   |v0 => [::v1;v3] 
   |v1 => [::v0;v2;v3] 
   |v2 => [::v1;v3] 
   |v3 => [::v1;v2;v0] 
end.

Lemma nuAdj_eq : forall u w, 
Adj u w = (w \in nu u). 
Proof. 
move=>u w;unfold Adj, nu.
case:u;case:w=>//. 
Qed. 

Lemma hp0 : Adj (v0,v1).1 (v0,v1).2. 
Proof. auto. Qed.

Definition p0 := Port hp0. 

(** Definition of the labelling 
 *) 
Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.

Definition initV : (LabelFunc V_finType VLabel) :=
finfun  (fun x:V => None).

Definition initP : (LabelFunc (@port_finType V_finType Adj)   PLabel) :=
 finfun (fun x => true).  

Definition init := (initV, initP). 

Definition initVF : (V ->  VLabel) :=
 (fun x:V => None).

Definition initPF : ((V*V) ->  PLabel) :=
 (fun x => true).

Definition initF := (initVF, initPF). 

Lemma init_eq1 : forall v,  init.1 v = initF.1 v.
Proof. 
move=>v. 
by rewrite ffunE.
Qed.

Lemma init_eq2 : forall v w,  
 Adj v w -> init.2 (VtoP v w p0) = initF.2 (v,w).
Proof. 
move=>v w h/=.
by rewrite ffunE.
Qed.

(** Equivalence
 *)

Lemma OMMF_eq7 : forall v n,
   ((OMMStep my_gen nu p0 (enum V_finType) init n).1).1 v = 
   ((OMMStepF my_gen nu [::v0;v1;v2;v3]  initF n).1).1 v.
Proof.
move=>v n. 
apply (OMMF_eq1 my_gen NG). 
 by apply nuAdj_eq.
 by apply enumV.
 by apply init_eq1.
by apply init_eq2.
Qed. 

Lemma OMMF_eq8 : forall v w n,
 Adj v w ->
   ((OMMStep my_gen nu p0 (enum V_finType) init n).1).2 (VtoP v w p0) = 
   ((OMMStepF my_gen nu [::v0;v1;v2;v3]  initF n).1).2 (v,w).
Proof.
move=>v w n. 
apply (OMMF_eq2 my_gen NG).
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

 Lemma OHSF_eq9 : forall n,
   (OMMStep my_gen nu p0 (enum V_finType) init n).2 = 
   (OMMStepF my_gen nu [::v0;v1;v2;v3]  initF n).2.
Proof.
move=>n. 
apply (OMMF_eq3 my_gen NG). 
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

Lemma OMMF_eq10 : forall n v r,
   ((OMMMC my_gen nu p0 n (enum V_finType) init r).1).1 v = 
   ((OMMMCF my_gen nu n [::v0;v1;v2;v3] initF r).1).1 v.
Proof.
move=>n v r. 
apply (OMMF_eq4 my_gen NG). 
 by apply nuAdj_eq.
 by apply enumV.
 by apply init_eq1.
by apply init_eq2.
Qed. 

Lemma OMMF_eq11 : forall n v w r,
 Adj v w ->
   ((OMMMC my_gen nu p0 n (enum V_finType) init r).1).2 (VtoP v w p0) = 
   ((OMMMCF my_gen nu n [::v0;v1;v2;v3]  initF r).1).2 (v,w).
Proof.
move=>n v w r. 
apply (OMMF_eq5 my_gen NG).
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

 Lemma OHSF_eq12 : forall n r,
   (OMMMC my_gen nu p0 n (enum V_finType) init r).2 = 
   (OMMMCF my_gen nu n [::v0;v1;v2;v3]  initF r).2.
Proof.
move=>n r. 
apply (OMMF_eq6 my_gen NG). 
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

(** Computation
 *)

(* With seed equal to 6 *)
Let R1 :=  (OMMStepF my_gen nu [::v0;v1;v2;v3] initF) 6. 

Check (R1).

Eval vm_compute in (R1.1.1 v3).
Eval vm_compute in (R1.1.2 (v3,v1)).
Eval vm_compute in (R1.1.2 (v3,v2)).
Eval vm_compute in (R1.1.2 (v3,v0)).

Eval vm_compute in (R1.1.1 v0).
Eval vm_compute in (R1.1.2 (v0,v1)).
Eval vm_compute in (R1.1.2 (v0,v3)).
Eval vm_compute in (R1.1.2 (v0,v0)).

Eval vm_compute in (R1.1.1 v1).
Eval vm_compute in (R1.1.2 (v1,v2)).
Eval vm_compute in (R1.1.2 (v1,v3)).
Eval vm_compute in (R1.1.2 (v1,v0)).

Eval vm_compute in (R1.1.1 v2).
Eval vm_compute in (R1.1.2 (v2,v1)).
Eval vm_compute in (R1.1.2 (v2,v3)).
Eval vm_compute in (R1.1.2 (v2,v0)).


Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  R1.1).

(* 
[:: (v0, None, [:: (v1, true); (v3, true)]);
           (v1, Some 1, [:: (v0, false); (v2, false); (v3, false)]);
           (v2, Some 0, [:: (v1, false); (v3, false)]);
           (v3, None, [:: (v1, true); (v2, true); (v0, true)])]
*)

Let R2 (n:nat) :=  (OMMMCF my_gen nu n [::v0;v1;v2;v3] initF) 6.

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (R2 1).1).

(* [:: (v0, None, [:: (v1, true); (v3, true)]);
           (v1, Some 1, [:: (v0, false); (v2, false); (v3, false)]);
           (v2, Some 0, [:: (v1, false); (v3, false)]);
           (v3, None, [:: (v1, true); (v2, true); (v0, true)])]
 *)

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (R2 2).1).

(*[:: (v0, Some 1, [:: (v1, false); (v3, false)]);
           (v1, Some 1, [:: (v0, false); (v2, false); (v3, false)]);
           (v2, Some 0, [:: (v1, false); (v3, false)]);
           (v3, Some 2, [:: (v1, false); (v2, false); (v0, false)])]
*)

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (R2 3).1).

(*[:: (v0, Some 1, [:: (v1, false); (v3, false)]);
           (v1, Some 1, [:: (v0, false); (v2, false); (v3, false)]);
           (v2, Some 0, [:: (v1, false); (v3, false)]);
           (v3, Some 2, [:: (v1, false); (v2, false); (v0, false)])]
 *)

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  (R2 6).1).

(* [:: (v0, Some 1, [:: (v1, false); (v3, false)]);
           (v1, Some 1, [:: (v0, false); (v2, false); (v3, false)]);
           (v2, Some 0, [:: (v1, false); (v3, false)]);
           (v3, Some 2, [:: (v1, false); (v2, false); (v0, false)])]
*)



End simulation.