Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.


Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import gen.
Require Import rdaTool_gen.
Require Import hsAct_gen.
Require Import handshake_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.


(** * Introduction

   The maximal matching algorithm is the following:
 State of a vertex: None (= active)  / Some i (matching ith neighbours or nobody 
                                          if i>deg)
    State of a port : Bit messages
    Algorithm : 2 stages, the first to udate the activity, 
                the second to choose a neighbour
    We consider a graph with active and inactive vertices. Handshakes happen in the 
    active subgraph.
    At the beginning, every vertex is active and sent 0-messages 
    (saying no choice are made)
    Only active vertex does the 2 computations.
   Local Computation 2: If the number of active neighbours is null 
                            then state becomes inactive (isolated vertex), 
                                 send 0 to all neighbours
                         Else, choose a neighbour and send  1 to it and 0 to the other 
   Local Computation 1: If the received message and the sent message is equal to 1 
                           (2 neighbours mutually choosen) 
                            then state become inactive (keep messages as before)
                         Else, stay active and send 1 to all neighbours
 

    At the end, every vertex is inactive, handshakes are represented by 
    1-labelled edges 
 *)


Section MaxMatch.
(** * The graph
 *)

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.
 
Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.


Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

Definition MMLoc1 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  gen (VLabel * seq PLabel) :=
 if (activeL lv) then 
   if (agreed lpout lpin) then 
       Greturn _ ( Some (index true lpout) , nseq (seq.size lpout) false)
    else Greturn _ (None, nseq (seq.size lpout) true)
 else (* inactif *) Greturn _ (lv, lpout).

Definition MMLoc2 (lv:VLabel) (lpout:seq PLabel) (lpin:seq PLabel): 
  gen (VLabel * seq PLabel) :=
 HSLoc lv lpout lpin.

Definition MMStep (seqV : seq V ) (res: VState*PState)   := 
 GPStep nu false p0  (MMLoc2::MMLoc1::nil) seqV res. 

Definition MMMC (n:nat) (seqV : seq V ) (res: VState*PState)   := 
 GPMC nu false p0  n (MMLoc2::MMLoc1::nil) seqV res. 


End MaxMatch.
