Require Import ssreflect ssrfun ssrbool eqtype ssrnat.
Require Import fintype finset fingraph seq finfun bigop choice tuple.
Import Prenex Implicits.

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../ra".
Add LoadPath "../graph".
Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Require Import Rplus.
Require Import my_alea.
Require Import my_ssr.
Require Import my_ssralea. 
Require Import graph.
Require Import labelling.
Require Import gen.
Require Import dist. 
Require Import rdaTool_gen.
Require Import rdaTool_dist.
Require Import handshake_gen.
Require Import hsAct_gen.
Require Import hsAct_dist.
Require Import maxmatch_gen.
Set Implicit Arguments.
Unset Strict Implicit.

(** * Introduction

          This file contains the analysis of the maximal matching algorithm described in maxmatch_gen
   *)

Section MaxMatch.

(** * Definitions
 *)
Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Definition Pt := (@port_finType V Adj). 

Definition E := (@edge_finType V Adj).
Variable e0:E.

Definition p0 := (EtoP1 e0). 

Definition VState := LabelFunc V VLab.
Definition PState := LabelFunc  Pt PLab.

Variable initState : VState * PState.

Hypothesis initState1 : forall (v:V), (activeG v initState)  -> 
 (Poutread nu p0 initState.2 v) = nseq (seq.size (nu v)) true.

Hypothesis initState2 : forall v, (inactiveG v initState) -> 
 (Poutread nu p0 initState.2 v) = nseq (seq.size (nu v)) false.

Hypothesis initState3 : 
(0 < count (fun x0 : V => activeG x0 initState && (0 < nactv nu e0 initState x0))
     (enum V))%nat. 

Definition DMMLoc1 (lv:VLab) (lpout:seq PLab) (lpin:seq PLab): 
  distr (VLab * seq PLab) :=
 if (activeL lv) then 
   if (agreed lpout lpin) then 
       Munit ( Some (index true lpout) , nseq (seq.size lpout) false)
    else Munit (None, nseq (seq.size lpout) true)
 else (* inactif *) Munit (lv, lpout).

Definition DMMLoc2 (lv:VLab) (lpout:seq PLab) (lpin:seq PLab): 
  distr (VLab * seq PLab) :=
 DHSLoc lv lpout lpin.


Definition DPRLC1 s x:=
(DPRound nu false p0 s x DMMLoc1).

Definition DPRLC2 s x :=
(DPRound nu false p0 s x DMMLoc2).

Definition DMMStep (seqV: seq V) (res: VState*PState)   := 
 DPStep nu false p0 (DMMLoc2::DMMLoc1::nil) seqV res. 


Definition DMMMC (n:nat) (seqV: seq V) (res: VState*PState)   := 
 DPMC nu false p0 n (DMMLoc2::DMMLoc1::nil) seqV res. 


(** * Equivalence 
 *) 

Lemma DPGMM_eq1 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem (MMLoc1 lv lp1 lp2) = 
 DMMLoc1 lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold MMLoc1,DMMLoc1.
case : (activeL lv)=>//=.
case:(agreed lp1 lp2)=>//=.
Qed.

Lemma DPGMM_eq2 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem (MMLoc2 lv lp1 lp2) = 
 DMMLoc2 lv lp1 lp2.
Proof.
apply DPGHS_eq1. 
Qed.

Lemma DPGMM_eq3 : forall  (seqV: seq V) (res:VState*PState),
 Distsem (MMStep nu p0 seqV res) == 
 DMMStep seqV res.
Proof.
move=>seqV res;unfold MMStep,DMMStep.  
apply DPG_eq2. 
simpl;split;intros. 
apply DPGMM_eq2.
split;intros=>//.
apply DPGMM_eq1. 
Qed. 

Lemma DPGMM_eq4 : forall (n:nat) (seqV: seq V) (res:VState*PState),
 Distsem (MMMC nu p0 n seqV res) == 
 DMMMC n seqV res.
Proof.
move=>n seqV res;unfold MMMC,DMMMC.  
apply DPG_eq3. 
simpl;split;intros. 
apply DPGMM_eq2.
split;intros=>//.
apply DPGMM_eq1. 
Qed. 

(** * Lemmas
 *)

Lemma DMMLoc1_total : forall lv lpout lpin,
 Term (DMMLoc1 lv lpout lpin).
Proof. 
move=>lv lpout lpin;unfold DMMLoc1. 
case:(activeL lv)=>//. 
case:(agreed lpout lpin)=>//. 
Qed. 

Lemma  DMMLoc2_total : forall lv lpout lpin,
 Term (DMMLoc2 lv lpout lpin).
Proof. 
apply DHSLoc_total. 
Qed.

Lemma DPRLC1_total : forall s x, 
 Term (DPRLC1 s x).
Proof.
move=>s x;unfold DPRLC1.
apply DRound_total=>w. 
apply DMMLoc1_total. 
Qed.   

Lemma DPRLC2_total : forall s x, 
 Term (DPRLC2 s x).
Proof.
move=>s x;unfold DPRLC2.
apply DRound_total=>w. 
apply DMMLoc2_total. 
Qed.  

Lemma DMMStep_total : forall s res,
 Term (DMMStep s res).
Proof.
move =>s res;unfold DMMStep=>/=. 
apply Mlet_term.
 apply (DPRLC2_total s res).
move=>x;apply Mlet_term=>//.
apply DPRLC1_total. 
Qed. 

Definition termB (f: VState* PState) : bool :=
 [forall v, ~~ activeL (f.1 v)]. 

Definition DMMStepLV (s: seq V) :=
 DPStepLV nu false p0 termB (DMMLoc2::DMMLoc1::nil) s. 

Lemma DMMStepLV_cont : forall s, continuous (DMMStepLV s). 
Proof. 
apply DStepLV_cont.
Qed. 

Definition DMMLV (s: seq V)  :=
 DPLV nu false p0 termB (DMMLoc2::DMMLoc1::nil) s.

Open Local Scope U_scope.
Open Local Scope O_scope.

Definition numberActiveGlob (resV: VState) := 
#|[set x | activeL (resV x)]|. 

Definition hct := [1-] (@hscte V Adj). 

Lemma numberActiveGlob_dec1 : forall x s, 
 (numberActiveGlob x < numberActiveGlob s)%nat ->
 exists v, activeL (s v) /\ ~~ activeL (x v).
Proof.
unfold numberActiveGlob. intros x s. 
do 2 rewrite cardE.
have : forall v, v \in (enum [set x0 | activeL (s x0)]) -> activeL (s v).
  move=>v. rewrite mem_enum in_set. done.
have : uniq (enum [set x0 | activeL (s x0)]). 
 by rewrite enum_uniq. 
elim:( enum [set x0 | activeL (s x0)])=>//=.
intros a l H H0 H1. rewrite ltnS leq_eqVlt. 
move/orP=>[h1| h2];last first.
   apply H=>//=. 
     by move/andP:H0=>[H2 H3]. 
     by  intros;apply H1;rewrite in_cons H2 orbT.
have [v [hv1 hv2]] : (exists v, v \in (a::l) /\ v \notin  (enum [set x0 | activeL (x x0)]) );last first. 
 by exists v;rewrite mem_enum in_set in hv2;rewrite hv2;apply H1 in hv1.
 
move/andP:H0=>[H0 H2]. 
move:h1 H0 H2.
have : uniq (enum [set x0 | activeL (x x0)]). 
 by rewrite enum_uniq. 
 set l' := (enum [set x0 | activeL (x x0)]). 
clear. move:l' a. elim:l=>//=.
 case=>//=. intros.  exists a.  by rewrite in_cons eq_refl.
move=>a. case. 
intros. clear x0. case:l' h1=>//=. 
intros. rewrite eqSS in h1. move/eqP:h1=>h1. apply size0nil in h1.
rewrite h1. case h2: (a0 == a1). 
  exists a. move/eqP:h2=>h2. rewrite -h2. repeat rewrite in_cons.
   rewrite eq_refl orbT. move:H0. rewrite in_cons eq_sym. case:(a==a0)=>//=. 
 exists a0. rewrite in_cons eq_refl;split=>//. rewrite in_cons h2. done. 
intros.  move/andP:H2=>[H2 H3]. 
simpl in H3. move/andP:H3=>[H3 H4].
repeat rewrite in_cons in H0. 
repeat rewrite Bool.negb_orb in H0. move/andP:H0=>[H01 H02]. 
move/andP:H02=>[H02 H03]. rewrite in_cons in H2. 
rewrite Bool.negb_orb in H2. move/andP:H2=> [H21 H22]. 
simpl in h1.   
case H5 : (a1 \in l');last first.
  exists a1. rewrite in_cons eq_refl H5. done.   
have [v [hv1 hv2]] : (exists v : V, v \in (a::a0:: l) /\ v \notin seq.rem a1 l');last first.
 exists v.  split. 
  rewrite in_cons.  rewrite hv1.  rewrite orbT. done. 
  case h:(v \in l')=>//.  have h':= (rem_mem_not h hv2).
  move:hv1.  rewrite h'.  repeat rewrite in_cons. 
  move:H01 H02 H03. case:(a1 == a)=>//. case: (a1 == a0)=>//=.
  case:(a1 \in l)=>//=.
apply H=>//. 
apply rem_uniq. done. 
simpl. rewrite size_rem=>//.  Search _ (_.+1 == _ .+1).
 rewrite -eqSS.  move/eqP:h1=>h1. rewrite -h1.
 rewrite NPeano.Nat.succ_pred=>//. 
 intro. rewrite h1 in H0.  done. 
rewrite in_cons. move: H21 H22. case:(a==a0)=>//=.
simpl.  rewrite H3. done. 
Qed. 


Lemma L11_aux : forall  x, 
(mu (DPRLC2 (enum V) x))  (fun x0 =>
         if [forall v, ~~ activeL (x.1 v) ==> ~~ activeL (x0.1 v)]
         then 1
         else 0) == 1.
Proof.
move=>x. apply Uge_one_eq.
transitivity ((mu (DPRLC2 (enum V) x))  (fun x0 =>
      if [forall v, ((v \in (enum V)) && ~~ activeL (x.1 v)) ==> ~~ activeL (x0.1 v)] then 1 else 0));last first.
 apply mu_le_compat=>//. intro.

case h1 : ([forall v,  (v \in enum V) && ~~ activeL (x.1 v) ==> ~~ activeL (x0.1 v)])=>//. 
case h2 : (  [forall v, ~~ activeL (x.1 v) ==> ~~ activeL (x0.1 v)] )=>//=. 
move/forallP:h1. move/forallP:h2. intros. destruct h2. intros. have := (h1 x1). 
rewrite mem_enum. simpl. done.  

unfold DPRLC2.
elim:(enum V)=>//=.

case h:( [forall v, true])=>//=. 
move/forallP:h=>h.  done. 

intros.
 apply (Ole_trans _ _ _ H).
apply mu_le_compat=>//. intro. unfold DMMLoc2,DHSLoc. 
unfold Vread,Vwrite. 
case h1 : ( [forall v,  (v \in l)  && ~~ activeL (x.1 v) ==> ~~ activeL (x0.1 v)] )=>//=. 
case h2:(activeL(x.1 a));last first. 
  
simpl. 
case h3: (   [forall v,  (v \in a :: l) &&
          ~~ activeL (x.1 v) ==>
          ~~ activeL ((update [set a] x0.1 [ffun=> x.1 a]) v)])=>//=. 
move/forallP:h1. intro. move/forallP:h3.  intro.  destruct h3. 
intros. move:(h1 x1). rewrite in_cons.
case h4:(activeL (x.1 x1))=>//=. repeat rewrite andbF. done.     
rewrite update_Plocal_iff in_set. 
case h5:(x1 == a)=>//=.  rewrite ffunE. move/eqP:h5 h4->. move->. done.

case :(numberActive ( Pinread nu p0 x.2 a)).  

simpl. 
case h4: ( [forall v, (v \in a :: l) &&  ~~ activeL (x.1 v) ==>  ~~  activeL
   ((update [set a] x0.1 [ffun=> Some  (seq.size (Poutread nu p0 x.2 a))]) v)])=>//=. 
move/forallP:h1. intro. move/forallP:h4.  intro.  destruct h4. 
intros. rewrite in_cons. move:(h1 x1).  case h4:(activeL (x.1 x1))=>//=.
repeat rewrite andbF;done.
rewrite update_Plocal_iff in_set. 
case h5:(x1 == a)=>//=.  rewrite ffunE. intro. unfold activeL.  done.

move=>n. rewrite Mlet_simpl.   
setoid_rewrite (fun x1 => Munit_simpl  _ (x.1 a, sendChosen x1.+1 (Pinread nu p0 x.2 a))). 
rewrite <-(Random_total n). apply mu_le_compat=>//.  intro. 
case h3 : (  [forall v,  (v \in a :: l) &&  ~~ activeL (x.1 v) ==>  ~~ activeL
   ((update [set a] x0.1 [ffun=> (x.1 a, sendChosen x1.+1 (Pinread nu p0 x.2 a)).1]) v)])=>//=. 
move/forallP:h1. intro. move/forallP:h3.  intro.  destruct h3. 
intros. rewrite in_cons.  
rewrite update_Plocal_iff in_set. 
case h5:(x2 == a)=>//=.
move/eqP:h5=>h5. subst x2. 
  rewrite ffunE. by case:(activeL (x.1 a)).
Qed. 

Lemma L12_aux : forall res, 
   (mu (DPRLC1 (enum V) res))
     (fun x =>
      B2U [forall v, ~~ activeL (res.1 v) ==> ~~ activeL (x.1 v)]) == 1.
Proof.
move=>res.
 apply Uge_one_eq.  
 unfold DPRLC1. simpl.
elim:(enum V)=>/=. case h: ( [forall v, ~~ activeL (res.1 v) ==> ~~ activeL (res.1 v)])=>//. 
move/forallP:h=>h. destruct h. intro. apply  implybb.

intros. rewrite H.  apply mu_le_compat=>// x.
case h1 : (   [forall v, ~~ activeL (res.1 v) ==> ~~ activeL (x.1 v)] )=>//=.
move/forallP:h1=>h1.  
unfold DMMLoc1. unfold Vread,Vwrite. 
case h2 : (activeL (res.1 a))=>/=;last first.
  case h3: (  [forall v,        ~~ activeL (res.1 v) ==>
        ~~ activeL ((update [set a] x.1 [ffun=> res.1 a]) v)] )=>//=. 
move/forallP:h3=>h3. destruct h3. move=>x0. 
move:(h1 x0).  rewrite update_Plocal_iff in_set.  rewrite ffunE. 
case h3 : (x0 == a)=>//=.  move/eqP:h3=>h3. subst a.  intro. apply implybb. 

case h3 : (agreed (Poutread nu p0 res.2 a) (Pinread nu p0 res.2 a))=>//=.
 case h4:( [forall v,
        ~~ activeL (res.1 v) ==>
        ~~
        activeL
          ((update [set a] x.1 [ffun=> Some (index true (Poutread nu p0 res.2 a))]) v)])=>//=.
move/forallP : h4. intro. destruct h4=>x0. 
rewrite update_Plocal_iff in_set.  rewrite ffunE. 
case h4 : (x0 == a)=>//=.   move/eqP:h4=>h4. subst a. rewrite h2. done. 

case h4 : ([forall v,
        ~~ activeL (res.1 v) ==>
        ~~ activeL ((update [set a] x.1  [ffun=> None]) v)])=>//=. 

move/forallP : h4. intro. destruct h4=>x0. 
rewrite update_Plocal_iff in_set.   rewrite ffunE. 
case h4 : (x0 == a)=>//=.   move/eqP:h4=>h4. subst a. rewrite h2. done. 
Qed.

Lemma L1_aux : forall res,
 mu (DMMStep (enum V) res)  
   (finv (fun x:VState*PState => 
  if [forall v, ~~(activeL (res.1 v)) ==> ~~(activeL (x.1 v))] then 1 else 0)) == 0.
Proof. 
intros res;rewrite mu_one_inv.
2:apply DMMStep_total.
rewrite <-Uinv_one.
apply Uinv_eq_compat. apply Uge_one_eq. 
unfold DMMStep,DPStep=>/=.

transitivity ( (mu (DPRLC2 (enum V) res) (fun x => 
 1 * B2U [forall v, ~~ activeL (res.1 v) ==> ~~ activeL (x.1 v)]) )).

setoid_rewrite Umult_one_left. 
by rewrite L11_aux. 

apply (compositional_reasoning (DPRLC2 (enum V) res) _ 
 (fun x => [forall v, ~~ activeL (res.1 v) ==> ~~ activeL (x.1 v)]) _ 1).
intros. 
rewrite <-(L12_aux x). apply mu_le_compat=>//. intro. 
case h:( [forall v, ~~ activeL (x.1 v) ==> ~~ activeL (x0.1 v)] )=>//=. 
case h' :([forall v, ~~ activeL (res.1 v) ==> ~~ activeL (x0.1 v)] )=>//=. 
move/forallP:h'=>h'.  destruct h'. move=>x1. 
move/forallP:H=>H. move:(H x1).
move/forallP:h=>h. move:(h x1).  
case h1:(activeL (res.1 x1))=>//=.
case h2:(activeL (x.1 x1))=>//=. 
Qed.


Lemma L21_aux : forall s res,  
 1 <=
   (mu (DPRLC1 s res))
     (fun x => B2U ([set x0 | activeL (x.1 x0)] \subset
   [set x0 | activeL (res.1 x0)])). 
Proof. 
elim. 
  by simpl;intro;rewrite subEproper eq_refl.

move=>a l hind res. simpl.  
rewrite (hind res).
apply mu_le_compat=>//x. 
case h1: ([set x0 | activeL (x.1 x0)] \subset [set x0 | activeL (res.1 x0)])=>//.  

unfold DMMLoc1. 
case h2 : (activeL (Vread res.1 a))=>//=;last first.

case h3 : ([set x0 | activeL ((update [set a] x.1 (Vwrite (Vread res.1 a) a)) x0)] \subset
      [set x0 | activeL (res.1 x0)])=>//. 

 move/negbT:h3. move/negP. intro h3. destruct h3.
 apply (fun x => subset_trans x h1).
 apply/subsetP. intro. 
do 2 rewrite in_set.  unfold activeL. rewrite update_Plocal_iff. 
rewrite in_set. unfold Vwrite. rewrite ffunE. unfold activeL in h2.
case h3:(x0==a)=>//. rewrite h2.  done. 

case h3 : (agreed (Poutread nu p0 res.2 a) (Pinread nu p0 res.2 a))=>/=.
 case h4 : ([set x0 | activeL
                  ((update [set a] x.1
                      (Vwrite (Some (index true (Poutread nu p0 res.2 a))) a))
                     x0)] \subset [set x0 | activeL (res.1 x0)])=>//. 
 move/negbT:h4. move/negP. intro h4. destruct h4.
 apply (fun x => subset_trans x h1).
 apply/subsetP. intro. 
do 2 rewrite in_set.  unfold activeL. rewrite update_Plocal_iff. 
rewrite in_set. unfold Vwrite. rewrite ffunE. 
case h3:(x0==a)=>//.

case h4 : ([set x0 | activeL ((update [set a] x.1 (Vwrite None a)) x0)] \subset
      [set x0 | activeL (res.1 x0)])=>//. 
 move/negbT:h4. move/negP. intro h4. destruct h4.
case h:(activeL (Vread x.1 a) ). 
  apply (fun x => subset_trans x h1).
  apply/subsetP. intro. 
  do 2 rewrite in_set.  unfold activeL. rewrite update_Plocal_iff. 
  rewrite in_set. unfold Vwrite. rewrite ffunE. 
  case h4:(x0==a)=>//. move/eqP:h4=>h4;subst x0.  unfold activeL in h. rewrite h. done. 

apply/subsetP. intro. 
do 2 rewrite in_set.  unfold activeL. rewrite update_Plocal_iff. 
rewrite in_set. unfold Vwrite. rewrite ffunE. unfold activeL,Vread in h2,h.
case h4:(x0==a)=>//.
move/eqP:h4=>h4. subst x0. done.  
move/subsetP:h1=>h1. move:(h1 x0).
do 2 rewrite in_set. unfold activeL. intro. done. 
Qed. 

Lemma L22_aux : forall s res,  
 1 <=
   (mu (DPRLC2 s res))
     (fun x => B2U ([set x0 | activeL (x.1 x0)] \subset
   [set x0 | activeL (res.1 x0)])). 
Proof. 
elim. 
  by simpl;intro;rewrite subEproper eq_refl.

move=>a l hind res. simpl.  
rewrite (hind res).
apply mu_le_compat=>//x. 
case h1: ([set x0 | activeL (x.1 x0)] \subset [set x0 | activeL (res.1 x0)])=>//.  

unfold DMMLoc2,DHSLoc. 
case h2 : (activeL (Vread res.1 a))=>//=;last first.

case h3 : ([set x0 | activeL ((update [set a] x.1 (Vwrite (Vread res.1 a) a)) x0)] \subset
      [set x0 | activeL (res.1 x0)])=>//. 

 move/negbT:h3. move/negP. intro h3. destruct h3.
 apply (fun x => subset_trans x h1).
 apply/subsetP. intro. 
do 2 rewrite in_set.  unfold activeL. rewrite update_Plocal_iff. 
rewrite in_set. unfold Vwrite. rewrite ffunE. unfold activeL in h2.
case h3:(x0==a)=>//. rewrite h2.  done. 

case : (numberActive (Pinread nu p0 res.2 a)).
 simpl. 
 case h4 : ([set x0 | activeL
                  ((update [set a] x.1
                      (Vwrite (Some  (seq.size (Poutread nu p0 res.2 a))) a))
                     x0)] \subset [set x0 | activeL (res.1 x0)])=>//. 
 move/negbT:h4. move/negP. intro h4. destruct h4.
 apply (fun x => subset_trans x h1).
 apply/subsetP. intro. 
do 2 rewrite in_set.  unfold activeL. rewrite update_Plocal_iff. 
rewrite in_set. unfold Vwrite. rewrite ffunE. 
case h3:(x0==a)=>//.

intro. 
rewrite Mlet_simpl. 
setoid_rewrite (fun k => 
 Munit_simpl _ (Vread res.1 a, sendChosen k.+1 (Pinread nu p0 res.2 a))).
rewrite Random_simpl random_simpl. unfold activeL. unfold Vwrite.
rewrite (Unth_sigma_Sn n).
apply sigma_le_compat. intros. 
case h4:([set x0 | (update [set a] x.1
                   [ffun=> (Vread res.1 a,
                           sendChosen k.+1 (Pinread nu p0 res.2 a)).1]) x0 ==
                None] \subset [set x0 | res.1 x0 == None]);auto.
 move/negbT:h4. move/negP. intro h4. destruct h4. 
unfold activeL,Vread in h2. move/eqP:h2=>h2. unfold Vread. rewrite h2. simpl. 
apply/subsetP. intro. 
do 2 rewrite in_set. 
rewrite update_Plocal_iff in_set ffunE.
case h4:(x0==a)=>//.
 move/eqP:h4=>h4;subst x0. by rewrite h2.
move/subsetP:h1=>h1. move:(h1 x0). do 2 rewrite in_set.
done. 
Qed. 

Lemma is_discrete_DMMLOC1 : 
 forall (x:VSt*PSt) (v:V),
   is_discrete_s
     (DMMLoc1 (Vread x.1 v) (Poutread nu p0 x.2 v) (Pinread nu p0 x.2 v)).
Proof. 
  intros x v; unfold DMMLoc1. case:( activeL (Vread x.1 v)). 
  case:(agreed (Poutread nu p0 x.2 v) (Pinread nu p0 x.2 v)).  
  exists (Build_discr_s (@retract_invn 0)
       (fun k:nat => (Some (index true (Poutread nu p0 x.2 v)),
                 nseq (seq.size (Poutread nu p0 x.2 v)) false)) ). 
   by simpl;intro y;repeat Usimpl.
  exists (Build_discr_s (@retract_invn 0)
       (fun k:nat => (None, nseq (seq.size (Poutread nu p0 x.2 v)) true))). 
   by simpl;intro y;repeat Usimpl.
  exists (Build_discr_s (@retract_invn 0)
       (fun k:nat => (Vread x.1 v, Poutread nu p0 x.2 v))). 
   by simpl;intro y;repeat Usimpl.
Qed. 

Lemma L2_aux : forall res, 
[forall v,
          activeG v res ==>
          (Poutread nu p0 res.2 v == nseq (seq.size (nu v)) true)] &&
       [forall v,
          ~~ activeG v res ==>
          (Poutread nu p0 res.2 v == nseq (seq.size (nu v)) false)] &&
       (0 <
        count (fun x0 : V => activeG x0 res && (0 < nactv nu e0 res x0)%nat) (enum V))%nat -> 
 hct <=
   (mu (DMMStep (enum V) res)
     (fun x =>if (lt_dec (numberActiveGlob x.1) (numberActiveGlob res.1)) then 1
      else 0)).
Proof.
move=>res res1. 
move/andP:res1=>[res1 res3]. move/andP:res1=>[res1 res2]. 
move/forallP:res1=>res1. move/forallP:res2=>res2. 
simpl. 
set m1 := DPRLC1.
set m2 := (DPRLC2  (enum V) res). 
unfold DMMLoc2,hct; rewrite (DHS_deg_whole NG Hnu Hnu2 _ _ res3)=>//;last first. 
intros. move/implyP:(res2 v)=>Hyp. apply/eqP. apply Hyp. 
unfold activeG. move:H. unfold inactiveG. move=>[i hi]. move/eqP:hi->. done. 
  intros. move/implyP:(res1 v)=>Hyp. apply/eqP. apply Hyp.  done.    

transitivity ((mu (DHS nu e0 (enum V) res)) (fun x => (carac_hs_glob_ex nu e0 res x) * 
 B2U ([set x1 | activeL (x.1 x1)]  \subset [set x1 | activeL (res.1 x1)] ))).
apply range_le with (P:= (fun a:VSt*PSt =>
  ([set x1 | activeL (a.1 x1)] \subset [set x1 | activeL (res.1 x1)])));last first. 
  by intros; rewrite H; auto.
 unfold range. intros. clear res1 res2 res3. clear m1 m2.
 elim:(enum V) res f H.
   simpl. intros. apply H. done. 
  intros. simpl.  apply H. intros. unfold DHSLoc. 
  case h1:(activeL (Vread res.1 a))=>/=;last first.
    apply H0. apply/subsetP. move/subsetP:H1. intro. intro. 
    move:(H1 x0). repeat rewrite in_set. 
    move:h1. unfold activeL,Vread,Vwrite;simpl. rewrite update_Plocal_iff.   
     rewrite in_set. rewrite ffunE. case ha:(x0==a)=>//=. 
     move->. done.
 case:( numberActive (Pinread nu (hsAct_dist.p0 e0) res.2 a)).
     simpl.     apply H0. apply/subsetP. move/subsetP:H1. intro. intro. 
    move:(H1 x0). repeat rewrite in_set. 
    move:h1. unfold activeL,Vread,Vwrite;simpl. rewrite update_Plocal_iff.   
     rewrite in_set. rewrite ffunE. by case ha:(x0==a)=>//=.
   intro. rewrite Mlet_simpl Random_simpl random_simpl.
   symmetry. apply sigma_zero. intros. simpl. rewrite -H0=>//. 
       apply/subsetP. move/subsetP:H1. intro. intro. 
    move:(H1 x0). repeat rewrite in_set. 
    move:h1. unfold activeL,Vread,Vwrite;simpl. rewrite update_Plocal_iff.   
     rewrite in_set. rewrite ffunE. case ha:(x0==a)=>//=.
    move/eqP:ha=>ha. subst x0. done.

 transitivity ((mu (DHS nu e0 (enum V) res)) (fun x => ((carac_hs_glob_ex nu e0 res x) * 
 B2U ([set x1 | activeL (x.1 x1)]  \subset [set x1 | activeL (res.1 x1)] )) * 
 B2U ([forall u, (u \in (enum V)) ==>(count ssrfun.id (Poutread nu p0 x.2 u) <= 1 )%nat]))). 
apply range_le with (P:= (fun a:VSt*PSt =>
  [forall u, (u \in (enum V)) ==> (count ssrfun.id (Poutread nu p0 a.2 u) <= 1 )%nat]));last first.
  by intros; rewrite H; auto.
 unfold range. intros. clear res1 res3. clear m1 m2.
 have:(uniq (enum V)). by apply enum_uniq.  
 elim:(enum V) res f H res2.
   simpl. intros. apply H. apply/forallP. done. 
  intros. simpl.  apply H. intros. unfold DHSLoc. 
  move:res2. unfold activeG. unfold activeL,Vread. intro. 
  move:(res2 a). case h1:(res.1 a == None)=>/=;last first.
    move/eqP. move->. apply H0. apply/forallP. intro u. apply/implyP.
    rewrite in_cons. intro. simpl.
   rewrite (@VPupdate_read_6 _ _ _ Hnu Hnu2 _ _ _ _ _ _  ( (res.1 u), 
 (nseq (seq.size (nu a)) false)))=>//. 
 move:H2. rewrite eq_sym. case hau:(a==u)=>/=;last first.
   move/forallP:H1=>H1. move:(H1 u). by case:(u \in l). 
  move=>_. move/eqP:hau=>hau. subst a. rewrite take_cat. 
  rewrite size_nseq. rewrite ltnn. rewrite cat_nseq. 
  elim:(nu u)=>//=. intros. rewrite subnS subSnn. simpl. 
  rewrite -cat_nseq.  rewrite count_cat. simpl.
  clear. elim:l0=>//=.
 
 move=>_. move:x. simpl. move/andP. move=>[huniqa1 huniqa2].  
 case:( numberActive (Pinread nu (hsAct_dist.p0 e0) res.2 a)). 
     simpl. move/eqP:h1=>h1. apply H0. apply/forallP. intro u. apply/implyP.
    rewrite in_cons. simpl. move:H1. unfold Poutread. rewrite size_map.
    move/forallP. intro H1. 
    case hua:(u==a);last first. simpl. intro H2. 
    move:(H1 u). move/implyP. intro H1'. apply H1' in H2.
    move:H2.
    move:hua.  have:(forall w, w \in (nu u) -> Adj u w).
            intros. by rewrite Hnu. 
    elim:(nu u)=>//=. intros. rewrite update_Plocal_iff in_set VtoP2;last first.
     apply x. by rewrite in_cons eq_refl.
    rewrite hua. move:H3. case hua2:( x0.2 (VtoP u a0 p0))=>/=;last first. 
      apply H2=>//.  intros. apply x. rewrite in_cons H3 orbT. done. 
    move/leP.  intro hc. apply/leP. apply le_n_S. apply/leP.
    apply le_S_n in hc. move/leP:hc. repeat rewrite leqn0.
    move/eqP. intro hc. apply/eqP. rewrite -hc. move:hua x. 
   clear. elim:l0=>//=.  intros. 
   rewrite update_Plocal_iff in_set. rewrite VtoP2;last first. 
   apply x. repeat rewrite in_cons. rewrite eq_refl. rewrite orbT. done. 
   rewrite hua. rewrite H=>//=.
   intros. apply x. move:H0. repeat rewrite in_cons. 
   case:(w==a0)=>//. case:(w \in l)=>//.  intro. rewrite orbT. done.
   
   move=>_. move/eqP:hua=>hua. subst a. 
     have:(forall w, w \in (nu u) -> Adj u w).
            intros. by rewrite Hnu. 
     elim:(nu u)=>//=. intros. rewrite update_Plocal_iff in_set. 
     rewrite VtoP2;last first. 
        apply x. rewrite in_cons eq_refl.  done. 
        rewrite eq_refl. rewrite ffunE. 
       change (false :: nseq (seq.size l0) false) with (nseq (seq.size l0).+1 false). 
        rewrite nth_nseq.  change 1%nat with (0+1)%nat.
        apply leq_add=>//. 
       case:(index (sndp (VtoP u a p0)) (nu u) < (seq.size l0).+1)%nat=>//=.
       have Hyp1:((forall w : V, w \in l0 -> Adj u w)). 
           intros. apply x. rewrite in_cons H3. rewrite orbT. done.
       apply H2 in Hyp1.   
       have Hyp: ( 
     [seq (update (WriteArea u) x0.2
             (Pwrite nu false (nseq (seq.size l0).+1 false) u)) 
            (VtoP u x p0)
        | x <- l0] = 
         [seq (update (WriteArea u) x0.2
                 (Pwrite nu false (nseq (seq.size l0) false) u))
                (VtoP u x p0)
            | x <- l0]);last by rewrite Hyp.
      apply eq_map. intro. repeat rewrite ffunE. 
      case:(VtoP u x1 p0 \in WriteArea u)=>//=. 
      change (false :: nseq (seq.size l0) false) with 
        (nseq (seq.size l0).+1 false). repeat rewrite nth_nseq.
      case:(  index (sndp (VtoP u x1 p0)) (nu u) < (seq.size l0).+1)%nat;
         case:(index (sndp (VtoP u x1 p0)) (nu u) < seq.size l0 )%nat=>//=. 
 
    intro. rewrite Mlet_simpl. rewrite Random_simpl. rewrite random_simpl. 
    rewrite sigma_zero=>//. intros. simpl. 
    rewrite -H0=>//. simpl. apply/forallP. intro. apply/implyP. 
      rewrite in_cons. case hxa:(x==a)=>/=. 
        move/eqP:hxa=> hxa. subst x. move=>_.
        rewrite (@VPupdate_read_3 _ _ _ Hnu Hnu2 _ _ false p0 a 
           (None,(sendChosen k.+1 (Pinread nu (hsAct_dist.p0 e0) res.2 a))) x0);
         last first. 
          simpl. Search _ sendChosen seq.size. rewrite sendChosen_size. 
          rewrite size_map. done;  done.
         simpl.  Search _ count sendChosen.  apply sendChosen_count. 
      move/negbT:hxa=>hxa. 
      rewrite (VPupdate_read_2 Hnu false p0 
        (None,(sendChosen k.+1 (Pinread nu (hsAct_dist.p0 e0) 
        res.2 a))) x0);last first.
        by rewrite eq_sym. move/forallP:H1. intro. 
        move:(H1 x). move/implyP. done. 
done. 
move:x. rewrite cons_uniq. case:(uniq l)=>//;by rewrite andbF.

apply mu_le_compat=>//x.
unfold carac_hs_glob_ex,hs_glob_ex,hs_glob,fB2U,B2U,hs_edgeB.
case he1 : ([exists x0,
  (activeG (fste x0) res && activeG (snde x0) res) &&
  ((hs_eqVB nu e0 (fste x0) (snde x0) x) &&
    (hs_eqVB nu e0 (snde x0) (fste x0) x))]);repeat Usimpl=>//.
move/existsP:he1=>[e he1]. move/andP:he1=>[he1 he2]. 
move/andP:he2=>[he2 he3]. move/andP:he1=>[he12 he11]. 
pose u:=(fste e).
case hinit : ( [set x1 | activeL (x.1 x1)] \subset
       [set x1 | activeL (res.1 x1)]);repeat Usimpl=>//.
case hinit': (  [forall u0,
          (u0 \in enum V) ==> (count ssrfun.id (Poutread nu p0 x.2 u0) <= 1)%nat]);
 repeat Usimpl=>//.  
rewrite (@DRoundCommute2 _ _ _ _ _ _ _  _ _ _ _ _ u);last first. 
  by rewrite mem_enum. 
  by apply disjoint_outerport. 
  by apply  (is_discrete_DMMLOC1).

simpl. unfold DMMLoc1 at 2. 
case h1: (activeL (Vread x.1 u));last first. 
 simpl.
 have [i h2]:(exists i, Vread x.1 u = Some i).
  move:h1. unfold activeL. case:(Vread x.1 u)=>//=. 
  intros. by exists a. 
rewrite h2. 
 transitivity (mu (m1 (seq.rem u (enum V)) x)  (fun x0 => B2U
 ([set x1 | activeL (x0.1 x1)] \subset [set x1 | activeL (x.1 x1)]))).
 apply L21_aux.  
apply mu_le_compat=>//.
intro. case h3 : ( [set x1 | activeL (x0.1 x1)] \subset
      [set x1 | activeL (x.1 x1)])=>//=.  
case:(lt_dec (numberActiveGlob (update [set u] x0.1 (Vwrite (Some i) u)))
            (numberActiveGlob res.1))=>//=h4.
 destruct h4. unfold numberActiveGlob. apply/ltP. apply proper_card. 
 apply/properP. split.
    apply/subsetP. intro. move/subsetP:h3=>h3. move:(h3 x1). 
    move/subsetP:hinit=>hinit. move:(hinit x1). 
    repeat rewrite in_set. unfold activeL. 
    rewrite update_Plocal_iff.  unfold Vwrite. rewrite in_set. rewrite ffunE.
    case hxu : (x1 == u)=>//=.  intro. by auto. 
    exists u;rewrite in_set=>//. 
    unfold activeL,Vwrite. rewrite update_Plocal_iff. rewrite in_set eq_refl ffunE. done. 

unfold activeL,Vread in h1. move/eqP:h1=>h1. 
case h2 : (agreed (Poutread nu p0 x.2 u) (Pinread nu p0 x.2 u)). 
 simpl. 
transitivity (mu (m1 (seq.rem u (enum V)) x)  (fun x0 => B2U
 ([set x1 | activeL (x0.1 x1)] \subset [set x1 | activeL (x.1 x1)]))).
 apply L21_aux.  
apply mu_le_compat=>//.
intro. case h3 : ( [set x1 | activeL (x0.1 x1)] \subset
      [set x1 | activeL (x.1 x1)])=>//=.  
case:(lt_dec (numberActiveGlob (update [set u] x0.1 (Vwrite (Some 
 (index true (Poutread nu p0 x.2 u))) u)))
            (numberActiveGlob res.1))=>//=h4.
 destruct h4. unfold numberActiveGlob. apply/ltP. apply proper_card. 
 apply/properP. split.
    apply/subsetP. intro. move/subsetP:h3=>h3. move:(h3 x1). 
    move/subsetP:hinit=>hinit. move:(hinit x1). 
    repeat rewrite in_set. unfold activeL. 
    rewrite update_Plocal_iff.  unfold Vwrite. rewrite in_set. rewrite ffunE.
    case hxu : (x1 == u)=>//=.  intro. by auto. 
    exists u;rewrite in_set=>//. 
    unfold activeL,Vwrite. rewrite update_Plocal_iff. rewrite in_set eq_refl ffunE. done.

simpl.
move/negP:h2=>h2. destruct h2. 
move:he2 he3. fold u. set v:=(snde e). unfold hs_eqVB. move/eqP. 
intros he1 he2. apply (@agreed_4 _ _ _ _ _ Hnu Hnu2 _ _ _ v)=>//. 
 rewrite gsym;by apply edge_fste_snde.
 by move/eqP:he2.
 move/forallP:hinit'. intro. done. 
Qed. 

Lemma L3_aux : forall (res:VSt*PSt) (x:V), res.1 x = None ->
nactv nu e0 res x = O ->
  1 <= (mu (DPStep nu false p0 [:: DMMLoc2; DMMLoc1] (enum V) res))
     (fun x : LabelFunc V VLab * LabelFunc port_finType PLab =>
      B2U (lt_dec (numberActiveGlob x.1) (numberActiveGlob res.1))).
Proof.
move =>res x h1 h2. simpl. 
have hx:(x \in (enum V)) by rewrite mem_enum. 
rewrite (DRoundCommute2 _ _ _ _ hx);last first. 
 by  apply disjoint_outerport.
 intro;apply is_discrete_DHSLoc.
simpl. unfold DMMLoc2 at 2;unfold DHSLoc,activeL,Vread. 
rewrite h1;simpl.  
unfold nactv in h2. rewrite h2. simpl.    
setoid_rewrite (fun y => DRoundCommute2 _ _  (is_discrete_DMMLOC1 y)
  (disjoint_outerport) hx).
simpl. unfold DMMLoc1 at 2. unfold activeL,Vread. 
setoid_rewrite update_Plocal_iff. rewrite in_set. rewrite eq_refl. 
rewrite ffunE. simpl.
rewrite (L22_aux (seq.rem x (enum V)) res).
apply mu_le_compat=>//.
intro.
case h3:(   [set x1 | activeL (x0.1 x1)] \subset [set x1 | activeL (res.1 x1)])=>//=. 
rewrite (L21_aux (seq.rem x (enum V)) 
         (update [set x] x0.1
            (Vwrite (Some (seq.size (Poutread nu p0 res.2 x))) x),
         update (WriteArea x) x0.2
           (Pwrite nu false (nseq (seq.size (Poutread nu p0 res.2 x)) false)
              x))).
apply mu_le_compat=>//.
intro. 
case h4 : ([set x2 | activeL (x1.1 x2)] \subset
      [set x2 | activeL
                  ((update [set x] x0.1
                      (Vwrite (Some (seq.size (Poutread nu p0 res.2 x))) x),
                   update (WriteArea x) x0.2
                     (Pwrite nu false
                        (nseq (seq.size (Poutread nu p0 res.2 x)) false) x)).1
                     x2)])=>//=. 
case :(lt_dec
        (numberActiveGlob
           (update [set x] x1.1
              (Vwrite
                 ((update [set x] x0.1
                     (Vwrite (Some (seq.size (Poutread nu p0 res.2 x))) x)) x)
                 x))) (numberActiveGlob res.1))=>//.
intro h5. destruct h5. apply/ltP.
unfold numberActiveGlob. move:h3 h4. 
unfold activeL,Vwrite.   
intros. 
apply proper_card.   apply/properP. split.
    apply/subsetP. intro. move/subsetP:h3=>h3. move:(h3 x2). 
    move/subsetP:h4=>h4. move:(h4 x2). 
    repeat rewrite in_set.
    rewrite update_Plocal_iff. rewrite in_set. rewrite ffunE.
    rewrite update_Plocal_iff. rewrite in_set. rewrite eq_refl. rewrite ffunE. 
    rewrite in_set. repeat rewrite ffunE. 
    case hxu : (x2 == x)=>//=.  intro. by auto. 
    exists x;rewrite in_set=>//.
     by rewrite h1.  
rewrite update_Plocal_iff. rewrite in_set eq_refl ffunE. 
rewrite update_Plocal_iff. rewrite in_set eq_refl ffunE.  done.
Qed. 

Lemma Umult_lt_1 : forall x y, x < 1 -> x * y < 1.
Proof. 
move=>x y Hx. destruct (or_lt_eq1 y);last first. 
 by rewrite H;Usimpl.
rewrite -(Umult_one_right 1).
apply Umult_lt_compat=>//.
Qed.     


Lemma DMMLV_term :
  Term (DMMLV (enum V) initState).
Proof.
apply DPLV_total  with (c := hct) 
  (cardTermB:= fun x  => numberActiveGlob x.1)
 (PR := (fun x => [forall v, (activeG v x) ==> (Poutread nu p0 x.2 v == 
     nseq (seq.size (nu v)) true)] &&
  [forall v, (~~(activeG v x)) ==> (Poutread nu p0 x.2 v ==
     nseq (seq.size (nu v)) false)])).
apply DMMStep_total. 

unfold numberActiveGlob,termB,activeL;move=>r h. 
apply card0_eq in h;apply/forallP=>x. 
have := (h x);rewrite in_set;move->.
done. 

unfold hct,hscte;apply Uinv_lt_zero.
have :(0 < #|E|)%nat. 
 by apply/card_gt0P;exists e0. 
case:(#|E|)=>//.  
by move=>n hn;rewrite prod_S;apply Umult_lt_1;auto.

intros res' Hcard H. 
case H': (0 <
    count (fun x0 : V => activeG x0 res' && (0 < nactv nu e0 res' x0)%nat)
      (enum V))%nat.
 apply L2_aux=>//.
 apply/andP;split=>//. 

move:H'. rewrite -has_count. move/hasP. intro H'. 
have H'' : ([exists x, activeG x res' && (0 < nactv nu e0 res' x)%nat]=false).
 apply (fun x => introF  x H'). apply introP; 
   move/existsP=>//.
  intros [x hx]. exists x=>//. by rewrite mem_enum. 
 move/negbT:H''. rewrite negb_exists. move/forallP.
  clear H'. unfold activeG. intro H0.
 move:Hcard. unfold numberActiveGlob at 1. unfold activeL.
 move/card_gt0P.  move=>[x]. rewrite in_set. move/eqP. move=>hx. 
 move:(H0 x). rewrite hx. rewrite eq_refl. rewrite lt0n. 
 case H':((nactv nu e0 res' x) == O)=>// _. move/eqP:H'=>H'. 
 by rewrite (Uge_one_eq _ (L3_aux hx H')).
 
move=> res' H. apply Ule_zero_eq. 
rewrite <-(L1_aux  res').
apply mu_le_compat;auto. 
intro x;unfold finv. 
case : (lt_dec (numberActiveGlob res'.1) (numberActiveGlob x.1));auto.
intro h. simpl. 
case h' : ([forall v, ~~ activeL (res'.1 v) ==> ~~ activeL (x.1 v)] )=>//.
move/forallP :h'=>h'.
move/ltP:h=>h. apply numberActiveGlob_dec1  in h;auto.
destruct h as [v [hv1 hv2]].
have := (h' v). move/implyP.  intro h.
apply h in hv2. by rewrite hv1 in hv2.


  apply/andP;split;apply/forallP=>u;apply/implyP=>hu. 
    by rewrite (initState1 hu).
  by move/negbTE:hu;move/activeinactive=>hu;rewrite initState2.

move=>s f h0.
transitivity ((mu (DPStep nu false p0 [:: DMMLoc2; DMMLoc1] (enum V) s))
     (fun x : LabelFunc V VLab * LabelFunc port_finType PLab =>
      B2U
        ([forall v, ((v \in (enum V)) && 
            activeG v x) ==>
            (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) true)] &&
         [forall v, (( v \in (enum V)) &&
            ~~ activeG v x) ==>
            (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) false)]) * 
      f x)).
 apply mu_eq_compat=>//. intro. 
 have h1 : ([forall v, activeG v x ==>
         (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) true)] = 
         [forall v, ((v \in (enum V)) && activeG v x) ==>
         (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) true)]). 
   apply eq_forallb=>v. by rewrite mem_enum. 
 have h2 : ([forall v, ~~ activeG v x ==>
        (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) false)] =
          [forall v, ((v \in (enum V)) &&      ~~ activeG v x) ==>
        (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) false)]). 
    apply eq_forallb=>v. by rewrite mem_enum. 
 rewrite h1 h2. done. 
 
 unfold DPStep,DStep. simpl.

apply range_eq with (P:=(fun x => [forall v,
                      ~~ activeG v x ==>
            (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) false)])). 
unfold range.  intros.  
 elim:(enum V) f0 H=>//=. intros. apply H. move/andP:h0=>[h01 h02]. done. 
intros. apply H. intros.  unfold DMMLoc2,DHSLoc.  
 unfold activeL,Vread. case h1:( s.1 a == None);last first. 
  simpl. apply H0. apply/forallP. intro. apply/implyP. 
  move:H1. unfold activeG. move/forallP. intro H1. rewrite update_Plocal_iff. 
  rewrite in_set. rewrite ffunE. intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _  
  ((s.1 a), (Poutread nu p0 s.2 a)))=>//. rewrite (eq_sym a x0).
  move:H2. case hxa:(x0==a)=>/=. intro. 
  move/andP:h0=>[h01 h02]. move/forallP:h02=>h02.  
  have H2' := (h02 a). rewrite H2 in H2'. simpl in H2'.  move/eqP:H2'=>H2'. 
   rewrite H2'. move/eqP:hxa=>hxa. subst x0.
     rewrite takel_cat;last by rewrite size_nseq.
   set ml := (nseq (seq.size (nu a)) false). 
   rewrite -(size_nseq (seq.size (nu a)) false). 
   rewrite take_size. done.
  intro. have :=(H1 x0). rewrite H2.  done. 
  case :(numberActive (Pinread nu p0 s.2 a)). 
   simpl. apply H0. apply/forallP. intro. apply/implyP. 
  move:H1. unfold activeG. move/forallP. intro H1. rewrite update_Plocal_iff. 
  rewrite in_set. rewrite ffunE. intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _  
  ((Some (seq.size (Poutread nu p0 s.2 a))),
    (nseq (seq.size (Poutread nu p0 s.2 a)) false)))=>//. rewrite (eq_sym a x0).
  move:H2. case hxa:(x0==a)=>/=. intro. 
  move/eqP:hxa=>hxa. subst x0. rewrite size_map. 
     rewrite takel_cat;last by rewrite size_nseq.
   set ml := (nseq (seq.size (nu a)) false). 
   rewrite -(size_nseq (seq.size (nu a)) false). 
   rewrite take_size. done.
  intro. have :=(H1 x0). rewrite H2.  done.
  intro. rewrite Mlet_simpl. 
  setoid_rewrite (fun x0=> 
     Munit_simpl _  (s.1 a, sendChosen x0.+1 (Pinread nu p0 s.2 a))).
  rewrite Random_simpl random_simpl. symmetry. apply sigma_zero.
  intros. rewrite -H0;auto. 
    apply/forallP. intro. apply/implyP. 
  move:H1. unfold activeG. move/forallP. intro H1. rewrite update_Plocal_iff. 
  rewrite in_set. rewrite ffunE. intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _  
  (s.1 a,
    (sendChosen k.+1 (Pinread nu p0 s.2 a))))=>//. rewrite (eq_sym a x0).
  move:H3. case hxa:(x0==a)=>/=. intro. 
  move/eqP:hxa=>hxa. subst x0. rewrite h1 in H3. done. 
  intro.  have :=(H1 x0). rewrite H3.  done.

intros x hx. 
apply range_eq with (P:=(fun x => [forall v,
            ( (v \in (enum V)) && activeG v x) ==>
            (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) true)] &&
         [forall v, ( ( v \in (enum V)) &&
            ~~ activeG v x) ==>
            (Poutread nu p0 x.2 v == nseq (seq.size (nu v)) false)]));last first. 
intros. rewrite H. done. 

unfold range. have:(uniq (enum V)). by rewrite enum_uniq.

 elim:(enum V)=>//=.
   intros. apply H. apply/andP;split;apply/forallP;by intro. 

intros. 
 move/andP:x0=>[huniq1 huniq2].  apply H;intros=>//. 
symmetry. 
unfold DMMLoc1. 
 move/andP:H1=>[H11 H12].
 move/forallP:H11=>H11. 
 move/forallP:H12=>H12.  
 have H11':(forall x : V,
        ((x \in l) && (activeG x x0)) ->
        (Poutread nu p0 x0.2 x == nseq (seq.size (nu x)) true)%B).
  intros. move:(H11 x1). rewrite H1. simpl. done. 
 have H12':( forall x : V,
        ((x \in l) && ~~ activeG x x0) ->
        (Poutread nu p0 x0.2 x == nseq (seq.size (nu x)) false)%B).
   intros. move:(H12 x1). rewrite H1. done.  

case ha1:(activeG a x).
  unfold activeG in ha1. move/eqP:ha1=>ha1. unfold activeL,Vread. 
  rewrite ha1. simpl. 
  case ha2:(  agreed (Poutread nu p0 x.2 a) (Pinread nu p0 x.2 a))=>//=. 
  symmetry. apply H0. apply/andP. split. 

  apply/forallP. intro. apply/implyP.  intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _
  ((Some (index true (Poutread nu p0 x.2 a))), 
         (nseq (seq.size (Poutread nu p0 x.2 a)) false)))=>//=.
  move:H1. unfold activeG. simpl. rewrite update_Plocal_iff. rewrite in_set
   (eq_sym x1 a).  rewrite in_cons. rewrite (eq_sym x1 a). 
  case hax1:(a==x1)=>/=;last first.
    by apply H11'.
   by move/eqP:hax1;intro;subst x1;rewrite ffunE.

  apply/forallP. intro. apply/implyP.  intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _
  ((Some (index true (Poutread nu p0 x.2 a))), 
         (nseq (seq.size (Poutread nu p0 x.2 a)) false)))=>//=.
  move:H1. unfold activeG. simpl. rewrite update_Plocal_iff. rewrite in_set
   (eq_sym x1 a). rewrite in_cons. rewrite (eq_sym x1 a).  
  case hax1:(a==x1);last first.
    by apply H12'.
   intro;move/eqP:hax1;intro;subst x1.
   rewrite size_map. 
   rewrite takel_cat;last by rewrite size_nseq.
   set ml := (nseq (seq.size (nu a)) false). 
   rewrite -(size_nseq (seq.size (nu a)) false). 
   rewrite take_size. done.

  symmetry. apply H0. apply/andP. split. 

  apply/forallP. intro. apply/implyP.  intro. unfold Vwrite. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _
  (None,
         (nseq (seq.size (Poutread nu p0 x.2 a)) true)))=>//=.
  move:H1. unfold activeG. simpl. rewrite update_Plocal_iff. rewrite in_set
   (eq_sym x1 a). rewrite in_cons. rewrite (eq_sym x1 a).  
  case hax1:(a==x1);last first.
    by apply H11'.
   move=> _.  move/eqP:hax1;intro;subst x1.
   rewrite size_map. 
   rewrite takel_cat;last by rewrite size_nseq.
   set ml := (nseq (seq.size (nu a)) true). 
   rewrite -(size_nseq (seq.size (nu a)) true). 
   rewrite take_size. done.

  apply/forallP. intro. apply/implyP.  intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _
  (None,
         (nseq (seq.size (Poutread nu p0 x.2 a)) true)))=>//=.
  move:H1. unfold activeG. simpl. rewrite update_Plocal_iff. rewrite in_set
   (eq_sym x1 a). rewrite in_cons. rewrite (eq_sym x1 a).  
  case hax1:(a==x1);last first.
    by apply H12'.
  move/eqP:hax1=>hax1. subst a. rewrite ffunE. done.

unfold activeL,Vread. unfold activeG in ha1. rewrite ha1. 
simpl. 
symmetry. apply H0. apply/andP. split.
  apply/forallP. intro. apply/implyP.  intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _
  (x.1 a, 
         (Poutread nu p0 x.2 a)))=>//=.  
  move:H1. unfold activeG. simpl. rewrite update_Plocal_iff. rewrite in_set
   (eq_sym x1 a). unfold Vwrite. rewrite ffunE. rewrite in_cons. rewrite (eq_sym x1 a).  
  case hax1:(a==x1);last first.
    by apply H11'.
   move/eqP:hax1;intro;subst x1. rewrite ha1. done.

  apply/forallP. intro. apply/implyP.  intro. 
  rewrite (VPupdate_read_6 _ _ _  _ _ _
  (x.1 a, (Poutread nu p0 x.2 a)))=>//=.
  move:H1. unfold activeG. simpl. rewrite update_Plocal_iff. rewrite in_set
   (eq_sym x1 a).  rewrite in_cons. rewrite (eq_sym x1 a). 
  case hax1:(a==x1);last first.
    by apply H12'.
   intro;move/eqP:hax1;intro;subst x1.
   rewrite takel_cat;last by rewrite size_map.
   set ml := (nseq (seq.size (nu a)) false). 
  rewrite -(size_map (fun x1 =>x.2 (VtoP a x1 p0))).
   rewrite take_size. 
 move/forallP:hx=>hx. move:(hx a). unfold activeG. rewrite ha1. simpl.  
 done.
Qed. 


End MaxMatch.
