Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.


Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import gen.
Require Import rdaTool_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.


(** * Introduction

   The handshake algorithm is the following:
    each vertex v chooses a neighbour c(v)
    v sends 1 to c(v) and 0 to its other neighbour
    if v receives 1 from c(v) there is a handshake.
 
    The message passing is simulated by a labelling on the ports
    If v has chosen c(v), the port p(v,c(v)) is relabelled 1.

   The graphe contains vertices which are either active or inactive. 
   We consider that new handshakes can only occur in the active subgraph. 
 *)


Section HS.
(** * The graph
 *)

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.
 
Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.

Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

(** * Activity
 *)

Definition activeL (lv:VLabel) :=
  lv == None. 

Definition numberActive (lpin: seq PLabel) : nat :=
 count (fun x => x==true) lpin. 

Fixpoint sendChosen (k:nat) (lpin: seq PLabel) : seq PLabel :=
 match lpin with 
  |t::q => match k with
             |0 => (false::(sendChosen 0 q)) 
             |1 => if t then (true::(sendChosen 0 q))
                       else (false::(sendChosen 1 q))
             |S k' => if t then (false::(sendChosen k' q))
                      else (false::sendChosen k q)
             end
  | nil => nil
 end. 

Lemma sendChosen_size : forall k lpin, 
 seq.size (sendChosen k lpin) = seq.size lpin. 
Proof. 
move=>k lpin;elim:lpin k=>//a l h k. 
case:k=>/=; first by rewrite (h O). 
case=>/=.
 case:a=>/=;first by rewrite (h O).
  by rewrite (h 1%nat).
move=> n;case:a=>/=; first by rewrite (h n.+1).
by rewrite (h n.+2). 
Qed.   

Lemma sendChosen_memT : forall k  lpin, 
 (k < numberActive lpin)%nat  -> 
  true \in sendChosen k.+1 lpin.
Proof.
move=>k lpin;elim:lpin k=>//=a l hind k h.
case:k h=>/=.
 case:a=>//= hk;rewrite in_cons/=;by apply hind.   
move=>k. 
case:a;rewrite in_cons=>/= hk;by apply hind. 
Qed.

Lemma sendChosen_count : forall k  lpin, 
 (count id (sendChosen k.+1 lpin) <= 1)%nat.
Proof.
move=>k lpin;elim:lpin k=>//=a l hind k.
case:k=>/=;last first. 
 move=>k;case:a=>/=.
 apply (@leq_trans (count id (sendChosen k.+1 l)))=>//.
 apply (@leq_trans (count id (sendChosen k.+2 l)))=>//.
case:a=>/=;last first. 
 apply (@leq_trans (count id (sendChosen 1 l)))=>//.
clear;elim:l=>//=.
Qed. 

Lemma sendChosen_countk : forall k  lpin, 
 (k < numberActive lpin)%nat  -> 
 count id (sendChosen k.+1 lpin) = 1.
Proof.
move=>k lpin;elim:lpin k=>//=a l hind k.
case:k=>/=;last first. 
 move=>k;case:a=>/=h;rewrite hind=>//.  
case:a=>h //=. 
 clear;elim:l=>//=.
rewrite hind=>//. 
Qed. 


(** * Algorithms
 *)

Definition HSLoc (lv:VLabel) (lpout lpin: seq PLabel) : gen (VLabel *seq PLabel) :=
if  (activeL lv) then
  match (numberActive lpin) with
   |O => Greturn _ (Some (seq.size lpout),nseq (seq.size lpout) false)
   |S n => Grandom _ n 
      (fun k => Greturn _ (lv,sendChosen k.+1 lpin))
  end
else Greturn _ (lv,lpout).

Definition HSRound (seqV: seq V) (res: VState * PState):=
 GPRound nu false p0 seqV res HSLoc. 


End HS.
