Require Import ssreflect ssrfun ssrbool eqtype ssrnat.
Require Import fintype finset fingraph seq finfun bigop choice tuple.
Import Prenex Implicits.

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Require Import Rplus.
Require Import my_alea.
Require Import my_ssr.
Require Import my_ssralea. 
Require Import graph.
Require Import graph_alea.
Require Import labelling.
Require Import bfs.
Require Import gen.
Require Import dist.
Require Import rdaTool_gen.
Require Import rdaTool_dist.
Require Import hsAct_gen.

Set Implicit Arguments.
Unset Strict Implicit.

Open Local Scope U_scope.
Open Local Scope O_scope.

(** * Introduction

       This file is the analysis of the solution of the handshake problem over an active 
       subgraph. 
  *)

Section Handshake.

(** * The graph
 *)

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Definition E := (@edge_finType V Adj).
Variable e0:E.

Definition Pt := (@port_finType V Adj). 
Definition p0 := (EtoP1 e0). 

Definition VLab : eqType := option_eqType nat_eqType.
Definition PLab : eqType := bool_eqType.

Definition VSt := LabelFunc V VLab.
Definition PSt := LabelFunc  Pt PLab.

(** * Some other definitions
 *)

Definition activeG (v:V) (s:VSt * PSt):= 
  s.1 v == None. 

Definition inactiveG (v:V) (s:VSt * PSt):= 
 exists i, s.1 v == Some i. 

Fixpoint index_ithActive_aux (lpin:seq PLab) (i res:nat) :=
 match lpin with 
   |nil => res
   |t::q => if t then 
             match i with |O => res |S n => (index_ithActive_aux q n res.+1) end
             else (index_ithActive_aux q i res.+1) 
 end.

Definition index_ithActive (lpin:seq PLab) (i:nat) :=
 index_ithActive_aux lpin i 0. 

Lemma nthActive0 : forall l n m,
index_ithActive_aux l n m.+1 = (index_ithActive_aux l n m).+1.
Proof.
elim=>//=. 
intros. case:a=>//=. 
case:n=>//=.
Qed. 

Lemma nthActive1 : forall lpin k,
 index_ithActive lpin k = index true (sendChosen k.+1 lpin).
Proof. 
unfold index_ithActive;elim=>//=.
intros;case:a;case:k=>//;[intros n | |intros n]; 
 rewrite index_cons=>//;rewrite -H;apply nthActive0.
Qed.

Lemma nthActive2 : forall lpin k x, (k < numberActive lpin)%nat -> 
k <> x -> index_ithActive lpin k <> index_ithActive lpin x. 
Proof. 
unfold index_ithActive. 
elim=>//=.
intros. move:H0;case a=>/=;last first. 
 intros. do 2 rewrite nthActive0. apply not_eq_S. apply H=>//. 
move:H1.  case:k=>//=.
 case:x=>//=. move=>n _ _. rewrite nthActive0. auto. 
case:x=>//=.
 move=>n _ h. rewrite nthActive0. auto. 
intros.  do 2 rewrite nthActive0. apply not_eq_S.  apply H=>//;auto.
Qed. 


(** * Local Algorithm
 *)

Definition DHSLoc (lv:VLab) (lpout lpin: seq PLab) 
 : distr (VLab *seq PLab) :=
if  (activeL lv) then
  match (numberActive lpin) with
   |O => Munit (Some (seq.size lpout),nseq (seq.size lpout) false)
   |S n => Mlet (Random n)
      (fun k => Munit (lv,sendChosen k.+1 lpin))
  end
else Munit (lv,lpout).

Section gen.
(** ** Proofs of the equivalence with the generic algorithm
 *)

Lemma DPGHS_eq1 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem  (HSLoc lv lp1 lp2) = 
 DHSLoc lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold HSLoc,DHSLoc.
case : (activeL lv)=>//=.
case:( numberActive lp2)=>//=.
Qed.

End gen.


(** ** Local Analysis
 *)

(** 
   DHSLoc can be decomposed in a sum of computations 
    around each port
 *)

Lemma is_discrete_DHSLoc : forall (lv:VLab) (lpout:seq PLab) 
 (lpin:seq PLab),
  is_discrete_s (DHSLoc lv lpout lpin).
Proof.
move=>lv lpout lpin.
unfold DHSLoc. 
case: (numberActive lpin).
 case:(activeL lv). 
  by exists (Build_discr_s(@retract_invn 0) (fun k=>(Some (seq.size lpout),
   nseq (seq.size lpout) false)))=>/=;intro x;repeat Usimpl.
  by exists (Build_discr_s (@retract_invn 0)  (fun k => (lv,lpout)))=>/=;
   intro x;repeat Usimpl.
intro n. 
case:(activeL lv). 
exists (Build_discr_s (@retract_invn n) 
 (fun k => (lv, sendChosen k.+1 lpin))).
by intro f.
  by exists (Build_discr_s (@retract_invn 0)  (fun k => (lv,lpout)))=>/=;
   intro x;repeat Usimpl.
Qed. 


(** 
     DHSLoc terminates 
 *)

Lemma DHSLoc_total : forall (lv:VLab) (lpout:seq PLab) (lpin:seq PLab),
 Term (DHSLoc lv lpout lpin).
Proof.
move =>lv lpout lpin;unfold DHSLoc.
case:(activeL lv);case:(numberActive lpin)=>//n.  
apply Random_total=>//.
Qed.



(** 
     The number generated by (DHSLoc v) are inferior or equal to 
     the number of active
 *)

Definition carac_lc_size : seq PLab -> VLab * seq PLab -> U  := 
 fun (lpin:seq PLab) (s:VLab * seq PLab)  => 
B2U ( (index true s.2) < seq.size lpin )%nat. 

Lemma DHSLoc_size : forall (lv:VLab) (lpout:seq PLab) (lpin:seq PLab), 
 (0 < numberActive lpin)%nat ->
 activeL lv ->
 mu (DHSLoc lv lpout lpin) (carac_lc_size lpin) == 1.
Proof.
unfold DHSLoc,carac_lc_size;move=>lv lpout lpin H->.
case h:(numberActive lpin == O)%B. 
 move/eqP:h=>h;rewrite h in H;done. 
have [n h']: (exists x, numberActive lpin == x.+1).
 move:h;case:(numberActive lpin)=>//. 
 intro n; exists n=>//. 
move/eqP:h'=>h';rewrite h'. 
rewrite Mlet_simpl.   
setoid_rewrite (fun x => Munit_simpl (fun s : VLab * seq PLab => 
  B2U (index true s.2 < seq.size lpin)%nat) (lv, sendChosen x.+1 lpin)).
rewrite random_simpl. 
rewrite (@sigma_eq_compat _ (fun k => [1/]1+n));auto.
intros k hk. simpl. rewrite -(sendChosen_size k.+1). rewrite index_mem. 
rewrite (sendChosen_memT) =>//.
by rewrite h';move/ltP:hk.
Qed.

(** 
   The probability for a vertex to choose the ith neighbour
    is 1/(deg v)
 *)

(** 
    carac_lc_eq returns true if i is equal to the choice of v
    i.e. it returns true if v chooses its ith neighbour
    else false
 *)

Definition carac_lc_eq : nat -> seq PLab -> VLab * seq PLab -> U  := 
 fun (i: nat) (lpin:seq PLab) (s: VLab * seq PLab) => 
  B2U ( (index_ithActive lpin i) == (index true s.2)).

Lemma DHSLoc_eq : forall (lv:VLab)(lpout lpin:seq PLab)(k n: nat), 
 (k < n.+1)%nat ->
 numberActive lpin = n.+1 -> 
 activeL lv ->
 (mu (DHSLoc lv lpout lpin)) (carac_lc_eq k lpin) == [1/]1+n.
Proof.
unfold DHSLoc;move=> lv lpout lpin k n hk h->;rewrite h.
rewrite Mlet_simpl. 
setoid_rewrite (fun x => Munit_simpl (carac_lc_eq k lpin)
  (_, sendChosen x.+1 lpin)).
rewrite <-Nmult_1;rewrite -(@Random_eq _ k)=>//;last by move/leP:hk;
 auto with arith. 
apply mu_eq_compat=>// x.
unfold carac_lc_eq,B2U,carac_eq,carac. 
case (eq_nat_dec k x)=>heq1.
subst k. by rewrite nthActive1 eq_refl.
simpl. 
rewrite -h in hk. 
move/eqP:(@nthActive2 lpin k x hk heq1).
rewrite (@nthActive1 _ x).
case:(index_ithActive lpin k == index true (sendChosen x.+1 lpin))=>//.
Qed.  
    

(** * Global Algorithm
 *)

(** 
    DHS seqV res : at the end of the algorithm DHS, 
    each vertices in seqV has made a choice among its neighbours
    and has updated its choice in res
 *)
Definition DHS (seqV: seq V) (res: VSt * PSt): distr (VSt * PSt) :=
 DPRound nu false p0 seqV res DHSLoc.

Section genRound.
(** ** Proofs of the equivalence with the generic algorithm
 *)

Lemma DPGHS_eq2 : forall  (seqV: seq V) (res:VSt*PSt),
 Distsem (HSRound nu p0 seqV res) = 
 DHS seqV res.
Proof.
move=>seqV res;unfold HSRound,DHS. 
apply DPG_eq1. 
apply DPGHS_eq1.
Qed. 

End genRound. 

(** ** Analysis
 *)

(** *** Termination
     DHS terminates whichever the sequence of vertices 
    on which DHS is applied
 *)

(** 
    
 *)

Lemma DHS_total : forall(s: seq V) (res: VSt*PSt), 
 Term (DHS s res).
Proof.
move=>s res;apply (DRound_total). 
move=>w;apply DHSLoc_total.
Qed.


(** *** Probability to choose a neighbour, local view

    The probability for a vertex to choose the ith neighbour
    (i.e. ith neighbour is labelled true)
    is 1/(deg v)
 *)

(** 
    carac_hs_eqNat returns true if i is equal to the local choice of v
    extracted from the global labelling function 
    i.e. it returns true if v chooses its ith neighbour
    else false
 *)

Definition carac_hs_eqNat : V -> seq PLab -> nat -> VSt * PSt -> U  := 
 fun (v:V) (lpin:seq PLab) (i: nat) (s: VSt * PSt) =>  
 B2U (index_ithActive lpin i == 
 index true (Poutread nu p0 s.2 v)). 

Lemma DHS_degv_aux1 : forall (v:V) (i:nat) (lpin:seq PLab) (y:VLab * seq PLab) 
(sn:VSt * PSt), 
 seq.size y.2 = seq.size (nu v) ->
 carac_lc_eq i lpin y == 
 carac_hs_eqNat v lpin i (VPupdate nu false v y sn).
Proof.
move=>v i lpin y sn h.
unfold carac_lc_eq,carac_hs_eqNat,B2U. 
rewrite VPupdate_read_3=>//.
Qed. 

Lemma DHS_size1 : forall a b c,
 seq.size b = seq.size c ->
 (mu (DHSLoc a b c)) (fun x => B2U(seq.size x.2 != seq.size c)) == 0.
Proof.
move=>a b c hbc;
unfold DHSLoc;case:(activeL a);last first. 
 by simpl;rewrite hbc eq_refl. 
case h : (numberActive c). 
 by simpl;rewrite size_nseq hbc eq_refl.
rewrite Mlet_simpl. 
apply mu_zero_eq.
move=>x/=. 
by rewrite sendChosen_size eq_refl.
Qed. 


Lemma DHSLtac1 a b c d f:
 seq.size b = seq.size c ->
 (mu (DHSLoc a b c)) (fplus f
      (fun x => B2U(seq.size x.2 != seq.size c)))  == d ->
 (mu (DHSLoc a b c)) f == d.
Proof. 
move=>h h1;apply Ole_antisym;
transitivity ((mu (DHSLoc a b c)) (fplus f 
 (fun x => B2U(seq.size x.2 != seq.size c )))); try rewrite h;auto.
rewrite mu_le_plus DHS_size1;auto.
Qed.


Lemma DHS_degv_aux2 : forall (v:V) (x:VLab*seq PLab) (s:VSt*PSt)(i:nat),
  seq.size x.2 = seq.size (nu v) ->
  (mu (DHS (seq.rem v (enum V)) s))
        (fun x0 : LabelFunc V VLab * LabelFunc port_finType bool_eqType =>
         carac_hs_eqNat v (Pinread nu p0 s.2 v) i (VPupdate nu false v x x0)) == 
         carac_hs_eqNat v (Pinread nu p0 s.2 v) i (VPupdate nu false v x s).
Proof.
have : uniq (enum V) by apply enum_uniq.
elim:(enum V)=>//. 
intros;rewrite cons_uniq in x;move/andP:x=>[h1 h2]/=.  
case hav:(a==v).
  replace l with (seq.rem v l);last by move/eqP:hav h1->; apply rem_id.
  by apply (H h2 v x0 s i).
simpl;rewrite -(H _ _ _ _ _)=>//.
apply mu_eq_compat=>//. 
intro x;unfold carac_hs_eqNat,B2U.
unfold VPupdate,Pupdate. simpl. 
transitivity ((mu (DHSLoc (Vread s.1 a) (Poutread nu p0 s.2 a) 
 (Pinread nu p0 s.2 a)))
     (fun x1 : option nat * seq bool =>
      if index_ithActive (Pinread nu p0 s.2 v) i ==
         index true
           (Poutread nu p0
   (update (outerport_set v) x.2 (Pwrite nu false x0.2 v)) v)
      then 1
      else 0));last first. 
 by rewrite  mu_cte DHSLoc_total .
apply mu_eq_compat=>//= x1.
rewrite (@VPupdate_read_3 _ _ _ _ _ _ _ _ _ _ _ 
(x.1, (update (outerport_set a) x.2 (Pwrite nu false x1.2 a))))=>//. 
rewrite VPupdate_read_3=>//. 
Qed. 
 
Lemma DHS_degv_local : forall (v:V)(i n:nat)(s:VSt*PSt), 
 (i < n.+1)%nat ->
 numberActive (Pinread nu p0 s.2 v) = n.+1 -> 
 activeG v s ->
 (mu  (DHS (enum V) s)) (carac_hs_eqNat v (Pinread nu p0 s.2 v) i) == 
 [1/]1+n.
Proof.
move=>v i n s hi hactive hact;unfold DHS.
unfold DPRound. 
rewrite (@DRoundCommute2 _ _ _ _ _ _ _ _ _ _  _ _ v);last first. 
 by rewrite mem_enum. 
by apply disjoint_outerport. 
 by intro w;apply is_discrete_DHSLoc.
rewrite DRoundcons2;last by apply is_discrete_DHSLoc.
simpl. 
rewrite -(@DHSLoc_eq (Vread s.1 v) (Poutread nu p0 s.2 v) 
 (Pinread nu p0 s.2 v) i)=>//.
have hnuv: (seq.size (Poutread nu p0 s.2 v) = seq.size (Pinread nu p0 s.2 v)). 
 by do 2 rewrite size_map.
apply DHSLtac1=>//;symmetry.
apply DHSLtac1=>//;symmetry.
apply mu_eq_compat=>//. 
intro x;unfold fplus. 
case h:( seq.size x.2 == seq.size (Pinread nu p0 s.2 v) )=>/=;Usimpl;auto. 
move/eqP:h;rewrite size_map=>h. 
rewrite DHS_degv_aux2=>//.
by rewrite (DHS_degv_aux1 _ _ s  h);Usimpl.
Qed. 



(** *** Probability to choose a neighbour, global view
      The probability for a vertex to choose the vertex w which is a neighbour
       is 1/(deg v)
 *)
(** 
    carac_hs_eqV returns true if v chooses w
    else false
 *)

Definition hs_eqVB (v w:V) (s:VSt*PSt) := 
 index w (nu v) == 
 index true (Poutread nu p0  s.2 v).

Definition carac_hs_eqV : V -> V -> VSt*PSt -> VSt*PSt ->U :=
 fun (v w: V) (inits s:VSt*PSt) => 
   B2U (hs_eqVB v w s). 


Lemma carac_hs_iff : forall (v w: V) (inits:VSt *PSt) (i:nat), 
 index w (nu v) = index_ithActive (Pinread nu p0 inits.2 v) i -> 
 carac_hs_eqV v w inits == 
 carac_hs_eqNat v (Pinread nu p0 inits.2 v) i.
Proof.
move=>v w inits i hi s;unfold carac_hs_eqV,carac_hs_eqNat.
by rewrite -hi.
Qed.

Definition is_neigh_active (v w:V) (s:VSt*PSt) :=
(nth false (Pinread nu p0 s.2 v) (index w (nu v))).

Lemma is_neigh_active1 : forall (v w:V) (s:VSt*PSt),
 is_neigh_active v w s ->
 exists i,
 (i < numberActive (Pinread nu p0 s.2 v))%nat /\
 (index w (nu v) = index_ithActive (Pinread nu p0 s.2 v) i).
Proof.
unfold is_neigh_active;move=>v w s.
unfold Pinread. 
elim:(nu v)=>//=a l hind.
case haw:(a==w)=>/=;case H0:(s.2 (VtoP a v p0))=>//=H1. 
   exists O=>//=.
 have [i [hi1 hi2]]:=(hind H1).
 exists i.+1;split=>//=.
 by rewrite hi2;unfold index_ithActive;simpl;rewrite nthActive0.
have [i [hi1 hi2]]:=(hind H1). 
exists i;split;auto. 
by rewrite hi2 -nthActive0.
Qed.

Lemma is_neigh_active2 :  forall (v w:V) (s:VSt*PSt),
 is_neigh_active v w s ->
 Adj v w. 
Proof. 
unfold is_neigh_active,Pinread;move=>v w s.
rewrite Hnu. rewrite -index_mem.
elim:(nu v)=>//=. 
intros a l hind.
case haw: (a == w)=>//=. 
Qed. 


Lemma DHS_degv_global : forall (v w: V) (s:VSt*PSt) (n:nat),
  numberActive (Pinread nu p0  s.2 v) = n.+1 ->
  is_neigh_active v w s ->
  activeG v s ->
 (mu (DHS (enum V) s)) (carac_hs_eqV v w s) == [1/]1+n.
Proof.
move=> v w s n h h' h''.
have [i [hi1 hi2]] := (is_neigh_active1 h').
rewrite (carac_hs_iff hi2).
rewrite h in hi1. 
by apply DHS_degv_local.
Qed.


Section initState.

(** We assume that initial state is coherent according to the activity of 
       vertices
  *)
Variable initState : VSt * PSt.

Hypothesis initState1 : forall (v:V), (activeG v initState)  -> 
 (Poutread nu p0 initState.2 v) = nseq (seq.size (nu v)) true.

Hypothesis initState2 : forall v, (inactiveG v initState) -> 
 (Poutread nu p0 initState.2 v) = nseq (seq.size (nu v)) false.



(** *** Probability of having a handshake on an edge
      The probability for an edge (v,w) having a handshake on it is 
     1/(deg v * deg w)
 *)

(** 
   carac_hse returns true if v chooses w and w chooses v 
    else false
 *)

Definition hs_edgeB (e:E) (s:VSt*PSt) : bool :=
(hs_eqVB (fste e) (snde e) s) &&  (hs_eqVB (snde e) (fste e) s).

Definition carac_hs_edge : E -> VSt*PSt -> U :=
 fun (e:E)  =>
  fB2U (fun (s:VSt*PSt) => hs_edgeB e s). 

Definition nactv (v:V) :=
 (numberActive (Pinread nu p0 initState.2 v)).

Definition nactvdecr (v:V) :=
 (numberActive (Pinread nu p0 initState.2 v)).-1.

Lemma activeG1 : forall v w,
 activeG w initState ->
 Adj v w ->
 is_neigh_active v w initState.
Proof.
move=>v w h1 hadj.  
apply initState1 in h1.
have : (w \in (nu v)).
 by rewrite -Hnu.
move:h1. unfold Poutread,is_neigh_active,Pinread.
elim:(nu v)=>//= u l hind h1.
rewrite in_cons.
rewrite eq_sym. 
case huw:(u == w)=>//=;last by apply hind. 
move=>_. move/eqP:huw h1=>huw. subst u.
have : (v \in (nu w)).
 by rewrite gsym in hadj;rewrite -Hnu.
clear. elim:(nu w)=>//=u l hind h1 h2.
 injection h2=>h3 h4. clear h2.
move:h1.
rewrite in_cons. case huv:(v == u)=>//=;last by intro;apply hind.
move/eqP:huv=>huv _. subst u. done.
Qed.

Lemma activeG2 : forall v w,
 activeG w initState ->
 Adj v w ->
 exists n, numberActive (Pinread nu p0  initState.2 v) = n.+1.
Proof. 
move=>v w h1 hadj. apply initState1 in h1.
have : (v \in (nu w)).
 by rewrite gsym in hadj;rewrite -Hnu.
move:h1. unfold Poutread,Pinread.
elim:(nu w)=>//=u l hind h1 h2.
move:h2. rewrite in_cons. case hvu: (v \in l).
 move=>_. apply hind=>//.
 by injection h1=>->.
case hvu':(v == u)=>//_.
move/eqP:hvu'=>hvu'. subst u.
injection h1=>h2 h3. clear h1.
have : (w \in (nu v)). 
 by rewrite -Hnu.
elim:(nu v)=>//=u l'. 
rewrite in_cons. case hw:(w \in l')=>//= hind'.
 move=>_. destruct hind'=>//. 
 rewrite H. exists ((initState.2 (VtoP u v p0) == true) + x)%nat=>//.
case hwu:(w==u)=>//=_.
move/eqP:hwu=>hwu. subst u.
rewrite h3 eq_refl/=.
exists ( numberActive [seq initState.2 (VtoP x v p0) | x <- l'])=>//. 
Qed.

Lemma activeG3 : forall (i:E),
 activeG (fste i) initState -> 
 (0 < (numberActive (Pinread nu p0 initState.2 (snde i))))%nat.
Proof. 
move=>e he. apply initState1 in he. move:he.  
unfold Poutread, Pinread,numberActive.
intro. 
have he2: (initState.2 (VtoP (fste e) (snde e) p0) == true).
 move:he. rewrite -(size_map (fun x =>initState.2 (VtoP (fste e) x p0))).
 move/all_pred1P. move/allP.  unfold pred1. simpl. 
 intro he. apply he. apply/mapP. exists (snde e)=>//. 
  rewrite -Hnu. apply edge_fste_snde. 

rewrite -has_count. apply/hasP. 
exists true=>//.
apply/mapP. 
exists (fste e). 
 rewrite -Hnu. rewrite gsym. apply edge_fste_snde.
by move/eqP:he2->.
Qed.

Lemma activeG4 : forall (i:E),
 activeG (snde i) initState -> 
 (0 < (numberActive (Pinread nu p0 initState.2 (fste i))))%nat.
Proof. 
move=>e he. apply initState1 in he. move:he.  
unfold Poutread, Pinread,numberActive.
intro. 
have he2: (initState.2 (VtoP (snde e) (fste e) p0) == true). 
  move:he. rewrite -(size_map (fun x =>initState.2 (VtoP (snde e) x p0))).
 move/all_pred1P. move/allP.  unfold pred1. simpl. 
 intro he. apply he. apply/mapP. exists (fste e)=>//. 
  rewrite -Hnu. rewrite gsym. apply edge_fste_snde. 
rewrite -has_count. apply/hasP. 
exists true=>//.
apply/mapP. 
exists (snde e). 
 rewrite -Hnu. apply edge_fste_snde.
by move/eqP:he2->.
Qed. 

Lemma indepbDHS_hs : forall  (e:E) (inits:VSt*PSt),
 indepb (DHS (enum V) inits)
    (hs_eqVB (fste e) (snde e))
    (hs_eqVB (snde e) (fste e)).
Proof.
intros e inits;unfold DHS. 
apply DRoundindepb with 
 (c:= fun x => (index (snde e) (nu (fste e)) ==  index true
(take (seq.size (nu (fste e))) (x.2 ++ nseq (seq.size (nu (fste e))) false))))
 (c':=fun x=>(index (fste e) (nu (snde e)) == index true 
(take (seq.size (nu (snde e))) (x.2 ++ nseq (seq.size (nu (snde e))) false)))).
intro w;apply DHSLoc_total.
unfold indepProp;intro t.
case hvt : ((fste e) == t);case hwt : ((snde e) == t)=>/=;
have hevw:=(edge_fs e);unfold hs_eqVB. 

by move/eqP:hwt hevw=>hwt;rewrite -hwt in hvt;rewrite hvt.

right;left;split;move=>x sn;move/eqP:hvt hevw->.
 by rewrite VPupdate_read_4. 
by intro;rewrite VPupdate_read_2.

right;right;split;move=>x sn;move/eqP:hwt hevw=>->;rewrite eq_sym=>
hevw=>//.
 by rewrite VPupdate_read_2. 
by rewrite VPupdate_read_4.

left;split;move=> x sn;rewrite eq_sym in hvt;rewrite eq_sym in hwt; 
rewrite VPupdate_read_2=>//;by [rewrite hvt|rewrite hwt].
Qed.



Lemma DHS_dege : forall (e:E),
 activeG (fste e) initState ->
 activeG (snde e) initState ->
 mu (DHS (enum V) initState) (carac_hs_edge e) == 
   [1/]1+(nactvdecr (fste e)) *
   [1/]1+(nactvdecr (snde e)).
Proof.
move=> e hn2 hm2.
have hindep := (@indepbDHS_hs e initState).
rewrite carac_prodb =>//;unfold fB2U. 
have hadj: (Adj (fste e) (snde e)). 
 clear;unfold snde,fste;destruct e=>/=.
 by move/andP:EdgeValP=>[h1 h2].
have [m hm] := (activeG2 hm2 hadj). 
have hm1 := (activeG1 hm2 hadj).
rewrite gsym in hadj.
have [n hn] := (activeG2 hn2 hadj). 
have hn1 := (activeG1 hn2 hadj).
rewrite (DHS_degv_global hn hn1 hm2). 
rewrite (DHS_degv_global hm hm1 hn2).
unfold nactvdecr. by rewrite hm hn.
Qed.


(** ***  Probability for having at least one vertex
 *)

Require Import Rplus. 

(** 
      hs_glob s returns true if there is a handshake in the graph
                 else false
 *)

Definition hs_glob (x:E) (inits s:VSt*PSt):= 
 (activeG (fste x) inits) && (activeG (snde x) inits) && (hs_edgeB x s).

Definition hs_glob_ex (inits s:VSt*PSt) : bool :=
  [exists x, hs_glob x inits s]. 

(** 
      carac_hs_glob s returns 1 if there is a handshake in the graph
                       else 0
 *)

Definition carac_hs_glob (x:E) (inits:VSt*PSt): VSt*PSt -> U :=
 fB2U (fun (s:VSt*PSt) => hs_glob x inits s).

Definition carac_hs_glob_ex (inits:VSt*PSt): VSt*PSt -> U :=
 fB2U (fun (s:VSt*PSt) => hs_glob_ex inits s).

Definition hscte := prod (fun _ => [1-] ([1/2] * [1/]1+(#|E|.-1))) #|E|. 

(** **** Rpsigma_hs
  *)


Lemma subsetmem1 : forall (l l':seq V) (a:V), 
 a \notin l' -> l' \subset a::l ->
 l' \subset l.
Proof.
elim=>/=.
 elim=>//=.
 intros. move/subsetP:H1=>hl. have:=(hl a).
 move:H0. rewrite in_cons in_cons in_cons eq_refl eq_sym in_nil.
 case:(a == a0)=>//=. intros. have:false=>//. by apply x.
intros. apply/subsetP. intros x hx.
move/subsetP:H1=>H1. have:=(H1 x hx).
rewrite in_cons. move/orP=>[H'| H']=>//.
by move/eqP:H' hx H0->=>->.
Qed.    

Lemma rem_mem_not : forall (l:seq V) (i a:V), 
  i \in l -> i \notin seq.rem a l -> i = a.
Proof.
elim=>//=.
intros a l hind i a'.
 rewrite in_cons.  case haa:(a==a')=>//=.
 move/eqP:haa->. case hi:(i == a')=>//=.
 move/eqP:hi. done.
 move=>->. done.
rewrite in_cons. case hi : (i == a)=>//=. apply hind.
Qed.


Lemma remsubsetcons : forall (l l':seq V) a, uniq l' -> 
 l' \subset a :: l -> a \in l' ->  seq.rem a l' \subset l.
Proof.
move=>l l' a hal. move/subsetP=>h1 h2.
apply/subsetP. intros x hx. have:=(h1 x).
case hx':(x \notin l')=>//.
 have := (rem_impl _ _ _ a hx');by rewrite hx. 
rewrite in_cons. case hca:(x == a);last first.
case:(x \in l)=>//=.
 apply. move:hx'. case:(x \in l');done.
move=>_. move/eqP:hca hx->.
rewrite (mem_rem_uniq _ hal a). unfold predD1.
move/andP. rewrite eq_refl. move=>[h h']. done.
Qed.

Lemma map_nseq_eq1 : forall (l:seq V) f a,  
 [seq f x | x <- l] = nseq (seq.size l) true ->
 [seq f x | x <- seq.rem a l] =
   nseq (seq.size (seq.rem a l)) true.
Proof.
elim=>//=.
intros a l hind f a'.
move=>[h1 h2].
case haa:(a == a')=>//=. 
rewrite h1.  rewrite hind=>//. 
Qed.

Lemma numberActive1 : forall l l', perm_eq l l' ->
 numberActive l = numberActive l'. 
Proof.
intros;unfold numberActive.
by apply/perm_eqP.
Qed. 
  
Lemma numberActive2 : forall l a v, 
 a \in l -> 
   numberActive [seq initState.2 (VtoP x0 v p0) | x0 <- l] =
   ( (initState.2 (VtoP a v p0) == true) +
     numberActive [seq initState.2 (VtoP x0 v p0) | x0 <- seq.rem a l])%nat.
Proof. 
intros. 
have hperm:= (perm_to_rem H). 
apply (perm_map (fun x =>  initState.2 (VtoP x v p0))) in hperm.
by rewrite (numberActive1 hperm)/=.
Qed.

Lemma activeinactive : forall a s, 
 activeG a s = false -> inactiveG a s.
Proof.
move=>a s;unfold inactiveG,activeG.
case:(s.1 a)=>//.
by intros;exists a0.
Qed. 


Lemma activeinit1 : forall v w,
 v \in nu w ->  activeG w initState = false ->
 initState.2 (VtoP w v p0) = false.
Proof.
move=>v w hwv.
move/activeinactive;move/initState2;unfold Poutread.
rewrite -(size_map (fun x => initState.2 (VtoP w x p0))).
move/all_pred1P;move/allP;unfold pred1=>/=h.
apply/eqP;apply (h (initState.2 (VtoP w v p0))).
by apply(map_f  (fun x => initState.2 (VtoP w x p0))).
Qed.

Lemma activeinit2 : forall v w,
 v \in nu w ->  activeG w initState = true ->
 initState.2 (VtoP w v p0) = true.
Proof.
move=>v w hwv.
move/initState1;unfold Poutread.
rewrite -(size_map (fun x => initState.2 (VtoP w x p0))).
move/all_pred1P;move/allP;unfold pred1=>/=h.
apply/eqP;apply (h (initState.2 (VtoP w v p0))).
by apply(map_f  (fun x => initState.2 (VtoP w x p0))).
Qed.

Lemma numberActive3 : forall v w,
 v \in nu w ->  
 initState.2 (VtoP v w p0) ->
 (0 < numberActive [seq initState.2 (VtoP x1 w p0) | x1 <- nu w])%nat.
Proof.
move=>v w.
unfold numberActive;rewrite count_filter.
elim:(nu w)=>//= a l hind h1 h2.
case ha:(initState.2 (VtoP a w p0))=>//=.
apply hind=>//.
move:h1;rewrite in_cons.
case h3:(v==a)=>//.
move/eqP:h3=>h3;subst v.
by rewrite h2 in ha.
Qed.

Lemma nactvdecr2' : forall v,
activeG v initState -> (0 < nactv v)%nat ->
   count (fun i : V => (i \in nu v) && (activeG i initState &&
 (0 < nactv i)%nat))
     (enum V) = (nactvdecr v).+1.
Proof.
unfold nactvdecr,nactv,Pinread;intros. 
rewrite count_filter prednK=>//.
have: (subset (mem (nu v)) (mem (enum V))).
 by apply/subsetP;move=>x h;rewrite mem_enum.
have:=(initState1 H);unfold Poutread.
have:(uniq (nu v)) by auto.
have:(forall w, w \in nu v -> v \in nu w).
 by intro;rewrite -Hnu -Hnu gsym.
have:(uniq (enum V)) by apply enum_uniq.

set l:=(nu v);move:l.   
elim:(enum V)=>/=. 
 case=>//=a l _ h1 h2 h3 h4.
 move/subsetP:h4=>h4.
 have:=(h4 a);rewrite in_nil in_cons eq_refl/==>h5.
 have h: true by done. 
 by apply h5 in h.

move=>a l hind l0;move/andP=>[Hi5 Hi6] Hi4 Hi1 Hi2 Hi3. 
case h1:(a \in l0)=>//=;last first.
 apply hind=>//. 
 by apply (@subsetmem1 _ _ a )=>//;rewrite h1.
have Hi7:=(Hi4 _ h1). 

case h2:(activeG a initState)=>/=;last first.
 have h3:( numberActive [seq initState.2 (VtoP x0 v p0) | x0 <- l0] = 
  numberActive [seq initState.2 (VtoP x0 v p0) | x0 <- seq.rem a l0])
  by rewrite (numberActive2 _ h1);rewrite activeinit1=>//.
 rewrite h3 -hind=>//;last first.
 by apply remsubsetcons.
 by move:Hi2;apply  map_nseq_eq1=>//;apply remsubsetcons.
 by apply rem_uniq.
 by move=>w hw;apply Hi4;apply (mem_rem hw).
 apply f_equal;apply eq_in_filter;move=> i hi/=. 
 case hi2:(i \in seq.rem a l0);first by rewrite (@mem_rem _ a l0 i).
 case hi3:(i \in l0)=>//=.
 by rewrite (@rem_mem_not _ i a hi3)=>//;[rewrite h2|rewrite hi2].

case h3:(0 < numberActive [seq initState.2 (VtoP x1 a p0) | x1 <- nu a])%nat
=>/=;
 last first. 
 by rewrite -Hnu in Hi7;have [i hi] := (activeG2 H Hi7);rewrite hi in h3.

rewrite (numberActive2 _ h1) (activeinit2 Hi7 h2) eq_refl add1n -hind=>//;
 last first.
 by apply remsubsetcons.
 by apply map_nseq_eq1.
 by apply rem_uniq.
 by move=>w hw;apply Hi4;apply (mem_rem hw).
apply f_equal;apply f_equal;apply eq_in_filter=> i hi.
case hi1: (i \in l0).
 have hi2:(i \in seq.rem a l0).
  rewrite rem_filter=>//;rewrite mem_filter hi1.
  unfold predC1=>/=;case hai:(i==a)=>//. 
  by move/eqP:hai=>hai;subst i;rewrite hi in Hi5.
 by rewrite hi2.
have hi2:(i \notin l0).
 by rewrite hi1.
apply (@rem_impl _ _ _ a) in hi2. 
move:hi2;case:(i \in  seq.rem a l0)=>//.
Qed. 

Lemma nactvdecr2 : forall v,
activeG v initState -> (0 < nactv v)%nat ->
   count (fun i : V => Adj v i && (activeG i initState && (0 < nactv i)%nat))
     (enum V) = (nactvdecr v).+1.
Proof.
move=>v h1 h2.
rewrite -(nactvdecr2' h1 h2).
apply eq_count.
move=>i/=. 
by rewrite Hnu. 
Qed. 

Lemma nactvdecr1 : forall n w, 
 activeG w initState ->
 (0 < nactv w)%nat ->
 count (fun x => activeG x initState && (0 < nactv x)%nat) (enum V) = n.+1 ->
 (nactvdecr w <= n)%nat.
Proof. 
move=>n w h1 h2 h3.
apply/leP;apply le_S_n;unfold nactvdecr. 
rewrite -nactvdecr2=>//.
rewrite -h3;apply/leP;apply sub_count.
intros x;move/andP=>[h1' h2']=>//.
Qed.

Lemma Rpsigma_hs : forall (e:E) ,
 (0 < (count (fun x => activeG x initState && (0<nactv x)%nat ) 
(enum V)))%nat ->
 U2Rp([1/2]) <=
   (Rpsigma (fun k : nat =>
       (mu (DHS (enum V) initState)) (carac_hs_glob (nth e0 (enum E) k) 
initState)))
    #|E|.
Proof.
move=>e h.
have [n hcount] : (exists n, count (fun x=> activeG x initState && 
 (0<nactv x)%nat) (enum V) = n.+1).
 move:h. case:(count (fun x : V => activeG x initState && (0 < nactv x)%nat)
  (enum V))=>//. 
 intro n;by exists n.
clear h. 
unfold carac_hs_glob,hs_glob. 
rewrite (Rpsigma_eq_compat _ (fun k=> 
 (if (activeG (fste (nth e0 (enum E) k)) initState) && 
     (0 < (nactv (fste (nth e0 (enum E) k))))%nat
   then 
       ([1/]1+nactvdecr (fste (nth e0 (enum E) k))) else 0) * 
 (if (activeG (snde (nth e0 (enum E) k)) initState) &&
     (0 < (nactv (snde (nth e0 (enum E) k))))%nat
    then
       [1/]1+nactvdecr (snde (nth e0 (enum E) k)) else  0))); last first.

 have hyp:=DHS_dege;unfold carac_hs_edge in hyp. 
 move=>k hk. 
 case h1:(activeG (fste (nth e0 (enum E) k)) initState);last first.
  rewrite <-Uinv_inv;rewrite -(mu_one_inv _ (DHS_total (enum V) initState))
  (DHS_total (enum V) initState) Bool.andb_false_l. by repeat Usimpl.
 case h2:(activeG (snde (nth e0 (enum E) k)) initState).
  rewrite (activeG3 h1). rewrite (activeG4 h2).
  by rewrite hyp=>//.  
 rewrite <-Uinv_inv;rewrite -(mu_one_inv _ (DHS_total (enum V) initState))
  (DHS_total (enum V) initState). rewrite Bool.andb_false_l. 
 by repeat Usimpl. 

rewrite -(rpsigma_bigop _ _ (fun x=> 
  (if activeG (fste x) initState &&
           (0 < nactv (fste x))%nat
        then [1/]1+nactvdecr (fste x)
        else 0) *
       (if activeG (snde x) initState &&
           (0 <nactv (snde x))%nat
        then [1/]1+nactvdecr (snde x)
        else 0))).
unfold prodOP. 
rewrite (eq_bigrs _ _ _ _ _ _ (fun y =>  
 (if activeG (fste y) initState &&(0 <nactv (fste y))%nat then 
U2Rp([1/]1+nactvdecr (fste y)) else O) *
 (if activeG (snde y) initState &&(0 <nactv (snde y))%nat then 
U2Rp ([1/]1+nactvdecr (snde y)) else O))%Rp);
 auto;last first.
 intros; rewrite U2Rp_mult.
 case:( activeG (fste i) initState && (0 < nactv (fste i))%nat);last  
   by repeat rewrite Rpmult_zero_left.
 case:(activeG (snde i) initState && (0 < nactv (snde i))%nat);auto.
 
rewrite <-Rpmult_one_left;rewrite U2Rp_Unth.
apply Rpmult_le_perm_left. 
rewrite (bigop_edge_half2 _ _ 
 (fun x => (if  activeG x initState &&(0 < nactv x)%nat then 
U2Rp ([1/]1+nactvdecr x) else O)))=>//.
apply bigop_edge_R1 with (d:=[1/]1+n).
 rewrite hcount Rpmult_sym. apply Unth_mult_eq.
 
 move=>v w. move/andP=>[ hv1 hv2] hvw. move/andP=>[hw1 hw2].
 apply U2Rp_le_compat. apply Unth_le_compat.
 apply/leP. unfold nactvdecr.
 by apply nactvdecr1.

move=>v;move/andP=>[hv1 hv2];unfold nactvdecr. 
have: (count (fun i : V => Adj v i && (activeG i initState &&
 (0 < nactv i)%nat)) (enum V) = 
 (nactvdecr v).+1). 
 apply nactvdecr2=>//.
move->;apply Unth_mult_eq. 
Qed.
 


(** **** hs1 
 *)
Definition eth (k:nat) := 
 nth e0 (enum E) k. 

Definition AdjAct : rel V := (fun x y => 
 (activeG x initState) && (activeG y initState) && (Adj x y)).

Definition parentFunc (k:nat) := (@tF _ AdjAct (fste (eth k)) #|V|).

Definition choiceFunc (k:nat) : {ffun V -> V} := 
 finfun (fun x => match parentFunc k x with 
                     |Some y => y
                     |None => snde (eth k)
                   end).

Definition coverTree (k: nat) :  {ffun Pt -> bool} :=
 finfun (fun x => if activeG (fstp x) initState && activeG (sndp x) initState 
                  then (choiceFunc k (fstp x)) == sndp x
                  else false).
Print Vupdate. 
Lemma hs1_aux11 :  forall l v k x x0,
v \notin l ->
(if [forall v0,  (v0 \in v :: l) ==> ((Vupdate  v x0 x.1) v0 == initState.1 v0) &&
     [forall w,Adj v0 w ==>((Pupdate nu false  v x0 x.2 ) (VtoP v0 w p0) ==
             (coverTree k) (VtoP v0 w p0))]] then 1 else 0) ==
      (B2U ((x0.1 == initState.1 v) &&
            [forall w, Adj v w ==> (nth false x0.2 (index w (nu v)) == 
 (coverTree k) (VtoP v w p0))]))*
     (B2U ( [forall v0,(v0 \in  l) ==>
            ( x.1 v0 == initState.1 v0) &&
            [forall w, Adj v0 w ==> (x.2 (VtoP v0 w p0) ==
                 (coverTree k) (VtoP v0 w p0))]])).
Proof.
intros.
case h: ([forall v0, (v0 \in l) ==>  (x.1 v0 == initState.1 v0) &&
 [forall w, Adj v0 w ==> (x.2 (VtoP v0 w p0) ==(coverTree k) (VtoP v0 w p0))]])
=>/=;Usimpl;last first.
 
  move:h;move/negbT;rewrite negb_forall;move/existsP=>[y].
  case hy1:( y \in l)=>//=hy2.
case h:( [forall v0,  (v0 \in v :: l) ==> ((Vupdate v x0 x.1) v0 == initState.1 v0)
 &&
   [forall w,Adj v0 w ==> ((Pupdate nu false v x0 x.2) (VtoP v0 w p0) 
== (coverTree k) (VtoP v0 w p0))]])=>//. 
  move/forallP:h=>h. have :=(h y). rewrite in_cons hy1 orbT=>/=.
  rewrite ffunE.  case hyv:(y==v). 
       by move/eqP:hyv=>hyv;subst y;rewrite hy1 in H.
    red in hy2. move:hy2. rewrite Bool.negb_true_iff.
  rewrite in_set hyv.  
    case:(  (x.1 y == initState.1 y) )=>//=.
   move/ negbT. move/existsP. move=>[z]. intro hz1. 
  move/forallP. intro H0. have:=(H0 z).
  move:hz1. case hadj:(Adj y z)=>//=.  
   rewrite Pupdate_1=>//.  rewrite hyv. 
     intros hz1 hz2. rewrite hz2 in hz1. done.

move/forallP:h=>h. 
case h':([forall v0, (v0 \in v :: l) ==>((Vupdate v x0 x.1) v0 == initState.1 v0) 
&&
 [forall w, Adj v0 w ==> ((Pupdate nu false v x0 x.2) (VtoP v0 w p0) ==
   (coverTree k) (VtoP v0 w p0))]]);last first. 
  
move/forallP:h'=>h'.
case h'':((x0.1 == initState.1 v) &&
      [forall w,
         Adj v w ==>
         (nth false x0.2 (index w (nu v)) == (coverTree k) (VtoP v w p0))])=>//. 
destruct h'. intro y.
 rewrite Vupdate_1. rewrite in_cons. 
case hyv:(y==v)=>/=;last first.
have := (h y).  case:(y \in l)=>//=.  move/andP=>[h1 h2]. rewrite h1. simpl. 
move/forallP:h2=>h2.
 apply/forallP. intro z. move:(h2 z).  case hadj:(Adj y z)=>//=.
rewrite Pupdate_1=>//. rewrite hyv. done.
move/eqP:hyv=>hyv. subst y.
move/andP:h''=>[h1 h2]. rewrite h1. simpl. 
apply/forallP. move=>z. case hzv:(Adj v z)=>//=.
rewrite Pupdate_1=>//. rewrite eq_refl.
move/forallP:h2=>h2. have:=(h2 z). rewrite hzv. simpl. done. 

move/forallP:h'=>h'. have := (h' v).  rewrite in_cons eq_refl=>/=.
rewrite Vupdate_1 eq_refl. case h1:( x0.1 == initState.1 v)=>//=.
case h2:( [forall w,
        Adj v w ==>
        (nth false x0.2 (index w (nu v)) == (coverTree k) (VtoP v w p0))])=>//. 
move/forallP=>h''. move/forallP:h2=>h2. destruct h2.  intro z. 
have:=(h'' z).  case hadj:(Adj v z)=>//=. 
rewrite Pupdate_1=>//. rewrite eq_refl=>//=.
Qed. 


Lemma DHS_inactive : forall (l1 l2:seq V) (s:VSt*PSt) (f: MF (VSt*PSt) ), 
 (forall v, inactiveG v s -> (fun x => f (VPupdate nu false v (s.1 v, 
Poutread nu p0 s.2 v) 
x))  == f  ) ->
 count (activeG^~ s)  l2 = O ->
 mu (DHS (l1++l2) s) f ==
 mu (DHS l1 s) f.
Proof. 
intros. 
have := (perm_catC l1 l2).
move/perm_eqlP=>H1. unfold DHS,DPRound. 
rewrite (DRoundCommute3 _ _ _ _ H1);last first. 
 by apply disjoint_outerport. 
 by intro v; apply is_discrete_DHSLoc.
clear H1. elim:l2 H0=>// v l hind Hcount. simpl in Hcount. move:Hcount.  
case hv:(activeG v s)=>//= Hcount.
have hinac := (activeinactive hv).
unfold DHSLoc,Vread,activeL.
unfold activeG in hv. rewrite hv. simpl.
rewrite (mu_stable_eq _ _ _ (H _ hinac)).
apply hind=>//=. 
Qed.

Lemma VPupdate_id : forall a (s:VSt*PSt),
 (forall v : V, inactiveG v s ->
               Poutread nu p0 s.2 v  = nseq (seq.size (nu v)) false)->
 inactiveG a s ->
 (VPupdate nu false a (s.1 a, Poutread nu p0  s.2 a) s) = s.
Proof. 
intros. 
rewrite (surjective_pairing   (VPupdate nu false a (s.1 a, Poutread nu p0  s.2 a)
 s)).    
rewrite (surjective_pairing s). 
apply/eqP. rewrite xpair_eqE. apply/andP. split;apply/eqP;rewrite -ffunP;
intro x=>//=.
 rewrite Vupdate_1. case ha:(x==a)=>//.  by move/eqP:ha->.
rewrite -(VtoP1 x p0).
rewrite Pupdate_1;last first.
 by apply (PvalP x). 
case ha:(fstp x == a)=>//=.
rewrite (H _ H0).  rewrite nth_nseq.  rewrite index_mem. 
rewrite -Hnu. move/eqP:ha=>ha. subst a. rewrite (PvalP x). symmetry. 
have := (H _ H0). unfold Poutread. 
rewrite -(size_map (fun x0 =>  s.2 (VtoP (fstp x) x0 p0))). move/all_pred1P.
move/allP. intro H1. have H2:=(@H1 (s.2 (VtoP (fstp x) (sndp x) p0)) ).
apply/eqP. apply H2. apply (map_f (fun x0 => s.2 (VtoP (fstp x) x0 p0) )).
rewrite -Hnu. apply (PvalP x). 
Qed. 

Lemma DHS_inactive' : forall (l:seq V) (s:VSt*PSt),
(forall v : V, inactiveG v s ->
               Poutread nu p0  s.2 v = nseq (seq.size (nu v)) false)->
(forall u,  u \in l -> inactiveG u s) ->
 mu (DHS l s)  == mu (Munit s).
Proof.
simpl. 
intro l. elim:l=>//.
move=> a l hind s hu hu' f.
unfold DHS,DPRound ; rewrite DRoundcons2;
last by apply is_discrete_DHSLoc.  simpl. 
assert (forall u : V, u \in l -> inactiveG u s).
  intros.  apply hu'. rewrite in_cons H orbT. done. 
rewrite (mu_stable_eq _ _ _ (fun x => hind s hu H  (fun x0 =>   
      f  (update [set a] x0.1 (Vwrite x.1 a),
           update (WriteArea a) x0.2 (Pwrite nu false x.2 a))))).
unfold DHSLoc,activeL,Vread. 
case ha:(activeG a s).
 have h : (inactiveG a s). 
   apply hu'. by rewrite in_cons eq_refl.
   destruct h as [i hi]. unfold activeG in ha. move/eqP:ha=>ha. 
   by rewrite ha in hi. 
unfold activeG in ha. rewrite ha. simpl.
have h := VPupdate_id. 
unfold VPupdate,Vupdate , Pupdate in h. 
rewrite h=>//. 
apply activeinactive. 
done. 
Qed.

Lemma DHS_deg_connect_aux24 :  forall (e:E) s,  
activeG (fste e) s -> activeG (snde e) s ->
(forall u v, activeG u s -> activeG v s ->
  connect (fun x y => activeG x s && activeG y s && Adj x y ) u v) ->
forall v,
 activeG v s ->
 exists w, Adj v w /\ activeG w s. 
Proof. 
intros. 
case he1:(v == fste e). 
  exists (snde e).
    move/eqP:he1->. rewrite edge_fste_snde. rewrite H0. done.  
have := (H1 _ _ H2 H0).  move/connectP=>[p [hp1 hp2]]. 
case:p hp1 hp2=>/=.
  intros. exists (fste e). split=>//.  rewrite -hp2 gsym edge_fste_snde. done.
 intros. exists a. move:hp1. move/andP=>[h1 h2]. move/andP:h1=>[h1 h3].
move/andP:h1=>[h1 h4]. split;auto. 
Qed.    

Lemma numberActive_conn :    forall (e:E) ,  
activeG (fste e) initState -> activeG (snde e) initState ->
(forall u v, activeG u initState -> activeG v initState ->
  connect (fun x y => activeG x initState && activeG y initState && Adj x y ) 
u v) ->
forall v,
activeG v initState ->
(0 < (numberActive (Pinread nu p0 initState.2 v)))%nat.
Proof.
intros. have [w [hw1 hw2]] := (DHS_deg_connect_aux24 H H0 H1 H2).
have [n hn] := (activeG2 hw2 hw1).
by rewrite hn. 
Qed. 


Lemma choiceFunc1 : (forall u v : V,
          activeG u initState ->
          activeG v initState ->
          connect
            (fun x y : V =>
             activeG x initState && activeG y initState && Adj x y) u v) -> 
 forall v k, activeG (fste (eth k)) initState ->
 activeG v initState -> Adj v (choiceFunc k v).  
Proof.
intros. unfold choiceFunc,parentFunc. rewrite ffunE.
have :=(@tF3 _ AdjAct _ (fste (eth k)) #|V| v). unfold parentF.   
case h1:((tF AdjAct (fste (eth k)) #|V|) v == None);last first.
 move:h1. case:((tF AdjAct (fste (eth k)) #|V|) v)=>//=. 
 unfold AdjAct. intros.
 assert (activeG v initState && activeG a initState && Adj v a).
  apply x=>//. intros. 
case:(  activeG u initState);case:(activeG v0 initState)=>//=. 
rewrite gsym. done. move/andP:H2=>[H2 H3]. done. 
move=>_. move/eqP:h1=>h1. rewrite h1. 
have H2:=(tF2' _ H H0 H1 h1). rewrite H2=>//;last first.
 apply grefl. 
apply edge_fste_snde.
Qed. 


Lemma choiceFunc2 : 
 forall v k, 
 activeG (snde (eth k)) initState ->  activeG (choiceFunc k v) initState.
Proof.
intros. unfold choiceFunc,parentFunc. rewrite ffunE.
have :=(@tF3 _ AdjAct _ (fste (eth k)) #|V| v). unfold parentF.   
case h1:((tF AdjAct (fste (eth k)) #|V|) v == None);last first.
 move:h1. case:((tF AdjAct (fste (eth k)) #|V|) v)=>//=. 
 unfold AdjAct. intros.
 assert (activeG v initState && activeG a initState && Adj v a).
  apply x=>//. intros. 
case:(  activeG u initState);case:(activeG v0 initState)=>//=. 
rewrite gsym. done. move/andP:H0=>[H1 H2].  
move/andP:H1=>[H1 H1'];done. 
move=>_. move/eqP:h1=>h1. rewrite h1.
done. 
Qed.

Lemma sendChosen3 : forall l i, (i < numberActive l)%nat ->  
 nth false (sendChosen i.+1 l) (index_ithActive l i) = true.
Proof. 
intros.  rewrite nthActive1.
rewrite nth_index=>//. 
by apply sendChosen_memT.
Qed. 


Lemma sendChosen4 : forall l l' l'' x, 
(sendChosen x.+1 l) = (l''++true::l') -> true \notin l'.
Proof.
elim=>//=.  
 intros l l''. 
 case:l''=>//=. 
intros a l hind.
intros l' l'' x. case:x=>//=. 
case:a=>//=.  
 assert (all (fun x => x ==false) (sendChosen 0 l))=>//.
  clear. elim:l=>//=. move/allP:H=>H.
 intros. case hl': (true \in l')=>//.
  have hl'1: (true \in sendChosen 0 l). 
 case:l'' H0=>/=. intro. injection H0. intro. rewrite H1. done. 
 intros. injection H0. intros. rewrite H1.  rewrite mem_cat in_cons eq_refl. 
 rewrite orbT.  done. apply H in hl'1. done. 
 
intro. case:l'' H=>//=. intros. apply (hind _ l0 O)=>//. 
 injection H. done. 
intros n.  case:l''=>//. 
 case:a=>//=. 
intros a0 l0. case:a. intro.  apply (hind _ l0 n). 
 injection H. done. 
intro. apply (hind _ l0 n.+1). injection H. done.     
Qed. 

Lemma sendChosen2 : forall l x i,
 nth false (sendChosen x.+1 l) i -> 
 index_ithActive l x = i.
Proof. 
intros l x. have H0:=(@sendChosen4 l _ _ x). intros.   
rewrite nthActive1.
move: i H H0. set l' :=((sendChosen x.+1 l)).
move:l'. elim=>//=. 
 intro i;rewrite nth_nil. done. 
intros. case ha:(a)=>//=. 
 subst a. have H2 : (true \notin l0). apply (H1 _ nil). done. 
 case:i H0=>//=. 
 intros. assert (false)=>//. move:H0 H2. clear.
 elim:l0 n=>//. 
  intro;rewrite nth_nil. done. intros. rewrite in_cons in H2. 
  case:n H0=>//=. intro. move:H2. rewrite H0;done. 
  intros.  apply (H n)=>//.  case:(true \in l) H2.  rewrite orbT. done.  done.
 subst a. case:i H0=>//=. 
 intros. rewrite (H n)=>//=. 
intros. apply (H1 _ (false::l2)). rewrite cat_cons. rewrite -H2. done.
Qed. 


Lemma index_eq : forall (l:seq V) x y,  x \in l -> index x l = index y l ->
 x = y.
Proof. 
elim=>//=.
intros a  l hind x y. rewrite in_cons. rewrite eq_sym. 
case hax:(a==x). 
 move/eqP:hax=>hax. subst a.  case hxy:(x==y)=>//=. 
 move/eqP:hxy. done. 
case hay:(a ==y)=>//=. 
intros. apply hind=>//.  
auto. 
Qed.  

Lemma hs1_aux12: 
(forall u v, activeG u initState -> activeG v initState ->
  connect (fun x y => activeG x initState && activeG y initState && Adj x y ) 
u v) ->
 (0 < count (fun x => activeG x initState) (enum V))%nat ->
forall k, activeG (fste (eth k)) initState ->
 activeG (snde (eth k)) initState ->
0 <(mu (DHS (enum V) initState))
     (fun x => if  [forall v, (v \in (enum V)) ==> 
               ( ((x.1 v) == initState.1 v) && 
 [forall w, Adj v w ==> ((x.2 (VtoP v w p0)) == 
     ((coverTree k) (VtoP v w p0)))])]
  then 1 else 0).
Proof.
move=>Hconn H k he1 he2. move:H.  
unfold DHS. 
have :=(enum_uniq V). 
elim:(enum V)=>//. 
move=>v l hind. rewrite cons_uniq. move/andP=>[ Huniq1 Huniq2] Hcount.
simpl.
have hyp := (hs1_aux11 k _ _ Huniq1).
rewrite (mu_stable_eq _ _ _ (fun x => mu_stable_eq  (DHSLoc 
(Vread initState.1 v) (Poutread nu p0 initState.2 v)
(Pinread nu p0 initState.2 v))  _ _  (hyp x))). clear hyp.
setoid_rewrite mu_stable_mult_right. 
setoid_rewrite mu_stable_mult2.  
apply Umult_lt_zero;last first.

case Hcount' : (0 < count (activeG^~ initState)  l)%nat. 
 by apply hind=>//. 
have hinact : (forall u, u \in l -> inactiveG u initState).
 rewrite -has_count in Hcount'. move/hasP:Hcount'. intros. 
  case h:(activeG u initState);last by apply activeinactive in h.
  destruct Hcount'.  exists u=>//.   
  rewrite (DHS_inactive' initState2 hinact). simpl. 
 case h:( [forall v0,
        (v0 \in l) ==>
        (initState.1 v0 == initState.1 v0) &&
        [forall w,
           Adj v0 w ==>
           (initState.2 (VtoP v0 w p0) == (coverTree k) (VtoP v0 w p0))]])=>//=. 
   move/forallP:h=>h.  destruct h. intros. case hx:(x \in l)=>//=.
  apply hinact in hx. rewrite eq_refl/=. apply/forallP=>w. 
  case hxw:(Adj x w)=>//=.
 have  :=(initState2 hx). unfold Poutread.    
unfold coverTree. rewrite ffunE. rewrite VtoP2=>//.  
  unfold activeG. destruct hx as [i hi].  move/eqP:hi=>hi. rewrite hi.  simpl. 
 rewrite -(size_map (fun x0 => initState.2 (VtoP x x0 p0))).
 move/all_pred1P.   move/allP. intro H2.
 apply ( H2 (initState.2 (VtoP x w p0) ) ). 
 apply (map_f (fun x0 =>  initState.2 (VtoP x x0 p0))). rewrite -Hnu. done.

unfold DHSLoc,Vread,activeL. 
case hv1: (activeG v initState);last first.
 move:Hcount. simpl. rewrite hv1. simpl. move=>Hcount.
 have hv2 :=(activeinactive hv1).
 unfold activeG in hv1. rewrite hv1. simpl.
 rewrite eq_refl. simpl. case h: ([forall w,
        Adj v w ==>
        (nth false (Poutread nu p0 initState.2 v) (index w (nu v)) ==
         (coverTree k) (VtoP v w p0))])=>//. 
move/forallP:h=>h. destruct h.  intros w. apply/implyP. intro hvw. 
unfold coverTree. rewrite ffunE. rewrite VtoP2=>//.  rewrite VtoP3=>//.
 unfold activeG. rewrite hv1. simpl. rewrite (initState2 hv2). 
 rewrite nth_nseq. rewrite index_mem -Hnu hvw. done.
have :=(numberActive_conn he1 he2 Hconn hv1). 
move:hv1;unfold activeG;move/eqP=>hv1. 
rewrite hv1 eq_refl.
have [x h]: (exists x, if(numberActive (Pinread nu p0 initState.2 v) ==O)%B
 then True else 
 (x.+1 <= numberActive (Pinread nu p0 initState.2 v))%coq_nat /\ 
[forall w, Adj v w ==> 
 (nth false (sendChosen x.+1 (Pinread nu p0 initState.2 v))
     (index w (nu v)) == (coverTree k) (VtoP v w p0))]);last first.
move:h. 
case hnact:(numberActive (Pinread nu p0  initState.2 v) == O) =>//.
 move/eqP:hnact=>hnact. rewrite hnact. done. 
have [n hnact'] : (exists n, (numberActive 
 (Pinread nu p0 initState.2 v)) = n.+1). 
 move:hnact. case:( numberActive (Pinread nu p0  initState.2 v))=>//. 
intros.  exists n. done. 
move=>[hx1 hx2] _. rewrite hnact'. 
setoid_rewrite (Mlet_simpl  (Random n)).
setoid_rewrite (fun x0 => Munit_simpl _ 
  (None, sendChosen x0.+1 (Pinread nu p0 initState.2 v))).

rewrite (@mu_eq_compat  _ _ (Random n) _ _ (carac_eq x))=>//.
rewrite Random_eq;auto.
 rewrite hnact' in hx1. by apply le_S_n.  
 intro. unfold B2U,carac_eq,carac. simpl.
case ( eq_nat_dec x x0);intro h.
 subst x0. rewrite hx2. done.
case h':( [forall w,
          Adj v w ==>
          (nth false (sendChosen x0.+1 (Pinread nu p0  initState.2 v))
             (index w (nu v)) == (coverTree k) (VtoP v w p0))])=>//.
move/forallP:hx2=>hx2. move/forallP:h'=>h'.
pose w :=  (choiceFunc k) v. 
have :=(hx2 w).  have :=  (h' w).
have hw1:(Adj v w). apply choiceFunc1=>//. unfold activeG. rewrite hv1. 
 done.  
have hw2:(activeG w initState). apply choiceFunc2.  done.  
unfold coverTree. rewrite ffunE. rewrite VtoP2=>//. rewrite VtoP3=>//. 
rewrite hw2. rewrite hw1. unfold activeG. rewrite hv1 eq_refl. simpl. 
rewrite eq_refl. move/eqP. intro h1. move/eqP=>h2.
 apply sendChosen2 in h1;apply sendChosen2 in h2. rewrite -h1 in h2.
 move/leP:hx1=>hx1.  
 destruct (@nthActive2 (Pinread nu p0 initState.2 v) _ _ hx1 h ). done. 
 

have hneigh : (is_neigh_active v (choiceFunc k v) initState).
 apply activeG1. 
  apply choiceFunc2=>//. 
  apply choiceFunc1=>//.  unfold activeG;rewrite hv1. done. 
have [i [hi1 hi2]] := (is_neigh_active1 hneigh).
exists i.  move:hi1. 
case hnumb:( numberActive (Pinread nu p0 initState.2 v)== O)=>//.
 intros. simpl.
split;auto. apply/leP.  done. 
apply/forallP. intro. case hadk:(Adj v x)=>//=.
case h: ((nth false
      (sendChosen i.+1
         (Pinread nu p0 initState.2 v)) (index x (nu v)))).
 apply sendChosen2 in h. rewrite h in hi2.  apply index_eq in hi2. 
 unfold coverTree. rewrite ffunE.  rewrite VtoP2=>//. 
rewrite VtoP3=>//. rewrite hi2 eq_refl. subst x. 
  rewrite choiceFunc2=>//. unfold activeG. rewrite hv1. simpl. done. 
 rewrite -Hnu. apply choiceFunc1=>//.  unfold activeG. rewrite hv1. done. 

unfold coverTree. rewrite ffunE. rewrite VtoP2=>//. 
rewrite VtoP3=>//. 
case hx1:(activeG x initState);last first. 
 rewrite andbF. done. 
  unfold activeG. rewrite hv1. simpl. 
case hx2:( ((choiceFunc k) v == x))=>//.
move/eqP:hx2=>hx2.
 rewrite hx2 in hi2. rewrite hi2 in h. 
rewrite sendChosen3 in h. done. 
done. 
Qed.

Lemma forall_port : forall (s1 s2:VSt*PSt) ,
 (forall (v:V),
    s1.1 v = s2.1 v /\ 
   (forall w, Adj v w -> (s1.2 (VtoP v w p0) = s2.2 (VtoP v w p0)))) ->
  s1 = s2.
Proof. 
intros. destruct s1 as [s11 s12]. destruct s2 as [s21 s22].
apply/eqP. rewrite xpair_eqE. apply/andP. split;apply/eqP;rewrite -ffunP;
 intro x.
 by have [H1 H2] := (H x).
have [H1 H2] :=(H (fstp x)). 
have H3:=(H2 (sndp x) (PvalP x)). simpl in H3. rewrite VtoP1 in H3. done. 
Qed. 

Lemma hs1_aux1 : 
(forall u v, activeG u initState -> activeG v initState ->
  connect (fun x y => activeG x initState && activeG y initState && Adj x y ) 
u v) ->
 (0 < count (fun x => activeG x initState) (enum V))%nat ->
forall k, activeG (fste (eth k)) initState -> activeG (snde (eth k)) initState ->
0 <(mu (DHS (enum V) initState))
     (fun x => if  x == (initState.1,coverTree k) then 1 else 0).
Proof.
intros. have H3 :=  (hs1_aux12 H H0 H1 H2).  
apply (Olt_le_trans _ _ _  (hs1_aux12 H H0 H1 H2)).
apply mu_le_compat=>//.
intro. 
case h:(x ==  (initState.1, coverTree k) )=>//. 
case h':([forall v,
          (v \in enum V) ==>
          (x.1 v == initState.1 v) &&
          [forall w,
             Adj v w ==> (x.2 (VtoP v w p0) == (coverTree k) (VtoP v w p0))]])=>//. 
have h'' : ( x = (initState.1, coverTree k)). 
 apply forall_port. 
 intros. move/forallP:h'=>h'. 
 have h1:=(h' v). rewrite mem_enum in h1. simpl in h1. move/andP:h1=>
 [h1 h2].
 move/forallP:h2=>h2. move/eqP:h1=>h1. split=>//.
 move=>w.  intro.  have := (h2 w). rewrite H4.  move/eqP. done. 
by rewrite h'' eq_refl in h.
Qed.  


Lemma hs1_aux2' : 
 (forall u v, activeG u initState -> activeG v initState ->
  connect (fun x y => activeG x initState && activeG y initState && Adj x y ) 
u v) ->
forall i k,
 (k < i < #|E|)%nat ->  activeG (fste (eth k)) initState ->
 (carac_hs_glob (nth e0 (enum E) i)) initState (initState.1, coverTree k) == 0.
Proof.
intro Hc. 
intros. 
set ei := (nth e0 (enum E) i).
unfold carac_hs_glob,hs_glob,fB2U,B2U.
case he1:(activeG (fste ei) initState)=>//=. 
case he2:(activeG (snde ei) initState)=>//=.
unfold hs_edgeB,hs_eqVB=>/=. 
unfold coverTree,choiceFunc,Poutread.
case h:((index (snde ei) (nu (fste ei)) == index true
[seq [ffun x0 => if activeG (fstp x0) initState &&  activeG (sndp x0) initState
 then[ffun x1 => match (parentFunc k) x1 with
| Some y => y| None => snde (eth k) end] (fstp x0) == 
sndp x0 else false] (VtoP (fste ei) x p0)| x <- nu (fste ei)]))=>//=.
case h':(  index (fste ei) (nu (snde ei)) ==index true
[seq [ffun x0 => if activeG (fstp x0) initState &&activeG (sndp x0) initState
     then[ffun x1 => match (parentFunc k) x1 with
| Some y => y| None => snde (eth k)end] (fstp x0) == 
sndp x0 else false] (VtoP (snde ei) x p0)| x <- nu (snde ei)])=>//=.
move/eqP:h=>h;move/eqP:h'=>h'.
have hedge1:= (edge_fste_snde ei).
have hedge2:= (edge_fste_snde ei).
rewrite gsym Hnu in hedge2. rewrite Hnu in hedge1. 
apply index_map2 in h;apply index_map2 in h'=>//. 
rewrite -Hnu in hedge1;rewrite -Hnu in hedge2. 
move:h';rewrite ffunE ffunE(VtoP2 _ hedge2) (VtoP3 _ hedge2) he1 he2=>/=. 
case hi1: ((parentFunc k) (snde ei) == None).
 move/eqP:hi1=>hi1;rewrite hi1.
 move/eqP=>hi2.
 have hi3: (fste (eth k) == snde ei). 
  by rewrite eq_sym;apply/eqP;apply (@tF2' _ Adj grefl (fun x => activeG x 
initState) 
    Hc _ _ H0 he2 hi1).
  by move/eqP:(edge_nth_neq2 H  hi3)=>hyp.

intro h'.  
have hi2: ( (parentFunc k) (snde ei) = Some (fste ei)).
 move:h' hi1;case: ((parentFunc k ) (snde ei))=>//. 
 by intro a;move/eqP->.
clear hi1 h'.
move:h;rewrite ffunE ffunE (VtoP2 _ hedge1) (VtoP3 _ hedge1) he1 he2=>/=.
case hi3: ((parentFunc k) (fste ei) == None).
 move/eqP:hi3=>hi3;rewrite hi3.
 move/eqP=>hi1. 
 have hi4: (fste (eth k) == fste ei). 
  by rewrite eq_sym;apply/eqP;apply (@tF2' _ Adj grefl (fun x => activeG x 
initState) 
    Hc _ _ H0)=>//.
  by move/eqP:(edge_nth_neq1 H  hi4)=>hyp.  
move=>h'.
have hi1: ( (parentFunc k) (fste ei) = Some (snde ei)).
  move:h' hi3. 
  case: ((parentFunc k ) (fste ei))=>//. 
   by intro a;move/eqP->.
clear h' hi3. 
apply tF4 in hi1=>//.
 move=>u v;unfold AdjAct;rewrite gsym;case:(activeG u initState);
  case:(activeG v initState)=>//=. 
by move=>u;unfold AdjAct;rewrite grefl andbF.
Qed. 

Lemma hs1_aux2 :
 (forall u v, activeG u initState -> activeG v initState ->
  connect (fun x y => activeG x initState && activeG y initState && Adj x y ) 
u v) ->
forall k,
activeG (fste (eth k)) initState ->
 0 <
 \big[(fun x : U => [eta Umult x])/1]_(k.+1 <= i < #|E|)
    finv (carac_hs_glob (nth e0 (enum E) i) initState) (initState.1, coverTree k).
Proof.
move=>Hc k hk. rewrite big1_seqs=>//=.
 move=>a b c d h1 h2. rewrite h1 h2. done.
move=>i. 
unfold finv;rewrite mem_index_iota=>hi.
rewrite hs1_aux2'=>//.
Qed. 


Lemma hs1 : forall (e:E), activeG (fste e) initState -> 
activeG (snde e) initState ->
 (forall u v, activeG u initState -> activeG v initState ->
  connect (fun x y => activeG x initState && activeG y initState && Adj x y ) 
u v) ->
forall k, (k < #|E|)%coq_nat ->
activeG (fste (nth e0 (enum E) k)) initState ->
activeG (snde (nth e0 (enum E) k)) initState ->
~ (mu (DHS (enum V) initState)) (fun a : VSt*PSt =>
      \big[(fun x : U => [eta Umult x])/1]_(k.+1 <= i < #|E|)
         finv (carac_hs_glob (nth e0 (enum E) i) initState) a) == 0.
Proof.
move=>e he1 he2 hconn k hk hk1 hk2 h0.
generalize (@Olt_antirefl  U ordU 0)=>H. destruct H. 
apply (Olt_le_trans _ ((mu (DHS (enum V) initState))
         (fun a  =>
          \big[(fun x : U => [eta Umult x])/1]_(k.+1 <= i < #|E|)
             finv (carac_hs_glob (nth e0 (enum E) i)initState) a)));
 last by rewrite h0.

apply (proba_not_null (initState.1 ,coverTree k)  _ _ 
(fun x y => if (x == y)%B   then 1 else 0));auto.

 move=>a b;case h:(a ==b);first by move/eqP:h ->. 
 move=>h';by apply Olt_neq in h'.
apply (@hs1_aux1)=>//. 
rewrite -has_count. apply/hasP. exists (fste (nth e0 (enum E) k))=>//.
rewrite mem_enum. done. 
apply hs1_aux2=>//.
Qed.


(** **** hs2 
 *)

(* e1 and e2 are two edges with one extrmity in common *)
Lemma hs_loc_neigh : forall e1 e2 s x, 
 hs_glob e1 s x -> 
 ((fste e1 == fste e2) && (snde e1 != snde e2)) || 
 ((fste e1 == snde e2) && (snde e1 != fste e2)) ||
 ((snde e1 == fste e2) && (fste e1 != snde e2)) ||
 ((snde e1 == snde e2) && (fste e1 != fste e2)) -> 
 (hs_glob e2 s x) = false.
Proof.
move=>e1 e2 s x;unfold hs_glob,hs_edgeB.
set u1 := (fste e1);set v1 := (snde e1).
set u2 := (fste e2);set v2 := (snde e2).
move/andP=>[h1 h3];move/andP:h1=>[h1 h2];move/andP:h3=>[h3 h4]. 
case h1':( activeG u2 s)=>//=. 
case h2':( activeG v2 s)=>//=. 
case h3':( hs_eqVB u2 v2 x)=>//=.
case h4':(  hs_eqVB v2 u2 x)=>//=.
have hv1: (v1 \in (nu u1)) by rewrite -Hnu edge_fste_snde. 
have hu1: (u1 \in (nu v1)) by rewrite -Hnu gsym edge_fste_snde. 
have hv2: (v2 \in (nu u2)) by rewrite -Hnu edge_fste_snde. 
have hu2: (u2 \in (nu v2)) by rewrite -Hnu gsym edge_fste_snde. 
case hb1 : ((u1 == u2) && (v1 != v2))=>/=.
 move/andP:hb1 h3 h3' hv1=>[hb1 hb1'];move/eqP:hb1->.
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hv1.
 have:=(index_neq_in _ (nu u2) _ _ hv1 hb1').
 by rewrite h.
case hb2: ((u1 == v2) && (v1 != u2))=>/=.
 move/andP:hb2 h3 h4' hv1=>[hb2 hb2'];move/eqP:hb2->.
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hv1.
 have:=(index_neq_in _ (nu v2) _ _ hv1 hb2').
 by rewrite h.
case hb3:((v1 == u2) && (u1 != v2))=>/=.
 move/andP:hb3 h4 h3' hu1=>[hb3 hb3'];move/eqP:hb3->.
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hu1.
 have:=(index_neq_in _ (nu u2) _ _ hu1 hb3').
 by rewrite h.
case hb4:((v1 == v2) && (u1 != u2))=>//=.
 move/andP:hb4 h4 h4' hu1=>[hb4 hb4'];move/eqP:hb4->.
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hu1.
 have:=(index_neq_in _ (nu v2) _ _ hu1 hb4').
 by rewrite h.
Qed. 

Lemma hs2 : forall k, (k < #|E|)%coq_nat ->
 forall x0 : VSt*PSt,
 carac_hs_glob (nth e0 (enum E) k) initState x0 *
 \big[(fun x1 : U => [eta Umult x1])/1]_(k.+1 <= i < #|E| | 
 (fste (nth e0 (enum E) k) == fste (nth e0 (enum E) i)) ||
 (fste (nth e0 (enum E) k) == snde (nth e0 (enum E) i)) ||
 (snde (nth e0 (enum E) k) == fste (nth e0 (enum E) i)) ||
 (snde (nth e0 (enum E) k) == snde (nth e0 (enum E) i))) 
 finv (carac_hs_glob (nth e0 (enum E) i) initState) x0 ==
 carac_hs_glob (nth e0 (enum E) k) initState x0.
Proof.
move=>k hk x;unfold carac_hs_glob,fB2U,B2U. 
case hsloc: (hs_glob (nth e0 (enum E) k) initState x)=>//;Usimpl. 
rewrite big1_nats=>//i;auto. 
move/andP=>[h2 h1].
unfold finv;rewrite (hs_loc_neigh hsloc)=>//.
move:h2;move/orP=>[h2|h3];last first.
 rewrite h3=>/=;rewrite (edge_nth_neq4 h1 h3) Bool.orb_true_r=>//.
move:h2;move/orP=>[h2|h3];last first.
 rewrite h3=>/=;rewrite (edge_nth_neq3 h1 h3) Bool.orb_true_r=>//.
move:h2;move/orP=>[h2|h3];last first.
 rewrite h3=>/=;rewrite (edge_nth_neq2 h1 h3) Bool.orb_true_r=>//.
rewrite h2=>/=;rewrite (edge_nth_neq1 h1 h2)=>//.
Qed.

(** **** hs3 
  *)

Lemma carac_hs_loc_iff : forall(e:E)(v:V)(sn:VSt*PSt)(x:VLab*seq PLab),
 carac_hs_glob e initState (VPupdate nu false v x sn) =
 match (fste e == v), (snde e == v) with
  |true, true => B2U false
  |true, false=> B2U ((activeG v initState && (activeG (snde e) initState) &&
           ((index (snde e) (nu v) == index true
             (take (seq.size (nu v)) (x.2 ++ nseq (seq.size (nu v)) false)))
         && (index v (nu (snde e)) == index true (Poutread nu p0 sn.2 (snde e) )))))
  |false, true=> B2U ((activeG (fste e) initState && (activeG v initState) &&
           ((index v (nu (fste e)) == index true (Poutread nu p0 sn.2 (fste e)))
         && (index (fste e) (nu v) == index true
             (take (seq.size (nu v)) (x.2 ++ nseq (seq.size (nu v)) false))))))
  |false, false => carac_hs_glob e initState sn
 end.
Proof.
move=>e v sn x;unfold carac_hs_glob,hs_glob,hs_edgeB,hs_eqVB,fB2U,
B2U.
case h1:(fste  e == v)=>/=;case h2:(snde e == v);move/eqP:h1=>h1;move/eqP:
h2=>h2;
have:=(edge_fste_snde e).
 by rewrite h1 h2 grefl.
 rewrite h1 VPupdate_read_4=>//. 
 by rewrite VPupdate_read_2=>//;apply/eqP;intro;destruct h2.
 rewrite h2 VPupdate_read_4=>//.
 by rewrite VPupdate_read_2=>//;apply/eqP;intro;destruct h1.
repeat rewrite VPupdate_read_2=>//.
by apply/eqP;intro;destruct h2.
by apply/eqP;intro;destruct h1.
Qed.

Lemma hs3_aux : forall (ek: E) (r:seq E),
 (fste ek \in (enum V)) -> (snde ek \in (enum V)) -> 
 indep (DHS (enum V) initState) (carac_hs_glob ek initState)
   (fun x0 : VSt * PSt =>
    \big[(fun x1 : U => [eta Umult x1])/1]_(e <- r)
       (if ~~
           ((fste ek == fste e) ||
            (fste ek == snde e) ||
            (snde ek == fste e) ||
            (snde ek == snde e))
        then finv (carac_hs_glob e initState) x0
        else 1)).
Proof. 
move=>ek r hek1 hek2;unfold indep,fconj.
unfold DHS. unfold DPRound. 
rewrite (@DRoundCommute2 _ _ _ _ _ _ _ _ _ _ _ _ (snde ek))=>//;last first.
 by apply disjoint_outerport.
 intros v; apply is_discrete_DHSLoc.
rewrite (@DRoundCommute2 _ _ _ _ _ _ _ _ _ _ _ _ (fste ek));last first.
 rewrite in_cons;case h:((fste ek \in seq.rem (snde ek) (enum V)));
  first by rewrite orbT.
 by rewrite orbF; apply /eqP;apply (rem_mem_not hek1);rewrite h.
 by apply disjoint_outerport.
 intro v;apply is_discrete_DHSLoc.
replace 
 (fste ek :: seq.rem (fste ek) (snde ek :: seq.rem (snde ek) (enum V))) with
 (fste ek :: (snde ek) :: seq.rem (fste ek) (seq.rem (snde ek) (enum V)));last first.
 simpl;rewrite eq_sym;case h:(fste ek == snde ek)=>//.
 by move/eqP:h (edge_fste_snde ek)->;rewrite grefl.
simpl. unfold finv. 

setoid_rewrite (fun x x0 x1 => carac_hs_loc_iff ek (fste ek) 
 (VPupdate nu false (snde ek) x0 x) x1). 
setoid_rewrite (fun x x0 => carac_hs_loc_iff ek (snde ek) x x0). 
repeat rewrite eq_refl.  
case hek: (snde ek == fste ek);first by move/eqP:hek (edge_fste_snde ek) ->;
 rewrite grefl.  
assert (forall x x0 x1, \big[(fun x2 : U => [eta Umult x2])/1]_(e <- r)
               (if ~~
                   ((fste ek == fste e) || (fste ek == snde e)
                    || (snde ek == fste e) || (snde ek == snde e))
                then
                 [1-] carac_hs_glob e initState
                  (update [set fste ek]
                      (update [set snde ek] x.1 (Vwrite x0.1 (snde ek)))
                      (Vwrite x1.1 (fste ek)),
                   update (WriteArea (fste ek))
                     (update (WriteArea (snde ek)) x.2
                        (Pwrite nu false x0.2 (snde ek)))
                     (Pwrite nu false x1.2 (fste ek)))
                else 1) ==
               \big[(fun x2 : U => [eta Umult x2])/1]_(e <- r)
               (if ~~
                   ((fste ek == fste e) || (fste ek == snde e)
                    || (snde ek == fste e) || (snde ek == snde e))
                then
                 [1-] (carac_hs_glob e initState) x
                else 1)) as h. 
 intros;rewrite (@eq_bigrs  _ _ _ _ _ _ (fun _ => true) _ 
 (fun e =>  (if ~~
          ((fste ek == fste e) || (fste ek == snde e) || (snde ek == fste e)
           || (snde ek == snde e))
       then [1-] carac_hs_glob e initState x
       else 1)));auto.
 intros;rewrite (carac_hs_loc_iff _ _ ((update [set snde ek] x.1 [ffun=> x0.1]), 
  (update (outerport_set (snde ek)) x.2 [ffun x2 => nth false x0.2 (index 
(sndp x2) (nu (snde ek)))]))).
rewrite (carac_hs_loc_iff _ _ x).
 case h1:(fste ek == fste i)=>//.
 rewrite eq_sym in h1;rewrite h1. 
 case h2:(fste ek == snde i)=>//.
 rewrite eq_sym in h2;rewrite h2.
 case h3:(snde ek == fste i)=>//. 
 rewrite eq_sym in h3;rewrite h3. 
 case h4:(snde ek == snde i)=>//.
 rewrite eq_sym in h4;rewrite h4;auto.
setoid_rewrite h. 
do 2 setoid_rewrite mu_stable_mult_right.
do 2 setoid_rewrite mu_cte.
setoid_rewrite DHSLoc_total. 
do 2 setoid_rewrite Umult_one_right.
setoid_rewrite (fun x x0=> @VPupdate_read_4 _ _ _ Hnu Hnu2 _ _ x0 x). 
setoid_rewrite mu_stable_mult2.
rewrite mu_cte  DHS_total(Umult_sym _ 1) Umult_one_left.
by apply Umult_eq_compat.
Qed.

Lemma hs3 : forall k, (k < #|E|)%coq_nat ->
 indep (DHS (enum V) initState) (carac_hs_glob (nth e0 (enum E) k) initState)
   (fun x0 : VSt*PSt =>
    \big[(fun x1 : U => [eta Umult x1])/1]_(k.+1 <= i < #|E|)
       (if ~~
           ((fste (nth e0 (enum E) k)
             == fste (nth e0 (enum E) i)) ||
            (fste (nth e0 (enum E) k)
             == snde (nth e0 (enum E) i)) ||
            (snde (nth e0 (enum E) k)
             == fste (nth e0 (enum E) i)) ||
            (snde (nth e0 (enum E) k)
             == snde (nth e0 (enum E) i)))
        then finv (carac_hs_glob (nth e0 (enum E) i) initState) x0
        else 1)).
Proof.
move=>k H.
have h1 := (@hs3_aux (nth e0 (enum E) k) (drop k.+1 (enum E)))
 (edge_in_V1
 (nth e0 (enum E) k)) 
  (edge_in_V2 (nth e0 (enum E)k)).
have h2 : (forall x0, eq
           (\big[(fun x1 : U => [eta Umult x1])/1]_(k.+1 <= i < #|E|)
         (if ~~
             ((fste (nth e0 (enum E) k) == fste (nth e0 (enum E) i))
              || (fste (nth e0 (enum E) k) == snde (nth e0 (enum E) i))
              || (snde (nth e0 (enum E) k) == fste (nth e0 (enum E) i))
              || (snde (nth e0 (enum E) k) == snde (nth e0 (enum E) i)))
          then finv (carac_hs_glob (nth e0 (enum E) i) initState) x0
          else 1))
         (\big[(fun x1 : U => [eta Umult x1])/1]_(e <- 
          drop k.+1 (enum E))
             (if ~~
                 ((fste (nth e0 (enum E) k) == fste e)
                  || (fste (nth e0 (enum E) k) == snde e)
                  || (snde (nth e0 (enum E) k) == fste e)
                  || (snde (nth e0 (enum E) k) == snde e))
              then finv (carac_hs_glob e initState) x0
              else 1))).
 move=>x0;rewrite (big_nth e0) (big_addn O) size_drop.
 apply congr_big_nat=>//;first by rewrite cardE.
 move=>i/andP;move=>[_ ];move/andP=>[hi1 hi2].
 rewrite nth_drop;replace (k.+1 + i)%nat with (i + k.+1)%nat;first by trivial. 
 rewrite addSn addnS;apply eq_S;elim k=>//. 
 move=>n hn;rewrite addSn addnS;by apply eq_S.
unfold indep,fconj;setoid_rewrite h2.
done. 
Qed.

(** **** DHS_deg 
  *)
Lemma DHS_deg_aux :
 (forall u v, activeG u initState -> activeG v initState ->
 connect (fun x y => activeG x initState && activeG y initState && Adj x y )
   u v) 
-> 
 (0 < count (fun x : V => activeG x initState && (0 < nactv x)%nat) 
(enum V))%nat ->
(mu (DHS (enum V) initState)) (prodConj edge_finType
  (fun e : edge_finType => finv (fB2U
    (fun s : VSt * PSt => hs_glob e initState s))))
 <=
 hscte.
Proof.
move=>h'' h'.
rewrite (@Mcond_prodConj _ _ e0 _ _ (DHS_total (enum V) initState) ).
rewrite (prod_le_compat _ (fun i => [1-] (mu (Mcond (DHS (enum V)initState)
  (prodConjBound E e0 (fun e => finv (carac_hs_glob e initState)) i)))  
  (carac_hs_glob (nth e0 (enum E) i) initState)));last first.
 move=>k hk. 
 apply (Ueq_orc ((mu (DHS (enum V) initState)) (prodConjBound E e0
        (fun e : E => finv (carac_hs_glob e initState)) k))  0);auto.
apply (Ole_trans _ (prod (fun i => [1-] (mu (DHS (enum V) initState)
       (carac_hs_glob (nth e0 (enum E) i) initState))) #|E|));last first.

 apply (transitivity (prod_sigma_averagefin _ e0 
  (fun x => (mu (DHS (enum V) initState)) (carac_hs_glob x initState)))). 
 apply prod_le_compat;move=>k hk;Usimpl. 
 apply U2Rp_le_simpl;rewrite -Rpsigma_U2Rp;auto.
 rewrite (Rpsigma_eq_compat _ (fun x=>  (U2Rp([1/]1+#|E|.-1) * 
 U2Rp((mu (DHS(enum V) initState))(carac_hs_glob(nth e0(enum E) x) 
initState))))%Rp);
 last by move=>k' hk';apply U2Rp_mult. 
 rewrite Rpsigma_mult U2Rp_mult Rpmult_sym.
 apply Rpmult_le_compat=>//.
 apply (Rpsigma_hs e0)=>//. 

apply prod_le_compat;move=>k hk;auto.
Usimpl;unfold prodConjBound.

case hk1:(activeG (fste (nth e0 (enum E) k)) initState);
 last by unfold carac_hs_glob,hs_glob,fB2U;rewrite hk1 mu_fzero_eq.
case hk2:(activeG (snde (nth e0 (enum E) k)) initState); 
 last by unfold carac_hs_glob,hs_glob,fB2U;rewrite hk1 hk2 mu_fzero_eq.
have h := (Mcond_prodConjBound _ _ _ _ _ _ (fun (e :E) n => 
 (fste e == fste (nth e0 (enum E) n)) ||
 (fste e == snde (nth e0 (enum E) n)) ||
 (snde e == fste (nth e0 (enum E) n)) ||
 (snde e == snde (nth e0 (enum E) n)))
 (DHS_total (enum V)initState)).
unfold prodConjBound in h;apply (@h _ (fun x => (carac_hs_glob x 
 initState))).
apply (hs1 hk1 hk2 h'' hk)=>//.
apply (hs2 hk).
apply (hs3 hk).
Qed.


Lemma DHS_deg :
(forall u v, activeG u initState -> activeG v initState ->
 connect (fun x y => activeG x initState && activeG y initState && Adj x y )
  u v) ->
 (0 < count (fun x : V => activeG x initState && (0 < nactv x)%nat)
 (enum V))%nat ->
 [1-] hscte
 <= (mu (DHS (enum V) initState)) (carac_hs_glob_ex initState).
Proof.
move=>h' h.
unfold carac_hs_glob_ex,fB2U,hs_glob_ex.  
assert ((fun x => B2U (hs_glob_ex initState x)) ==
 fun x => finv NB2U (hs_glob_ex initState x)).
 intro x;apply NB2Uinv. 
rewrite H mu_one_inv;last apply DHS_total.
rewrite forall_exists_fB2U;repeat Usimpl;rewrite forall_prodConj_fB2U. 
by apply DHS_deg_aux.
Qed.

(** **** For a connected subgraph
  *)

Definition subinit1 (e:E)  : VSt  :=
 finfun (fun v => if (connect (fun x y => activeG x initState && activeG y
 initState && Adj x y ) (fste e) v) then initState.1 v else Some O).  

Definition subinit2 (e:E)  : PSt  :=
 finfun (fun p => if (connect (fun x y => activeG x initState && activeG y
 initState && Adj x y ) (fste e) (fstp p)) then initState.2 p else false).  
 
Lemma connectProp : forall f (x y:V), 
 (forall w, f w y = false) ->
 x <> y -> connect f x y -> false.
Proof.
move=>f x y hw hwy. move/connectP=>[p hp1 hp2].
move:hp1 hp2. 
apply(@last_ind _ (fun p => path.path f x p -> y = last x p -> false))=>//=.
 intros. destruct hwy. done.
intros. rewrite path.rcons_path in H0. move/andP:H0=>[H2 H3].
move:H3. rewrite last_rcons in H1. rewrite -H1. by rewrite hw.
Qed.

Lemma DHS_deg_exconn : forall (e':E), activeG (fste e') initState -> 
activeG (snde e') initState ->
exists (e:E) (s:VSt*PSt), 
activeG (fste e) s /\
 activeG (snde e) s /\
 (forall v : V,  inactiveG v s ->  
    Poutread nu p0 s.2 v = nseq (seq.size (nu v)) false) /\ 
 (forall u v, activeG u s -> activeG v s -> 
       connect (fun x y => activeG x s && activeG y s && Adj x y ) u v) /\
 (forall v:V, activeG v s -> s.1 v = initState.1 v) /\
 (forall v x:V, activeG v s -> Adj v x -> 
       s.2 (VtoP v x p0) = initState.2 (VtoP v x p0))/\ 
 (forall v x:V, inactiveG v initState -> Adj v x -> 
     s.2 (VtoP v x p0) = initState.2 (VtoP v x p0))/\ 
 (forall v w, Adj v w -> activeG v s -> activeG w initState -> activeG w s). 
Proof.
move=>e he1 he2.
exists e;exists  (subinit1 e,subinit2 e). simpl. 
have h1 : ( forall v : V,activeG v (subinit1 e, subinit2 e) ->
    (subinit1 e, subinit2 e).1 v = initState.1 v). 
 unfold activeG,subinit1. simpl. intro v. repeat rewrite ffunE. 
 case h:( connect
          (fun x y : V =>
           activeG x initState && activeG y initState && Adj x y) 
          (fste e) v)=>//=. 
have h2:(forall v x : V,
    activeG v (subinit1 e, subinit2 e) ->
    Adj v x ->
    (subinit2 e) (VtoP v x p0) = initState.2 (VtoP v x p0)).
 unfold activeG,subinit1,subinit2;simpl. intros v x. 
 repeat  rewrite ffunE. intros. rewrite VtoP2=>//. 
 move:H. case h:( connect (fun x0 y : V =>
 activeG x0 initState && activeG y initState && Adj x0 y)  (fste e) v)=>//=. 
have h3:(forall v x : V, inactiveG v initState -> Adj v x ->
    (subinit2 e) (VtoP v x p0) = initState.2 (VtoP v x p0)) .
 unfold subinit2. intros v x H1 H2. rewrite ffunE.
 rewrite VtoP2=>//. case H3:(   connect (fun x0 y : V =>
  activeG x0 initState && activeG y initState && Adj x0 y) (fste e) v)=>//=.
 apply initState2 in H1. move:H1. unfold Poutread. 
 rewrite -(size_map (fun x => initState.2 (VtoP v x p0))).
 move/all_pred1P. move/allP. intro H. have := (H (initState.2 (VtoP v x p0))).
 unfold pred1. simpl.  intro. symmetry. apply/eqP. apply x0=>//. 
 rewrite (map_f (fun x => initState.2 (VtoP v x p0)))=>//. 
 by rewrite -Hnu. 
have h4:(forall v w : V, Adj v w -> activeG v (subinit1 e, subinit2 e) ->
    activeG w initState -> activeG w (subinit1 e, subinit2 e)).
 move=>v w hvw. unfold activeG. simpl. unfold subinit1. 
 repeat rewrite ffunE. case h:( connect (fun x y : V =>
activeG x initState && activeG y initState && Adj x y) (fste e) v)=>//=. 
move/eqP=>H1. move/eqP=>H2. rewrite H2. 
case H3:( connect (fun x y : V =>
 activeG x initState && activeG y initState && Adj x y) (fste e) w)=>//.
move/connectP:h=>[p H4 H5]. move/connectP:H3. intro. destruct H3. 
exists (p++(w::nil));last by rewrite last_cat. 
rewrite path.cat_path=>//=.  apply/andP. rewrite H4. rewrite -H5.
 unfold activeG.  rewrite H1 H2 hvw. done.
have h5 :(forall v : V, inactiveG v (subinit1 e, subinit2 e) ->
 Poutread nu p0 (subinit2 e) v = nseq (seq.size (nu v)) false).
 intros. case h:(activeG v initState);last first. 
   apply activeinactive in h. rewrite -initState2=>//. 
   unfold Poutread. apply eq_in_map. intros i Hi.
   rewrite -Hnu in Hi.  by apply h3=>//.
  unfold Poutread.    rewrite -(size_map (fun x => (subinit2 e) (VtoP v x p0))).
 apply/all_pred1P. apply/allP. intro x. 
 unfold pred1. simpl. move/mapP. move=>[z hz1 hz2].
 rewrite -Hnu in hz1. subst x.
 unfold subinit2. rewrite ffunE. rewrite VtoP2=>//=.
 move:H. unfold inactiveG. move=>[i hi]. 
 move:hi. simpl.  unfold subinit1. rewrite ffunE. 
 case H:( connect (fun x y : V =>
  activeG x initState && activeG y initState && Adj x y)  (fste e) v)=>//.
 move/eqP=>H1. move:h. unfold activeG.  rewrite H1. done. 
have h6:(forall u v : V, activeG u (subinit1 e, subinit2 e) ->
activeG v (subinit1 e, subinit2 e) ->  connect (fun x y : V =>
 activeG x (subinit1 e, subinit2 e) &&
 activeG y (subinit1 e, subinit2 e) && Adj x y) u v).
intros. move:H H0. unfold activeG. simpl. 
move/eqP=>H. move/eqP=>H1.
case H0:(connect   (fun x y : V =>
 ((subinit1 e) x == None) && ((subinit1 e) y == None) && Adj x y) u v)=>//.
move:H H1. unfold subinit1. repeat rewrite ffunE.
case H1:( connect
         (fun x y : V =>
          activeG x initState && activeG y initState && Adj x y) 
         (fste e) u)=>//=. 
move=>H2. case H3:(connect
         (fun x y : V =>
          activeG x initState && activeG y initState && Adj x y) 
         (fste e) v)=>//=. move=>H4. 

have H5: (forall u, (connect (fun x y : V =>
 activeG x initState && activeG y initState && Adj x y)(fste e) u -> 
 connect (fun x y : V => 
 ((subinit1 e) x == None) && ((subinit1 e) y == None) && Adj x y) (fste e) u)).
clear. intro. move/connectP=>[p H1 H2]. apply/connectP. exists p=>//. 
move:H1 H2. move:e.  elim:p u=>//=.
intros. 
 move/andP:H1=>[H1 H3]. 
move/andP:H1=>[H1 H4]. move/andP:H1=>[H1 H5].
case H6:(path.path   (fun x y : V =>
      ((subinit1 e) x == None) && ((subinit1 e) y == None) && Adj x y) a l).
unfold subinit1. repeat rewrite ffunE. rewrite H4. rewrite connect0.
unfold activeG in H1,H5. rewrite H1.  rewrite connect1. by rewrite H5.
unfold activeG. rewrite H1 H5 H4.  done.
rewrite andbF. rewrite -H6.  
move:H3. have:(connect (fun x y : V => activeG x initState 
 && activeG y initState && Adj x y) (fste e) a). rewrite connect1=>//.
 rewrite H1 H5 H4. done. clear. elim:l a e=>//=. 
intros. move/andP:H3=>[H3 H4]. 
have H5: (connect (fun x0 y : V => activeG x0 initState &&
  activeG y initState && Adj x0 y)    (fste e) a).
 apply (@connect_trans _ _ a0)=>//. rewrite connect1=>//. 
unfold subinit1. repeat rewrite ffunE. rewrite x. 
 rewrite (H a e) =>//=;last first. 
 rewrite H5. unfold activeG in H3. rewrite H3. done.
apply H5 in H3. apply H5 in H1. 
rewrite -H0. apply (@connect_trans _ _ (fste e))=>//=.
move/connectP:H1=>[p hp1 hp2]. rewrite -path.rev_path in hp1.
apply/connectP. rewrite -hp2 in hp1. exists (rev (belast (fste e) p))=>//. 
move:hp1. apply path.sub_path. 
intros a b. rewrite gsym. 
case:((subinit1 e) b);case:((subinit1 e) a)=>//=. 
move:hp2. clear. elim:p=>//=. 
intros. rewrite rev_cons. rewrite last_rcons.  done. 
split. 
 unfold activeG,subinit1. rewrite ffunE.  rewrite connect0. done. 
split=>//.
unfold activeG,subinit1. rewrite ffunE.  rewrite connect1=>//. 
rewrite he1 he2 edge_fste_snde. done.
Qed. 


Section sdeg_conn.

Variables (s:VSt*PSt) (e:E).
Hypothesis s4 : forall v : V,  inactiveG v s ->  Poutread nu p0 s.2 v = nseq
 (seq.size (nu v)) false. 
Hypothesis s5 : activeG (fste e) s.
Hypothesis s6 : activeG (snde e) s.
Hypothesis s7 : forall u v, activeG u s -> activeG v s -> connect
 (fun x y => activeG x s && activeG y s && Adj x y ) u v. 
Hypothesis s8 : forall v:V, activeG v s -> s.1 v = initState.1 v. 
Hypothesis s9 : forall v x:V, activeG v s -> Adj v x -> s.2 (VtoP v x p0) = 
initState.2 (VtoP v x p0). 
Hypothesis s11 : forall v x:V, inactiveG v initState -> Adj v x -> s.2 
(VtoP v x p0) = initState.2 (VtoP v x p0). 
Hypothesis s12 : forall v w, Adj v w -> activeG v s -> activeG w initState -> 
activeG w s. 


Lemma activeNone : forall s v, activeG v s -> s.1 v = None.
Proof. 
by move=>s' v;unfold activeG;move/eqP.
Qed.   

Lemma s1 :forall x, activeG x s -> activeG x initState. 
Proof. 
by move=>x h;unfold activeG;rewrite -(s8 h) (activeNone h).
Qed.  

Lemma s3 : forall v : V,  activeG v s -> Poutread nu p0 s.2 v = 
nseq (seq.size (nu v)) true.
Proof. 
move=>v hv. rewrite -initState1;last by apply s1.
unfold Poutread.
have : (forall w, w \in nu v -> Adj v w) by  move=>w hw;rewrite (Hnu v w).
elim:(nu v)=>//=w l hind h1.
rewrite hind;last first.
 move=>z hz.  apply h1. rewrite in_cons. rewrite hz orbT. done. 
rewrite s9=>//. 
apply h1. rewrite in_cons eq_refl. done.   
Qed.  

Lemma DHS_deg_connect_aux1 : 
 (mu (DHS(enum V) initState)) 
  (fun x : VSt * PSt => B2U (hs_glob_ex s x)) <=
 (mu (DHS (enum V) initState))
    (fun x : VSt * PSt => B2U (hs_glob_ex initState x)).
Proof.
intros. 
unfold carac_hs_glob_ex,fB2U,hs_glob_ex.  
assert (forall s', (fun x => B2U (hs_glob_ex s' x)) ==
 fun x => finv NB2U (hs_glob_ex s' x)).
 intros s' x;apply NB2Uinv. 
rewrite (H initState) (H s) mu_one_inv mu_one_inv;try apply DHS_total;
 last first. 
 by rewrite mu_zero. 
rewrite forall_exists_fB2U;repeat Usimpl;rewrite forall_prodConj_fB2U. 
rewrite forall_exists_fB2U;repeat Usimpl;rewrite forall_prodConj_fB2U.
 unfold prodConj.
assert (forall a, \big[(fun x : U => [eta Umult x])/1]_y
 (finv (fB2U [eta hs_glob y 
initState]) a) ==
\big[(fun x : U => [eta Umult x])/1]_ y (finv (fB2U [eta hs_glob y s]) a) *
  \big[(fun x : U => [eta Umult x])/1]_(y|~~(activeG (fste y) s && 
activeG (snde y) s)) 
 (finv (fB2U [eta hs_glob y initState]) a)).
 intro. rewrite (@bigIDs _ _ 1 (fun x=>[eta Umult x]) _ (index_enum E) 
 (fun x => activeG (fste x) s && activeG (snde x) s) (fun _ => true))=>//=;
last by intros;rewrite H0 H1.
apply Umult_eq_compat=>//.
rewrite big_mkconds=>//;last by intros;rewrite H0 H1. 
apply eq_bigs=>//.
 intros. rewrite H0 H1. done. 
intros. unfold fB2U, hs_glob,finv.
 case h1: (activeG (fste i) s);case h2:(activeG (snde i) s)=>//=.
by unfold activeG;rewrite -(s8 h1) -(s8 h2) (activeNone h1) (activeNone h2) 
eq_refl/=.
setoid_rewrite H0. apply   mu_cond_le. 
Qed. 

Lemma DHS_deg_connect_aux22 :  forall v, activeG v s ->
 (forall x,  x \in nu v -> (activeG x s <-> activeG x initState)). 
Proof. 
intros. split;intro. 
 by unfold activeG;rewrite -(s8 H1)  (activeNone H1).
rewrite -Hnu in H0. apply (s12 H0 H H1).
Qed. 

Lemma DHS_deg_connect_aux23 :  forall v, activeG v s ->
Pinread nu p0 initState.2 v = Pinread nu p0  s.2 v.
Proof. 
intros v hv. unfold Pinread.
have := (DHS_deg_connect_aux22 hv).
have: (forall w, w \in (nu v) -> Adj v w).
 intro. rewrite Hnu. done. 
elim:(nu v)=>//=. 
intros. rewrite H;last first. 
  intros. apply x0. rewrite in_cons. rewrite H0 orbT.  done.
  intros.  apply x. rewrite in_cons H0 orbT. done.  
have :( s.2 (VtoP a v p0) =  initState.2 (VtoP a v p0) );last first. 
 by move->. 
have adj1:(Adj a v).  rewrite gsym. apply x. rewrite in_cons eq_refl=>//.  
case h1:(activeG a initState);last first. 
  apply activeinactive in h1. by rewrite (s11 h1 adj1).
rewrite s9=>//. rewrite x0=>//. rewrite in_cons eq_refl. done. 
Qed.

Lemma DHS_deg_connect_aux25 :  forall v, activeG v s ->
 (0 <numberActive  (Pinread nu p0 initState.2 v))%nat.
Proof. 
intros.
have [w [hw1 hw2]] := ( DHS_deg_connect_aux24  s5 s6 s7 H).
have hw3:(activeG w initState) by unfold activeG;rewrite -(s8 hw2).
have [n hn] := (activeG2  hw3 hw1); by rewrite hn.
Qed. 

Lemma DHS_deg_connect_aux21 : forall f v,
 (forall a,  inactiveG a s -> forall x x0,  f s (VPupdate nu false a x x0) ==
   f s x0) ->
(forall a x, activeG a s -> activeG a initState ->  
  f s (VPupdate nu false a x initState) == f s (VPupdate nu false a x s)) ->
(f s initState == f s s) ->
(mu  (DHSLoc (Vread initState.1 v) (Poutread nu p0  initState.2 v)
   (Pinread nu p0  initState.2 v))) (fun x0 =>  (f s (VPupdate 
  nu false v x0 initState))) 
==
 (mu (DHSLoc (Vread s.1 v) (Poutread nu p0 s.2 v) (Pinread nu p0 s.2 v)))
     (fun x0 => (f s (VPupdate nu false v x0 s))).
Proof. 
intros.  unfold DHSLoc,activeL,Vread.
case ha1:(activeG v s).
   have ha2:= (s1  ha1).
   have := (DHS_deg_connect_aux25 ha1). 
   rewrite (DHS_deg_connect_aux23 ha1). 
   rewrite (s3 ha1). rewrite (initState1 ha2). 
   unfold activeG in ha1,ha2. rewrite ha1 ha2.
   move/eqP:ha1=>ha1. move/eqP:ha2=>ha2.  rewrite ha1 ha2.
       case:(numberActive  (Pinread nu p0  s.2 v))=>//. 
  move=> n _. 
  apply mu_eq_compat=>//. intro. 
  rewrite H0 =>//;unfold activeG;try rewrite ha1;try rewrite ha2;
  by rewrite eq_refl.

case ha2: (activeG v initState);last first.
  have ha1':= (activeinactive ha1).
  unfold activeG in ha1,ha2. rewrite ha1 ha2. simpl.
   do 2 rewrite (H _ ha1'). rewrite H1. done. 

 have ha1':= (activeinactive ha1).
unfold activeG in ha1,ha2. rewrite ha1 ha2.
case:( numberActive (Pinread nu p0  initState.2 v) ).
 simpl. repeat rewrite (H _ ha1'). by rewrite H1.
intro. rewrite Mlet_simpl. rewrite Munit_simpl.
 setoid_rewrite (fun x => Munit_simpl _    (initState.1 v, sendChosen x.+1
 (Pinread nu p0  initState.2 v))).  
 rewrite (H _ ha1'). setoid_rewrite (H _ ha1'). rewrite mu_cte. 
rewrite Random_total. 
rewrite H1. done. 
Qed. 

Lemma inactive_active : forall x s', activeG x s' -> ~inactiveG x s'. 
Proof. 
unfold activeG,inactiveG;intros x s'. 
case:(s'.1 x)=>//=.
intros _ H. destruct H. done. 
Qed. 


Lemma DHS_deg_connect_aux2 : forall f, 
  (forall a, inactiveG a s ->  forall x x0, (f s (VPupdate nu false a x x0)) 
 == (f s x0)) ->
(forall (l:seq (V* (VLab * seq PLab))), (forall a, a \in l -> activeG a.1 s) -> 
              (forall a, a \in l -> activeG a.1 initState) -> 
   f s (foldr (fun x s'=> VPupdate nu false x.1 x.2 s') initState l) == 
   f s (foldr (fun x s'=> VPupdate nu false x.1 x.2  s') s l)) ->
(f s initState == f s s) ->
 (mu (DHS (enum V) initState))  (fun x : VSt * PSt => (f s x)) ==
 (mu (DHS (enum V) s))  (fun x : VSt * PSt => (f s x)).
Proof.
unfold DHS.
have : (0 < seq.size (enum V))%nat.
 rewrite -cardE. apply/card_gt0P. exists (fste e0).   done.
elim:(enum V)=>//;intros.
case hl: (l == nil). 
   move/eqP:hl=>hl. subst l.  simpl.
  apply  DHS_deg_connect_aux21=>//.
 intros. have:= (H1 ((a0,x0)::nil)). simpl. intro.  apply x1.
  intro.  rewrite in_cons in_nil orbF. move/eqP->. simpl. done. 
 intro. rewrite in_cons in_nil orbF. move/eqP->. simpl. done.
 

assert (0 < seq.size l)%nat. 
 move:hl. clear. elim:l=>//=.
simpl. 
unfold DHSLoc,activeL,Vread.
case ha1: (activeG a s).
   have Ha1 := ha1.  
   have ha2:= (s1  ha1).
   have := (DHS_deg_connect_aux25 ha1). 
   rewrite (DHS_deg_connect_aux23 ha1).

   rewrite (s3 ha1). rewrite (initState1 ha2). 
   unfold activeG in ha1,ha2. rewrite ha1 ha2.
   move/eqP:ha1=>ha1. move/eqP:ha2=>ha2.  rewrite ha1 ha2.
       case:(numberActive  (Pinread nu p0 s.2 a))=>//. 
  move=> n _. 
  setoid_rewrite Mlet_simpl.  
  setoid_rewrite (fun x1=>Munit_simpl _ (None, sendChosen x1.+1
 (Pinread nu p0  s.2 a))).
 apply (H H3 (fun s x0 => ((mu (Random n))
        (fun x1 : nat =>
           (f s
              (VPupdate nu false a
                 (None, sendChosen x1.+1 (Pinread nu p0  s.2 a)) x0)) ))))=>//.
  intros. apply mu_eq_compat=>//. intro. 
  rewrite VPupdate_1. rewrite (H0 _ H4). done. 
  case haa0:(a == a0)=>//. move/eqP:haa0=>haa0. subst a.
  destruct (inactive_active Ha1). done. 
  intros. apply mu_eq_compat=>//. intro. 
  apply (@H1 ((a,(None, sendChosen x0.+1 (Pinread nu p0  s.2 a)) )::l0)).
   intro. rewrite in_cons;simpl.  
   case ha3: ((a0 == (a, (None, sendChosen x0.+1 (Pinread nu p0 s.2 a))))). 
   move=>_.  move/eqP:ha3=>ha3. rewrite ha3. simpl. done. 
  simpl. apply H4.   intro. rewrite in_cons;simpl.  
   case ha3: ((a0 == (a, (None, sendChosen x0.+1 (Pinread nu p0  s.2 a))))). 
   move=>_.  move/eqP:ha3=>ha3. rewrite ha3. simpl. unfold activeG. 
  rewrite ha2 eq_refl. done.  
  simpl. apply H5.

 apply mu_eq_compat=>//. intro.
 apply (@H1 ((a,(None, sendChosen x0.+1 (Pinread nu p0  s.2 a)) )::nil)).
  intro. rewrite in_cons;simpl.  
   case ha3: ((a0 == (a, (None, sendChosen x0.+1 (Pinread nu p0  s.2 a))))). 
   move=>_.  move/eqP:ha3=>ha3. rewrite ha3. simpl. done. 
  simpl. rewrite in_nil. done.    intro. rewrite in_cons;simpl.  
   case ha3: ((a0 == (a, (None, sendChosen x0.+1 (Pinread nu p0  s.2 a))))). 
   move=>_.  move/eqP:ha3=>ha3. rewrite ha3. simpl. unfold activeG. 
  rewrite ha2 eq_refl. done.  
  simpl. by rewrite in_nil.
  
have ha1':= (activeinactive ha1). 
case ha2 :(activeG a initState);last first.
unfold activeG in ha1,ha2. rewrite ha1 ha2. 
simpl. 
setoid_rewrite (H0 _ ha1' (initState.1 a, (Poutread nu p0  initState.2 a ))).
setoid_rewrite (H0 _ ha1' (s.1 a, (Poutread nu p0  s.2 a))).
apply H=>//.

unfold activeG in ha1,ha2. rewrite ha1 ha2. 
case :(numberActive (Pinread nu p0 initState.2 a)).
 simpl. unfold VPupdate,Vupdate,Pupdate in H0. 
setoid_rewrite (H0 _ ha1'  (Some (seq.size (Poutread nu p0  initState.2 a)),
 nseq (seq.size (Poutread nu p0 initState.2 a)) false) ).
setoid_rewrite (H0 _ ha1'  (s.1 a, (Poutread nu p0  s.2 a))). 
 apply H=>//. 
intro. setoid_rewrite Mlet_simpl. 
setoid_rewrite (fun k => Munit_simpl _  (initState.1 a,
               sendChosen k.+1 (Pinread nu p0  initState.2 a))).
setoid_rewrite (Munit_simpl _   (s.1 a, Poutread nu p0  s.2 a)).
assert ( forall (x : VLab * seq bool_eqType)
         (x0 : LabelFunc V VLab * LabelFunc port_finType bool_eqType),
        (f s (VPupdate nu false a x x0)) == (f s x0)) as H7.  
apply H0=>//.
 setoid_rewrite (H7 ((s.1 a, Poutread nu p0  s.2 a) )).
setoid_rewrite (fun x1 => H7  (initState.1 a,
                 sendChosen x1.+1 (Pinread nu p0 initState.2 a)) ) .
setoid_rewrite mu_cte. 
setoid_rewrite Random_total. 
setoid_rewrite Umult_one_right.
apply H=>//.
Qed. 


Lemma DHS_deg_connect :
 (mu (DHS (enum V) s))  (fun x : VSt * PSt => B2U (hs_glob_ex s x)) <=
 (mu (DHS (enum V) initState))  (fun x : VSt * PSt => B2U 
  (hs_glob_ex initState x)).
Proof.
assert ((mu (DHS (enum V) s)) (fun x : VSt * PSt => B2U (hs_glob_ex s x)) ==
(mu (DHS (enum V) initState))
          (fun x : VSt * PSt => B2U (hs_glob_ex s x)));
last by rewrite H; apply DHS_deg_connect_aux1.
symmetry. 
apply (@DHS_deg_connect_aux2(fun x s'=> B2U (hs_glob_ex x s')))=>//.
intros. assert (hs_glob_ex s (VPupdate nu false a x x0)= hs_glob_ex s x0);
 last first.
 by rewrite H0. 
  unfold hs_glob_ex,hs_glob.
apply eq_existsb. intro z.
unfold hs_edgeB,hs_eqVB.
case hz1:(activeG (fste z))=>//=.   
 case haz: (a ==(fste z)). 
    move/eqP:haz=>haz;subst a. by destruct (inactive_active hz1). 
case hz2:(activeG (snde z))=>//=.   
 case haz2: (a ==(snde z)). 
    move/eqP:haz2=>haz2;subst a. by destruct (inactive_active hz2).
  repeat rewrite VPupdate_read_2=>//.
    by rewrite haz2. by rewrite haz.
intros. 
assert (hs_glob_ex s
        (foldr
           (fun x : V * (VLab * seq bool_eqType) =>
            [eta VPupdate nu false x.1 x.2]) initState l) =
     (hs_glob_ex s
        (foldr
           (fun x : V * (VLab * seq bool_eqType) =>
            [eta VPupdate nu false x.1 x.2]) s l)));last first.
 by rewrite H1.

 
unfold hs_glob_ex,hs_glob.
apply eq_existsb. intro z.
unfold hs_edgeB,hs_eqVB.
case hz1:(activeG (fste z))=>//=;
case hz2:(activeG (snde z))=>//=. 
assert ((index (snde z) (nu (fste z)) ==
    index true
      (Poutread nu p0 
         (foldr
            (fun x : V * (option nat * seq bool) =>
             [eta VPupdate nu false x.1 x.2]) initState l).2 (fste z))) =
 (index (snde z) (nu (fste z)) ==
    index true
      (Poutread nu p0 
         (foldr
            (fun x : V * (option nat * seq bool) =>
             [eta VPupdate nu false x.1 x.2]) s l).2 (fste z)))). 
 elim:l H H0=>//=. 
   intros. by rewrite (s3 hz1) (initState1 (s1 hz1)).
  intros. 
 case haz:(a.1== fste z);last first.
 case haz2:(a.1==snde z);last first. 
  repeat rewrite VPupdate_read_2=>//;try rewrite haz=>//;try rewrite haz2=>//.
   apply H=>//. intros. apply H0. rewrite in_cons H2 orbT. done. 
   intros. apply H1. rewrite in_cons H2 orbT. done. 
move/eqP:haz2=>haz2. rewrite -haz2.  repeat rewrite write_read4=>//. 
   repeat rewrite VPupdate_read_2=>//;try rewrite haz=>//;try rewrite haz2=>//.
  apply H=>//. intros. apply H0. rewrite in_cons H2 orbT. done. 
   intros. apply H1. rewrite in_cons H2 orbT. done. 
move/eqP:haz=>haz. rewrite -haz.  repeat rewrite VPupdate_read_4=>//. 
rewrite H1. clear H1.
 apply andb_id2l. move=>_. 
 elim:l H H0=>//=. 
   intros. by rewrite (s3 hz2) (initState1 (s1 hz2)).
  intros. 
 case haz:(a.1== fste z);last first.
 case haz2:(a.1==snde z);last first. 
  repeat rewrite VPupdate_read_2=>//;try rewrite haz=>//;try rewrite haz2=>//.
   apply H=>//. intros. apply H0. rewrite in_cons H2 orbT. done. 
   intros. apply H1. rewrite in_cons H2 orbT. done. 
move/eqP:haz2=>haz2. rewrite -haz2.  repeat rewrite VPupdate_read_4=>//. 
   repeat rewrite VPupdate_read_2=>//;try rewrite haz=>//;try rewrite haz2=>//.
  apply H=>//. intros. apply H0. rewrite in_cons H2 orbT. done. 
   intros. apply H1. rewrite in_cons H2 orbT. done. 
move/eqP:haz=>haz. rewrite haz. by apply edge_fs. 
move/eqP:haz=>haz. rewrite haz. by apply edge_fs.

assert (hs_glob_ex s initState= hs_glob_ex s s);last first. 
 by rewrite H. 
unfold hs_glob_ex,hs_glob. 
apply eq_existsb;intro z.
unfold hs_edgeB,hs_eqVB.
case hz1:(activeG (fste z))=>//=;
case hz2:(activeG (snde z))=>//=.
      rewrite (s3 hz1) (s3 hz2)(initState1 (s1 hz1)) (initState1 (s1 hz2)). done .
Qed. 

End  sdeg_conn.
End initState. 


Section whole.
Variable initState : VSt * PSt.
Hypothesis initState1 : forall (v:V), (activeG v initState)  -> 
 (Poutread nu p0  initState.2 v) = nseq (seq.size (nu v)) true.
Hypothesis initState2 : forall v, (inactiveG v initState) -> 
 (Poutread nu p0  initState.2 v) = nseq (seq.size (nu v)) false.

Lemma initsub : forall (s:VSt*PSt) (e:E),
(forall v : V,activeG v s -> Poutread nu p0  s.2 v= nseq (seq.size (nu v)) true) ->
activeG (fste e) s ->
activeG (snde e) s ->
 (0 < count (fun x : V => activeG x s && (0 < nactv s x)) (enum V))%nat. 
Proof.
intros;rewrite count_filter -has_predT.  
apply/hasP.
exists (fste e)=>//. 
rewrite mem_filter H0=>/=.
rewrite mem_enum. case h:(fste e \in V)=>//;rewrite andbT.
unfold nactv,numberActive. rewrite count_filter -has_predT.
apply/hasP.  exists true=>//.
rewrite mem_filter eq_refl=>/=.  unfold Pinread.
have := (edge_fste_snde e). rewrite Hnu. intro h'. 
have := (map_f  (fun x => s.2 (VtoP x (fste e) p0)) h'). 
have : ( s.2 (VtoP (snde e) (fste e) p0) = true).
 have := (H _ H1).  unfold Poutread. 
 rewrite -(size_map (fun x => s.2 (VtoP (snde e) x p0))).
 move/all_pred1P.   move/allP. intro H2. apply/eqP. apply ( H2 (s.2
 (VtoP (snde e) (fste e) p0) ) ).
 apply (map_f (fun x =>  s.2 (VtoP (snde e) x p0))). rewrite -Hnu. rewrite gsym. 
apply edge_fste_snde. 
move->. done. 
Qed. 

Lemma DHS_deg_whole :
 (0 < count (fun x : V => activeG x initState && (0 < nactv initState x)%nat) 
(enum V))%nat ->
 [1-] hscte
 <= (mu (DHS (enum V) initState)) (carac_hs_glob_ex initState).
Proof.
rewrite -has_count. move/hasP. move=>[v _].
unfold nactv,numberActive,Pinread.  move/andP=>[hv1 hv2].
have [w [hw1 hw2]]:(exists w, Adj v w /\ activeG w initState). 
  move:hv2. have :(forall w, w \in (nu v) -> Adj v w). intros. by rewrite Hnu.
 elim:(nu v)=>//=;intros.
 move:hv2 H. case:( count (eq_op^~ true) [seq initState.2 (VtoP x0 v p0) |
 x0 <- l] )
;last first.
   intros. apply H=>//.  intros.  apply x. rewrite in_cons H0 orbT. done. 
  case ha:(initState.2 (VtoP a v p0) )=>//=. 
  exists a. split. apply x. rewrite in_cons eq_refl. done.
  case ha2:( activeG a initState)=>//=. 
 apply activeinactive in ha2. apply initState2 in ha2.  unfold Poutread in ha2. 
  move:ha2. rewrite -(size_map (fun x =>initState.2 (VtoP a x p0))).
 move/all_pred1P. move/allP.  unfold pred1. simpl. 
 intro he. have:( initState.2 (VtoP a v p0) == false). apply (he (initState.2 
(VtoP a v p0))).
  apply (map_f (fun x0 =>  initState.2 (VtoP a x0 p0))). rewrite -Hnu. rewrite gsym. 
apply x. 
  by rewrite in_cons eq_refl. move/eqP. intro H0. rewrite H0 in ha. done.
set e := if (enum_rank v < enum_rank w)%nat then (@VtoE V Adj v w e0)
 else (@VtoE V Adj w v e0).
have he1 : (activeG (fste e) initState). 
 unfold e. case h2:(enum_rank v < enum_rank w)%nat. 
 by move/eqP:(VtoE2 e0 hw1 h2)->. 
 rewrite ltnNge leq_eqVlt in h2.
 case h3: ((enum_rank w < enum_rank v))%nat. 
    by rewrite gsym in hw1;move/eqP:(VtoE2 e0 hw1 h3)->.
 rewrite h3 orbF in h2. move/eqP:h2.  
 intro. have : (w = v). 
  apply (enum_rank_inj). apply ord_inj.   done.
 intro. rewrite x grefl in hw1. done.
have he2 :   (activeG (snde e) initState). 
 unfold e. case h2:(enum_rank v < enum_rank w)%nat. 
 by move/eqP:(VtoE3 e0 hw1 h2)->. 
 rewrite ltnNge leq_eqVlt in h2.
 case h3: ((enum_rank w < enum_rank v))%nat. 
    by rewrite gsym in hw1;move/eqP:(VtoE3 e0 hw1 h3)->.
 rewrite h3 orbF in h2. move/eqP:h2.  
 intro. have : (w = v). 
  apply (enum_rank_inj). apply ord_inj.   done.
 intro. rewrite x grefl in hw1. done.
have [e' [s [h1 [h2 [h3 [h4 [h5 [h6 [h7 h8]]]]]]]]] :=
 (DHS_deg_exconn initState2 he1 he2). 
unfold carac_hs_glob_ex,fB2U.
apply (fun x => Ole_trans _ _ _ x  
 (DHS_deg_connect initState1 h1 h2 h4 h5 h6 h7 h8)).  
apply DHS_deg=>//.
apply (s3 initState1 h5 h6).
apply (initsub (s3 initState1 h5 h6)  h1 h2).
Qed. 


End whole.
End Handshake.
