Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun tuple.

Require Import Ensembles.

Require Import graph.
Require Import labelling.
Require Import gen.
Require Import setSem.
Require Import rdaTool_gen.
Require Import handshake_gen.
Require Import handshake_spec.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction
      We prove that there exists a randomised algorithms which 
       solve the handshake algorithm with a non-null probability
  *)


Section hsalgo.

(** To have an hsAlgo, we consider the algorithm defined in handshake_gen
 *)

(** * Definitions and proofs of hypotheses 
  *)

Let VLabel := option_eqType nat_eqType.
Let PLabel := bool_eqType. 
Let vunit  : VLabel := None.
Let lunit : PLabel := true.

Let VSt (V: finType) := LabelFunc V VLabel. 
Let Pt (V:finType) (Adj: rel V) := (@port_finType V Adj).
Let PSt (V:finType) (Adj: rel V)  :=  LabelFunc (Pt Adj) PLabel. 
Let State (V:finType) (Adj:rel V) := Datatypes.prod (LabelFunc V VLabel)  
 ( LabelFunc (@port_finType V Adj) PLabel). 

Definition rand_HsR  : seq (VLabel -> seq PLabel -> seq PLabel -> gen (VLabel * seq PLabel)) := 
(randHSLoc::nil).

Definition rand_HsP  (lv:VLabel) (lpout lpin :seq PLabel) : option nat :=
 if (agreed lpout lpin) then Some (index true lpout) else None.

Definition rand_HsI  (V:finType) (Adj : rel V) (Gr:Graph Adj)(NG: NGraph Gr): State  Adj   :=
  (finfun [ffun v => None], finfun [ffun p => false]). 

Lemma rand_HsI1 (V:finType) (Adj : rel V) (Gr:Graph Adj)(NG: NGraph Gr)(nu : V -> seq V) 
    (Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)))  (Hnu2: forall (v :V), uniq (nu v)) 
    (p0 : Pt Adj) : 
   consistent p0 nu rand_HsP (rand_HsI NG).
Proof. 
move=>v. 
unfold assNeigh,hsPortR,rand_HsP,rand_HsI=>/=.
case h : (agreed (Poutread nu p0 [ffun x => [ffun=> false] x] v)
             (Pinread nu p0 [ffun x => [ffun=> false] x] v))=>//=. 
have:false=>//. 
move:h;unfold Poutread,Pinread;elim:(nu v)=>//=;intros. 
move:h.  repeat rewrite ffunE. done. 
Qed. 

Lemma rand_HsI2  (V:finType) (Adj : rel V) (Gr:Graph Adj)(NG: NGraph Gr)(nu : V -> seq V) 
    (Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)))  (Hnu2: forall (v :V), uniq (nu v)) :
    Uniform (rand_HsI NG). 
Proof.
split=>[v1 v2 |p1 p2]; 
 by repeat rewrite ffunE.
Qed.


Lemma rand_HsP1  (V:finType) (Adj: rel V) (Gr:Graph Adj)(NG: NGraph Gr)(nu:V -> seq V) 
 (Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)))  (Hnu2: forall (v :V), uniq (nu v)) 
 (p0: Pt Adj) (s: State Adj) (v:V) (i:nat)  :
 hsPortR p0 nu rand_HsP s v = Some i -> i < deg Gr v.
Proof.
unfold hsPortR,rand_HsP.
case h : ( agreed (Poutread nu p0 s.2 v) (Pinread nu p0 s.2 v))=>// h0. 
injection h0;move<-.  
replace (deg Gr v) with (size (nu v));last first.
  unfold deg,Nb_enum.
  apply/eqP. rewrite -uniq_size_uniq=>//.
  apply enum_uniq.
  intro. rewrite -Hnu mem_enum. done.
replace (size (nu v)) with (size (Poutread nu p0 s.2 v));last by rewrite size_map.  
rewrite index_mem.
by apply agreed_1.   
Qed.


Lemma HS1  (V:finType) (Adj: rel V) (nu:V -> seq V) 
 (Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)))  (Hnu2: forall (v :V), uniq (nu v)) 
  (p0: Pt Adj) : 
forall s s' w, 
Setsem  (GRound WriteArea (Vwrite (VLab:=VLabel)) (Pwrite nu false) (Vread (VLab:=VLabel)) 
(Pinread nu p0) (Poutread nu p0) (enum V) s randHSLoc) s' ->
count id (Poutread nu p0 s'.2 w) <= 1 .
Proof.
move=> s s' w. have : (w \in (enum V)) by rewrite mem_enum.
elim:(enum V) s s' w=>//=.
intros a l H s s' w;rewrite in_cons=>h1 [y [hy [z [hz hz1]]]]. subst s'.
 simpl. rewrite VPupdate_read_6=>//. rewrite eq_sym.   
move:h1. case hwa:(w==a)=>//=;last first. 
  intro;have H' := (H _ _ _ h1 hy)=>//. 
move/eqP:hwa=>hwa;subst a. 
move=>_. move:hz. unfold randHSLoc. 
case:( numberNeigh (Pinread nu p0 s.2 w)). 
   simpl;intro;subst z.  
   have hw :size (nu w) = size (nseq (size (Poutread nu p0 s.2 w)) false) 
   by  rewrite size_nseq size_map.   
   simpl.  by elim:(nu w)=>//. 
simpl. intros n [i [hi1 hi2]]. subst z. simpl. 
have hw := (rand_sendChosen_size (Pinread nu p0 s.2 w) i.+1). 
rewrite size_map in hw. rewrite takel_cat=>/=;last by rewrite hw. 
rewrite -hw. rewrite take_size. apply rand_sendChosen_count. 
Qed. 

Lemma rand_HsRind (V:finType) (Adj: rel V) (Gr:Graph Adj)(NG: NGraph Gr)(nu:V -> seq V)  
                (Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)))  (Hnu2: forall (v :V), uniq (nu v)) 
                (p0: Pt Adj) :
  Stable _ 
      (consistent p0 nu rand_HsP)  (nextState false rand_HsR p0 nu (enum V)). 
Proof.
move=> s H0 s'.  unfold In;simpl. 
move=>[y [hy hy2]]. subst y.
intro v. unfold assNeigh,hsPortR, rand_HsP.
case h:(agreed (Poutread nu p0 s'.2 v) (Pinread nu p0 s'.2 v))=>//.
set i:= (index true (Poutread nu p0 s'.2 v)).
have hi3 :   (index true (Poutread nu p0 s'.2 v) = i) by trivial.  
set w:= (nth v (nu v) i). 
have hi1 : ( (nth v (nu v) i) = w) by trivial.
have hi2 : (i < size (nu v)). 
 replace (size (nu v)) with (size ( Poutread nu p0 s'.2 v));last by rewrite size_map.
 unfold i. rewrite index_mem. apply agreed_1.  done.     
have [j [hj1 hj2]]:(exists j', nth w (nu w) j' = v /\ j' < size (nu w)).
 exists (index v (nu w)).
 have H: ( index v (nu w) < size (nu w)).
   rewrite index_mem -Hnu gsym Hnu -hi1. apply mem_nth. done.
 split=>//. rewrite index_mem in H.  apply nth_index.  done.
have hj2' : ( j < deg Gr w). 
  replace (deg Gr w) with (size (nu w))=>//. 
  unfold deg,Nb_enum;apply/eqP. rewrite -uniq_size_uniq=>//.
  apply enum_uniq.  intro. rewrite -Hnu mem_enum. done.
have hj3 := (agreed_3 Hnu Hnu2 h hi3 hi1 hj1 hj2' (HS1 Hnu Hnu2 w hy)).
rewrite hj3 (agreed_2 hi1 (HS1 Hnu Hnu2 w hy) hi3 h).
 by rewrite hj1.
rewrite -Hnu gsym Hnu -hi1. apply mem_nth. done.
Qed.


Definition rand_hs : (hsAlgo VLabel false) := 
 (Build_hsAlgo rand_HsI1 rand_HsI2 rand_HsP1 rand_HsRind). 

Lemma NonADet : ~ Adet (HsR rand_hs).
Proof.
unfold rand_hs. simpl. unfold randHSLoc. 
move=>[H1 H2]. 
by move:(H1 (None) nil (true::nil)).
Qed. 

Section Correct. 
(** * Correction
  *)

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Ptf := Pt Adj. 

Definition E1 := (@edge_finType V Adj).
Variable (e0:E1). 
Definition p1 := (EtoP1 e0).  

Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Ptf PLabel.

Let hsr := (HsR rand_hs). 
Let hsp := (HsP rand_hs). 
Let hsi := (HsI rand_hs NG). 
Let hsi1 := (HsI1 rand_hs NG Hnu Hnu2 p1). 
Let hsi2 := (HsI2 rand_hs NG Hnu Hnu2). 
Let hsp1 := (@HsP1 _ _ _ rand_hs _ _ _ NG _ Hnu Hnu2 p1).
Let hsrind := (@HsRind _ _ _ rand_hs _ _ _ NG _ Hnu Hnu2 p1).

Lemma rand_HsI_choice (v:V) : 
agreed (Poutread nu p1 hsi.2 v)
             (Pinread nu p1 hsi.2 v) = false. 
Proof. 
unfold Poutread,Pinread;elim:(nu v)=>//=.
intros. repeat rewrite ffunE. done. 
Qed. 
 
Lemma rand_HsI3  :
 @matching _ Adj (fun v => assNeigh p1 nu hsp v hsi).
Proof.
split=>v;unfold assNeigh,hsPortR,hsp,rand_hs,rand_HsP;simpl;by rewrite rand_HsI_choice.
Qed.


Lemma rand_HSInvariant_matching  :
 Invariant _ (fun s => @matching _ Adj (fun v => assNeigh p1 nu hsp v s))
  (nextState false  hsr p1 nu (enum V)) hsi. 
Proof.
split. 
  apply rand_HsI3.
move=>s [H0 H1] s'.
unfold In. simpl.
move=>[y  [hy hy2]]. subst y.
split;last first. 
 apply  (HsRind _   Hnu Hnu2 H1). unfold In. simpl.  exists s'. split=>//.
move=>v. simpl.  unfold assNeigh,hsPortR,hsp. simpl. unfold rand_HsP.
case h:(agreed (Poutread nu p1 s'.2 v) (Pinread nu p1 s'.2 v))=>//. 
rewrite Hnu. rewrite mem_nth=>//. 
rewrite -(size_map  (fun x => s'.2 (VtoP v x p1) ) (nu v)) index_mem. 
by apply agreed_1. 
Qed. 


Definition f (V0:finType) (Adj0:rel V0) nu0 (l:seq V0) (p0:@port_finType V0 Adj0):=
 finfun (fun x:@port_finType V0 Adj0 => 
 if ((fstp x) \in l) then 
    if ((fstp x) == (fstp p0)) then if ((sndp x) == (sndp p0)) then true 
                                    else false
    else if ((fstp x) == (sndp p0)) then if   ((sndp x) == (fstp p0)) then true 
                                    else false
    else if (index (sndp x) (nu0 (fstp x)) == O) then true 
                                                 else false
 else false). 

Lemma Real : hsRealisation rand_hs. 
Proof.
unfold hsRealisation. intros. unfold hsEventually. 
unfold hsExists. 
exists (finfun (fun x:V0 => None (A:=nat)), f nu0 (enum V0) p0). 
split;last first.
set v:= (fstp p0). 
set w := (sndp p0).  
exists v. exists w. unfold hsBetween. rewrite PvalP. simpl. 
unfold assNeigh,hsPortR,rand_HsP;simpl.    
have hnu1 : (v \in (nu0 w)) by rewrite -Hnu0 gsym;destruct p0.
have hnu2 : (w \in (nu0 v)) by  rewrite -Hnu0;destruct p0.

have : (agreed  (Poutread nu0 p0 (f nu0 (enum V0) p0) v)
            (Pinread nu0 p0 (f nu0 (enum V0) p0) v)). 
  unfold Poutread,Pinread.
  have : (forall u, u \in (nu0 v) -> Adj0 v u) by intro;rewrite Hnu0.    
  elim:(nu0 v) hnu2=>//=;intros. 
  repeat rewrite ffunE. repeat rewrite mem_enum. simpl. 
  have ha1:(Adj0 v a). apply x. rewrite in_cons eq_refl. done.
  rewrite (VtoP2 _ ha1) eq_refl. rewrite (VtoP3 _ ha1). 
  case haw:(a==w). 
    move/eqP:haw=>haw. subst a. rewrite gsym in ha1. rewrite (VtoP2 _ ha1). 
    rewrite (VtoP3 _ ha1). rewrite eq_refl eq_refl.
   case hwv:(v==w)=>//. move/eqP:hwv=>hwv. rewrite hwv grefl in ha1. done. 
   rewrite eq_sym. rewrite hwv.  done. 
  apply H. move:hnu2. rewrite in_cons. rewrite eq_sym. rewrite haw. done.
  intros. apply x. rewrite in_cons H0 orbT. done. 
intro hc. rewrite hc. 

have : (agreed (Poutread nu0 p0 (f nu0 (enum V0) p0) w)
 (Pinread nu0 p0 (f nu0 (enum V0) p0) w)). 
  unfold Poutread,Pinread.
  have : (forall u, u \in (nu0 w) -> Adj0 w u) by intro;rewrite Hnu0.    
  elim:(nu0 w) hnu1=>//=;intros. 
  repeat rewrite ffunE. repeat rewrite mem_enum. simpl. 
  have ha1:(Adj0 w a). apply x. rewrite in_cons eq_refl. done.
  rewrite (VtoP2 _ ha1) eq_refl. rewrite (VtoP3 _ ha1).
  rewrite gsym in ha1. rewrite (VtoP2 _ ha1) (VtoP3 _ ha1).  
  case hvw:(w==v)=>//. 
      move/eqP:hvw=>hvw. subst w. subst v. move:(PvalP p0). move:hvw. 
      unfold fstp,sndp.  move->. rewrite grefl. done. 
    rewrite eq_refl.  case hav:(a==v)=>//. apply H. 
     move:hnu1. rewrite in_cons. rewrite eq_sym hav. done. 
     intros. apply x. rewrite in_cons H0 orbT. done.
 
intro hc2. rewrite hc2. 
apply/andP;split;apply/eqP;apply f_equal;unfold Poutread. 
 have : (forall u, u \in (nu0 v) -> Adj0 v u) by intro;rewrite Hnu0.   
 elim:(nu0 v) hnu2=>//=. 
 intros. unfold f. repeat rewrite ffunE. repeat rewrite mem_enum. simpl. 
 have ha1:(Adj0 v a). apply x. rewrite in_cons eq_refl. done.
 rewrite (VtoP2 _ ha1) (VtoP3 _ ha1). rewrite gsym in ha1. 
 rewrite eq_refl. move:hnu2. rewrite in_cons eq_sym. 
 case hwa:(a==w)=>/=;last first.
  intro. apply H=>//.  intros.  apply x. rewrite in_cons H0 orbT. done. 
  by move/eqP:hwa.
have : (forall u, u \in (nu0 w) -> Adj0 w u) by intro;rewrite Hnu0.   
elim:(nu0 w) hnu1=>//=. 
intros. unfold f. repeat rewrite ffunE.
have ha1:(Adj0 w a). apply x. rewrite in_cons eq_refl. done.
repeat rewrite mem_enum. simpl. 
rewrite (VtoP2 _ ha1) (VtoP3 _ ha1). rewrite gsym in ha1. 
rewrite eq_refl. case hwv :(w==v). 
  move/eqP:hwv=>hwv.  subst w. subst v. move:(PvalP p0). move:hwv. 
      unfold fstp,sndp.  move->. rewrite grefl. done. 
move:hnu1. rewrite in_cons eq_sym. 
case hwa:(a==v)=>/=;last first.
intro. apply H=>//.  intros.  apply x. rewrite in_cons H0 orbT. done. 
by move/eqP:hwa.

unfold reachFrom. exists 1. simpl. unfold In. exists (rand_HsI NG0). 
split=>//. exists ( ([ffun=> None], f nu0 (enum V0) p0)). split=>//.

elim:(enum V0)=>//=.
 unfold rand_HsI. 
 have h1 : ([ffun=> None]=[ffun x => [ffun=> None] x]). 
   intros. apply/ffunP. intro. repeat rewrite ffunE. done. 
 have h2 : (  [ffun=> false]= [ffun x => [ffun=> false] x]). 
  intros. apply/ffunP. intro. repeat rewrite ffunE. done. 
 rewrite -h1 -h2=>//.

intros.
exists ([ffun=> None], f nu0 l p0). 
split=>//.  unfold randHSLoc. unfold numberNeigh. rewrite size_map. 
case h:(size (nu0 a) == 0). 
 move/eqP:h=>h. rewrite h. simpl. 
 exists (None,[::]). split=>//.
 simpl.
 have h1 : ([ffun=> None] = 
  update [set a] [ffun=> None] (Vwrite None a)). 
   intro. apply/ffunP. intro. rewrite update_Plocal_iff. rewrite in_set. 
   by case hxa:(x==a)=>//. 
 have h2 : (f nu0 (a::l) p0 = 
  update (WriteArea a) (f nu0 l p0) (Pwrite nu0 false [::] a)). 
     apply/ffunP. unfold f. intro. repeat rewrite update_Plocal_iff. 
  repeat rewrite in_set. repeat rewrite ffunE. rewrite in_cons.  
   case hxa:(fstp x == a)=>//. move/eqP:hxa=>hxa. subst a. simpl.  
   have : ((sndp x) \in (nu0 (fstp x))). 
      rewrite -Hnu0. destruct x. apply PvalP. 
   apply size0nil in h.  rewrite h. done. 
  rewrite -h1 -h2. done.
 
  have [n hn] :(exists n , (size (nu0 a)) = S n).
   move:h. case: (size (nu0 a))=>//.  intros. exists n. done.  
 
rewrite hn.  simpl. clear h. 

case h1: (a == (fstp p0)).
 move/eqP:h1=>h1. subst a. 
 exists (None,  rand_sendChosen (index (sndp p0) (nu0 (fstp p0))) .+1
          (Pinread nu0 p0 [ffun x => [ffun=> false] x] (fstp p0))).
 split=>//. exists (index (sndp p0) (nu0 (fstp p0))). split=>//.
 apply/leP. rewrite -ltnS.  rewrite -hn.
 rewrite index_mem. rewrite -Hnu0. destruct p0. done. 
 simpl. 
   have h1 : ([ffun=> None] = 
       update [set fstp p0] [ffun => None]
      (Vwrite None (fstp p0))). 
   intro. apply/ffunP. intro. rewrite update_Plocal_iff. rewrite in_set. 
   case:(x==fstp p0)=>//. 
   have h2 : ( (f nu0 (fstp p0 :: l) p0) = 
     update (WriteArea (fstp p0)) (f nu0 l p0)
     (Pwrite nu0 false
        (rand_sendChosen (index (sndp p0) (nu0 (fstp p0))).+1
           (Pinread nu0 p0 [ffun x => [ffun=> false] x] (fstp p0))) 
        (fstp p0))).
     apply/ffunP. intro. rewrite update_Plocal_iff in_set.
   repeat rewrite ffunE. repeat rewrite in_set. rewrite in_cons.  
   case hxa:(fstp x == fstp p0)=>//. move/eqP:hxa=>hxa. simpl. 
   case hxa': (sndp x == sndp p0 )=>//. 
    move/eqP:hxa'=>hxa'. rewrite hxa'. rewrite rand_sendChosen_nth1=>//. 
   by rewrite size_map. by rewrite hn. by rewrite -Hnu0; destruct p0. 
   rewrite rand_sendChosen_nth2=>//. 
   by rewrite size_map. by rewrite hn. 
   rewrite -h1 -h2. done.

case h2: (a == (sndp p0)).
 move/eqP:h2=>h2. subst a. 
 exists (None,  rand_sendChosen (index (fstp p0) (nu0 (sndp p0))) .+1
          (Pinread nu0 p0 [ffun x => [ffun=> false] x] (sndp p0))).
 split=>//. exists (index (fstp p0) (nu0 (sndp p0))). split=>//.
 apply/leP. rewrite -ltnS.  rewrite -hn.
 rewrite index_mem. rewrite -Hnu0. rewrite gsym. destruct p0. done.

have H1 : ([ffun=> None] = update [set sndp p0] [ffun=> None]
      (Vwrite
         (None,
         rand_sendChosen (index (fstp p0) (nu0 (sndp p0))).+1
           (Pinread nu0 p0 [ffun x => [ffun=> false] x] (sndp p0))).1
         (sndp p0))). 
   intro. apply/ffunP. intro. rewrite update_Plocal_iff. rewrite in_set.
   repeat rewrite ffunE.  
   case:(x==sndp p0)=>//.  
   have H2 : (f nu0 (sndp p0 :: l) p0= update (WriteArea (sndp p0)) (f nu0 l p0)
     (Pwrite nu0 false
        (None,
        rand_sendChosen (index (fstp p0) (nu0 (sndp p0))).+1
          (Pinread nu0 p0 [ffun x => [ffun=> false] x] (sndp p0))).2
        (sndp p0))).
    intro.  apply/ffunP. intro. rewrite update_Plocal_iff in_set.
    repeat rewrite ffunE. rewrite in_cons.  
   case hxa:(fstp x == sndp p0)=>//. move/eqP:hxa=>hxa.
   rewrite hxa. case hxa': (sndp x == fstp p0 ). 
    move/eqP:hxa'=>hxa'. rewrite hxa'. simpl. 
     rewrite h1. 
    rewrite rand_sendChosen_nth1=>//. 
    by rewrite size_map. by rewrite hn. by rewrite -Hnu0 gsym; destruct p0.
   simpl. rewrite h1. rewrite rand_sendChosen_nth2=>//. 
   by rewrite size_map. by rewrite hn. 
   rewrite -H1 -H2. done.

exists  (None, (true::(nseq n false))). 
split=>/=.
 exists 0. split. apply/leP. done.
rewrite (@rand_sendChosenlpin _ (nseq n.+1 false)).
simpl.
rewrite (@rand_sendChosen0 (nseq n false))=>//. 
rewrite size_nseq. done. 
rewrite size_map. rewrite hn. rewrite size_nseq. done. 

   have H1 : ([ffun=> None] = (update [set a] [ffun=> None] (Vwrite None a))). 
   intro. apply/ffunP. intro. rewrite update_Plocal_iff. rewrite in_set. 
   case:(x==a)=>//. rewrite -H1. 
   have H2 : (f nu0 (a :: l) p0 = update (WriteArea a) (f nu0 l p0)
     (Pwrite nu0 false (true :: nseq n false) a)). 
     apply/ffunP. intro. rewrite update_Plocal_iff in_set.
   repeat rewrite ffunE. rewrite in_cons.  
   case hxa:(fstp x == a)=>//. move/eqP:hxa=>hxa.
   repeat rewrite ffunE.  rewrite hxa h1 h2.
   case:(index (sndp x) (nu0 a))=>//=.  intro.
   rewrite nth_nseq. case:(n0 < n)=>//. 
   rewrite H2. done.
Qed. 

Section proba.
(** * Analyse
  *)
Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.

Require Import my_alea.
Require Import dist.
Require Import rdaTool_dist.
Require Import handshake_dist.


Set Implicit Arguments.
Unset Strict Implicit.

Open Local Scope U_scope.
Open Local Scope O_scope.



Lemma rand_hsexists :
 [1-] (@hscte _ Adj) <= mu (Distsem (GPStep nu false p1 hsr (enum V) hsi))
           (fun x => B2U ([exists v, [exists w, 
            @hsBetween _ Adj (fun v => assNeigh p1 nu hsp v x) v w]])).
Proof.
rewrite (@DHS_deg _ _ _ NG _ Hnu Hnu2 e0 hsi).
apply mu_le_compat=>//. 
  by rewrite -DPGHS_eq2.
intro x.
unfold carac_hs_glob_ex,hs_glob_ex,fB2U.
case h: ( [exists x0, hs_edgeB nu e0 x0 x])=>//. 
case h' : ([exists v,exists w,hsBetween ((assNeigh p1 nu hsp)^~ x) v w])=>//. 
move/existsP:h=>[e]. 
unfold hs_edgeB,hs_eqVB. move/andP=>[he1 he2]. move/eqP:he1=>he1. move/eqP:he2=>he2. 
move/existsP:h'=>h'. destruct h'. exists (fste e). apply/existsP. exists (snde e). 
unfold hsBetween. rewrite edge_fste_snde. 
unfold assNeigh,hsPortR,rand_HsP,Vread,hsp,rand_hs. simpl. unfold rand_HsP.  
rewrite (agreed_4 _ _ _ _ he1 he2)=>//;
 last by rewrite gsym;apply edge_fste_snde.
  rewrite (agreed_4 _ _ _ _ he2 he1)=>//;
 last by apply edge_fste_snde.
rewrite -he1 -he2. 
repeat rewrite  nth_index. 
by repeat rewrite eq_refl.
by rewrite -Hnu gsym;apply edge_fste_snde.
by rewrite -Hnu;apply edge_fste_snde.
Qed.

End proba. 
End Correct.  
End hsalgo.



