Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.


Require Import my_ssr.
Require Import graph.
Require Import labelling.
Require Import op.
Require Import rdaTool_op.
Require Import handshake_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Simulation of handshake algorithm
  *)

Section HS.

Variable (rand_t : Type)(get : nat -> rand_t -> nat * rand_t).
Context (rand : ORandom _ get).

Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.

Definition OHSLoc (lv:VLabel) (lpout lpin: seq PLabel) 
 : Op rand_t (VLabel *seq PLabel) :=
  match (numberNeigh lpin) with
   |O => Oreturn (None, nil)
   |S n => Obind (Orandom n rand)
      (fun k => Oreturn (None,rand_sendChosen k.+1 lpin))
  end.


Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.

Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

Definition OHSRound (seqV: seq V)(res: VState * PState)  :=
 OPRound nu false p0 seqV res OHSLoc. 

Section gen.

Lemma OPGHS_eq1 : forall  (lv:VLabel) (lp1 lp2: seq PLabel) ,
 Opsem _ get rand (randHSLoc lv lp1 lp2) = 
 OHSLoc lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold randHSLoc,OHSLoc.
case:( numberNeigh lp2)=>//=.
Qed.

Lemma OPGHS_eq2 : forall  (seqV: seq V) (res:VState*PState),
 Opsem _ get rand (randHSRound nu p0 seqV res) = 
 OHSRound seqV res.
Proof.
move=>seqV res;unfold randHSRound,OHSRound. 
apply OPG_eq1. 
apply OPGHS_eq1.
Qed. 

End gen.

Section simulation.

Definition OHSRoundF (seqV: seq V) (res: (V -> VLabel) * (V *  V -> PLabel)) :=
 OPFRound nu false seqV res OHSLoc.

Lemma OHSF_eq1 : forall (seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v n,
 seqV = seqVF ->
 (forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   ((OHSRound seqV res n).1).1 v = 
   ((OHSRoundF seqVF resF n).1).1 v.
Proof.
move=>seqV seqVF res resF v n h0 h1 h2; unfold OHSRound,OHSRoundF.
rewrite h0.
apply OPF_eq5=>//. 
Qed. 

Lemma OHSF_eq2 : forall  (seqV seqVF : seq V)(res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) v w n,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
 Adj v w ->
   ((OHSRound seqV res n).1).2 (VtoP v w p0) = 
   ((OHSRoundF seqVF resF n).1).2 (v,w).
Proof.
move=>seqV seqVF res resF v w n h0 h1 h2 h3; unfold OHSRound,OHSRoundF.
rewrite h0. 
apply OPF_eq6=>//. 
Qed. 

 Lemma OHSF_eq3 : forall (seqV seqVF : seq V) (res: VState*PState) 
 (resF : (V -> VLabel) * (V *  V -> PLabel) ) n,
 seqV = seqVF ->
(forall v,  res.1 v = resF.1 v) ->
(forall v w,  Adj v w -> res.2 (VtoP v w p0) = resF.2 (v,w)) ->
   (OHSRound seqV res n).2 = 
   (OHSRoundF seqVF resF n).2.
Proof.
move=>seqV seqVF res resF n h0 h1 h2; unfold OHSRound,OHSRoundF.
rewrite h0. 
apply OPF_eq3=>//. 
Qed. 

End simulation.


End HS.

Section simulation.

(** Definition of the graph 
 *)

Inductive V : Type :=
 |v0 : V
 |v1 : V
 |v2 : V
 |v3 : V. 

Definition eqV := (fun x y : V =>
 match x,y with 
|v0,v0 => true
|v1,v1 => true
|v2,v2=>true
|v3,v3 => true
|_,_ => false
end). 

Lemma eqVP : Equality.axiom eqV. 
Proof. 
intros a b;unfold eqV. 
case:a;case b=>//=;constructor=>//=.
Qed. 


Canonical V_eqMixin := EqMixin eqVP. 
Canonical V_eqType:= Eval hnf in EqType V V_eqMixin.

Lemma V_pickleK : pcancel (fun v : V => match v with |v0 => O |v1 => 1%nat |v2 => 
2 |v3 => 3 end) 
 (fun x : nat => match x with |0 => Some v0 | 1 => Some v1 |2 => Some v2 | 3 => Some v3 | _ => None end).
Proof.
intro x. case:x=>//=. 
Qed. 

Fact V_choiceMixin : choiceMixin V.
Proof. 
apply (PcanChoiceMixin V_pickleK). 
Qed. 

Canonical V_choiceType :=  Eval hnf in ChoiceType V V_choiceMixin.

Definition V_countMixin := CountMixin V_pickleK.
Canonical V_countType := Eval hnf in CountType V V_countMixin.

Definition venum :=  (v0:: v1:: v2:: v3:: nil). 
Lemma V_enumP : Finite.axiom venum. 
Proof. 
by case. 
Qed.
 
Definition V_finMixin := Eval hnf in FinMixin  V_enumP.
Canonical V_finType := Eval hnf in FinType V V_finMixin.

Lemma card_V : #|{: V}| = 4. 
Proof. 
by rewrite cardT enumT unlock. 
Qed.

Definition Adj : rel V := (fun x y => match x, y with
 |v0,v1 |v0,v3 |v1,v0 |v1,v2 |v1,v3 |v2,v1 |v2,v3 |v3,v0 |v3,v1 |v3,v2 => true
 | _,_ => false
 end).

Lemma AdjSym : symmetric Adj.
Proof. 
intros m n.
case:m;case:n=>//=. 
Qed. 
   
Lemma AdjIrrefl : irreflexive Adj. 
Proof. 
intro n.
case:n=>//=.
Qed. 

Lemma enumV : (enum V_finType) = ([::v0;v1;v2;v3] ). 
Proof.
by rewrite enumT unlock. 
Qed.

Context `(NG: NGraph V_finType Adj).

Lemma Nb_enumv0 : Nb_enum Gr v0 = (v1::v3::nil). 
Proof.
unfold Nb_enum,Adj=>/=.
unfold enum_mem. 
by rewrite -enumT enumV.
Qed. 

Lemma degv0 : (deg Gr v0) = 2. 
Proof. 
unfold deg. 
by rewrite Nb_enumv0.
Qed.

Definition nu (v: V) : seq V :=
 match v with 
   |v0 => [::v1;v3] 
   |v1 => [::v0;v2;v3] 
   |v2 => [::v1;v3] 
   |v3 => [::v1;v2;v0] 
end.

Lemma nuAdj_eq : forall u w, 
Adj u w = (w \in nu u). 
Proof. 
move=>u w;unfold Adj, nu.
case:u;case:w=>//. 
Qed. 

Lemma hp0 : Adj (v0,v1).1 (v0,v1).2. 
Proof. auto. Qed.

Definition p0 := Port hp0. 

(** Definition of the labelling 
 *) 
Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.

Definition initV : (LabelFunc V_finType VLabel) :=
finfun  (fun x:V => None).

Definition initP : (LabelFunc (@port_finType V_finType Adj)   PLabel) :=
 finfun (fun x => true).  

Definition init := (initV, initP). 

Definition initVF : (V ->  VLabel) :=
 (fun x:V => None).

Definition initPF : ((V*V) ->  PLabel) :=
 (fun x => true).

Definition initF := (initVF, initPF). 

Lemma init_eq1 : forall v,  init.1 v = initF.1 v.
Proof. 
move=>v. 
by rewrite ffunE.
Qed.

Lemma init_eq2 : forall v w,  
 Adj v w -> init.2 (VtoP v w p0) = initF.2 (v,w).
Proof. 
move=>v w h/=.
by rewrite ffunE.
Qed.

(** Equivalence
 *)

Lemma OHSF_eq4 : forall v n,
   ((OHSRound my_gen nu p0 (enum V_finType) init n).1).1 v = 
   ((OHSRoundF my_gen nu [::v0;v1;v2;v3]  initF n).1).1 v.
Proof.
move=>v n. 
apply (OHSF_eq1 my_gen NG). 
 by apply nuAdj_eq.
 by apply enumV.
 by apply init_eq1.
by apply init_eq2.
Qed. 

Lemma OHSF_eq5 : forall v w n,
 Adj v w ->
   ((OHSRound my_gen nu p0 (enum V_finType) init n).1).2 (VtoP v w p0) = 
   ((OHSRoundF my_gen nu [::v0;v1;v2;v3]  initF n).1).2 (v,w).
Proof.
move=>v w n. 
apply (OHSF_eq2 my_gen NG).
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

 Lemma OHSF_eq6 : forall n,
   (OHSRound my_gen nu p0 (enum V_finType) init n).2 = 
   (OHSRoundF my_gen nu [::v0;v1;v2;v3]  initF n).2.
Proof.
move=>n. 
apply (OHSF_eq3 my_gen NG). 
 by apply nuAdj_eq.
 by apply enumV.  
 by apply init_eq1. 
by apply init_eq2. 
Qed. 

(** Computation
 *)

(* With seed equal to 6 *)
Let R1 :=  (OHSRoundF my_gen nu [::v0;v1;v2;v3] initF) 6. 

Check (R1).

Eval vm_compute in (R1.1.1 v3).
Eval vm_compute in (R1.1.2 (v3,v1)).
Eval vm_compute in (R1.1.2 (v3,v2)).
Eval vm_compute in (R1.1.2 (v3,v0)).

Eval vm_compute in (R1.1.1 v0).
Eval vm_compute in (R1.1.2 (v0,v1)).
Eval vm_compute in (R1.1.2 (v0,v3)).
Eval vm_compute in (R1.1.2 (v0,v0)).

Eval vm_compute in (displayOP  nu [::v0;v1;v2;v3]  R1.1).

End simulation.