Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun tuple.

Require Import Ensembles.

Require Import graph.
Require Import labelling.
Require Import gen.
Require Import setSem.
Require Import rdaTool_gen.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction

   The handshake algorithm is the following:
    each vertex v chooses a neighbour c(v)
    v sends 1 to c(v) and 0 to its other neighbour
    if v receives 1 from c(v) there is a handshake.
 
    The message passing is simulated by a labelling on the ports
    If v has chosen c(v), the port p(v,c(v)) is relabelled 1.
 *)



Section genAlgo.

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Let Pt := (@port_finType V Adj). 
Variable p0 : Pt.
 
Let VLabel : eqType := option_eqType nat_eqType.
Let PLabel : eqType := bool_eqType.

Let VState := LabelFunc V VLabel.
Let PState := LabelFunc  Pt PLabel.

(** * Auxiliairy functions
  *)

(** 
       numberNeigh lpin: number of neighbours according a local view
  *)
Definition numberNeigh (lpin: seq PLabel) : nat := 
 size lpin. 

(** 
       rand_sendChosen k lpin : the sequence of size lpin composed of 
       false elements except the kth wichi is true
  *)
Fixpoint rand_sendChosen (k:nat) (lpin: seq PLabel) : seq PLabel :=
 match lpin with 
  |t::q => match k with
             |0 => (false::(rand_sendChosen 0 q)) 
             |1 => (true::(rand_sendChosen 0 q))
             |S k' => (false::(rand_sendChosen k' q))
             end
  | nil => nil
 end.

Lemma rand_sendChosen_size : forall l i, 
 size (rand_sendChosen i l) = size l.
Proof. 
elim=>//=. 
intros. case:i=>//=. 
 rewrite H. done. 
intro. case:n=>//=. 
 by rewrite H.
intro. by rewrite H. 
Qed.

Lemma rand_sendChosen_count : forall (k : nat) (lpin : seq bool_eqType),
       count id (rand_sendChosen k.+1 lpin) <= 1.
Proof. 
move=>k lpin. elim:(lpin) k=>//=.
intros. case:k=>//=. 
clear. elim:l=>//=.
Qed.   
 
Lemma rand_sendChosen_index : forall (k : nat) (lpin : seq bool_eqType),
k < seq.size lpin -> 
index true (rand_sendChosen k.+1 lpin) = k.
Proof.
move=>k lpin.  
elim:lpin k=>//=.
intros.  elim:k H0=>//=.
intros.  rewrite H=>//. 
Qed. 

Lemma rand_sendChosen_index2 : forall (k : nat) (lpin : seq bool_eqType),
 seq.size lpin <= k-> 
index true (rand_sendChosen k.+1 lpin) = seq.size lpin.
Proof.
move=>k lpin.  
elim:lpin k=>//=.
intros.  elim:k H0=>//=.
intros.  rewrite H=>//. 
Qed. 

Lemma rand_sendChosenlpin : forall lpin1 lpin2 n,
seq.size lpin1 = seq.size lpin2 -> 
rand_sendChosen n lpin1 = rand_sendChosen n lpin2.
Proof. 
elim=>/=. 
 by case=>//=.
intros.  move:H0. case:lpin2=>//=.
intros. 
apply eq_add_S in H0. 
repeat rewrite (H _ _ H0).
case:n=>//. case=>//. 
intro. rewrite (H _ _ H0). 
done. 
Qed. 

Lemma rand_sendChosen0 : forall l,
 rand_sendChosen 0 l =  nseq (size l) false.
Proof. 
elim=>//=. 
 intros. rewrite -H. done. 
Qed. 

Lemma rand_sendChosen_nth1 : forall (V0:finType) lp (w:V0) l,
 size l = size lp ->    
 size l <> 0 ->
 w \in l ->
 nth false (rand_sendChosen (index w l).+1 lp)(index w l).
Proof. 
intro. elim=>/=;intros. 
 by rewrite H in H0. 
case:l0 H0 H1 H2=>//=;intros. 
move:H2. rewrite in_cons eq_sym. 
case h: (a0 ==w)=>//=. intro. 
apply H=>//. apply eq_add_S. done.
intro. apply size0nil in H3. rewrite H3 in H2. done. 
Qed.  

Lemma rand_sendChosen_nth2 : forall (V0:finType) lp (v w:V0) l,
 size l = size lp ->    
 size l <> 0 ->
 (v == w)=false ->
 nth false (rand_sendChosen (index w l).+1 lp)(index v l) = false.
Proof. 
intro. elim=>/=;intros. 
 by rewrite H in H0. 
case:l0 H0 H1 H2=>//=;intros. 
case h: (a0 ==w)=>//=. 
 move/eqP:h=>h. subst a0. 
 rewrite eq_sym H2.  simpl. rewrite rand_sendChosen0.
 set p := (index v l0). clear. elim :l p=>/=;first by intro;rewrite nth_nil.
 intros. case:p=>//=. 
case:(a0==v)=>//=.
clear H1. case:l0 H0=>//. 
 clear. case:l=>//=.
intros.   
apply H=>//. 
by apply eq_add_S.
Qed. 

(** 
       agreed lpout lpin : returns true if ith element of lpin is true where 
                                          i is the index of the first element at true in lpout
                                          else returns false
                                          
                                           
  *)
Fixpoint agreed (lpout:seq PLabel) (lpin:seq PLabel) : bool := 
 match lpout,lpin with
  |true::q,  true::q' => true
  |true::q,  false::q' => false
  |false::q, _::q' => agreed q q'
  |_ , _ => false
 end.

Lemma agreed_1 v : forall (y:VState*PState), 
  agreed (Poutread nu p0 y.2 v) (Pinread nu p0 y.2 v) = true ->
  true \in (Poutread nu p0 y.2 v) .
Proof.
unfold Poutread,Pinread;elim(nu v)=>//= a l hind y.
case:( y.2 (VtoP v a p0))=>//= h. 
rewrite in_cons=>/=. 
apply hind=>//.
Qed.

Lemma agreed_2 v : forall (y:VState*PState) w i, 
  nth v (nu v) i = w->
  count id (Poutread nu p0 y.2 w) <= 1  ->
  index true (Poutread nu p0 y.2 v) = i ->
  agreed (Poutread nu p0 y.2 v) (Pinread nu p0 y.2 v) = true ->
  v \in (nu w) ->
  agreed (Poutread nu p0 y.2 w) (Pinread nu p0 y.2 w) = true.
Proof. 
unfold Poutread,Pinread. 
elim:(nu v)=>//=a l H y w i H0 H1.
case hy1:(y.2 (VtoP v a p0))=>/=;last first. 
  intros. case:i H0 H1 H2=>//=. intros. 
  apply (H _ _ n)=>//;last by injection H2.
intros. subst i.  simpl in H0. subst a.
move:H3. case hy3:(y.2 (VtoP w v p0))=>//=_. 
move:H4 hy1 hy3 H1.
clear.
elim:(nu w) v=>//=.
intros. move:H1.
 case h1 : ( y.2 (VtoP w a p0))=>//=;last first. 
 intros. move:H4. rewrite in_cons. case hva:(v==a)=>/=.
  move/eqP:hva=>hva. subst a. rewrite hy3 in h1. done. 
  intros. apply (H v)=>//.
move:H4. rewrite in_cons. case hva:(v == a)=>/=. 
 move=>_ H0. move/eqP:hva=>hva. subst a. 
 rewrite hy1. done. 
intros.    
have H1': (count id [seq y.2 (VtoP w x p0) | x <- l]) = 0. 
 by move:H1;case:(count id [seq y.2 (VtoP w x p0) | x <- l])=>/=.  
case h2 : (y.2 (VtoP a w p0) )=>//=.
move:H1' H4 hy3.  
clear. elim:l=>//=;intros.
move:H4. 
  rewrite in_cons. case hva:(v==a)=>//=.
  move/eqP:hva=>hva. subst a. rewrite hy3 in H1'. done. 
intro. apply H=>//. 
move:H1'. case:(y.2 (VtoP w a p0))=>//=. 
Qed. 

Lemma agreed_3 v : forall (y:VState*PState) w i j,
 agreed (Poutread nu p0 y.2 v) (Pinread nu p0 y.2 v) = true ->
 index true (Poutread nu p0 y.2 v) = i -> nth v (nu v) i = w ->
 nth w (nu w) j = v -> j < deg Gr w ->
 count id (Poutread nu p0 y.2 w) <= 1  ->
 index true (Poutread nu p0 y.2 w) = j.
Proof.
unfold Poutread,Pinread;move:(Hnu2 v).  
elim:(nu v)=>//=a l H huniq y w i j H0 H1 H2 H3 H4 H5.
move/andP:huniq=>[huniq1 huniq2]. move:H0 H1.  
case hy1:(y.2 (VtoP v a p0))=>/=;last first. 
  intros. case:i H0 H1 H2 =>//=. intros. 
  apply (H huniq2 _ _ n)=>//. by injection H1.
case hy3:(y.2 (VtoP a v p0))=>//=_. 
intros. subst i.  simpl in H2. subst a.
move:H3 H5 hy1 hy3 H4 huniq1 huniq2.
move:(Hnu2 w). rewrite -(degnu1 Hnu Hnu2). 
clear. 
elim:(nu w) v j=>//=;intros. 
case:j H3 H4=>//=;intros. 
 subst a. by rewrite hy3. 
move/andP:Hnu2=>[huniq3 huniq4].
move:H5.  
case h1 : ( y.2 (VtoP w a p0))=>//=;intro;
  last by  rewrite (@H v n) =>//.
have H1': (count id [seq y.2 (VtoP w x p0) | x <- l0]) = 0. 
 move:H5;case:(count id [seq y.2 (VtoP w x p0) | x <- l0])=>//=.  
move:H1' hy3.
have:(v \in l0) by apply/(nthP w);exists n=>//.   
clear. elim:l0=>//=;intros.
move:x;rewrite in_cons;case hva:(v==a)=>//=.
  move/eqP:hva=>hva. subst a. rewrite hy3 in H1'. done. 
intro. apply H=>//. 
move:H1'. case:(count id [seq y.2 (VtoP w x0 p0) | x0 <- l] );case:(  y.2 (VtoP w a p0) )=>//=. 
Qed. 

Lemma agreed_4 u : forall (x:VState*PState) v,
Adj v u ->
index v (nu u) = index true (Poutread nu p0 x.2 u) ->
index u (nu v) = index true (Poutread nu p0 x.2 v) ->
agreed (Poutread nu p0 x.2 u) (Pinread nu p0 x.2 u).
Proof.
move=>x v hadj. 
have:(u \in (nu v))  by rewrite -Hnu.
have:(v \in (nu u)) by rewrite -Hnu gsym. 
clear hadj. move:x v.  
unfold Poutread,Pinread;move:(Hnu2 u).
elim:(nu u)=>//=a l H huniq y v H0 H1 H2 H3.
move/andP:huniq=>[huniq1 huniq2]. 
move:H2.
case hy1:(y.2 (VtoP u a p0))=>/=;last first. 
  intros. move:H0 H2. rewrite in_cons eq_sym. case hva:(a==v)=>//=. intros. 
  apply (H huniq2 _ v)=>//. by apply eq_add_S.
move:H0. rewrite in_cons eq_sym. case hva:(a==v)=>//= _ _.
move/eqP:hva=>hva. subst a. 
clear H. 
elim:(nu v) (Hnu2 v) u l H1 H3 huniq2 huniq1 hy1=>//=. 
intros. 
move/andP:Hnu0=>[huniq3 huniq4].  
move:H3 H1.  rewrite in_cons eq_sym.  case hua:(u==a)=>/=.
 move/eqP:hua=>hua. subst a. case:(  y.2 (VtoP v u p0) )=>//.
case hy2:( y.2 (VtoP v a p0))=>//=. intro. apply eq_add_S in H3. 
intros. apply (H huniq4 _ _ H1 H3 huniq2)=>//.
Qed. 

(** *  Local algorithm
  *)
Definition randHSLoc (lv:VLabel) (lpout lpin: seq PLabel) : gen (VLabel *seq PLabel) :=
match (numberNeigh lpin) with
   |O => Greturn _ (None, nil)
   |S n => Grandom _ n 
      (fun k => Greturn _ (None,rand_sendChosen k.+1 lpin))
  end.

(** *  Global algorithm
  *)
Definition randHSRound (seqV: seq V) (res: VState * PState):=
 GPRound nu false p0 seqV res randHSLoc. 

End genAlgo. 
