Require Import ssreflect ssrfun ssrbool eqtype ssrnat.
Require Import fintype finset fingraph seq finfun bigop choice tuple.
Import Prenex Implicits.

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Require Import Rplus.
Require Import my_alea.
Require Import my_ssr.
Require Import my_ssralea. 
Require Import graph.
Require Import graph_alea.
Require Import labelling.
Require Import bfs.
Require Import gen.
Require Import dist.
Require Import rdaTool_gen.
Require Import rdaTool_dist.
Require Import handshake_gen.

Set Implicit Arguments.
Unset Strict Implicit.

Open Local Scope U_scope.
Open Local Scope O_scope.

Section Handshake.

(** * The graph
 *)

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).


Variable nu : V -> seq V.
Hypothesis Hnu: forall (v w:V), (Adj v w) = (w \in (nu v)). 
Hypothesis Hnu2: forall (v :V), uniq (nu v). 

Definition E := (@edge_finType V Adj).
Variable e0:E.

Definition Pt := (@port_finType V Adj). 
Definition p0 := (EtoP1 e0). 

Definition VLab : eqType := option_eqType nat_eqType.
Definition PLab : eqType := bool_eqType.

Definition VSt := LabelFunc V VLab.
Definition PSt := LabelFunc  Pt PLab.

(** * Local Algorithm
 *)

Definition DHSLoc (lv:VLab) (lpout lpin: seq PLab) 
 : distr (VLab *seq PLab) :=
  match (numberNeigh lpin) with
   |O => Munit (None, nil)
   |S n => Mlet (Random n)
      (fun k => Munit (None,rand_sendChosen k.+1 lpin))
  end.

Section gen.
(** ** Proofs of the equivalence with the generic algorithm
 *)

Lemma DPGHS_eq1 : forall  (lv:VLab) (lp1 lp2: seq PLab) ,
 Distsem  (randHSLoc lv lp1 lp2) = 
 DHSLoc lv lp1 lp2.
Proof.
move=>lv lp1 lp2;unfold randHSLoc,DHSLoc.
case:( numberNeigh lp2)=>//=.
Qed.

End gen.


(** ** Local Analysis
 *)

(** 
   DHSLoc can be decomposed in a sum of computations 
    around each port
 *)

Lemma is_discrete_DHSLoc : forall (lv:VLab) (lpout:seq PLab) 
 (lpin:seq PLab),
  is_discrete_s (DHSLoc lv lpout lpin).
Proof.
move=>lv lpout lpin.
unfold DHSLoc. 
case: (numberNeigh lpin). 
  by exists (Build_discr_s(@retract_invn 0) (fun k=>(None, nil)))=>/=;
     intro x;repeat Usimpl.
intro n.
exists (Build_discr_s (@retract_invn n) 
 (fun k => (None, rand_sendChosen k.+1 lpin))).
by intro f.
Qed. 


(** 
     DHSLoc terminates 
 *)

Lemma DHSLoc_total : forall (lv:VLab) (lpout:seq PLab) (lpin:seq PLab),
 Term (DHSLoc lv lpout lpin).
Proof.
move =>lv lpout lpin;unfold DHSLoc.
case:(numberNeigh lpin)=>//n.  
apply Random_total=>//.
Qed.

(** 
   The probability for a vertex to choose the ith neighbour
    is 1/(deg v)
 *)

(** 
    carac_lc_eq returns true if i is equal to the choice of v
    i.e. it returns true if v chooses its ith neighbour
    else false
 *)

Definition carac_lc_eq : nat -> seq PLab -> VLab * seq PLab -> U  := 
 fun (i: nat) (lpin:seq PLab) (s: VLab * seq PLab) => 
  B2U (i == (index true s.2)).

Lemma DHSLoc_eq : forall (lv:VLab)(lpout lpin:seq PLab)(k: nat),
 (k < seq.size lpin)%nat ->
 (mu (DHSLoc lv lpout lpin)) (carac_lc_eq k lpin) == 
 [1/]1+((seq.size lpin).-1).
Proof.
unfold DHSLoc;move=> lv lpout lpin k hk.
have[n hn] : (exists n, seq.size lpin = S n)
 by case:(seq.size lpin) hk=>//n _;exists n.
unfold numberNeigh;rewrite hn.
rewrite Mlet_simpl.
setoid_rewrite (fun x => Munit_simpl (carac_lc_eq k lpin)
  (None, rand_sendChosen x.+1 lpin)).
rewrite hn in hk. 
rewrite <-Nmult_1;rewrite -(@Random_eq _ k)=>//;last first.
  by apply/leP;rewrite -ltnS.
apply mu_eq_compat=>// x.
unfold carac_lc_eq,B2U,carac_eq,carac=>//.
rewrite -hn in hk.
case (eq_nat_dec k x)=>heq1.
 subst x.  rewrite rand_sendChosen_index=>//. by rewrite eq_refl.
move/eqP:heq1;move/negbTE=>heq1.  
case h: (x < seq.size lpin)%nat.
  rewrite rand_sendChosen_index=>//. rewrite heq1. done.
rewrite rand_sendChosen_index2.
case hk2:(k==seq.size lpin)=>//.
  move/eqP:hk2=>hk2. rewrite hk2 in hk. rewrite ltnn in hk. done.
rewrite leqNgt h. done. 
Qed. 
    

(** * Global Algorithm
 *)

(** 
    DHS seqV res : at the end of the algorithm DHS, 
    each vertices in seqV has made a choice among its neighbours
    and has updated its choice in res
 *)
Definition DHS (seqV: seq V) (res: VSt * PSt): distr (VSt * PSt) :=
 DPRound nu false p0 seqV res DHSLoc.

Section genRound.
(** ** Proofs of the equivalence with the generic algorithm
 *)

Lemma DPGHS_eq2 : forall  (seqV: seq V) (res:VSt*PSt),
 Distsem (randHSRound nu p0 seqV res) = 
 DHS seqV res.
Proof.
move=>seqV res;unfold randHSRound,DHS. 
apply DPG_eq1. 
apply DPGHS_eq1.
Qed. 

End genRound. 

(** ** Analysis
 *)

(** *** Termination
     DHS terminates whichever the sequence of vertices 
    on which DHS is applied
 *)

Lemma DHS_total : forall(s: seq V) (res: VSt*PSt), 
 Term (DHS s res).
Proof.
move=>s res;apply (DRound_total). 
move=>w;apply DHSLoc_total.
Qed.


(** *** Probability to choose a neighbour, local view

    The probability for a vertex to choose the ith neighbour
    (i.e. ith neighbour is labelled true)
    is 1/(deg v)
 *)

(** 
    carac_hs_eqNat returns true if i is equal to the local choice of v
    extracted from the global labelling function 
    i.e. it returns true if v chooses its ith neighbour
    else false
 *)

Definition carac_hs_eqNat : V -> seq PLab -> nat -> VSt * PSt -> U  := 
 fun (v:V) (lpin:seq PLab) (i: nat) (s: VSt * PSt) =>  
 B2U (i  == 
 index true (Poutread nu p0 s.2 v)). 

Lemma DHS_degv_aux1 : forall (v:V) (i:nat) (lpin:seq PLab) (y:VLab * seq PLab) 
(sn:VSt * PSt), 
 seq.size y.2 = seq.size (nu v) ->
 carac_lc_eq i lpin y == 
 carac_hs_eqNat v lpin i (VPupdate nu false v y sn).
Proof.
move=>v i lpin y sn h.
unfold carac_lc_eq,carac_hs_eqNat,B2U. 
rewrite VPupdate_read_3=>//.
Qed. 

Lemma DHS_size1 : forall a b c,
 seq.size b = seq.size c ->
 (mu (DHSLoc a b c)) (fun x => B2U(seq.size x.2 != seq.size c)) == 0.
Proof.
move=>a b c hbc;
unfold DHSLoc,numberNeigh. 
case h:(seq.size c == O).
 move/eqP:h=>h;rewrite h=>//.
have[n hn]:(exists n, seq.size c = S n). 
  move:h;case:(seq.size c)=>//. 
  intros. exists n. done.
rewrite hn. 
rewrite Mlet_simpl. 
apply mu_zero_eq.
move=>x/=. 
rewrite rand_sendChosen_size hn eq_refl. done.
Qed. 


Lemma DHSLtac1 a b c d f:
 seq.size b = seq.size c ->
 (mu (DHSLoc a b c)) (fplus f
      (fun x => B2U(seq.size x.2 != seq.size c)))  == d ->
 (mu (DHSLoc a b c)) f == d.
Proof. 
move=>h h1;apply Ole_antisym;
transitivity ((mu (DHSLoc a b c)) (fplus f 
 (fun x => B2U(seq.size x.2 != seq.size c )))); try rewrite h;auto.
rewrite mu_le_plus DHS_size1;auto.
Qed.


Lemma DHS_degv_aux2 : forall (v:V) (x:VLab*seq PLab) (s:VSt*PSt)(i:nat),
  seq.size x.2 = seq.size (nu v) ->
  (mu (DHS (seq.rem v (enum V)) s))
        (fun x0 : LabelFunc V VLab * LabelFunc port_finType bool_eqType =>
         carac_hs_eqNat v (Pinread nu p0 s.2 v) i (VPupdate nu false v x x0)) == 
         carac_hs_eqNat v (Pinread nu p0 s.2 v) i (VPupdate nu false v x s).
Proof.
have : uniq (enum V) by apply enum_uniq.
elim:(enum V)=>//. 
intros;rewrite cons_uniq in x;move/andP:x=>[h1 h2]/=.  
case hav:(a==v).
  replace l with (seq.rem v l);last by move/eqP:hav h1->; apply rem_id.
  by apply (H h2 v x0 s i).
simpl;rewrite -(H _ _ _ _ _)=>//.
apply mu_eq_compat=>//. 
intro x;unfold carac_hs_eqNat,B2U.
unfold VPupdate,Pupdate. simpl. 
transitivity ((mu (DHSLoc (Vread s.1 a) (Poutread nu p0 s.2 a) 
 (Pinread nu p0 s.2 a)))
     (fun x1 : option nat * seq bool =>
      if i ==
         index true
           (Poutread nu p0
   (update (outerport_set v) x.2 (Pwrite nu false x0.2 v)) v)
      then 1
      else 0));last first. 
  by rewrite  mu_cte DHSLoc_total .
apply mu_eq_compat=>//= x1.
rewrite (@VPupdate_read_3 _ _ _ _ _ _ _ _ _ _ _ 
(x.1, (update (outerport_set a) x.2 (Pwrite nu false x1.2 a))))=>//. 
rewrite VPupdate_read_3=>//. 
Qed. 
 
Lemma DHS_degv_local : forall (v:V)(i:nat)(s:VSt*PSt), 
 (i < (deg Gr v))%nat ->
 (mu  (DHS (enum V) s)) (carac_hs_eqNat v (Pinread nu p0 s.2 v) i) == 
 [1/]1+((deg Gr v).-1).
Proof.
move=>v i s hi;unfold DHS.
unfold DPRound. 
rewrite (@DRoundCommute2 _ _ _ _ _ _ _ _ _ _  _ _ v);last first. 
 by rewrite mem_enum. 
by apply disjoint_outerport. 
 by intro w;apply is_discrete_DHSLoc.
rewrite DRoundcons2;last by apply is_discrete_DHSLoc.
simpl. 
have hi1 :=(@DHSLoc_eq (Vread s.1 v) (Poutread nu p0 s.2 v) 
 (Pinread nu p0 s.2 v) i)=>//.
have hi2:(seq.size (Pinread nu p0 s.2 v) = deg Gr v). 
  rewrite size_map. apply (degnu1 Hnu Hnu2)=>//.
rewrite hi2 in hi1. rewrite -(hi1  hi).  
have hnuv: (seq.size (Poutread nu p0 s.2 v) = seq.size (Pinread nu p0 s.2 v)). 
 by do 2 rewrite size_map.
apply DHSLtac1=>//;symmetry.
apply DHSLtac1=>//;symmetry.
apply mu_eq_compat=>//. 
intro x;unfold fplus. 
case h:( seq.size x.2 == seq.size (Pinread nu p0 s.2 v) )=>/=;Usimpl;auto. 
move/eqP:h;rewrite size_map=>h. 
rewrite DHS_degv_aux2=>//.
by rewrite (DHS_degv_aux1 _ _ s  h);Usimpl.
Qed. 



(** *** Probability to choose a neighbour, global view
      The probability for a vertex to choose the vertex w which is a neighbour
       is 1/(deg v)
 *)
(** 
    carac_hs_eqV returns true if v chooses w
    else false
 *)

Definition hs_eqVB (v w:V) (s:VSt*PSt) := 
 index w (nu v) == 
 index true (Poutread nu p0  s.2 v).

Definition carac_hs_eqV : V -> V -> VSt*PSt -> VSt*PSt ->U :=
 fun (v w: V) (inits s:VSt*PSt) => 
   B2U (hs_eqVB v w s). 


Lemma carac_hs_iff : forall (v w: V) (inits:VSt *PSt) (i:nat), 
 index w (nu v) = i -> 
 carac_hs_eqV v w inits == 
 carac_hs_eqNat v (Pinread nu p0 inits.2 v) i.
Proof.
move=>v w inits i hi s;unfold carac_hs_eqV,carac_hs_eqNat.
unfold hs_eqVB. 
by rewrite hi.
Qed.


Lemma DHS_degv_global : forall (v w: V) (s:VSt*PSt),
 Adj v w ->
 (mu (DHS (enum V) s)) (carac_hs_eqV v w s) == [1/]1+((deg Gr v).-1).
Proof.
move=> v w s hadj.
rewrite (@carac_hs_iff _ _ _ (index w (nu v)))=>//.  
apply DHS_degv_local.
rewrite -(degnu1 Hnu Hnu2).
rewrite index_mem. rewrite -Hnu. done.   
Qed.



(** *** Probability of having a handshake on an edge
      The probability for an edge (v,w) having a handshake on it is 
     1/(deg v * deg w)
 *)

(** 
   carac_hs_edge returns true if v chooses w and w chooses v 
    else false
 *)

Definition hs_edgeB (e:E) (s:VSt*PSt) : bool :=
(hs_eqVB (fste e) (snde e) s) &&  (hs_eqVB (snde e) (fste e) s).

Definition carac_hs_edge : E -> VSt*PSt -> U :=
 fun (e:E)  =>
  fB2U (fun (s:VSt*PSt) => hs_edgeB e s). 

(** 
   carac_hs_edge returns true if v chooses w, w chooses v and 
    v and w are in the connex composant of the edge eth 
    else false
 *)

Definition eth  := 
 nth e0 (enum E) 0. 

Definition carac_hs_edge0 : E -> VSt*PSt -> U :=
 fun (e:E)  =>
  fB2U (fun (s:VSt*PSt) => hs_edgeB e s && 
 connect (fun v w => Adj v w) (fste eth) (fste e)). 



Lemma indepbDHS_hs : forall  (e:E) (inits:VSt*PSt),
 indepb (DHS (enum V) inits)
    (hs_eqVB (fste e) (snde e))
    (hs_eqVB (snde e) (fste e)).
Proof.
intros e inits;unfold DHS. 
apply DRoundindepb with 
 (c:= fun x => (index (snde e) (nu (fste e)) ==  index true
(take (seq.size (nu (fste e))) (x.2 ++ nseq (seq.size (nu (fste e))) false))))
 (c':=fun x=>(index (fste e) (nu (snde e)) == index true 
(take (seq.size (nu (snde e))) (x.2 ++ nseq (seq.size (nu (snde e))) false)))).
intro w;apply DHSLoc_total.
unfold indepProp;intro t.
case hvt : ((fste e) == t);case hwt : ((snde e) == t)=>/=;
have hevw:=(edge_fs e);unfold hs_eqVB. 

by move/eqP:hwt hevw=>hwt;rewrite -hwt in hvt;rewrite hvt.

right;left;split;move=>x sn;move/eqP:hvt hevw->.
 by rewrite VPupdate_read_4. 
by intro;rewrite VPupdate_read_2.

right;right;split;move=>x sn;move/eqP:hwt hevw=>->;rewrite eq_sym=>
hevw=>//.
 by rewrite VPupdate_read_2. 
by rewrite VPupdate_read_4.

left;split;move=> x sn;rewrite eq_sym in hvt;rewrite eq_sym in hwt; 
rewrite VPupdate_read_2=>//;by [rewrite hvt|rewrite hwt].
Qed.



Lemma DHS_dege : forall (e:E) (s:VSt*PSt),
 mu (DHS (enum V) s) (carac_hs_edge e) == 
   [1/]1+((deg Gr (fste e)).-1) *
   [1/]1+((deg Gr (snde e)).-1).
Proof.
move=> e s.
have hindep := (@indepbDHS_hs e s).
rewrite carac_prodb =>//;unfold fB2U. 
have hadj: (Adj (fste e) (snde e)) by apply edge_fste_snde.
have hadj2 : (Adj (snde e) (fste e)) by  rewrite gsym.
rewrite (DHS_degv_global)=>//.  
rewrite (DHS_degv_global)=>//.
Qed. 


(** ***  Probability for having at least one vertex
 *)

Require Import Rplus. 

(** 
     
      hs_glob s returns true if there is a handshake in the graph
                 else false
 *)


Definition hs_glob_ex (s:VSt*PSt) : bool :=
  [exists x, hs_edgeB x s]. 

Definition hs_glob_ex0 (s:VSt*PSt) : bool :=
  [exists x, hs_edgeB x s && 
   connect (fun x y => Adj x y ) (fste eth) (fste x) ]. 


(** 
      carac_hs_glob s returns 1 if there is a handshake in the graph
                       else 0
 *)

Definition carac_hs_glob_ex : VSt*PSt -> U :=
 fB2U (fun (s:VSt*PSt) => hs_glob_ex  s).


Definition carac_hs_glob_ex0 : VSt*PSt -> U :=
 fB2U (fun (s:VSt*PSt) => hs_glob_ex0  s).

Definition hscte := prod (fun _ => [1-] ([1/2] * [1/]1+(#|E|.-1))) #|E|. 

(** **** Rpsigma_hs
  *) 

Lemma conncount1 : forall w v, 
   connect (fun v0 : V => [eta Adj v0]) v w ->
   (deg Gr w <=
    (count (connect (fun v0 : V => [eta Adj v0]) v) (enum V)).-1)%coq_nat.
Proof. 
move=>w v hcon.  
have : (deg Gr w = (count (fun v => (Adj w v)) (seq.rem w (enum V)))).
  unfold deg,Nb_enum. rewrite count_filter. apply perm_eq_size.
  apply uniq_perm_eq. by rewrite enum_uniq. apply filter_uniq. apply rem_uniq.  by rewrite enum_uniq. 
   intro. rewrite mem_enum. rewrite mem_filter. case ha:(Adj w x)=>//=.
   case hb : (x \in seq.rem w (enum V))=>//.
   have h: (x = w) by  move/negbT:hb=>hb; apply (fun x => rem_mem_not _ _ _ _ x hb);rewrite mem_enum.
   subst x. by rewrite grefl in ha.    
move->.
replace ((count (connect (fun v0 : V => [eta Adj v0]) v) (enum V)).-1) with 
  (count (connect (fun v0 : V => [eta Adj v0]) v) (seq.rem w (enum V))). 
   apply/leP. apply sub_count. intros x hx.  apply/connectP. move/connectP:hcon=>[p hp1 hp2].
    exists (p++(x::nil)).  rewrite path.cat_path hp1 -hp2. simpl;by rewrite hx.
    by rewrite last_cat.
replace (count (connect (fun v0 : V => [eta Adj v0]) v) (enum V)) with 
 (count (connect (fun v0 : V => [eta Adj v0]) v) (w::(seq.rem w (enum V)))).
   by simpl;rewrite hcon add1n. 
apply/perm_eqP.  rewrite perm_eq_sym.  apply perm_to_rem.
by rewrite mem_enum. 
Qed.  

Lemma conncount2 : forall v,
 connect (fun v : V => [eta Adj v]) (fste eth) v ->
count (fun i : V =>Adj v i && connect (fun v0 : V => [eta Adj v0]) (fste eth) i) (enum V) 
 = deg Gr v.
Proof. 
intros. 
have : (deg Gr v = (count (fun w => (Adj v w)) (enum V))).
  unfold deg,Nb_enum. rewrite count_filter. apply perm_eq_size.
  apply uniq_perm_eq. by rewrite enum_uniq. apply filter_uniq.  by rewrite enum_uniq. 
   intro. rewrite mem_enum. rewrite mem_filter. case ha:(Adj v x)=>//=. by rewrite mem_enum. 
move->. 
apply eq_count. intro w. case h:(Adj v w)=>//=. 
apply/connectP. move/connectP:H=>[p hp1 hp2]. exists (p++(w::nil))=>//.
  rewrite path.cat_path hp1;simpl. by rewrite -hp2 h.
by rewrite last_cat.
Qed. 

Lemma Rpsigma_hs : forall (res:VSt*PSt),
 U2Rp([1/2]) <=
   (Rpsigma (fun k : nat =>
       (mu (DHS (enum V) res)) (carac_hs_edge0 (nth e0 (enum E) k))))
    #|E|.
Proof.
move=>res.
unfold carac_hs_edge0. 
rewrite (@Rpsigma_eq_compat _ (fun k => 
 (if (connect (fun v : V => [eta Adj v]) (fste eth) (fste (nth e0 (enum E) k)))
  then [1/]1+((deg Gr (fste (nth e0 (enum E) k))).-1) else 0) *
 (if (connect (fun v : V => [eta Adj v]) (fste eth) (snde (nth e0 (enum E) k)))
  then  [1/]1+((deg Gr (snde (nth e0 (enum E) k))).-1) else 0))%U);last first. 
  intros k hk. 
  case h1 : (connect (fun v : V => [eta Adj v]) (fste eth)
         (fste (nth e0 (enum E) k)));last first. 
    Usimpl. unfold fB2U,B2U.  setoid_rewrite andbF. by auto.
  case h2 : (connect (fun v : V => [eta Adj v]) (fste eth)
         (snde (nth e0 (enum E) k)));last first.
   move/connectP:h2=>h2;destruct h2. move/connectP:h1=>[p hp]. 
  exists (p++(snde (nth e0 (enum E) k) ::nil))=>//=. 
    rewrite path.cat_path hp. rewrite -q;simpl. by rewrite edge_fste_snde.
  by rewrite last_cat. 
  assert ((fB2U (fun s : VSt * PSt => hs_edgeB (nth e0 (enum E) k) s && true))
   == (fB2U (fun s : VSt * PSt => hs_edgeB (nth e0 (enum E) k) s))).
   unfold fB2U,B2U. intro x. rewrite andbT.  done. 
  rewrite H -(DHS_dege (nth e0 (enum E) k) res). done. 
 
rewrite -(rpsigma_bigop _ e0 (fun x=>(
 (if connect (fun v : V => [eta Adj v]) (fste eth)
             (fste x) then [1/]1+((deg Gr (fste x)).-1) else 0) *
 (if connect (fun v : V => [eta Adj v]) (fste eth)
             (snde x)
  then [1/]1+((deg Gr (snde x)).-1) else 0)))%U).
rewrite <-Rpmult_one_left;rewrite U2Rp_Unth.
apply Rpmult_le_perm_left.
unfold prodOP. 
rewrite (eq_bigrs _ _ _ _ _ _ (fun y =>  
 (if connect (fun v : V => [eta Adj v]) (fste eth) (fste y)
    then U2Rp([1/]1+(deg Gr (fste y)).-1) else O) *
 (if connect (fun v : V => [eta Adj v]) (fste eth) (snde y)
     then U2Rp([1/]1+(deg Gr (snde y)).-1) else O))%Rp);
 auto;last first. 
 by intros i _;case: (connect (fun v : V => [eta Adj v]) (fste eth) (fste i))=>//;
  case:(connect (fun v : V => [eta Adj v]) (fste eth) (snde i))=>//;
  repeat Usimpl;auto.
rewrite (bigop_edge_half2 _ _ (fun x =>
 if connect (fun v : V => [eta Adj v]) (fste eth) x
    then  U2Rp ([1/]1+((deg Gr x).-1)) else R0))=>//.
 
set n' := (count (connect (fun v : V => [eta Adj v]) (fste eth)) (enum V)). 
have [n hn]:(exists n, n' = S n).
 unfold n'.  have:(snde eth \in (enum V)) by rewrite mem_enum. 
 elim:(enum V)=>//=;intros. move:x. rewrite in_cons. 
 case he1 : (snde eth == a)=>/=;last first. intros. 
 have [y hy] := (H x). rewrite hy. 
 exists ((connect (fun v : V => [eta Adj v]) (fste eth) a) + y)%nat.
 rewrite addnS. done.
 move=>_. move/eqP:he1=>he1. subst a. 
 exists (count (connect (fun v : V => [eta Adj v]) (fste eth)) l). 
 rewrite connect1. rewrite add1n. done. 
 by apply edge_fste_snde.

apply bigop_edge_R1 with (d:=[1/]1+n).
 rewrite Rpmult_sym. fold n'. rewrite hn. by apply Unth_mult_eq.  
 move=>v w h1 hvw h2.
   apply U2Rp_le_compat;apply Unth_le_compat. 
   transitivity (deg Gr w);first by apply le_pred_n.
   replace n with (n'.-1);last by rewrite hn.
 
  move:h2. unfold n'. apply conncount1.
move=>v hv. 
have : (count (fun i : V => Adj v i && 
  connect (fun v0 : V => [eta Adj v0]) (fste eth) i)  (enum V)
  = (deg Gr v).-1.+1); 
 last by move->;apply Unth_mult_eq.
rewrite -(@S_pred _ O);last first. 
  apply/ltP. case h:(0 < deg Gr v)%nat=>//=.  
  move:h. rewrite lt0n;move/eqP. rewrite deg_zero=>h.  
  move/connectP:hv=>[p hp1 hp2].
 case:p hp1 hp2.
    intros. destruct (h (snde eth)).  rewrite hp2 edge_fste_snde.  done. 
  intros. move:(h  (nth a (fste eth::a::l) (seq.size l)) )=>h'. destruct h'. rewrite hp2. simpl.
  move/path.pathP:hp1=>hp1.
  move:(hp1 a (seq.size l))=>/=.  rewrite -last_nth. intros. rewrite gsym. apply hp0. done. 
by apply conncount2.
Qed. 


(** **** hs1 
 *)

Definition parentFunc (k:nat) := (@tF _ Adj (fste eth) #|V|).

Definition choiceFunc (k:nat) : {ffun V -> V} := 
 finfun (fun x => match parentFunc k x with 
                     |Some y => y
                     |None => snde eth
                   end).

Definition coverTree (k: nat) :  {ffun Pt -> bool} :=
 finfun (fun x => (choiceFunc k (fstp x)) == sndp x).

Definition subinit (initState:PSt)  : PSt  :=
 finfun (fun p => if (connect (fun x y => Adj x y ) (fste eth) (fstp p))
  then initState p else 
  (nth false (rand_sendChosen 1 (Pinread nu p0 initState (fstp p)))
   (index (sndp p) (nu (fstp p))))).  

Lemma forall_port : forall (s1 s2:VSt*PSt) ,
 (forall (v:V),
    s1.1 v = s2.1 v /\ 
   (forall w, Adj v w -> (s1.2 (VtoP v w p0) = s2.2 (VtoP v w p0)))) ->
  s1 = s2.
Proof. 
intros. destruct s1 as [s11 s12]. destruct s2 as [s21 s22].
apply/eqP. rewrite xpair_eqE. apply/andP. split;apply/eqP;rewrite -ffunP;
 intro x.
 by have [H1 H2] := (H x).
have [H1 H2] :=(H (fstp x)). 
have H3:=(H2 (sndp x) (PvalP x)). simpl in H3. rewrite VtoP1 in H3. done. 
Qed. 

Lemma hs1_aux11 :  forall a l (x:VSt*PSt) (x0:VLab * seq PLab),
a \notin l ->
(if[forall v,(v \in a :: l)==>((update [set a] x.1 (Vwrite x0.1 a)) v == None)&&
   [forall w,Adj v w ==>((update (WriteArea a) x.2 (Pwrite nu false x0.2 a))
   (VtoP v w p0) ==(subinit (coverTree 0)) (VtoP v w p0))]] then 1 else 0) ==
(B2U ((x0.1 == None) &&
      [forall w, Adj a w ==> (nth false x0.2 (index w (nu a)) == 
 (subinit (coverTree 0)) (VtoP a w p0))]))*
(B2U ( [forall v,(v \in  l) ==>(x.1 v == None) &&
 [forall w, Adj v w ==> (x.2 (VtoP v w p0) ==
          (subinit (coverTree 0)) (VtoP v w p0))]])). 
Proof.
intros. 
case h1: ([forall v,
          (v \in a :: l) ==>
          ((update [set a] x.1 (Vwrite x0.1 a)) v == None) &&
          [forall w,
             Adj v w ==>
             ((update (WriteArea a) x.2 (Pwrite nu false x0.2 a))
                (VtoP v w p0) == (subinit (coverTree 0)) (VtoP v w p0))]]);
case h2: ( ((x0.1 == None) &&
      [forall w,
         Adj a w ==>
         (nth false x0.2 (index w (nu a)) == (subinit (coverTree 0)) (VtoP a w p0)
)]));

case h3 : ([forall v,
        (v \in l) ==>
        (x.1 v == None) &&
        [forall w,
           Adj v w ==> (x.2 (VtoP v w p0) == 
           (subinit (coverTree 0)) (VtoP v w p0))]]);
unfold B2U;try repeat Usimpl=>//.
move/forallP:h3=>h3.  destruct h3. intro v. apply/implyP. intro.
move/andP:h2=>[h21 h22].  
move/forallP:h1=>h1. move:(h1 v). rewrite in_cons. rewrite H0 orbT;simpl.
rewrite update_Plocal_iff in_set. case hva:(v==a). 
 move/eqP:hva=>hva;subst a. rewrite H0 in H. done. 
move/andP=>[h11 h12]. rewrite h11. simpl. apply/forallP. intro. 
apply/implyP. intro. move/forallP:h12=>h12. move:(h12 x1). rewrite H1. 
simpl. rewrite ffunE in_set. rewrite (VtoP2 _ H1) hva. done.   

move/andP:h2=>h2. destruct h2. 
move/forallP:h1=>h1. move:(h1 a). rewrite in_cons eq_refl. simpl. 
rewrite ffunE in_set eq_refl ffunE.  move/andP=>[h21]. rewrite h21. 
move/forallP=>h22. split=>//. apply/forallP=>w. apply/implyP. 
move=>hadj. move:(h22 w). rewrite hadj. simpl. rewrite ffunE in_set. 
rewrite (VtoP2 _ hadj) eq_refl. rewrite ffunE. rewrite (VtoP3 _ hadj). done.

move/andP:h2=>h2. destruct h2. 
move/forallP:h1=>h1. move:(h1 a). rewrite in_cons eq_refl. simpl. 
rewrite ffunE in_set eq_refl ffunE.  move/andP=>[h21]. rewrite h21. 
move/forallP=>h22. split=>//. apply/forallP=>w. apply/implyP. 
move=>hadj. move:(h22 w). rewrite hadj. simpl. rewrite ffunE in_set. 
rewrite (VtoP2 _ hadj) eq_refl. rewrite ffunE. rewrite (VtoP3 _ hadj). done.

move/forallP:h1=>h1. destruct h1. intro v. 
rewrite in_cons. case hva:(v==a)=>/=. 
 move/eqP:hva=>hva;subst a. rewrite update_Plocal_iff in_set eq_refl ffunE. 
 move/andP:h2=>[h21 h22]. rewrite h21.  simpl. apply/forallP=> w. 
 apply/implyP. move=> hadj. rewrite ffunE in_set(VtoP2 _ hadj) eq_refl ffunE. 
 move/forallP:h22=>h22. move:(h22 w). rewrite hadj. simpl. 
 by rewrite (VtoP3 _ hadj). 
apply/implyP=>hl. rewrite update_Plocal_iff in_set hva. 
move/forallP:h3=>h3. move:(h3 v). rewrite hl. simpl. 
move/andP=>[h11 h12]. rewrite h11. simpl. apply/forallP=>w.
apply/implyP=>hadj. rewrite update_Plocal_iff in_set (VtoP2 _ hadj) hva. 
move/forallP:h12=>h12. move:(h12 w). rewrite hadj. done. 
Qed.     

  
Lemma hs1_aux12: 
forall res, 
0 <(mu (DHS (enum V) res))
     (fun x => if  [forall v, (v \in (enum V)) ==> 
               ( ((x.1 v) == None) && 
 [forall w, Adj v w ==> ((x.2 (VtoP v w p0)) == 
     ((subinit (coverTree 0)) (VtoP v w p0)))])]
  then 1 else 0).
Proof.
have :=(enum_uniq V). 
elim:(enum V). 
 simpl;intros. case h:([forall v, true])=>//. 
 move/forallP:h=>h. by destruct h. 
intros. move:x. rewrite cons_uniq. move/andP=>[huniq1 huniq2];   simpl.
have hyp := (hs1_aux11 _ _ huniq1).
rewrite (mu_stable_eq _ _ _ (fun x => mu_stable_eq  (DHSLoc 
(Vread res.1 a) (Poutread nu p0 res.2 a)
(Pinread nu p0 res.2 a))  _ _  (hyp x))). clear hyp.
setoid_rewrite mu_stable_mult_right. 
setoid_rewrite mu_stable_mult2.  
apply Umult_lt_zero;last first.
 by apply H. 

unfold DHSLoc,numberNeigh. 
rewrite size_map. 
case hseq:((seq.size (nu a)) == O).
 move/eqP:hseq=>hseq. rewrite hseq.  simpl. 
 case h':([forall w,Adj a w ==>
  (nth false [::] (index w (nu a)) ==
  (subinit (coverTree 0)) (VtoP a w p0))])=>//.
 move/forallP:h'=>h'. destruct h'. intro w. apply/implyP. intro hadj. 
 apply size0nil in hseq. by rewrite Hnu hseq in_nil in hadj.
have [n hn] : (exists n, seq.size (nu a) = S n).  
 move:hseq;elim(nu a)=>//=;intros.  exists (seq.size l0). done. 
rewrite hn. setoid_rewrite Mlet_simpl.
setoid_rewrite (fun k => Munit_simpl _ 
 (None, rand_sendChosen k.+1 (Pinread nu p0 res.2 a))).
rewrite random_simpl.
case hcon : (connect (fun x : V => [eta Adj x]) (fste eth) a). 
  
apply (@sigma_not_zero _ _ (index ((choiceFunc 0) a) (nu a))).
 rewrite -hn. apply/leP. rewrite index_mem. rewrite -Hnu. 
 unfold choiceFunc. rewrite ffunE. unfold parentFunc.
 have := (@tF3 V Adj gsym (fste eth) #|V| a).
 have := (tF2'' grefl hcon).
 case:( (tF Adj (fste eth) #|V|) a)=>//. 
  intros. have h:= (@x0 _ NG a0). apply h. done. 
 intros. rewrite x=>//. by apply edge_fste_snde.   
 
simpl.  
case h: ( [forall w, Adj a w ==>
        (nth false (rand_sendChosen (index ((choiceFunc 0) a) (nu a)).+1
 (Pinread nu p0 res.2 a))
           (index w (nu a)) == (subinit (coverTree 0)) (VtoP a w p0))]);
unfold B2U;Usimpl=>//. 
move/forallP:h=>h. destruct h.  move=> v. apply/implyP. move=>hadj.
unfold subinit. repeat rewrite ffunE. rewrite (VtoP2 _ hadj). rewrite hcon.
rewrite (VtoP3 _ hadj). 
case h1 : (a == fste eth)=>/=;last first.
  case : ( (bfs Adj #|V| [:: fste eth]
                 [ffun x => if x == fste eth
                            then Some (fste eth)
                            else None]) a)=>//=.
  intro. 
  case ha0 : (a0 == v). 
   move/eqP:ha0=>ha0;subst a0. 
   rewrite rand_sendChosen_nth1=>//. 
   by rewrite size_map. 
   by rewrite hn. 
   by rewrite -Hnu. 
   rewrite rand_sendChosen_nth2=>//. 
   by rewrite size_map. 
   by rewrite hn.
   by rewrite eq_sym. 
  case ha0 : (snde eth == v). 
   move/eqP:ha0=>ha0;subst v. 
   rewrite rand_sendChosen_nth1=>//. 
   by rewrite size_map. 
   by rewrite hn. 
   by rewrite -Hnu. 
   rewrite rand_sendChosen_nth2=>//. 
   by rewrite size_map. 
   by rewrite hn.
   by rewrite eq_sym.
  case ha0 : (snde eth == v). 
   move/eqP:ha0=>ha0;subst v. 
   rewrite rand_sendChosen_nth1=>//. 
   by rewrite size_map. 
   by rewrite hn. 
   by rewrite -Hnu. 
   rewrite rand_sendChosen_nth2=>//. 
   by rewrite size_map. 
   by rewrite hn.
   by rewrite eq_sym.  

apply (@sigma_not_zero _ _ 0);auto with arith. 
simpl. 
case h : ([forall w,Adj a w ==>
        (nth false (rand_sendChosen 1 (Pinread nu p0 res.2 a))
           (index w (nu a)) == (subinit (coverTree 0)) (VtoP a w p0))]);
unfold B2U;Usimpl=>//.
move/forallP:h=>h. destruct h=>v. 
apply/implyP. move=>hadj. rewrite ffunE. rewrite (VtoP2 _ hadj).
rewrite hcon. rewrite (VtoP3 _ hadj).
rewrite (@rand_sendChosenlpin _ (Pinread nu p0 (coverTree 0) a))=>//. 
by repeat rewrite size_map.
Qed.    

Lemma hs1_aux1 : forall res, 
0 <
   (mu (DHS (enum V) res))
     (fun x : VSt * PSt =>
      if x == (finfun (fun _ => None), subinit (coverTree 0)) then 1 else 0).
Proof.
intro res.  
apply (Olt_le_trans _ _ _  (hs1_aux12 res)).
apply mu_le_compat=>//.
intro. 
case h:(x == ([ffun=> None], subinit (coverTree 0)))=>//. 
case h':([forall v,
          (v \in enum V) ==>
          (x.1 v == None) &&
          [forall w,
             Adj v w ==> (x.2 (VtoP v w p0) == (subinit (coverTree 0))
  (VtoP v w p0))]])=>//.
move/eqP:h=>h;destruct h. 
move/forallP:h'=>h'. 
apply forall_port;split;intros. 
 move:(h' v);rewrite mem_enum;simpl;move/andP=>[h1 h2]. 
 by move/eqP:h1->;rewrite ffunE.
simpl;rewrite ffunE. move:(h' v). rewrite mem_enum;simpl. 
move/andP=>[h1 h2]. move/forallP:h2=>h2. move:(h2 w). 
rewrite H. simpl. move/eqP->.  
unfold subinit. rewrite ffunE. done. 
Qed. 

Lemma hs1_aux2 : forall k, (k < #|E|)%coq_nat ->
0 <
   \big[(fun x : U => [eta Umult x])/1]_(k.+1 <= i < #|E|)
      finv (carac_hs_edge0 (nth e0 (enum E) i))
        ([ffun=> None], subinit (coverTree 0)).
Proof.
move=>k hk. rewrite big1_seqs=>//=.
 move=>a b c d h1 h2. rewrite h1 h2. done.
move=>i. 
unfold finv;rewrite mem_index_iota=>hi.
unfold carac_hs_edge0,fB2U,B2U. 
set ei := (nth e0 (enum E) i).  
case hcon : (connect (fun v : V => [eta Adj v]) (fste eth) (fste ei));last first.
 rewrite andbF. done. 
unfold hs_edgeB,hs_eqVB. simpl.
case h1 : (  (index (snde ei) (nu (fste ei)) ==
        index true (Poutread nu p0 (subinit (coverTree 0)) (fste ei))))=>//. 
case h2 : ((index (fste ei) (nu (snde ei)) ==
        index true (Poutread nu p0 (subinit (coverTree 0)) (snde ei))))=>//.
unfold Poutread in h1,h2. move/eqP:h1=>h1. move/eqP:h2=>h2.
 have hedge1:= (edge_fste_snde ei).
have hedge2:= (edge_fste_snde ei).
rewrite gsym Hnu in hedge2. rewrite Hnu in hedge1. 
apply index_map2 in h1=>//. 
apply index_map2 in h2=>//. 
rewrite -Hnu in hedge1;rewrite -Hnu in hedge2. 
move:h1;unfold subinit;rewrite ffunE (VtoP2 _ hedge1) (VtoP3 _ hedge1) hcon=>h1.  
move:h2;unfold subinit;rewrite ffunE (VtoP2 _ hedge2) (VtoP3 _ hedge2). 
case hcon':(connect (fun x : V => [eta Adj x]) (fste eth) (snde ei));last first.
  move/connectP:hcon'=>hcon';destruct hcon'. move/connectP:hcon=>[p hp]. 
  exists (p++(snde ei ::nil))=>//=. 
    rewrite path.cat_path hp. by rewrite -q;simpl;rewrite hedge1.
  by rewrite last_cat.
move=>h2. 
move:h1;do 2 rewrite ffunE. unfold parentFunc. 
rewrite (VtoP2 _ hedge1). rewrite (VtoP3 _ hedge1).
have := (@tF4 V Adj gsym grefl (fste eth) #|V| (fste ei)). 
have := (tF2'' grefl hcon).
have hi' : (0 < i < #|E|). 
    move/andP:hi=>[hi1 hi2];apply/andP;split=>//.
    apply/ltP. move/ltP:hi1=>hi1. apply (le_lt_trans 0 k)=>//.
    apply/leP. done. 
 case:( (tF Adj (fste eth) #|V|) (fste ei))=>/=;last first. 
   intros. move/eqP:(edge_nth_neq4 hi' h1)=>h. destruct h. by rewrite x. 

intros a _ H0 H1. move/eqP:H1=>H1. subst a. 
have H1 : ((tF Adj (fste eth) #|V|) (snde ei) <> Some (fste ei)).
 by apply (H0 _ NG _ NG).  
move:h2;do 2 rewrite ffunE. unfold parentFunc.
rewrite (VtoP2 _ hedge2). rewrite (VtoP3 _ hedge2).
move:H1. 
have:=(tF2'' grefl hcon').
case:((tF Adj (fste eth) #|V|) (snde ei))=>//=;last first.  
 intros. move/eqP:(edge_nth_neq3 hi' h2)=>h. destruct h. by rewrite x.
intros. destruct H1. move/eqP:h2->.  done. 
Qed. 

Lemma hs1 : forall res,
forall k, (k < #|E|)%coq_nat ->
~ (mu (DHS (enum V) res)) (fun a : VSt*PSt =>
      \big[(fun x : U => [eta Umult x])/1]_(k.+1 <= i < #|E|)
         finv (carac_hs_edge0 (nth e0 (enum E) i)) a) == 0.
Proof.
move=>res k hk  h0.
generalize (@Olt_antirefl  U ordU 0)=>H. destruct H. 
apply (Olt_le_trans _ ((mu (DHS (enum V) res))
         (fun a  =>
          \big[(fun x : U => [eta Umult x])/1]_(k.+1 <= i < #|E|)
             finv (carac_hs_edge0 (nth e0 (enum E) i)) a)));
 last by rewrite h0.

apply (proba_not_null (finfun (fun _ => None), subinit (coverTree 0))  _ _ 
(fun x y => if (x == y)%B   then 1 else 0));auto.

 move=>a b;case h:(a ==b);first by move/eqP:h ->. 
 move=>h';by apply Olt_neq in h'.
apply hs1_aux1.
apply hs1_aux2=>//.
Qed.





(** **** hs2 
 *)

(* e1 and e2 are two edges with one extremity in common *)
Lemma hs_loc_neigh : forall e1 e2 x, 
 (hs_edgeB e1 x) -> 
 ((fste e1 == fste e2) && (snde e1 != snde e2)) || 
 ((fste e1 == snde e2) && (snde e1 != fste e2)) ||
 ((snde e1 == fste e2) && (fste e1 != snde e2)) ||
 ((snde e1 == snde e2) && (fste e1 != fste e2)) -> 
 (hs_edgeB e2 x) = false.
Proof.
move=>e1 e2 x;unfold hs_edgeB.
set u1 := (fste e1);set v1 := (snde e1).
set u2 := (fste e2);set v2 := (snde e2).
case h3':( hs_eqVB u2 v2 x)=>//=.
case h4':(  hs_eqVB v2 u2 x)=>//=.
have hv1: (v1 \in (nu u1)) by rewrite -Hnu edge_fste_snde. 
have hu1: (u1 \in (nu v1)) by rewrite -Hnu gsym edge_fste_snde. 
have hv2: (v2 \in (nu u2)) by rewrite -Hnu edge_fste_snde. 
have hu2: (u2 \in (nu v2)) by rewrite -Hnu gsym edge_fste_snde. 
case hb1 : ((u1 == u2) && (v1 != v2))=>/=.
 move/andP:hb1 h3' hv1=>[hb1 hb1'];move/eqP:hb1->.
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h;move/andP=>[hv1 hv1'].
 have:=(index_neq_in _ (nu u2) _ _ h hb1').
 by rewrite eq_sym;rewrite hv1.
case hb2: ((u1 == v2) && (v1 != u2))=>/=.
 move/andP:hb2 h4' hv1=>[hb2 hb2'];move/eqP:hb2->.
 rewrite eq_sym in hb2'. 
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hv1.
 have:=(index_neq_in _ (nu v2) _ _ hu2 hb2').
 move/andP:hv1=>[hv1 hv1'];by rewrite hv1.
case hb3:((v1 == u2) && (u1 != v2))=>/=.
 move/andP:hb3 h3' hu1=>[hb3 hb3'];move/eqP:hb3->. rewrite eq_sym in hb3'. 
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hu1.
 have:=(index_neq_in _ (nu u2) _ _ hv2 hb3').
 by move/andP:hu1=>[hu1 hu1'];rewrite eq_sym in hu1';rewrite hu1'.
case hb4:((v1 == v2) && (u1 != u2))=>//=.
 move/andP:hb4  h4' hu1=>[hb4 hb4'];move/eqP:hb4->.
 unfold hs_eqVB;move/eqP=><-;rewrite eq_sym=>h hu1.
 have:=(index_neq_in _ (nu v2) _ _ h hb4').
 move/andP:hu1=>[hu1 hu1']. 
 by rewrite hu1'.
Qed. 

Lemma hs2 : forall k, (k < #|E|)%coq_nat ->
 forall x0 : VSt*PSt,
 carac_hs_edge0 (nth e0 (enum E) k) x0 *
 \big[(fun x1 : U => [eta Umult x1])/1]_(k.+1 <= i < #|E| | 
 (fste (nth e0 (enum E) k) == fste (nth e0 (enum E) i)) ||
 (fste (nth e0 (enum E) k) == snde (nth e0 (enum E) i)) ||
 (snde (nth e0 (enum E) k) == fste (nth e0 (enum E) i)) ||
 (snde (nth e0 (enum E) k) == snde (nth e0 (enum E) i))) 
 finv (carac_hs_edge0 (nth e0 (enum E) i)) x0 ==
 carac_hs_edge0 (nth e0 (enum E) k)  x0.
Proof.
move=>k hk x;unfold carac_hs_edge0,fB2U,B2U. 
case hsloc: (hs_edgeB (nth e0 (enum E) k) x&&
       connect (fun v : V => [eta Adj v]) (fste eth)
         (fste (nth e0 (enum E) k)) )=>//;Usimpl. 
rewrite big1_nats=>//i;auto. 
move/andP=>[h2 h1].
move/andP:hsloc=>[hsloc1 hsloc2].  
unfold finv;rewrite (hs_loc_neigh hsloc1)=>//.
move:h2;move/orP=>[h2|h3];last first.
 rewrite h3=>/=;rewrite (edge_nth_neq4 h1 h3) Bool.orb_true_r=>//.
move:h2;move/orP=>[h2|h3];last first.
 rewrite h3=>/=;rewrite (edge_nth_neq3 h1 h3) Bool.orb_true_r=>//.
move:h2;move/orP=>[h2|h3];last first.
 rewrite h3=>/=;rewrite (edge_nth_neq2 h1 h3) Bool.orb_true_r=>//.
rewrite h2=>/=;rewrite (edge_nth_neq1 h1 h2)=>//.
Qed.

(** **** hs3 
  *)

Lemma carac_hs_loc_iff : forall(e:E)(v:V)(sn:VSt*PSt)(x:VLab*seq PLab),
 carac_hs_edge0 e (VPupdate nu false v x sn) =
 match (fste e == v), (snde e == v) with
  |true, true => B2U false
  |true, false=> B2U (
           (index (snde e) (nu v) == index true
             (take (seq.size (nu v)) (x.2 ++ nseq (seq.size (nu v)) false)))
         && (index v (nu (snde e)) == index true (Poutread nu p0 sn.2 (snde e) ))
         && (connect (fun v0 : V => [eta Adj v0]) (fste eth) v))
  |false, true=> B2U (
           (index v (nu (fste e)) == index true (Poutread nu p0 sn.2 (fste e)))
         && (index (fste e) (nu v) == index true
             (take (seq.size (nu v)) (x.2 ++ nseq (seq.size (nu v)) false)))
         && (connect (fun v0 : V => [eta Adj v0]) (fste eth) (fste e)))
  |false, false => carac_hs_edge0 e sn
 end.
Proof.
move=>e v sn x;unfold carac_hs_edge0,hs_edgeB,hs_eqVB,fB2U,
B2U.
case h1:(fste  e == v)=>/=;case h2:(snde e == v);move/eqP:h1=>h1;move/eqP:
h2=>h2;
have:=(edge_fste_snde e).
 by rewrite h1 h2 grefl.
 rewrite h1 VPupdate_read_4=>//. 
 by rewrite VPupdate_read_2=>//;apply/eqP;intro;destruct h2.
 rewrite h2 VPupdate_read_4=>//.
 by rewrite VPupdate_read_2=>//;apply/eqP;intro;destruct h1.
repeat rewrite VPupdate_read_2=>//.
by apply/eqP;intro;destruct h2.
by apply/eqP;intro;destruct h1.
Qed.


Lemma hs3_aux : forall res (ek: E) (r:seq E),
 (fste ek \in (enum V)) -> (snde ek \in (enum V)) -> 
 indep (DHS (enum V) res) (carac_hs_edge0 ek)
   (fun x0 : VSt * PSt =>
    \big[(fun x1 : U => [eta Umult x1])/1]_(e <- r)
       (if ~~
           ((fste ek == fste e) ||
            (fste ek == snde e) ||
            (snde ek == fste e) ||
            (snde ek == snde e))
        then finv (carac_hs_edge0 e) x0
        else 1)).
Proof. 
move=>res ek r hek1 hek2;unfold indep,fconj.
unfold DHS. unfold DPRound. 
rewrite (@DRoundCommute2 _ _ _ _ _ _ _ _ _ _ _ _ (snde ek))=>//;last first.
 by apply disjoint_outerport.
 intros v; apply is_discrete_DHSLoc.
rewrite (@DRoundCommute2 _ _ _ _ _ _ _ _ _ _ _ _ (fste ek));last first.
 rewrite in_cons;case h:((fste ek \in seq.rem (snde ek) (enum V)));
  first by rewrite orbT.
 by rewrite orbF; apply /eqP;apply (rem_mem_not _ _ _ _ hek1);rewrite h.
 by apply disjoint_outerport.
 intro v;apply is_discrete_DHSLoc.
replace 
 (fste ek :: seq.rem (fste ek) (snde ek :: seq.rem (snde ek) (enum V))) with
 (fste ek :: (snde ek) :: seq.rem (fste ek) (seq.rem (snde ek) (enum V)));last first.
 simpl;rewrite eq_sym;case h:(fste ek == snde ek)=>//.
 by move/eqP:h (edge_fste_snde ek)->;rewrite grefl.
simpl. unfold finv. 

setoid_rewrite (fun x x0 x1 => carac_hs_loc_iff ek (fste ek) 
 (VPupdate nu false (snde ek) x0 x) x1). 
setoid_rewrite (fun x x0 => carac_hs_loc_iff ek (snde ek) x x0). 
repeat rewrite eq_refl.  
case hek: (snde ek == fste ek);first by move/eqP:hek (edge_fste_snde ek) ->;
 rewrite grefl.  
assert (forall x x0 x1, \big[(fun x2 : U => [eta Umult x2])/1]_(e <- r)
               (if ~~
                   ((fste ek == fste e) || (fste ek == snde e)
                    || (snde ek == fste e) || (snde ek == snde e))
                then
                 [1-] carac_hs_edge0 e 
                  (update [set fste ek]
                      (update [set snde ek] x.1 (Vwrite x0.1 (snde ek)))
                      (Vwrite x1.1 (fste ek)),
                   update (WriteArea (fste ek))
                     (update (WriteArea (snde ek)) x.2
                        (Pwrite nu false x0.2 (snde ek)))
                     (Pwrite nu false x1.2 (fste ek)))
                else 1) ==
               \big[(fun x2 : U => [eta Umult x2])/1]_(e <- r)
               (if ~~
                   ((fste ek == fste e) || (fste ek == snde e)
                    || (snde ek == fste e) || (snde ek == snde e))
                then
                 [1-] (carac_hs_edge0 e) x
                else 1)) as h. 
 intros;rewrite (@eq_bigrs  _ _ _ _ _ _ (fun _ => true) _ 
 (fun e =>  (if ~~
          ((fste ek == fste e) || (fste ek == snde e) || (snde ek == fste e)
           || (snde ek == snde e))
       then [1-] carac_hs_edge0 e x
       else 1)));auto.
 intros;rewrite (carac_hs_loc_iff _ _ ((update [set snde ek] x.1 [ffun=> x0.1]), 
  (update (outerport_set (snde ek)) x.2 [ffun x2 => nth false x0.2 (index 
(sndp x2) (nu (snde ek)))]))).
rewrite (carac_hs_loc_iff _ _ x).
 case h1:(fste ek == fste i)=>//.
 rewrite eq_sym in h1;rewrite h1. 
 case h2:(fste ek == snde i)=>//.
 rewrite eq_sym in h2;rewrite h2.
 case h3:(snde ek == fste i)=>//. 
 rewrite eq_sym in h3;rewrite h3. 
 case h4:(snde ek == snde i)=>//.
 rewrite eq_sym in h4;rewrite h4;auto.
setoid_rewrite h. 
do 2 setoid_rewrite mu_stable_mult_right.
do 2 setoid_rewrite mu_cte.
setoid_rewrite DHSLoc_total. 
do 2 setoid_rewrite Umult_one_right.
setoid_rewrite (fun x x0=> @VPupdate_read_4 _ _ _ Hnu Hnu2 _ _ x0 x). 
setoid_rewrite mu_stable_mult2.
rewrite mu_cte  DHS_total(Umult_sym _ 1) Umult_one_left.
by apply Umult_eq_compat.
Qed.

Lemma hs3 : forall res k, (k < #|E|)%coq_nat ->
 indep (DHS (enum V) res) (carac_hs_edge0 (nth e0 (enum E) k))
   (fun x0 : VSt*PSt =>
    \big[(fun x1 : U => [eta Umult x1])/1]_(k.+1 <= i < #|E|)
       (if ~~
           ((fste (nth e0 (enum E) k)
             == fste (nth e0 (enum E) i)) ||
            (fste (nth e0 (enum E) k)
             == snde (nth e0 (enum E) i)) ||
            (snde (nth e0 (enum E) k)
             == fste (nth e0 (enum E) i)) ||
            (snde (nth e0 (enum E) k)
             == snde (nth e0 (enum E) i)))
        then finv (carac_hs_edge0 (nth e0 (enum E) i)) x0
        else 1)).
Proof.
move=>res k H.
have h1 := (@hs3_aux res (nth e0 (enum E) k) (drop k.+1 (enum E)))
 (edge_in_V1
 (nth e0 (enum E) k)) 
  (edge_in_V2 (nth e0 (enum E)k)).
have h2 : (forall x0, eq
           (\big[(fun x1 : U => [eta Umult x1])/1]_(k.+1 <= i < #|E|)
         (if ~~
             ((fste (nth e0 (enum E) k) == fste (nth e0 (enum E) i))
              || (fste (nth e0 (enum E) k) == snde (nth e0 (enum E) i))
              || (snde (nth e0 (enum E) k) == fste (nth e0 (enum E) i))
              || (snde (nth e0 (enum E) k) == snde (nth e0 (enum E) i)))
          then finv (carac_hs_edge0 (nth e0 (enum E) i) ) x0
          else 1))
         (\big[(fun x1 : U => [eta Umult x1])/1]_(e <- 
          drop k.+1 (enum E))
             (if ~~
                 ((fste (nth e0 (enum E) k) == fste e)
                  || (fste (nth e0 (enum E) k) == snde e)
                  || (snde (nth e0 (enum E) k) == fste e)
                  || (snde (nth e0 (enum E) k) == snde e))
              then finv (carac_hs_edge0 e) x0
              else 1))).
 move=>x0;rewrite (big_nth e0) (big_addn O) size_drop.
 apply congr_big_nat=>//;first by rewrite cardE.
 move=>i/andP;move=>[_ ];move/andP=>[hi1 hi2].
 rewrite nth_drop;replace (k.+1 + i)%nat with (i + k.+1)%nat;first by trivial. 
 rewrite addSn addnS;apply eq_S;elim k=>//. 
 move=>n hn;rewrite addSn addnS;by apply eq_S.
unfold indep,fconj;setoid_rewrite h2.
done. 
Qed.

(** **** DHS_deg 
  *)
Lemma DHS_deg_aux : forall initState, 
(mu (DHS (enum V) initState)) (prodConj edge_finType
  (fun e : edge_finType => finv (fB2U
    (fun s : VSt * PSt => hs_edgeB e  s &&
         connect (fun x : V => [eta Adj x]) (fste eth) (fste e)))))
 <=
 hscte.
Proof.
move=>res.
rewrite (@Mcond_prodConj _ _ e0 _ _ (DHS_total (enum V) res) ).
rewrite (prod_le_compat _ (fun i => [1-] (mu (Mcond (DHS (enum V) res)
  (prodConjBound E e0 (fun e => finv (carac_hs_edge0 e)) i)))  
  (carac_hs_edge0 (nth e0 (enum E) i))));last first.
 move=>k hk. 
 apply (Ueq_orc ((mu (DHS (enum V) res)) (prodConjBound E e0
        (fun e : E => finv (carac_hs_edge0 e )) k))  0);auto.
apply (Ole_trans _ (prod (fun i => [1-] (mu (DHS (enum V) res)
       (carac_hs_edge0 (nth e0 (enum E) i) ))) #|E|));last first.

 apply (transitivity (prod_sigma_averagefin _ e0 
  (fun x => (mu (DHS (enum V) res)) (carac_hs_edge0 x)))). 
 apply prod_le_compat;move=>k hk;Usimpl. 
 apply U2Rp_le_simpl;rewrite -Rpsigma_U2Rp;auto.
 rewrite (Rpsigma_eq_compat _ (fun x=>  (U2Rp([1/]1+#|E|.-1) * 
 U2Rp((mu (DHS(enum V) res))(carac_hs_edge0 (nth e0(enum E) x) 
))))%Rp);
 last by move=>k' hk';apply U2Rp_mult. 
 rewrite Rpsigma_mult U2Rp_mult Rpmult_sym.
 apply Rpmult_le_compat=>//. 
  apply Rpsigma_hs=>//. 

apply prod_le_compat;move=>k hk;auto.
Usimpl;unfold prodConjBound.

have h := (Mcond_prodConjBound _ _ _ _ _ _ (fun (e :E) n => 
 (fste e == fste (nth e0 (enum E) n)) ||
 (fste e == snde (nth e0 (enum E) n)) ||
 (snde e == fste (nth e0 (enum E) n)) ||
 (snde e == snde (nth e0 (enum E) n)))
 (DHS_total (enum V) res)).
unfold prodConjBound in h. apply (@h _ (fun x => (carac_hs_edge0 x 
 ))).
apply hs1 =>//.
apply (hs2 hk).
apply (hs3 res hk).
Qed.

Lemma DHS_deg : forall initState,
 [1-] hscte
 <= (mu (DHS (enum V) initState)) (carac_hs_glob_ex).
Proof.
move=>initState.
transitivity ((mu (DHS (enum V) initState)) carac_hs_glob_ex0);last first. 
 apply mu_le_compat=>//x. 
 unfold carac_hs_glob_ex0,carac_hs_glob_ex,hs_glob_ex0,hs_glob_ex,fB2U,B2U.
 case h1:(   [exists x0,
          hs_edgeB x0 x &&
          connect (fun x1 : V => [eta Adj x1]) (fste eth) (fste x0)])=>//. 
   move/existsP:h1=>[e he1]. move/andP:he1=>[he1 he2]. 
   case h2:( [exists x0, hs_edgeB x0 x])=>//. 
   move/existsP:h2=>h2. destruct h2.  exists e.  done. 
unfold carac_hs_glob_ex0,fB2U,hs_glob_ex0.  
assert ((fun x => B2U (hs_glob_ex0 x)) ==
 fun x => finv NB2U (hs_glob_ex0 x)).
 intro x';apply NB2Uinv. 
rewrite H mu_one_inv;last apply DHS_total.
rewrite forall_exists_fB2U;repeat Usimpl;rewrite forall_prodConj_fB2U. 
by apply DHS_deg_aux.
Qed.


End Handshake.
