Add LoadPath "../prelude".
Add LoadPath "../graph".
Add LoadPath "../ra".

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun tuple.

Require Import Ensembles.

Require Import graph.
Require Import labelling. 
Require Import gen.
Require Import setSem. 
Require Import rdaTool_gen. 
Require Import handshake_spec.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.



(** * Introduction
      This files describes the proof of the following lemma:
      there is no deterministic algorithm which solves the handshake problem
 *) 

Section Witness.

(** * Description of the witness graph 
 *)
Definition Vw : finType := ordinal_finType 3.
 
Definition Adjw : rel Vw := (fun x y => x != y).

Context `(wNG: NGraph Vw Adjw).

Lemma Hv0 : 0 < 3.
Proof. auto. Qed.

Lemma Hv1 : 1 < 3.
Proof. auto. Qed.

Lemma Hv2 : 2 < 3.
Proof. auto. Qed.

Definition v0 : Vw := (Ordinal Hv0).
Definition v1 : Vw := (Ordinal Hv1).
Definition v2 : Vw := (Ordinal Hv2).

Definition sVw := ([::v0;v1;v2] ).

Definition nuw (v:Vw) :=
 match (val v) with
  |0 => (v1::v2::nil)
  |1 => (v2::v0::nil)
  |2 => (v0::v1::nil)
  |_ => nil
 end.


(** Lemmas **)
Lemma enumV1 : (enum Vw) = ord_enum 3. 
Proof. 
by rewrite enumT unlock.
Qed.

Lemma enumV : (enum Vw) = ([::v0;v1;v2] ). 
Proof.
rewrite enumV1;unfold ord_enum,iota,oapp=>/=.
repeat rewrite insubT=>/=.
have h0 : Hv0 = is_true_true by apply Eqdep_dec.UIP_dec, Bool.bool_dec.
unfold v0;rewrite h0.
have h1 : Hv1 = is_true_true by apply Eqdep_dec.UIP_dec, Bool.bool_dec.
unfold v1;rewrite h1.
have h2 : Hv2 = is_true_true by apply Eqdep_dec.UIP_dec, Bool.bool_dec.
by unfold v2;rewrite h2.
Qed.

Lemma Gind : forall (P:Vw->Prop), 
 P v0 -> P v1 -> P v2 -> 
 forall v, P v. 
Proof.
move=>P H H0 H1 v;case:v=>m i.
case:m i.
 move=>i;have h: (Hv0 = i) by  apply Eqdep_dec.UIP_dec, Bool.bool_dec.
 by rewrite -h.
move=>m;case:m=>//.
 move=>i;have h: (Hv1 = i) by  apply Eqdep_dec.UIP_dec, Bool.bool_dec.
 by rewrite -h.
move=>m;case:m=>//.
move=>i;have h: (Hv2 = i) by  apply Eqdep_dec.UIP_dec, Bool.bool_dec.
by rewrite -h.
Qed.

Lemma v012 : forall v, v == v0 \/ v == v1 \/ v == v2. 
Proof. 
apply Gind;rewrite eq_refl.
 by left. 
 by right;left.
by right; right.
Qed. 

Lemma v210 : forall v, v0 == v \/ v1 == v \/ v2 == v. 
Proof. 
apply Gind;rewrite eq_refl.
 by left. 
 by right;left.
by right; right.
Qed. 

Lemma degree_2 : forall v, deg Gr v = 2.
Proof.
move=>v;unfold deg,Nb_enum,Adjw,enum_mem.
rewrite -enumT enumV=>/=.
repeat rewrite unfold_in.
case h0 : (v == v0)=>/=.
 by move/eqP:h0=>->.
case h1 : (v == v1)=>/=.
 by move/eqP:h1=>->.
case h2 : (v == v2)=>//=.
have:=(v012 v);rewrite h0 h1 h2.  
by case;case. 
Qed. 

Lemma nu1 : forall v, uniq (nuw v).
Proof.
move=>v;unfold nuw;case:(val v)=>//.
move=>n;case:n=>//.
move=>n;case:n=>//.
Qed. 

Lemma nu2 : forall v, size (nuw v) = (deg Gr v).
Proof.
apply Gind;rewrite degree_2=>//. 
Qed.


Lemma nu3 : forall v w, Adjw v w = (w \in nuw v). 
Proof. 
move=>v;apply Gind;move:v;apply Gind=>//. 
Qed. 

(** * No algorithm 
 *)

Variables (VLabel: eqType) (PLabel:eqType).

Variables (vunit:VLabel) (lunit:PLabel).


Let VSt := LabelFunc Vw VLabel.
Let PSt := LabelFunc (@port_finType Vw Adjw) PLabel.

Variable p0 : (@port_finType Vw Adjw). 

Variable A : (hsAlgo VLabel lunit).

(** **Induction step 
 *)
Section Ind.
Variable Msigma: gen (VSt * PSt).  
Hypothesis Hsigma1 : forall s, In _ (Setsem Msigma) s -> UniformView p0 nuw s.
Hypothesis Hsigma2 : forall s, In _ (Setsem Msigma) s -> consistent p0 nuw (HsP A) s.

Let HsP0 s v := (@HsP1 _ _ _ A _ _ _ wNG _ nu3 nu1 p0 s v).


Lemma nohs00 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v0 sigma != Some v0.
Proof.
unfold assNeigh.
move:(@HsP0 sigma v0). 
case:(hsPortR p0 nuw (HsP A) sigma v0)=>//i Hi. 
have:(i < 2) by rewrite -(degree_2 v0);apply Hi. 
clear;case:i=>//=i;case:i=>//=.
Qed.

Lemma nohs10 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) : 
 assNeigh p0 nuw (HsP A) v1 sigma != Some v0.
Proof.
case h:(assNeigh p0 nuw (HsP A) v1 sigma  == Some v0)=>//.
have:=(Hsigma2 Hsig v1).
move/eqP:h=>h;rewrite h;move=>h'.
move/eqP in h'. 
apply (assNeigh1 HsP0 (nu1 v1) (nu2 v1)) in h.
apply (assNeigh1 HsP0 (nu1 v0) (nu2 v0)) in h'.
move:h h'=>/=;unfold hsPortR.
have := Hsigma1;unfold UniformView;move=>h;have:=(h sigma Hsig v0 v1).
intros [H1 [H2 H3]]=>//.
rewrite H1 H2 H3. 
by move->.
Qed.


Lemma nohs20 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v2 sigma  != Some v0.
Proof.
case h:(assNeigh p0 nuw (HsP A) v2 sigma  == Some v0)=>//.
have:=(Hsigma2 Hsig v2).
move/eqP:h=>h;rewrite h;move=>h'.
move/eqP in h'. 
apply (assNeigh1 HsP0 (nu1 v2) (nu2 v2)) in h.
apply (assNeigh1 HsP0 (nu1 v0) (nu2 v0)) in h'.
move:h h'=>/=;unfold hsPortR.
have := Hsigma1;unfold UniformView;move=>h;have:=(h sigma Hsig v0 v2).
intros [H1 [H2 H3]]=>//.
rewrite H1 H2 H3. 
by move->.
Qed.

Lemma nohs01 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v0 sigma  != Some v1.
Proof.
case h:(assNeigh p0 nuw (HsP A) v0 sigma == Some v1)=>//.
have:=(Hsigma2 Hsig v0).
move/eqP:h=>h;rewrite h;move=>h'.
move/eqP in h'. 
apply (assNeigh1 HsP0 (nu1 v1) (nu2 v1)) in h'.
apply (assNeigh1 HsP0 (nu1 v0) (nu2 v0)) in h.
move:h h'=>/=;unfold hsPortR.
have := Hsigma1;unfold UniformView;move=>h;have:=(h sigma Hsig v0 v1).
intros [H1 [H2 H3]]=>//.
rewrite H1 H2 H3. 
by move->.
Qed.

Lemma nohs11 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v1 sigma  != Some v1.
Proof.
unfold assNeigh.
move:(@HsP0 sigma v1).
case:(hsPortR p0 nuw (HsP A) sigma v1)=>//i Hi.
have:(i < 2) by rewrite -(degree_2 v1);apply Hi. 
clear;case:i=>//=i;case:i=>//=.
Qed.

Lemma nohs21 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v2 sigma  != Some v1.
Proof.
case h:(assNeigh p0 nuw (HsP A) v2 sigma  == Some v1)=>//.
have:=(Hsigma2 Hsig v2).
move/eqP:h=>h;rewrite h;move=>h'.
move/eqP in h'. 
apply (assNeigh1 HsP0 (nu1 v1) (nu2 v1)) in h'.
apply (assNeigh1 HsP0 (nu1 v2) (nu2 v2)) in h.
move:h h'=>/=;unfold hsPortR.
have := Hsigma1;unfold UniformView;move=>h;have:=(h sigma Hsig v2 v1).
intros [H1 [H2 H3]]=>//.
rewrite H1 H2 H3. 
by move->.
Qed.


Lemma nohs02 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v0 sigma != Some v2.
Proof.
case h:(assNeigh p0 nuw (HsP A) v0 sigma == Some v2)=>//.
have:=(Hsigma2 Hsig v0).
move/eqP:h=>h;rewrite h;move=>h'.
move/eqP in h'. 
apply (assNeigh1 HsP0 (nu1 v2) (nu2 v2)) in h'.
apply (assNeigh1 HsP0 (nu1 v0) (nu2 v0)) in h.
move:h h'=>/=;unfold hsPortR.
have := Hsigma1;unfold UniformView;move=>h;have:=(h sigma Hsig v0 v2).
intros [H1 [H2 H3]]=>//.
rewrite H1 H2 H3. 
by move->.
Qed.

Lemma nohs12 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v1 sigma != Some v2.
Proof.
case h:(assNeigh p0 nuw (HsP A) v1 sigma == Some v2)=>//.
have:=(Hsigma2 Hsig v1).
move/eqP:h=>h;rewrite h;move=>h'.
move/eqP in h'. 
apply (assNeigh1 HsP0 (nu1 v2) (nu2 v2)) in h'.
apply (assNeigh1 HsP0 (nu1 v1) (nu2 v1)) in h.
move:h h'=>/=;unfold hsPortR.
have := Hsigma1;unfold UniformView;move=>h;have:=(h sigma Hsig v1 v2).
intros [H1 [H2 H3]]=>//.
rewrite H1 H2 H3. 
by move->.
Qed.


Lemma nohs22 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 assNeigh p0 nuw (HsP A) v2 sigma != Some v2.
Proof.
unfold assNeigh.
move:(@HsP0 sigma v2).
case:(hsPortR p0 nuw (HsP A) sigma v2)=>//i Hi.
have:(i < 2) by rewrite -(degree_2 v2);apply Hi. 
clear;case:i=>//=i;case:i=>//=.
Qed.

Lemma nohs3 (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) : 
forall v w,
 assNeigh p0 nuw (HsP A) v sigma  != Some w.
Proof.
move=>v;apply Gind;move:v;apply Gind.
apply (nohs00 Hsig). 
apply (nohs10 Hsig). 
apply (nohs20 Hsig). 
apply (nohs01 Hsig). 
apply (nohs11 Hsig). 
apply (nohs21 Hsig). 
apply (nohs02 Hsig). 
apply (nohs12 Hsig). 
apply (nohs22 Hsig).  
Qed.

Lemma nohs (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma) :
 forall v, 
 assNeigh p0 nuw (HsP A) v sigma = None.
Proof.
move=>v;have := (nohs3 Hsig v). 
case:(assNeigh p0 nuw (HsP A) v sigma)=>//.
by move=>a h;move:(h a);rewrite eq_refl.
Qed.

Lemma NoHs (sigma:VSt*PSt) (Hsig:In _ (Setsem Msigma) sigma)   :
 ~(@hsExists _ Adjw  (fun v => assNeigh p0 nuw (HsP A) v sigma)). 
Proof.
unfold hsExists,hsBetween;move=>[v [w h]].
move/andP:h=>[h1 h2];move/andP:h1=>[h1 h3].
by rewrite (nohs Hsig v) in h3.
Qed.


Lemma Unif_aux1 : forall (y:VSt*PSt) (y' : VSt) k, 
y' = update [set v0]
            (update [set v1]
               (update [set v2] y.1 (Vwrite k.1 v2),
               update (WriteArea v2) y.2 (Pwrite nuw lunit k.2 v2)).1
               (Vwrite k.1 v1),
            update (WriteArea v1)
              (update [set v2] y.1 (Vwrite k.1 v2),
              update (WriteArea v2) y.2 (Pwrite nuw lunit k.2 v2)).2
              (Pwrite nuw lunit k.2 v1)).1 (Vwrite k.1 v0) ->
(forall v w:Vw, Vread y.1 v = Vread y.1 w) ->
forall v w : Vw,  Vread y' v = Vread y' w.
Proof. 
move=>y y' k h1 h2 v w. 
rewrite h1. 
repeat rewrite (VPupdate_read_5 nuw lunit).
have:=(v210 v). 
case hv0:(v0 == v). 
 move/eqP:hv0=>hv0 _;subst v. 
 have:=(v210 w).
 case hw0:(v0==w)=>//. 
 case hw1:(v1==w)=>//.
 case hw2:(v2==w)=>//. 
 by move=>h';destruct h' as [h'| [h' |h']].  
case hv1:(v1==v)=>//. 
 move/eqP:hv1=>hv1 _;subst v. 
 have:=(v210 w).
 case hw0:(v0==w)=>//. 
 case hw1:(v1==w)=>//.
 case hw2:(v2==w)=>//. 
 by move=>h';destruct h' as [h'| [h' |h']]. 
case hv2:(v2==v)=>//. 
 move/eqP:hv2=>hv2 _;subst v. 
 have:=(v210 w).
 case hw0:(v0==w)=>//. 
 case hw1:(v1==w)=>//.
 case hw2:(v2==w)=>//. 
 by move=>h';destruct h' as [h'| [h' |h']]. 
by move=>h';destruct h' as [h'| [h' |h']]. 
Qed.

Lemma Unif_aux2 : forall (y:VSt*PSt) (y' : PSt) k,
y' = update (WriteArea v0)
           (update [set v1]
              (update [set v2] y.1 (Vwrite k.1 v2),
              update (WriteArea v2) y.2 (Pwrite nuw lunit k.2 v2)).1
              (Vwrite k.1 v1),
           update (WriteArea v1)
             (update [set v2] y.1 (Vwrite k.1 v2),
             update (WriteArea v2) y.2 (Pwrite nuw lunit k.2 v2)).2
             (Pwrite nuw lunit k.2 v1)).2 (Pwrite nuw lunit k.2 v0) ->
(forall v w:Vw, Poutread nuw p0 y.2 v = Poutread nuw p0 y.2 w) ->
 forall v w, Poutread nuw p0 y' v = Poutread nuw p0 y' w.
Proof.
move=>y y' k h1 h2 v w;rewrite h1.
repeat rewrite VPupdate_read_6;try apply nu1;try apply nu3.
have:=(v210 v). 
case hv0:(v0 == v). 
 move/eqP:hv0=>hv0 _;subst v. 
 have:=(v210 w).
 case hw0:(v0==w)=>//.
  by move/eqP:hw0=>hw0 _;subst w.
 case hw1:(v1==w)=>//.
  by move/eqP:hw1=>hw1 _;subst w.
 case hw2:(v2==w)=>//.
  by move/eqP:hw2=>hw2 _;subst w.
 by move=>h';destruct h' as [h'| [h' |h']].
case hv1:(v1 == v). 
 move/eqP:hv1=>hv1 _;subst v. 
 have:=(v210 w).
 case hw0:(v0==w)=>//.
  by move/eqP:hw0=>hw0 _;subst w.
 case hw1:(v1==w)=>//.
  by move/eqP:hw1=>hw1 _;subst w.
 case hw2:(v2==w)=>//.
  by move/eqP:hw2=>hw2 _;subst w.
 by move=>h';destruct h' as [h'| [h' |h']].
case hv2:(v2 == v). 
 move/eqP:hv2=>hv2 _;subst v. 
 have:=(v210 w).
 case hw0:(v0==w)=>//.
  by move/eqP:hw0=>hw0 _;subst w.
 case hw1:(v1==w)=>//.
  by move/eqP:hw1=>hw1 _;subst w.
 case hw2:(v2==w)=>//.
  by move/eqP:hw2=>hw2 _;subst w.
 by move=>h';destruct h' as [h'| [h' |h']].
by move=>h';destruct h' as [h'| [h' |h']].
Qed.

Lemma Unif_aux3 : forall (y:VSt*PSt) (y' : PSt) k,
y' = update (WriteArea v0)
           (update [set v1]
              (update [set v2] y.1 (Vwrite k.1 v2),
              update (WriteArea v2) y.2 (Pwrite nuw lunit k.2 v2)).1
              (Vwrite k.1 v1),
           update (WriteArea v1)
             (update [set v2] y.1 (Vwrite k.1 v2),
             update (WriteArea v2) y.2 (Pwrite nuw lunit k.2 v2)).2
             (Pwrite nuw lunit k.2 v1)).2 (Pwrite nuw lunit k.2 v0) ->
(forall v w:Vw, Pinread nuw p0 y.2 v = Pinread nuw p0 y.2 w) ->
 forall v w, Pinread nuw p0 y' v = Pinread nuw p0 y' w.
Proof.
move=>y y' k h1 h2 v w;rewrite h1.
have:=(v210 v). 
case hv0:(v0 == v). 
 move/eqP:hv0=>hv0 _;subst v=>/=. 
 have:=(v210 w).
 case hw0:(v0==w)=>//.
  by move/eqP:hw0=>hw0 _;subst w.
 case hw1:(v1==w)=>//.
  move/eqP:hw1=>hw1 _;subst w=>/=. 
  unfold Pinread;simpl;repeat rewrite update_Plocal_iff.
  repeat rewrite in_set;repeat rewrite VtoP2=>//=.
  unfold Pwrite;repeat rewrite ffunE. 
  by repeat rewrite VtoP3.
 case hw2:(v2==w)=>//.
  move/eqP:hw2=>hw2 _;subst w=>/=. 
  unfold Pinread;simpl;repeat rewrite update_Plocal_iff.
  repeat rewrite in_set;repeat rewrite VtoP2=>//=.
  unfold Pwrite;repeat rewrite ffunE. 
  by repeat rewrite VtoP3.
 by move=>h';destruct h' as [h'| [h' |h']].
case hv1:(v1 == v). 
 move/eqP:hv1=>hv1 _;subst v=>/=. 
 have:=(v210 w).
 case hw0:(v0==w)=>//.
  move/eqP:hw0=>hw0 _;subst w=>/=. 
  unfold Pinread;simpl;repeat rewrite update_Plocal_iff.
  repeat rewrite in_set;repeat rewrite VtoP2=>//=.
  unfold Pwrite;repeat rewrite ffunE. 
  by repeat rewrite VtoP3.
 case hw1:(v1==w)=>//.
  by move/eqP:hw1=>hw1 _;subst w.
 case hw2:(v2==w)=>//.
  move/eqP:hw2=>hw2 _;subst w=>/=. 
  unfold Pinread;simpl;repeat rewrite update_Plocal_iff.
  repeat rewrite in_set;repeat rewrite VtoP2=>//=.
  unfold Pwrite;repeat rewrite ffunE. 
  by repeat rewrite VtoP3.
 by move=>h';destruct h' as [h'| [h' |h']].
case hv2:(v2 == v). 
 move/eqP:hv2=>hv2 _;subst v=>/=. 
 have:=(v210 w).
 case hw0:(v0==w)=>//.
  move/eqP:hw0=>hw0 _;subst w=>/=. 
  unfold Pinread;simpl;repeat rewrite update_Plocal_iff.
  repeat rewrite in_set;repeat rewrite VtoP2=>//=.
  unfold Pwrite;repeat rewrite ffunE. 
  by repeat rewrite VtoP3.
 case hw1:(v1==w)=>//.
  move/eqP:hw1=>hw1 _;subst w=>/=. 
  unfold Pinread;simpl;repeat rewrite update_Plocal_iff.
  repeat rewrite in_set;repeat rewrite VtoP2=>//=.
  unfold Pwrite;repeat rewrite ffunE. 
  by repeat rewrite VtoP3.
 case hw2:(v2==w)=>//.
  by move/eqP:hw2=>hw2 _;subst w.
 by move=>h';destruct h' as [h'| [h' |h']].
by move=>h';destruct h' as [h'| [h' |h']].
Qed.

Lemma UniformViewStablehs : Adet (HsR A) ->
 forall s',
 In _ (Setsem (Gbind _ _ Msigma 
    (fun x => nextState lunit (HsR A) p0 nuw sVw x))) s' ->
 UniformView p0 nuw s'.
Proof.
unfold UniformView,In,sVw;simpl.
move=> Hdet s' [y [hy1 hy2]] v w.
have:=(Hsigma1 hy1);unfold UniformView.
move: hy2 Hdet;clear;move:y.
elim:(HsR A) =>//=.
  move=> y->;intros;apply x;by repeat rewrite degree_2.
move=>a l H y [y' [hy'1 hy'2]] [hdet Hdet] H'.
apply (H y')=>//.
move:hy'1;simpl. 
move=> [r1 [[r2 [[r4 [hr41 [r6 [hr61 hr62]]]] 
 [r5 [hr51 hr52]]]] [r3 [hr31 hr32]]]].  
subst r4;subst r1;subst r2.
have hyp : (forall v w, size (nuw v) = size (nuw w)).
 intros r1 r2 ;apply ( @Gind (fun x => size (nuw x) = size (nuw r2)))=>/=; 
   apply  (@Gind (fun x => 2 = size (nuw x)))=>//=. 
have [H1 [H2 H3]] := (H' v0 v1 (hyp v0 v1)).
rewrite -H1 in hr51;clear H1. 
rewrite -H2 in hr51;clear H2.
rewrite -H3 in hr51;clear H3.
have [H1 [H2 H3]] := (H' v0 v2 (hyp v0 v2)).
rewrite -H1 in hr61;clear H1. 
rewrite -H2 in hr61;clear H2.
rewrite -H3 in hr61;clear H3.

have H1 := (Deterministic_singleton _ 
 (hdet (Vread y.1 v0)(Poutread nuw p0 y.2 v0) (Pinread nuw p0 y.2 v0))
  _ _ hr51  hr61).
subst r6.
have H1 := (Deterministic_singleton _ 
 (hdet (Vread y.1 v0)(Poutread nuw p0 y.2 v0) (Pinread nuw p0 y.2 v0))
  _ _ hr51  hr31).
subst r3.

move=>z z';split.
  apply (@Unif_aux1 y y'.1 r5)=>//.
  by rewrite hr32.
  by move=>x x';have [hx1 hx2] := (H' x x' (hyp x x')).

split.
 apply (@Unif_aux3 y y'.2 r5). 
 by rewrite hr32. 
 by move=>x1 x1';have [hx1 [hx2 hx3]] := (H' x1 x1' (hyp x1 x1')).

apply (@Unif_aux2 y y'.2 r5). 
by rewrite hr32. 
by move=>x1 x1';have [hx1 [hx2 hx3]] := (H' x1 x1' (hyp x1 x1')).
Qed.

End Ind.

Lemma NotReal : Adet (HsR A) ->
 ~ (hsRealisation A).
Proof. 
unfold hsRealisation,hsEventually=>hdet h0. 
have h:=(h0 Vw Adjw Gr wNG nuw nu3 nu1 p0).
destruct h as  [s  [h1 h2]]. 
Print reachInd. 
have h := (@reachInd _ _  
 (nextState lunit (HsR A) p0 nuw sVw) 
 (HsI A wNG)  _ s). 
destruct (fun x y => @NoHs (Greturn _ s) x y s)=>// s';
 unfold In;simpl;move=>->;clear s'. 

 apply h=>//;clear h;last by unfold sVw;rewrite -enumV.
 split.
   by apply uniformUniformView;apply (HsI2 A wNG nu3 nu1).
 move=> s0 H s' H0.  
 apply (@UniformViewStablehs (Greturn _ s0))=>//. 
 by unfold In;simpl=>s1->.

simpl. unfold In. exists s0. done. 

apply h=>//;clear h;unfold sVw;rewrite -enumV=>//.
split. 
  by apply (HsI1 A wNG nu3 nu1).
by apply (HsRind wNG nu3 nu1). 
Qed. 


End Witness.

(* NoReal : 
Graph Adjw ->
       forall (VLabel PLabel : eqType) (lunit : PLabel),
       port_finType ->
       forall A : hsAlgo VLabel lunit, Adet (HsR A) -> ~ hsRealisation A 
*)
