Require Import Ensembles. 
Require Import gen.

(** * Definition of ensemblist  semantic
  *)
Fixpoint Setsem {B: Type}(m :gen B) : Ensemble B :=
match m with 
  |Greturn b => fun x => x = b
  | Gbind  A a f => fun x => exists y, Setsem a y /\  Setsem (f y) x 
  | Grandom n f => fun x => exists i, (i <= n)%nat /\ Setsem (f i) x
end.

(** * About determinism
  *)

Lemma Deterministic_singleton {B:Type}(mb : gen B): 
 Deterministic mb ->
 forall b b', In _ (Setsem mb) b  -> In _ (Setsem mb)  b' -> b = b'.
Proof.
induction mb;simpl. 
 now unfold In;intros _ b1 b2 hb1 hb2;subst b.
 intros [H0 H1] b1 b2 [y [hy1 hy2]] [z [hz1 hz2]].
 assert (z = y).
  apply IHmb;auto.
 now subst z; apply (H y); auto.   
contradiction. 
Qed.


Lemma Setsem1 {B:Type} (s y: B) (f: B -> gen B) :
In _ (Setsem  (Gbind _ _  (Greturn _ s) f)) y <-> In _ (Setsem (f s)) y .
Proof. 
unfold In;simpl;split.
 intros [z [hz1 hz2]]. now rewrite <-hz1.
intro h. exists s;split;auto. 
Qed. 

Section reachability.
(** * Invariant
  *)

Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.

Variable B:Type.

Definition Stable (P: B -> Prop) (f: B -> gen B) :=
 forall s,  P s ->
   forall s',  In _ (Setsem (f s)) s' -> P s'.

Definition Invariant   (P: B -> Prop) (f: B -> gen B) (init : B)  :=
 P init /\ (Stable P f).

Definition reachFrom (f: B -> gen B) (init s:  B) :=
 exists n, In _ (Setsem (iter n (fun x => Gbind _ _ x f) (Greturn _ init))) s.

Lemma reachInd : forall (P:B -> Prop) (f: B -> gen B) (init: B) ,
 Invariant P f init -> 
 forall s, reachFrom f init s -> P s.
Proof.
unfold reachFrom,In. 
move=>P f init [hinit hstable] s [n hR].
elim:n f init s hR hinit hstable =>/=. 
  intros;rewrite hR;apply hinit.
move=>n hind f init s [s' [hn1 hn2]] hinit hstable.
have h := (hind _ _ _ _ hinit hstable). 
apply (hstable s').
 by apply h. 
done. 
Qed. 

End reachability.
