Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.

Require Import gen.

(** * Definition of operational semantic
  *)
Definition Op (t:Type)(A:Type) := t -> (A * t).

Definition Oreturn {t A}(a:A) : Op t A := fun g => (a, g).

Definition Obind {t A B} (m : Op t A) (f : A -> Op t B) : Op t B :=
                  fun g =>  (f (m g).1) (m g).2.

Class ORandom (t:Type)(get : nat -> Op t nat):={
  get_ok : forall n x,  ( (get n x).1 <= n)%nat
 }.

Definition Orandom (n:nat){t:Type}{get :  nat -> t -> nat * t}
                        (rand :  ORandom t get) : Op t nat := 
 get n.


Section op.

Variable (rand_t : Type)(get : nat -> rand_t -> nat * rand_t).
Context (rand : ORandom rand_t get).

Fixpoint Opsem {B: Type}(m :gen B) : Op rand_t B :=
match m with Greturn b => Oreturn b
           | Gbind _ a f => Obind (Opsem a) (fun x => (Opsem (f x)))
           | Grandom n f =>
                   Obind (Orandom n rand)
                        (fun x => Opsem (f x))
  end.

End op. 


Section generator.

(** * Definition of pseudo random number generator
  *)

Let rand_t := nat. 

Require Import div. 

Let next0 m (* modulo *)
                         a (* multiplicative coefficient *)
                         c (* constant coefficient *) 
                         (x : rand_t) : rand_t := modn  (a * x + c)%nat m.

Let phi (n: nat) (x: rand_t) (max: rand_t) :=
  (n * x)%nat %/ max.

(*  modulo m.+1 to be sure it is different from 0 *)
Let get0 m a c (n:nat) (x: rand_t)  : nat * rand_t :=
 if (n < m.+1)%nat then
    (phi n (next0 m.+1 a c x) m,   (next0 m.+1 a c x))
 else (O,O). 

Instance lcg_generator (m a c : nat) : ORandom rand_t (get0 m a c).
unfold get0,phi,next0. constructor. 
move=>n x. case hnm: (n < m.+1)%nat=>//=.
case hm : (0 < m)%nat.
 rewrite -(leq_pmul2r hm). apply (@leq_trans  (n * ((a * x + c) %% m.+1)) %nat).
   apply leq_trunc_div.
 apply leq_mul=>//.   
 by rewrite -ltnS ltn_mod.
move/negbT:hm;rewrite -eqn0Ngt;move/eqP=>hm. subst m.
by rewrite divn0.
Qed. 

(** * Tests
  *)
Example my_gen := lcg_generator (2^8.-1) 137 187.

Compute (Orandom 1 my_gen 223).  
Compute (Orandom 1 my_gen 155).
Compute (Orandom 1 my_gen 91).
Compute (phi 1 255 255).     

End generator.

