(** * Definition of randomised algorithm syntax
  *)

Inductive gen (B:Type):  Type :=
  Greturn (b:B)
| Gbind (A :Type)(a:gen  A)(f : A -> gen B) 
| Grandom (n:nat)(f : nat -> gen B).


(** * Definition of deterministic algorithms
  *)

Fixpoint Deterministic  {B:Type}(e : gen B):Prop :=
match e with 
  Greturn b => True
| Gbind A a f => Deterministic a /\ forall b, Deterministic (f b)
| _ => False
end.

