Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun choice tuple.

Require Import gen.
Require Export Cover.
Require Export Prog.
Require Export Ccpo.

Section dist.

(** * Definition of distributional semantic 
  *)

Fixpoint Distsem {B: Type}(m :gen B) : distr B :=
match m with Greturn b => Munit b
           | Gbind _ a f => Mlet (Distsem a) (fun x => (Distsem (f x)))
           | Grandom n f => Mlet (Random n) (fun x => Distsem (f x))
  end.

End dist. 
