Require Import ssreflect ssrfun ssrbool eqtype ssrnat bigop.
Require Import fintype finset fingraph seq.
Import Prenex Implicits.
Require Import my_ssr. 

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Set Implicit Arguments.


(**  
     Adjusting of bigop with Oeq 
 *)

Lemma big_mkconds : forall (R : Type) (ordR: Ccpo.ord R) 
  (idx : R) (op : R -> R -> R) 
  (I : Type) (r : seq I) (P : pred I) (F : I -> R),
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, a == b -> c == d -> op a c == op b d) ->
    Oeq  (\big[op/idx]_(i <- r | P i) F i) 
     (\big[op/idx]_(i <- r) (if P i then F i else idx)).
Proof.
move=>R ordR idx op I r P F hassoc hidl hidr hs.
elim:r;first by do 2 rewrite big_nil.
move=>t s h;repeat rewrite big_cons;case P.
 by rewrite (hs _ _ _ _ (Oeq_refl (F t)) h).
by rewrite hidl.
Qed.

Lemma big_mkcondrs :  forall (R : Type) (ordR: Ccpo.ord R) 
  (idx : R) (op : R -> R -> R) 
  (I : Type) (r : seq I) (P Q: pred I) (F : I -> R),
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, a == b -> c == d -> op a c == op b d) ->
  Oeq  (\big[op/idx]_(i <- r | P i && Q i) F i) 
     (\big[op/idx]_(i <- r | P i) (if Q i then F i else idx)).
Proof. 
move=>R ordR idx op I r P F hassoc hidl hidr hs h.
rewrite -big_filter_cond big_mkconds=>//. 
by rewrite big_filter.
Qed.

Lemma big_splits :  forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
 (I : Type) (r : seq I) (P : pred I) (F1 F2 : I -> R),
  (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
   Oeq (\big[op/idx]_(i <- r | P i) op (F1 i) (F2 i))
       (op (\big[op/idx]_(i <- r | P i) F1 i)
        (\big[op/idx]_(i <- r | P i) F2 i)).
Proof.
move=>R ordR idx op I r P F1 F2 hcomm hassoc hidl hidr hs.
elim: r;first by do 3 rewrite big_nil;rewrite hidl.
move=>t s h;repeat rewrite big_cons;case P=>//.
rewrite (hs _ _ _ _ (Oeq_refl (op (F1 t) (F2 t))) h).
repeat rewrite -hassoc;apply hs=>//.
rewrite hcomm;repeat rewrite -hassoc;apply hs=>//.
Qed.

Lemma eq_bigrs : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
 (I : Type) (r : seq I) (P : pred I) (F1 F2 : I -> R),
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
  (forall i : I, P i -> F1 i == F2 i) ->
   \big[op/idx]_(i <- r | P i) F1 i == \big[op/idx]_(i <- r | P i) F2 i.
Proof.
move=> R ordR idx op I r P F1 F2 hs eqF12. 
elim: r;first by do 2 rewrite big_nil.
move=>x r h;do 2 rewrite big_cons=>//.
case Px: (P x)=>//. 
by rewrite (hs _ _ _ _ (eqF12 _ Px) h).
Qed.


Lemma bigIDs :  forall (R : Type) (ordR: Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
 (I : Type) (r : seq I) (a P : pred I) (F : I -> R),
  (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
     (Oeq (\big[op/idx]_(i <- r | P i) F i)
          (op (\big[op/idx]_(i <- r | P i && a i) F i)
              (\big[op/idx]_(i <- r | P i && ~~ a i) F i))).
Proof.
move=>R ordR idx op I r a P F hcomm hassoc hidl hidr hs. 
rewrite (big_mkconds _ _ _ _ _ F)=>//.
have h:= (big_mkconds _ _ _ r _ F hassoc hidl hidr hs ).
rewrite (hs _ _ _ _ (h (fun i => P i && a i)) 
 (h (fun i =>P i && ~~ a i) )). 
rewrite -big_splits=>//. 
apply eq_bigrs=>//.
move=>i _;case: (a i);rewrite Bool.andb_true_r Bool.andb_false_r.
 by rewrite hidr.
by rewrite hidl.  
Qed.

Lemma big_seq1s : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R->R->R) 
  (I : Type) (i : I) (F : I -> R),
    (forall a, (Oeq (op a idx) a)) ->
     (Oeq  (\big[op/idx]_(j <- [:: i]) F j) (F i)).
Proof.
move=>R ordR idx op I i F hidr. 
rewrite unlock => /= *.
exact (hidr (F i)).
Qed.
  
Lemma big_pred1_eqs : forall (R : Type) (ordR: Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
 (I : finType) (i : I) (F : I -> R),
 (forall a, (Oeq (op a idx) a)) ->
      (Oeq (\big[op/idx]_(j | j == i) F j) (F i)).
Proof.
move=> R ordR idx op I i F hidr.
by rewrite -big_filter filter_index_enum enum1 big_seq1s.
Qed.

Lemma big_pred1s : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
 (I : finType) (i : I) (P : pred I) (F : I -> R),
 (forall a, (Oeq (op a idx) a)) ->
  P =1 pred1 i -> (Oeq (\big[op/idx]_(j | P j) F j) (F i)).
Proof. 
move=> R ordR idx op I i P F hidr.
move/(eq_bigl _ _)->. 
exact: big_pred1_eqs.
Qed.

Lemma bigD1s : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
 (I : finType) (j : I) (P : pred I) (F : I -> R),
  (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
 P j ->
 Oeq (\big[op/idx]_(i | P i) F i)
     (op (F j) (\big[op/idx]_(i | P i && (i != j)) F i)).
Proof.
move=> R ordR idx op I j P F hcomm hassoc hidl hidr hs Pj. 
rewrite (bigIDs ordR _ _ _ (pred1 j) _ _ hcomm hassoc hidl hidr hs).
apply hs=>//.
apply:big_pred1s=>//i;rewrite /=andbC; by case:eqP=>//->.
Qed.

Lemma big_catS : forall (R : Type) (ordR: Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
         (I : Type) (r1 r2 : seq I) (P : pred I) (F : I -> R),
  (forall a b c : R, op a (op b c) == op (op a b) c) ->
  (forall a : R, op idx a == a) ->
  (forall a : R, op a idx == a) ->
  (forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
       \big[op/idx]_(i <- (r1 ++ r2) | P i) F i ==
       op (\big[op/idx]_(i <- r1 | P i) F i)
         (\big[op/idx]_(i <- r2 | P i) F i).
Proof.
move=> R ordR idx op I r1 r2 P F hcomm hidl hidr hs.
have hmk := (big_mkconds _ _ _ _ P _ hcomm hidl hidr hs)=>//.
rewrite hmk (hs _ _ _ _ (hmk r1 F) (hmk r2 F)).
elim: r1 => [|i r1 IHr1].
 by rewrite big_nil hidl.
by rewrite /= !big_cons (hs _ _ _ _ (Oeq_refl (if P i then F i else idx)) IHr1).
Qed.

Lemma big_cat_nats : forall (R : Type) (ordR : Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
 (n m p : nat) (P : pred nat) (F : nat -> R),
  (forall a b c : R, op a (op b c) == op (op a b) c) ->
  (forall a : R, op idx a == a) ->
  (forall a : R, op a idx == a) ->
  (forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
       (m <= n)%nat ->
       (n <= p)%nat ->
       \big[op/idx]_(m <= i < p | P i) F i ==
       op (\big[op/idx]_(m <= i < n | P i) F i)
         (\big[op/idx]_(n <= i < p | P i) F i).
Proof.
move=> R ordR idx op n m p P F hcomm hidl hidr hs le_mn le_np;
 rewrite -big_catS=>//.
by rewrite -{2}(subnKC le_mn) -iota_add  subnDA subnKC // leq_sub2r.
Qed.



Lemma big_nat1s : forall (R : Type) (ordR : Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
         (n : nat) (F : nat -> R),
  (forall a : R, op a idx == a) -> 
 \big[op/idx]_(n <= i < n.+1) F i == F n.
Proof. 
move=> R ordR idx op n F hidl; rewrite big_ltn // big_geq //.
Qed.

Lemma big_nat_recrs : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
         (n m : nat) (F : nat -> R),
  (forall a b c : R, op a (op b c) == op (op a b) c) ->
  (forall a : R, op idx a == a) ->
  (forall a : R, op a idx == a) ->
  (forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
  (m < n.+1)%nat ->
       \big[op/idx]_(m <= i < n.+1) F i ==
       op (\big[op/idx]_(m <= i < n) F i) (F n).
Proof.
move=> R ordR idx op n m F hcomm hidl hidr hs hmn. 
rewrite (@big_cat_nats _ _ _ _ n) ?leqnSn //;auto. 
rewrite (hs _ _ _ _ _ (big_nat1s _ _ _ _ _ hidr))=>//.
Qed.

Lemma big1_nats : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R)
 (P : nat -> bool) 
     (F : nat -> R) (m n : nat),
  (forall a b c : R, op a (op b c) == op (op a b) c) ->
  (forall a : R, op idx a == a) ->
  (forall a : R, op a idx == a) ->
 (forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
   (forall i, P i && (m <= i < n) -> Oeq (F i) idx) ->
   Oeq (\big[op/idx]_(m <= i < n | P i) F i) idx.
Proof.
move=>R ordR idx op P F m n hcomm hidl hidr hs.
rewrite big_mkconds //.
elim:n m;first by move=>m;rewrite big_geq.
move=> n hn m hi;case hm:(m<n.+1)%nat;last first.
 by rewrite big_geq // ltnNge;move:hm;rewrite ltnS=>->.
rewrite big_nat_recrs //.
have hn':(@Oeq _ ordR (\big[op/idx]_(m <= i < n) (if P i then F i else idx))idx).
apply hn;move=>i/andP;move=>[h1 h2];move/andP:h2=>[h2 h3];apply hi;
 rewrite h1 h2/=;auto.
rewrite (hs _ _ _ _ hn' (Oeq_refl (if P n then F n else idx))) hidl.
case hp:(P n)=>//.
apply hi;rewrite hp (ltnSn n) -ltnS hm=>//.
Qed.


Lemma big1_eqs : forall (R : Type) (ordR: Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
         (I : Type) (r : seq I) (P : pred I),
  (forall a : R, op a idx == a) ->
 (forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
       \big[op/idx]_(<- r | [eta P]) (fun _ : I => idx) == idx.
Proof.
move=> R ordR idx op I r P hil hcomm; rewrite big_const_seq. 
elim: (count _ _) => //= n h.
assert (idx == idx)=>//.
by rewrite (hcomm _ _ _ _ H h).
Qed.

Lemma big1_seqs : forall (R: Type) (ordR: Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
         (I : eqType) (r : seq_predType I) (P : pred I) 
         (F : I -> R),
(forall a : R, op a idx == a) ->
(forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
       (forall i : I, P i && (i \in r) -> F i == idx) ->
       \big[op/idx]_(i <- r | P i) F i == idx.
Proof.
move=> R ordR idx op I r P F hil hcomm eqF1.  
rewrite big_seq_cond. 
setoid_rewrite Bool.andb_comm in eqF1. 
rewrite (eq_bigrs _ _ _ _ _ _ _ _ eqF1)=>//.
rewrite big1_eqs=>//.
Qed.

Print eq_bigl. 

Lemma eq_bigls : forall (R : Type) (ordR: Ccpo.ord R) 
 (idx : R) (op : R -> R -> R) 
         (I : Type) (r : seq I) (P1 P2 : pred I) (F : I -> R),
       P1 =1 P2 ->
       \big[op/idx]_(i <- r | P1 i) F i == \big[op/idx]_(i <- r | P2 i) F i.
Proof. 
move=> R ordR idx op I r P1 P2 F H.
rewrite (eq_bigl P1)=>//. 
Qed.  

Lemma eq_bigs : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
  (I : Type) (r : seq I) (P1 P2 : pred I) (F1 F2 : I -> R),
      (forall a b c d : R, a == b -> c == d -> op a c == op b d )->
       P1 =1 P2 ->
       (forall i : I, P1 i -> F1 i == F2 i) ->
       \big[op/idx]_(i <- r | P1 i) F1 i == \big[op/idx]_(i <- r | P2 i) F2 i.
Proof. 
move=> R ordR idx op I r P1 P2 F1 F2 H0 H1 H2.
rewrite -(eq_bigl _ _ H1);apply eq_bigrs=>//. 
Qed.


Lemma partition_bigs : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
         (I J : finType) (P : pred I) (p : I -> J) 
         (Q : pred J) (F : I -> R),
    (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
       (forall i : I, P i -> Q (p i)) ->
       \big[op/idx]_(i | P i) F i ==
       \big[op/idx]_(j | Q j) \big[op/idx]_(i | P i && (p i == j)) F i.
Proof.
move=> R ordR idx op I J P p Q F h1 h2 h3 h4 h5 Qp. 
transitivity (\big[op/idx]_(i | P i && Q (p i)) F i). 
  by apply: eq_bigls => i; case Pi: (P i); rewrite // Qp.
elim: {Q Qp}_.+1 {-2}Q (ltnSn #|Q|) => // n IHn Q.
case: (pickP Q) => [j Qj | Q0 _]; last first.
  by rewrite !big_pred0 // => i; rewrite Q0 andbF.
rewrite ltnS (cardD1x  Qj) (bigD1s _ _ _ _ j) //. 
move/IHn=> {n IHn}. move=>h. simpl in h. 
rewrite <- (h5 _ _ _ _ (Oeq_refl (\big[op/idx]_(i | P i && (p i == j)) F i)) h).
clear h.
rewrite (bigIDs _ _ _ _ (fun i => p i == j))=>//. 
apply h5=>//;apply eq_bigls=> i. 
  case: eqP => [-> | _]; rewrite !(Qj, andbF)=>//.
 by repeat rewrite andbT.  
by rewrite andbA.
Qed.

Lemma reindex_ontos : forall (R : Type) (ordR:Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
         (I J : finType) (h : J -> I) (h' : I -> J) 
         (P : pred I) (F : I -> R),
  (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
       (forall i : I, P i -> h (h' i) = i) ->
       \big[op/idx]_(i | P i) F i ==
       \big[op/idx]_(j | P (h j) && (h' (h j) == j)) F (h j).
Proof.
move=>R ordR idx op I J h h' P F h1 h2 h3 h4 h5.
move=> h'K; elim: {P}_.+1 {-3}P h'K (ltnSn #|P|) => //= n IHn P h'K.
case: (pickP P) => [i Pi | P0 _]; last first.
  by rewrite !big_pred0 // => j; rewrite P0.
rewrite ltnS (cardD1x Pi); move/IHn {n IHn} => IH.
rewrite (bigD1s _ _ _ _ _ _ _ _ _ _ _ _ Pi)=>//. 
rewrite (bigD1s _ _ _ _ (h' i))=>//;rewrite h'K ?Pi ?eq_refl //=. 
apply h5=>//. 
rewrite {}IH => [|j]; [apply: eq_bigls => j | by case/andP; auto].
rewrite andbC -andbA (andbCA (P _)); case: eqP => //= hK; congr (_ && ~~ _).
by apply/eqP/eqP=> [<-|->] //; rewrite h'K.
Qed.

Print pair_big_dep. 

Lemma pair_big_deps : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
         (I J : finType) (P : pred I) (Q : I -> pred J) 
         (F : I -> J -> R),
    (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
       \big[op/idx]_(i | P i) \big[op/idx]_(j | Q i j) F i j ==
       \big[op/idx]_(p | P p.1 && Q p.1 p.2) F p.1 p.2.
Proof.
move=>R ordR idx op I J P Q F h0 h1 h2 h3 h4.
rewrite (partition_bigs _ _ _ _ _ _ (fun p => p.1) P) =>// [|j]; last by case/andP.
apply: eq_bigrs.
 intros;apply h4=>//.
move=> i Pi.
rewrite (reindex_ontos _ _ _ _ _ (pair i) (fun p => p.2))=>//.
   by apply eq_bigls => //j; rewrite !eqxx [P i]Pi !andbT.
by case=> i' j /=; case/andP=> _ /=; move/eqP->.
Qed.

Lemma exchange_big_deps : forall (R : Type) (ordR: Ccpo.ord R)
 (idx : R) (op : R -> R -> R) 
         (I J : Type) (rI : seq I) (rJ : seq J) (P : pred I)
         (Q : I -> pred J) (xQ : pred J) (F : I -> J -> R),
  (forall a b, (Oeq (op a b) (op b a))) ->
  (forall a b c, (Oeq (op a (op b c)) (op (op a b) c))) ->
  (forall a, (Oeq (op idx a) a)) ->
  (forall a, (Oeq (op a idx) a)) ->
  (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op a c) (op b d))) ->
       (forall (i : I) (j : J), P i -> Q i j -> xQ j) ->
       \big[op/idx]_(i <- rI | P i) \big[op/idx]_(j <- rJ | Q i j) F i j ==
       \big[op/idx]_(j <- rJ | xQ j)
          \big[op/idx]_(i <- rI | P i && Q i j) F i j.
Proof.
move=>R ordR idx op I J rI rJ P Q xQ F h0 h1 h2 h3 h4.
move=> PQxQ; pose p u := (u.2, u.1).
have h := (@eq_bigrs R ordR idx op J rJ xQ _ 
 (fun i =>\big[op/idx]_(i0 < seq.size rI | P (tuple.tnth (tuple.in_tuple rI) i0) &&
                                  Q (tuple.tnth (tuple.in_tuple rI) i0) i)
         F (tuple.tnth (tuple.in_tuple rI) i0) i ) h4).
rewrite h;last first;clear h.
move=>i;rewrite (big_tnth _ _ rI _ _ )=>//.  
rewrite (big_tnth _ _ rJ).
have h := (@eq_bigrs R ordR idx op I rI P _ 
 (fun i =>\big[op/idx]_(i0 < seq.size rJ | Q i (tuple.tnth (tuple.in_tuple rJ) i0))
         F i (tuple.tnth (tuple.in_tuple rJ) i0)  ) h4).
rewrite h;last first;clear h.
move=>i;rewrite (big_tnth _ _ rJ _ _ )=>//.
rewrite big_tnth.  
rewrite !pair_big_deps=>//.
rewrite (reindex_ontos _ _ _ _ _  (p _ _) (p _ _))=>// [|[]] //=.
apply eq_bigs =>// [] [j i] //=; symmetry; rewrite eqxx andbT andb_idl //.
by case/andP; exact: PQxQ.
Qed.

Print big_morph.

Lemma big_morphs :  forall (R1 R2 : Type) (ordR1:Ccpo.ord R1) (ordR2: Ccpo.ord R2)
       (f : R2 -> R1) (id1 : R1) 
         (op1 : R1 -> R1 -> R1) (id2 : R2) (op2 : R2 -> R2 -> R2),
   (forall a b c d, (Oeq a b) -> (Oeq c d) -> (Oeq (op1 a c) (op1 b d))) ->
       (forall x y : R2, f (op2 x y) == op1 (f x) (f y)) ->
       f id2 == id1 ->
       forall (I : Type) (r : seq I) (P : pred I) (F : I -> R2),
       f (\big[op2/id2]_(i <- r | P i) F i) ==
       \big[op1/id1]_(i <- r | P i) f (F i).
Proof.
move=>R1 R2 ordR1 ordR2 f id1 op1 id2 op2 H0 h0 h1 I r P F.
rewrite unlock.
elim: r => //= i r h.
case hp:(P i)=>//=.
have h' :=(H0 (f (F i)) _  _ _ _ h).
rewrite <-h'=>//.
Qed.

Lemma big_endos : forall (R : Type) (ordR:Ccpo.ord R)
 (f : R -> R) (idx : R) (op : R -> R -> R),
     (forall a b c d : R, a == b -> c == d -> op a c == op b d) ->
       (forall x y : R, f (op x y) == op (f x) (f y)) ->
       f idx == idx ->
       forall (I : Type) (r : seq I) (P : pred I) (F : I -> R),
       f (\big[op/idx]_(i <- r | P i) F i) ==
       \big[op/idx]_(i <- r | P i) f (F i).
Proof.
move=>R ordR f idx op H0 h0 h1 I r P F.
apply(@big_morphs _ _ _ ordR _ _ _ _ _ H0 h0 h1).
Qed.

Lemma big_distrrs : forall (R : Type) (ordR: Ccpo.ord R)
 (zero : R) (times : R -> R -> R) (plus : R -> R -> R) (I : Type) 
         (r : seq I) (a : R) (P : pred I) (F : I -> R),
 (forall x y : R, times a (plus x y) == plus (times a x) (times a y)) ->
 (forall a0 b c d : R, a0 == b -> c == d -> plus a0 c == plus b d) ->
 times a zero == zero -> 
       times a (\big[plus/zero]_(i <- r | P i) F i) ==
       \big[plus/zero]_(i <- r | P i) times a (F i).
Proof.
move=>R ordR zero times plus I r a P F h0 h1 h2.
rewrite big_endos//. 
Qed.


Lemma proba_not_null2_1 : forall (A:finType) (m:distr A) (f : MF A) 
 (P: A -> A -> U),
  (0 < mu m f)%U -> 
  (forall a b, (0 < P a b)%U -> f a == f b) ->
  ~(forall (t:A), (Oeq (f t) 0%U)). 
Proof.
intros;intro.  have h := (mu_zero_eq m f H1). 
move:H. rewrite h. auto. 
Qed. 

Lemma proba_not_null_eq1 : forall (T:finType) (m:distr T) (f : MF T),
 (mu m f) ==
 (mu m (fun x => \big[Uplus/0]_y (B2U(x == y) * f y)%U)).
Proof. 
intros. apply mu_eq_compat;auto. 
intro. 
rewrite  (bigD1s _ _ _ _ x);auto. 
rewrite eq_refl. simpl. Usimpl. 
rewrite big_mkconds;auto.
assert (Oeq (\big[Uplus/0]_i (if i != x then B2U (x == i) * f i else 0))%U 
          0%U).
 assert (Oeq (\big[Uplus/0]_i (if i != x then (B2U (x == i) * f i)%U else 0))
  (\big[Uplus/0]_y ( (fun (y:T) => 0) y))).
 apply eq_bigs;auto. 
   intros. rewrite eq_sym. case h:(x==i)=>//=. 

 rewrite H. apply big1_eqs;auto.

rewrite H;auto. 
Qed.
 
Lemma mu_bigop1 : forall (T:finType) m (F:T -> T -> U), 
(mu m) (fun x : T => \big[Uplus/0]_y (F x y)) <=
 \big[Uplus/0]_y ((mu m) (fun x => (F x y))).
Proof. 
intros. elim:(index_enum T)=>//=. 
 rewrite big_nil. rewrite mu_zero_eq;auto. 
 intro. rewrite big_nil. done. 
intros. rewrite big_cons. rewrite -H.
transitivity ((mu m) (fun x : T => F x a + \big[Uplus/0]_(y <- l) F x y))%U.
 apply mu_le_compat=>//. 
 intro. rewrite big_cons. done.
apply mu_le_plus.
Qed. 

Lemma proba_not_null2_2 : forall (T:finType) (m:distr T) (f : MF T),
  0 < mu m f -> 
  ~(forall t, (f t == 0) \/ (Oeq (mu m (fun x => B2U (x==t))) 0)). 
Proof.
intros. 
intro.
move:H. rewrite proba_not_null_eq1.
intro. 
have := (mu_bigop1 _ m (fun x y => (B2U (x == y) * f y)%U)).
assert (Oeq (\big[Uplus/0]_y (mu m) (fun x : T => (B2U (x == y) * f y)%U))
(\big[Uplus/0]_y (((mu m) (fun x : T => B2U (x == y))) * f y)%U)).
 apply eq_bigs;auto. 
 intros. rewrite mu_stable_mult_right. done. 
 rewrite H1. clear H1. 
assert (Oeq (\big[Uplus/0]_y ((mu m) (fun x : T => B2U (x == y)) * f y)%U)
  (\big[Uplus/0]_y ( (fun (y:T) => 0) y))).
 apply eq_bigs;auto.
 intros. have [h| h] := (H0 i);rewrite h;auto.
rewrite H1. clear H1. rewrite big1_eqs;auto. 
intro.
apply Ule_zero_eq in H1. move:H. rewrite H1. 
auto. 
Qed.


Hypothesis dec_zero : forall x : U, {x == 0}+{~ x == 0}.

Lemma proba_not_null2 : forall  (T:finType) (t0:T) (m:distr T) (f : MF T),
  0 < mu m f -> 
  exists t, (0 < f t)%U /\ (0 < (mu m (fun x => B2U (x==t))))%U.
Proof. 
intros.
apply Decidable.dec_not_not;last first. 
intro. apply proba_not_null2_2 in H.
destruct H. intros. 
apply  Decidable.dec_not_not;last first. 
intros. 
 destruct H0. exists t. 
split;auto.
apply Decidable.dec_or.
 red;destruct (dec_zero (f t));auto.  
 red;destruct (dec_zero ((mu m) (fun x : T => B2U (x == t))));auto.
  
assert ( (exists t : T, t \in (enum T) /\ 0 < f t /\ 0 < (mu m) (fun x : T => B2U (x == t))) \/
   ~ (exists t : T, t \in (enum T) /\ 0 < f t /\ 0 < (mu m) (fun x : T => B2U (x == t))));last first. 

destruct H0. left.  destruct H0. destruct H0.  exists x. auto. 
right. intro. destruct H0. 
destruct H1. exists x. rewrite mem_enum. split;auto. 


 elim:(enum T);auto. 
  right. intro. destruct H0. destruct H0. auto. 
 intros. destruct H0. 
 left. destruct H0. exists x. destruct H0. rewrite in_cons. 
 rewrite H0;split;auto.  rewrite Bool.orb_true_r. done.

 have [h|h] := (dec_zero  (f a));last first.
  have [h'|h'] := (dec_zero (  (mu m) (fun x : T => B2U (x == a))));last first.
  left. exists a.  rewrite in_cons eq_refl;split;auto.
 right. intro. destruct H1. destruct H1. 
move:H1. rewrite in_cons. case ha: (x == a). 
 move=>_. move/eqP:ha=>ha. rewrite ha in H2.
 move:H2. rewrite h'.  move=>[h1 h2]. auto. 
 simpl. intro. destruct H0. exists x. split;auto.
 right. intro. destruct H1. destruct H1. move:H1. 
 rewrite in_cons. case ha:(x == a)=>//=. 
 move=>_. move/eqP:ha=>ha. rewrite ha in H2. 
 move:H2. rewrite h.  move=>[h1 h2];auto. 
 intro. destruct H0. exists x.  split;auto. 
Qed.
