Require Import ssreflect ssrfun ssrbool eqtype ssrnat.
Require Import fintype finset fingraph seq.
Import Prenex Implicits.


(** Lemmas to complete ssr libraries
 *)

Lemma leqMinus : forall x y, (x < y)%nat -> (x <= y - 1)%nat.
Proof.
move=> x y h;replace y with (y - 1 + 1)%nat in h. 
 by rewrite addn1 ltnS in h.
rewrite addn1 subn1;apply (ltn_predK h).
Qed.

Lemma lt_le_1 : forall (i n:nat), (i < n)%nat -> (i <= n-1)%coq_nat.
Proof.
intro;induction n;first by rewrite ltn0;discriminate.
move/ltP;rewrite subn1/=; apply Lt.lt_n_Sm_le.
Qed.


Lemma irrefl_mem : forall (F:Type) (r:rel F) (f:F), 
 irreflexive r -> f \notin (r f). 
Proof.
move=> F r f r_irr;by rewrite /in_mem /= r_irr.
Qed.



Delimit Scope seq_scope with SEQ.
Open Scope seq_scope.

Section Rem.

Variables (T : eqType) (x : T).

Lemma rem_impl (s: seq_predType T) (u v:T) : u \notin s -> u \notin (rem v s).
Proof.
elim :s=>//=t s hind.
rewrite in_cons;move/norP=>[h1 h2];case:(t==v)=>//.
rewrite in_cons;move:h1;case:(u==t)=>//_;apply (hind h2).
Qed.

Lemma rem_mem_not : forall (l:seq T) (i a:T), 
  i \in l -> i \notin seq.rem a l -> i = a.
Proof.
elim=>//=.
intros a l hind i a'.
 rewrite in_cons.  case haa:(a==a')=>//=.
 move/eqP:haa->. case hi:(i == a')=>//=.
 move/eqP:hi. done.
 move=>->. done.
rewrite in_cons. case hi : (i == a)=>//=. apply hind.
Qed.

End Rem.

Section seq.
Variables (T' : finType).
Variables (T: eqType).

Lemma index_cons : forall (v t:T) s, (t==v)=false ->
 (index v (t::s)) = (index v s) .+1.
Proof.
 intros;induction s=>/=;rewrite H=>//.
Qed. 

Lemma index_neq : forall (v u: T'),
 (v!=u) -> index v (enum T') != index u (enum T').
Proof.
move=>v;have:=(@enumP T' v);rewrite -enumT;elim : (enum T') =>[| t s hind]//.
move=>h u hvu;move:h=>/=;case htv:(t==v).
 move/eqP:htv=>->;move:hvu;case:(v==u)=>//. 
move=>h;case:(t==u);auto.
rewrite eqSS;apply hind;auto. 
Qed.

Lemma index_neq_in : forall l (x y:T'), x \in l -> 
 x != y -> index x l != index y l.
Proof.
elim=>//= z l hind x y. 
rewrite in_cons eq_sym.
case hzx:(z == x)=>//=.
 move/eqP:hzx=>hzx;subst z;case hxy:(x == y)=>//.
case hzy:(z == y)=>//=hx hxy. 
by apply hind.
Qed.  



Lemma index_set_nth : forall (v w1 w2: T') x n, 
 w1 != v -> w2 != v -> 
 index v (set_nth w1 (nseq n w2) x v) = x.
Proof.
move=>v w1 w2 x n;elim:n x=>//n.
 rewrite set_nth_nil;elim:n=>/=;first by rewrite eq_refl.
 move=>n;case:(w1==v);case:(w2==v)=>//->//.
move=>H x;elim:x=>/=;first by rewrite eq_refl.
move=>x H';move:H;case:(w1==v);case(w2==v)=>//->//.
Qed.


Lemma rem_T : forall v, v \notin (rem  v (enum T')).  
Proof.
move=>v;rewrite (mem_rem_uniq v  (enum_uniq T')).
rewrite inE/= eq_refl;auto.
Qed.

Lemma count_notin : forall (x:T) s, x \notin s -> count (pred1 x) s = O.
Proof.
move=>x s;elim:s x=>//=.
move=>t s hind x;rewrite in_cons eq_sym;case:(t==x)=>//.
apply hind. 
Qed.


Lemma index_map2 : forall (T1 T2:eqType)(f:T1 -> T2) (s:seq T1) (x:T1) (y:T2),
 x \in s -> index x s = index y [seq f i | i <- s] -> f x = y.
Proof.
move=>T1 T2 f;elim=>//=. 
move=>a l hind x y.
rewrite in_cons eq_sym. 
case hax:(a == x)=>/=.  
 move/eqP:hax=>hax. 
 subst x. 
 case hax':(f a == y)=>//=.
 by move/eqP:hax'. 
case hax':(f a == y)=>//=. 
move=>h1 h2. 
apply hind=>//. 
auto.
Qed. 
  

End seq.

Section fun1.

Require Import Arith.
Require Import Compare_dec.

Variable D : Type.
Variable def: D.
Variable i: nat.
Variable f : ordinal i -> D.

Definition funbound (j:nat) : D. 
case:(le_lt_dec i j)=>H;first exact def.
apply f;exists j;move/ltP:H=>//.
Defined.

End fun1.

Section fun2.

Variable D : Type. 
Variable g : nat -> D.
 
Definition fbound {i:nat}{j:ordinal i} := g (nat_of_ord j).

End fun2.


Lemma fbound1 : forall D (f: nat->D) i j (H : j < i),
 f j = @fbound  D f i (Ordinal H).
Proof.
auto. 
Qed.

Lemma funbound1 : forall D d i (f : ordinal i -> D)(x:ordinal i),
 f x = funbound _ d i f (nat_of_ord x).
Proof.
move=>D d i f x;unfold funbound.
case:(le_lt_dec i x).
 move/leP;by rewrite leqNgt (ltn_ord x).
move/ltP;move=>H;apply f_equal;by apply/val_eqP.
Qed. 


Lemma disjoint_set : forall (T:finType) (t v:T), t != v -> 
 disjoint (mem  [set t]) (mem [set v]).
Proof. 
intros T t v htv. 
rewrite (@eq_disjoint1 _ t). 
 rewrite in_set;auto.
intro;rewrite in_set. 
unfold pred1;by rewrite inE.
Qed. 