Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".

Require Export Cover.
Require Export Misc.
Require Export Bernoulli.
Require Export Rplus.

Require Import my_alea.

Set Implicit Arguments.
Open Local Scope U_scope.
Open Local Scope O_scope.

Section Geom.

Variable (p:U).

Instance Fgeom_mon :
  monotonic (fun (f : nat -> distr nat) (x:nat) =>
   Mif (bernoulli p) (Munit x) (f (S x))).
red;intros;intro m;apply Mif_le_compat;auto.
Defined.

Definition Fgeom : (nat -> distr nat) -m> (nat -> distr nat) :=
 mon (fun f (x:nat) => Mif (bernoulli p) (Munit x) (f (S x))).

Lemma Fgeom_simpl : forall f x,
 Fgeom f x = Mif (bernoulli p) (Munit x) (f (S x)).
Proof.
trivial.
Qed.

Lemma continuousFgeom: continuous Fgeom.
Proof.
intros h x. rewrite Fgeom_simpl.
rewrite (fcpo_lub_simpl h (S x)).
rewrite Mif_lub_eq_right.
rewrite fcpo_lub_simpl.
apply lub_le_compat.
intro n.
auto.
Qed.

Definition geom : nat -> distr nat :=
 Mfix Fgeom.


Instance Mugeom_mon : forall (q: nat -> U),
 monotonic (fun geom (x:nat) =>
  p * (q x) + [1-]p * (geom (S x))).
auto.
Qed.

Definition Mugeom (q:nat -> U) : MF nat -m> MF nat :=
 mon (fun geom (x:nat) =>
  p * (q x) + [1-]p * (geom (S x))).

Lemma Mugeom_simpl : forall (q: nat -> U) f x,
 Mugeom q f x =  p * (q x) + [1-]p * (f(S x)).
Proof.
trivial.
Qed.

Lemma Mugeom_eq : forall (q:nat -> U) (f:nat -> distr nat) (x:nat),
 mu (Fgeom f x) q == Mugeom q (fun y => mu (f y) q) x.
Proof.
intros; rewrite Mugeom_simpl;rewrite Fgeom_simpl.
rewrite Mif_eq. rewrite Munit_simpl.
rewrite Bern_true;rewrite Bern_false.
rewrite Umult_sym. auto.
Qed.

Lemma Geom_eq : forall (q: nat -> U) x,
 mu (geom x) q == mufix (Mugeom q) x.
Proof.
intros;apply Oeq_sym.
unfold geom. apply mufix_mu with (muF:=(Mugeom q))
 (q:=fun (x:nat) => q).
intros.  rewrite Mugeom_eq. auto.
Qed.

Lemma Geom_commute : forall q: nat -> U,
 mu_muF_commute_le Fgeom (fun (x:nat) => q) (Mugeom q).
Proof.
red;intros.
rewrite Mugeom_eq. auto.
Qed.


Lemma Geom_term : 0 < p -> forall x, mu (geom x) (fone nat) == 1.
Proof.
intros; transitivity (mufix (Mugeom (fone nat)) x).
 apply Geom_eq.
transitivity (lub (Uq1min ([1-]p)));last first.
 apply eq_lim_Uq1min;auto.
unfold mufix,fixp;simpl; apply lub_eq_compat.
intro n.
transitivity (Ccpo.iter (D:=MF nat) (Mugeom (fone nat)) n x);auto.
generalize x;induction n;auto.
intros; transitivity (p + (Uq1min ([1-]p)) n * [1-]p).
rewrite iterS_simpl.
rewrite Mugeom_simpl.
unfold fone;repeat Usimpl.
rewrite IHn. auto.
rewrite Uq1min_S. auto.
Qed.




Lemma geom_eq_x1 : forall n k x, (k < x)%nat ->
 iter_ (Mugeom (carac_eq k)) n x == 0.
Proof.
intro n.
induction n;simpl;auto.
intros. rewrite IHn;auto. repeat Usimpl.
unfold carac_eq,carac.
case (eq_nat_dec k x);auto.
intro. rewrite e in H.
destruct (lt_irrefl x);auto.
Qed.

Lemma geom_eq_0 :
(mu (geom 0)) (carac_eq 0) == p.
Proof.
rewrite Geom_eq;unfold mufix,fixp.
symmetry;rewrite <-(lubpcte1 p);symmetry.
apply lub_eq_compat;intro n;simpl.
induction n;simpl;auto.
rewrite geom_eq_x1;auto.
repeat Usimpl.
case (eq_nat_dec 0 0);auto.
Qed.



Lemma geom_eq_x:
 forall x,  (mu (geom x)) (carac_eq x) == p.
Proof.
intro x.
rewrite Geom_eq;unfold mufix,fixp.
symmetry;rewrite <-(lubpcte1 p);symmetry.
apply lub_eq_compat;intro n;simpl.
induction n;simpl;auto.
rewrite geom_eq_x1;auto.
repeat Usimpl.
unfold carac_eq,carac.
case (eq_nat_dec x x);auto.
Qed.

Lemma geom_eq_1 : forall x k,
((mu (geom (S x))) (carac_eq (S k))) ==
((mu (geom x)) (carac_eq k)).
Proof.
intros. do 2 rewrite Geom_eq.
unfold mufix,fixp.
apply mlub_eq_compat. intro n. simpl.
move:x k.
induction n;auto.
intros. simpl. rewrite IHn.
auto.
Qed.



Lemma geom_eq_kx :
 forall k x, (x < k)%nat ->
   mu (geom x) (carac_eq k) ==
             p * ([1-]p)^(k-x).
Proof.
induction k;intros x hx.
 by destruct (lt_n_0 x).
unfold geom.
rewrite (@Mfix_eq _ _ Fgeom (continuousFgeom) x).
rewrite Mugeom_eq. rewrite Mugeom_simpl.
unfold carac_eq,carac.
case (eq_nat_dec (S k) x);intro hkx.
 rewrite hkx in hx. by destruct (lt_irrefl x).
repeat Usimpl.
fold (carac (eq_nat_dec (S k))).
fold (carac_eq (S k)).
unfold geom in IHk.
case (eq_nat_dec x k).
 clear hx hkx. intro hkx. rewrite hkx.
 replace (S k - k)%nat with 1%nat.
 Usimpl. rewrite Umult_sym. repeat Usimpl.
 generalize (geom_eq_x (S k));unfold geom;trivial.
 clear. induction k;auto.
intro hkx2.

generalize (geom_eq_1 x k); unfold geom. intro hyp.
rewrite hyp. clear hyp.
rewrite IHk.
rewrite Umult_sym. rewrite <-Umult_assoc.
simpl. generalize hx. clear hx. case x.
  intro hx. repeat Usimpl.
  rewrite <-(minus_n_O k);rewrite Umult_sym;auto.
 intros n hx. repeat Usimpl.
 transitivity (([1-] p) ^ (S(k - S n))).
  simpl. rewrite Umult_sym;auto.
  apply Uexp_eq_compat;auto.
  rewrite NPeano.Nat.sub_succ_r.
  apply NPeano.Nat.succ_pred. intro.
   destruct (NPeano.Nat.sub_gt k n);auto.
   apply (lt_S_n _ _ hx).
  apply lt_n_Sm_le in hx. apply le_lt_eq_dec in hx.
  destruct hx;auto.
  destruct hkx2;rewrite e. trivial.
Qed.

Lemma geom_eq_k :
 forall k,
   mu (geom 0) (carac_eq k) ==
             p * ([1-]p)^k.
Proof.
intros.
case k.
repeat Usimpl;apply geom_eq_0.
intro.
rewrite geom_eq_kx;auto with arith.
Qed.

End Geom.


Open Scope Rp_scope.

Definition sumgk (x:U) (n:nat) :=
  Rpsigma (fun k => (k+1)%nat * (Rpexp x k)) n.

Set Printing Coercions.
Print sumgk.
 

Lemma sumgk_eq n : forall x, ~ (U2Rp x == R1) -> 
  sumgk x n ==
   ([1/](R1 - x)^2)%Rp * (R1 - 
 ((S(S n)) * x^(S n) - (S n)%nat * x^(S(S n)))).
Admitted. 


Lemma sumgk_lim : forall (x:U), ~ U2Rp  x == R0 ->
 islub (fun n => x * sumgk ([1-]x) n) ([1/]x).
Proof. 
Admitted.


Definition exp_geom (p:U) (n:nat):=
 Rpsigma (fun k => (k+1)%nat * (mu (geom p 0) (carac_eq k))) n.

Lemma geom_exp : forall p, (0 < p) ->
 (islub (exp_geom p) ([1/]p)%Rp).
Proof.
intros.
apply (islub_eq_compat _ _ _
 (fun n => p * (sumgk ([1-]p) n)) _ ([1/]p));auto.

 intro n. unfold sumgk. rewrite <-Rpsigma_mult.
 apply Rpsigma_eq_compat.
 intros. rewrite geom_eq_k.
 rewrite Rpmult_sym. rewrite <-Rpmult_assoc.
 apply Rpmult_eq_compat;auto.
 rewrite Rpmult_sym.
 rewrite U2Rp_mult.
 apply Rpmult_eq_compat;auto.
 rewrite U2Rp_exp.
 rewrite U2Rp_Uinv;auto.
apply (sumgk_lim).
intro. symmetry in H0. apply U2Rp_0_simpl in H0.
rewrite H0 in H. 
by destruct (Olt_antirefl p).
Qed.

Lemma pp': forall (p p':U), (0 < p) -> p <= p' ->
 [1/]p' <= [1/]p.
Proof.
intros.
apply Rp1div_le_compat;auto.
Qed.

Lemma geom_exp2 : forall p p', (0 < p) -> (0 < p') ->
 p' <= p ->
forall n, exp_geom p n <= [1/]p'.
Proof.
intros.
transitivity ([1/]p).
2: apply pp';auto.
apply le_islub. apply geom_exp.
auto.
Qed.
