Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.                      
Require Import fintype path finset fingraph finfun tuple.
Add LoadPath "../prelude".


Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction

         This file is about labelling 
 *)

Section Labelling. 

(** * Definitions 
  *)


(** 
    Locat: corresponds to the location of a label                        
    Label: the type of a label
 *)

Variables (Locat:finType) (Label: eqType).


(** 
     LabelFunc: labelling function, maps a label to a location
 *)

Definition LabelFunc := {ffun Locat -> Label}.

(** 
    newLabel finit: 
    Constructor of a LabelFunc returning (finit x) for a location x
 *)

Definition newLabel (finit: Locat -> Label) : LabelFunc :=
 finfun (fun (x:Locat) => finit x).

(** 
    update A old new:
    Update of a LabelFunc.
    If x is in A then it is updated by returning the new value from newF.
    Else it returns the old value from oldF
 *)

Definition update (A:{set Locat}) (old new: LabelFunc) : LabelFunc :=
 finfun (fun (x:Locat) => if x \in A then (new x) else (old x)).


(** * Lemmas on update
 *)
Lemma update_Plocal_iff : forall (A:{set Locat}) (D Fup:LabelFunc) (w:Locat),
 (update A D Fup) w = if (w \in A) then (Fup w) else (D w).
Proof.
move=>A D fup w;unfold update;simpl;by rewrite ffunE.
Qed.

Lemma update_Pcomm : forall (A B:{set Locat}) (D FupA FupB:LabelFunc),   
 [disjoint A & B] ->
  (update B (update A D FupA) FupB) =
  (update A (update B D FupB) FupA).
Proof.
move=>A B D FupA FupB hdisj.
unfold update;rewrite -ffunP;move=>z;do 4 rewrite ffunE.
case h1:(z \in B)=>//.
apply disjoint_setI0 in hdisj.
case h2:((z\in A) && (z \in B)).
 by rewrite -in_setI hdisj in_set0 in h2.
rewrite h1 Bool.andb_true_r in h2;by rewrite h2.
Qed.

End Labelling. 
