Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun bigop choice tuple.         

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.
Add Rec LoadPath "$ALEA_LIB/Continue".
Add LoadPath "../prelude".
Require Export Prog.
Require Export Cover.
Require Import Ccpo.
Require Import Rplus.
Require Import my_alea.
Require Import my_ssr.
Require Import my_ssralea.
Require Import graph.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.

(** * Introduction
    This file develops a relation between sum over edges and over vertices 
    in the Positive Real of Alea
 *)
 

Section half.

Generalizable Variables V Adj.
Context `(NG: NGraph V Adj).

Definition E := (@edge_finType V Adj).

Variable (e0:E). 

Lemma bigop_edge_half1 : forall (f:V->Rp),
  \big[Rpplus/R0]_(e:E) (fun a  => ((f (fste a)) * (f (snde a)))%Rp) e ==
  \big[Rpplus/R0]_v (fun a : V => 
       (\big[Rpplus/R0]_(y | Adj a y && 
                          (enum_rank a < enum_rank y)%nat ) 
                            (fun x => (f a * f x)%Rp) y ))
        v.
Proof.
move=>f.  
have h1: (forall a b c : Rp, Rpeq (Rpplus a (Rpplus b c)) 
 (Rpplus (Rpplus a b) c)).
 apply Rpplus_assoc.
have h2: (forall a : Rp, Rpeq (Rpplus R0 a) a).
 apply Rpplus_zero_left.
have h3: (forall a : Rp, Rpeq (Rpplus a R0) a).
 apply Rpplus_zero_right.
have h4: (forall a b c d : Rp, (Rpeq a b) -> (Rpeq c d) 
 -> Rpeq (Rpplus a c) (Rpplus b d)).
 move=>a b c d h h';by apply Rpplus_eq_compat. 

rewrite (partition_bigs Rpord R0 Rpplus E V
 (fun x =>true) (fun p => (fste p)) (fun x => true))=>//.   
apply eq_bigrs=>// v _.
have h : (@Oeq _ Rpord  (\big[Rpplus/R0]_(i | true && ((@fste _ Adj i) == v)) 
  (fun i => (f (fste i) * f (snde i))%Rp) i) 
 (\big[Rpplus/R0]_(i | (fste i == v) && Adj v (@snde _ Adj i) && 
            (enum_rank v < enum_rank (snde i))%nat) 
   (fun i => (f v * f (snde i))%Rp) i)).
 rewrite big_mkconds=>//;symmetry.
 rewrite big_mkconds//.
 apply eq_bigs=>//.
 move=>i _;case h:(fste i ==v)=>//. 
 move/eqP:h<-;rewrite (EdgeValP i);auto.
rewrite h;clear h.
rewrite (reindex_ontos _ _ _ _ _  (fun x => if (fste x == v) then 
 (@snde _ Adj x) else v) (fun x => VtoE v x e0))=>//.
 apply eq_bigs=>//;intro i;case hx:(fste i == v)=>//; last 
 by rewrite grefl.
 case h:( Adj v (snde i) && (enum_rank v < enum_rank (snde i))%nat)=>//=.
 move/eqP:hx<-. by rewrite VtoE1 eq_refl. 
move=>i;move/andP=>[H1 H2].
rewrite (VtoE2 _ H1 H2). 
by move/eqP:(VtoE3 e0 H1 H2).
Qed. 

Lemma bigop_edge_half2 : forall (f:V->Rp),
  (2 * \big[Rpplus/R0]_(e:E) (fun a  => (f (fste a)) * (f (snde a))) e)%Rp ==
  \big[Rpplus/R0]_v (fun a : V => ((f a) * 
       (\big[Rpplus/R0]_(y | Adj a y) (fun x => f x) y))%Rp)
        v.
Proof. 
move=>f;rewrite bigop_edge_half1. 

rewrite -(@eq_bigrs _ _ _ _ _ _ _   
 (fun i => \big[Rpplus/R0]_(i0 | Adj i i0) (f i * f i0)%Rp )
 (fun i => (f i * (\big[Rpplus/R0]_(i0 | Adj i i0) f i0))%Rp));auto;
  last first. 
 move=>i _;rewrite big_distrrs=>//;auto.
have h:(@Oeq _ Rpord (\big[Rpplus/R0]_v (\big[Rpplus/R0]_(y | Adj v y) 
 (f v * f y)%Rp)) 
 (\big[Rpplus/R0]_v  ( (\big[Rpplus/R0]_(y | Adj v y && 
 ((enum_rank v) < (enum_rank y))%nat) 
 (f v * f y)%Rp) + (\big[Rpplus/R0]_(y | Adj v y && 
 (~~((enum_rank v) < (enum_rank y))%nat) ) 
 (f v * f y)%Rp))%Rp)). 
 apply eq_bigs=>//;auto;move=>i _.  rewrite -bigIDs=>//;auto. 
rewrite h;clear h.
rewrite big_splits;auto. 
rewrite Rp_double1. apply Rpplus_eq_compat;auto.

rewrite(@exchange_big_deps _ Rpord R0 _
  _ _ (index_enum V) (index_enum V)
 (fun _ => true) 
 (fun x y => Adj x y && ~~ (enum_rank x < enum_rank y)%nat) 
 (fun _ => true))=>//;auto.
apply eq_bigs=>//;auto;move=>i _. 
apply eq_bigs=>j;last by auto with arith.
 auto. 
rewrite gsym;case h1:(Adj j i)=>//=.
symmetry;rewrite -leqNgt leq_eqVlt.
case h':((enum_rank i < enum_rank j))%nat;first by rewrite orbT. 
rewrite orbF;apply/eqP=>h.
have h'': i = j. 
 apply enum_rank_inj;by apply ord_inj.
by rewrite h'' grefl in h1.
Qed.
 
Lemma bigop_edge_R1 : forall (P Q: V-> bool)(f g:V->Rp) ( d:Rp),
(  Rpmult (count P (enum V)) d == R1) ->  
(forall v w, P v -> Adj v w -> Q w ->  ( d <= (g w))) ->
(forall v, P v -> Rpmult (f v) 
 (count (fun i : V =>  Adj v i && Q i) (enum V)) == R1) -> 
 R1 <=  \big[Rpplus/R0]_v (fun a : V => (if P a then (f a) else R0) * 
       (\big[Rpplus/R0]_(y | Adj a y) (fun x => if Q x then g x else R0) y))%Rp
        v.
Proof.
move=>P Q f g d h h' h''.
transitivity (\big[Rpplus/R0]_v (fun a : V =>
 if (P a) then d
 else R0) v).

rewrite -big_mkconds;auto. 
rewrite big_const_seq. 
unfold index_enum. rewrite -enumT.
rewrite iter_Rpplus_0. by rewrite h.

apply bigRpplusleq.
intro v;case hv: (P v)=>//.
transitivity ( Rpmult (f v)  (\big[Rpplus/R0]_(y | Adj v y && Q y) d)).
rewrite big_const_seq. unfold index_enum. rewrite -enumT.
rewrite iter_Rpplus_0. 
rewrite Rpmult_assoc. rewrite (h'' _ hv). auto.

apply Rpmult_le_compat=>//.
rewrite big_mkconds;auto.
rewrite (@big_mkconds _ _ _ _ _ _ (fun y => Adj v y));auto.
apply bigRpplusleq.
move=>w.
case h1:(Adj v w);auto. 
case h2:(Q w);auto. 
apply (h' v)=>//.
Qed. 

 
End half.
