Require Import ssreflect ssrfun ssrbool eqtype ssrnat seq.
Require Import fintype path finset fingraph finfun bigop choice tuple.

Add LoadPath "../prelude".
Require Import my_ssr.
Require Import graph.

Set Implicit Arguments.
Unset Strict Implicit.
Import Prenex Implicits.


(** * Introduction
      This file implements a breadth first search (BFS) on a graph 
      described with a set of vertices V and a edge relation Adj
 *)

Section BFS.

Variables (V:finType) (Adj:rel V).
Hypothesis gsym: forall u v, Adj u v = Adj v u.
Hypothesis grefl: forall u, Adj u u = false.
  
(**
    connected: there is a path between two vertices of the graph
 *)

Definition connected := forall (u v:V), connect Adj u v. 

(** 
     parentF f: f is a parent function of the graph
 *)

Definition parentF (f: {ffun V -> (option V)}) :=
 forall u v, f u = Some v -> Adj u v.

(** 
    Nnone v f: the set of neighbours of v which have no parent
 *)

Definition Nnone (v: V) (f: {ffun V -> (option V)}) :=
 [set x| (Adj v x) && (f x == None)].
 

(** 
    bfs n l f: the parent function made from an update of f with bfs
               where n is the number of visited nodes
               and l is the sequence of already visited nodes 
 *)

Fixpoint bfs (n: nat) (l: seq V) (f: {ffun V -> (option V)})  {struct n}
 : {ffun V -> (option V)} :=
  if n is n'.+1 then
    if l is (t::q) then
       bfs n' (cat q (enum (Nnone t f))) 
           (finfun (fun x => if (x \in (Nnone t f)) then (Some t) else (f x)))
     else f
  else f.

(**
    bfsL n lv lr: the sequence of bfs of size n
                  lv are the already visited nodes
                  lr the marked nodes which still has to be visited
 *)

Fixpoint bfsL (n: nat) (lv lr: seq V)
  {struct n} : seq V :=
  if n is n'.+1 then
    if lr is (t::q) then
       (t:: (bfsL n' (t::lv) 
                 (cat q (enum [set x| (Adj t x) && (x \notin lv) &&
                            (x \notin lr)])))) 
     else lr
  else lr.

(**
   tF v n: the parent function made from bfs where the root v has no parent
 *)
Definition tF (v:V) (n:nat):=
 finfun (fun x => if x == v then None 
          else (bfs n [::v] 
             (finfun (fun x => if x == v then Some v else None))) x).



(** * Lemmas: BFS
 *)

(** ** bfs
 *)

Lemma bfs_simpl : forall n l f, 
 bfs n.+1 l f =  if l is (t::q) then
       bfs n (cat q (enum (Nnone t f))) 
           (finfun (fun x => if (x \in (Nnone t f)) then (Some t) else (f x)))
     else f.
Proof.
auto. 
Qed. 



Lemma bfs1 n: forall l (f:{ffun V -> (option V)}) x y,
 f x = Some y -> (bfs n l f) x = Some y.
Proof.
elim:n=>//= n hind l f x y hx.
case:l=>// a l. 
apply hind;rewrite ffunE.
rewrite in_set hx. 
case hy: (Some y == None)=>//. 
by rewrite Bool.andb_false_r.
Qed.

Lemma bfs2 n: 
 forall u w (l : seq V) (f : {ffun V -> option V}),
   f u = None -> (bfs n l f) u = Some w -> Adj u w.
Proof.
elim:n=>/=. 
 by move=>u w l f->.
move=>n hind u w l f hfu.
 case:l;first by rewrite hfu.
move=>a l h.
case hu: (u \in Nnone a f);last first.
 by apply hind in h=>//;rewrite ffunE hu.
have hf: [ffun x => if x \in Nnone a f then Some a else f x] u = Some a.
 by rewrite ffunE hu.
rewrite (bfs1 _ _ hf) in h.
injection h=><-. rewrite gsym. 
by move:hu;rewrite in_set hfu eq_refl Bool.andb_true_r. 
Qed.

Lemma bfs3 n: 
 forall u  (l : seq V) (f : {ffun V -> option V}),
   f u = None -> (bfs n l f) u <> Some u.
Proof.
intros. intro. apply bfs2 in H0=>//.
move : H0. by rewrite grefl.
Qed.

   
Lemma bfs4 n : forall l x y f,
 (bfs n l f) x == Some y ->
 (bfs n.+1 l f) x == Some y.
Proof.
elim:n.
 simpl. intros. case:l=>//. 
 intros. rewrite ffunE. unfold Nnone. rewrite in_set. 
 move/eqP:H=>H. rewrite H. 
 case: (Adj a x)=>//. 
intros. simpl in H0. case:l H0. 
 simpl=>//. 
intros. apply H in H0. done. 
Qed.

Lemma bfs5 n : forall l x y (f:{ffun V -> (option V)}),
 (forall x, x \in l -> f x <> None) ->
 (bfs n l f) x = None ->
 (bfs n.+1 l f) x = Some y ->
 (bfs n l f) y <> None.
Proof.
elim:n. 
 simpl. intro. case:l=>//. intros. rewrite H0 in H1. done.
 intros. move:H1. rewrite ffunE. unfold Nnone. rewrite in_set H0 eq_refl.
 case ha: (Adj a x)=>//=. intro. injection H1. move<-.
 apply H. rewrite in_cons eq_refl. done.
intros. rewrite bfs_simpl in H1. rewrite bfs_simpl in H2.
case:l H0 H1 H2.
 simpl. intros. rewrite H1 in H2.  done. 
intros.   have h := (H _ _ _ _ _ H1 H2).
simpl. apply h. 
intros. rewrite ffunE.
case hx0: (x0 \in Nnone a f)=>//. 
move:H3. rewrite mem_cat. rewrite mem_enum. rewrite hx0. 
rewrite Bool.orb_false_r. intro. apply H0. rewrite in_cons. rewrite H3. 
rewrite Bool.orb_true_r. done. 
Qed. 

Lemma bfs6 n : forall l x (f:{ffun V -> (option V)}),
 (forall x, x \in l -> f x <> None) ->
 (bfs n l f) x = None ->
 (bfs n.+1 l f) x <> None ->
 exists y, (bfs n l f) y <> None /\
           (bfs n.+1 l f) x = Some y.
Proof.
intros.
have [y hy]: (exists y, (bfs n.+1 l f) x = Some y). 
 case: (bfs n.+1 l f x) H1=>//.  intro. exists a. done. 
exists y. split=>//.
apply/(bfs5 H H0  hy).
Qed.


Lemma bfs7 n: forall l x (f:{ffun V -> (option V)}),
 (exists v, v \in l) -> (forall x, x \notin l -> f x = None) ->
 (forall x, x \in l -> f x <> None) ->
  x \notin l ->
  (bfs n l f) x <> None -> 
  exists p, exists v, v \in l /\
            path.path (fun x y => (bfs n l f) y == Some x) v (p++[::x]) /\
            seq.size p < n /\ 
            uniq (v::x::p).
Proof.
elim:n.
 simpl;move=>l x f hl1 hl2 hl3 hxl hfx;apply hl2 in hxl.
 by rewrite hxl in hfx.
move=> n hind l x f hl1 hl2 hl3 hxl hfx;case:l hl1 hl2 hl3 hxl hfx.
 simpl;intros;destruct hl1;rewrite in_nil in H;done.
intros;move: hl1 hl2 hl3 hxl hfx;set l' := (a::l);move:l';clear a l.  
intros. 
case h1: ( (bfs n l' f) x == None );move/eqP:h1=>h1;last first.
 have [p [v [h2 [h3 [h4 h5]]]]] := (hind l' x f hl1 hl2 hl3 hxl h1).
 exists p;exists v;split=>//;split;last first.
  split=>//. 
  by rewrite ltnS;apply ltnW.
 apply (path.sub_path (fun x y =>@bfs4 n l' y x f) h3).
have [y [h2 h3]] := (bfs6 hl3 h1 hfx). 
case hy: (y \notin l');last first.
 exists nil;exists y;split=>//;case:(y \in l') hy=>//.
 rewrite cat_path;unfold path,last;rewrite h3 eq_refl.
 split=>//;split=>//;rewrite cons_uniq in_cons in_nil;simpl.
 case hyx: (y == x)=>//=;move/eqP:hyx=>hyx;rewrite hyx in h3.
 destruct (@bfs3 n.+1 x l' f)=>//;apply hl2;done.
have hy' : (f y = None). 
 apply hl2;rewrite hy;done.
have [p [v [h4 [h5 [h6 h7]]]]] := (hind l' y f hl1 hl2 hl3 hy h2).
exists (p++[::y]);exists v.
split=>//;do 2 rewrite cat_path.
rewrite cat_path in h5;move/andP:h5=>[h5 h8].
split.
 apply (sub_path (fun x y => @bfs4 n l' y x f)) in h5.
 apply (sub_path (fun x y => @bfs4 n l' y x f)) in h8.
 rewrite h5 h8 last_cat;unfold last ,path. 
 rewrite h3 eq_refl=>//.

rewrite size_cat;simpl;split=>//. 
 rewrite addn1;rewrite ltnS;done.  

rewrite cat_uniq.  
repeat rewrite mem_cat. 
repeat rewrite in_cons;rewrite mem_cat in_cons. 
repeat rewrite in_nil;simpl. 
move:h7. repeat rewrite cons_uniq.
rewrite in_cons. 
case hvy:(v == y)=>//.
case hvp:(v \in p)=>//=.
case hyp: (y \in p)=>//=.
case huniq:(uniq p)=>//= _.
case hvx: (v == x)=>//=.  
move/eqP:hvx=>hvx. apply hl2 in hxl. rewrite -hvx in hxl.
apply hl3 in h4. rewrite hxl in h4. done.
case hxy: (x == y). 
 move/eqP:hxy=>hxy. rewrite hxy in h3.
 destruct (@bfs3 n.+1 y l' f)=>//.  
case hxp: (x \in p)=>//.
have [x' hx']: (exists y, (bfs n l' f) x = Some y);last first.
 rewrite hx' in h1. done.
move:h5 hxp.  clear. elim:p v=>//=.
intros. move/andP:h5=>[h5 h6].
move:hxp.  rewrite in_cons. case hxa: (x ==a)=>/=.
 move=>_. move/eqP:hxa->. exists v. move/eqP:h5;done.
apply (H _ h6).
Qed.

Lemma bfs8 p: forall  p' n l x v (f:{ffun V -> (option V)}),
  uniq (v::x::p)-> uniq(v::x::p') ->
  path.path (fun x y => (bfs n l f) y == Some x) v (p++[::x]) ->
  path.path (fun x y => (bfs n l f) y == Some x) v (p'++[::x]) ->
  p = p'.
Proof.
apply (@last_ind _ (fun p => forall (p' : seq V) (n : nat) (l : seq V) (x v : V)
     (f : {ffun V -> option V}),
   uniq [:: v, x & p] ->
   uniq [:: v, x & p'] ->
   path (fun x0 y : V => (bfs n l f) y == Some x0) v (p ++ [:: x]) ->
   path (fun x0 y : V => (bfs n l f) y == Some x0) v (p' ++ [:: x]) ->
    p = p'))=>/=.
 elim=>//=.
 intros. move/andP:H3=>[H3 H4]. move:H4. rewrite cat_path.
 move/andP=>/=[H4]. move/andP=>[H5 _]. move/eqP:H5=>H5.
 rewrite H5 in H2. move/andP:H2=>[H2 _]. move/eqP:H2=>H2.
 injection H2=>h2. move:H1. rewrite -h2.
 rewrite in_cons. rewrite mem_last Bool.orb_true_r. done.
intros. move:H2. rewrite cat_rcons. 
change [::x;x0] with (rcons [::x] x0). 
rewrite -cat_rcons. rewrite cat_path -cats1.
move/andP=>[H2]. rewrite last_cat. simpl. move/andP=>[H4 _]. 
case/lastP:p' H1 H3.
 simpl. move/eqP:H4=>H4. rewrite H4. move=>_. 
 move/andP=>[h _]. move/eqP:h=>h. injection h=>h'. 
 move:H0. rewrite h'.  rewrite in_cons. rewrite mem_rcons. 
 rewrite in_cons. rewrite eq_refl.  rewrite Bool.orb_true_r. done.
intros. move:H3.  rewrite cat_rcons. 
change [::x1;x0] with (rcons [::x1] x0). 
rewrite -cat_rcons. rewrite -cat_rcons. rewrite cat_path -cats1.
move/andP=>[H3]. simpl. rewrite last_cat. simpl.  move/andP=>[H6 _].
rewrite cats0.
move/eqP:H6=>H6. rewrite H6 in H4. move/eqP:H4. 
intro. injection H4=>H7. rewrite H7 in H3. rewrite H7. 
rewrite cats1.
rewrite (fun x y =>H _ _ _ _ _ _ x y  H2 H3)=>//. 

move:H0. rewrite in_cons. rewrite mem_rcons.
case : (v \in x:: s)=>//=. 
 rewrite Bool.orb_true_r. done.
 rewrite rcons_uniq. case:(x \in s)=>//=. 
do 2 rewrite Bool.andb_false_r. done.
case:(uniq s)=>//. do 2 rewrite Bool.andb_false_r. done. 

move:H1. rewrite H7. rewrite in_cons. rewrite mem_rcons.
case : (v \in x:: s0)=>//=. 
 rewrite Bool.orb_true_r. done.
 rewrite rcons_uniq. case:(x \in s0)=>//=. 
do 2 rewrite Bool.andb_false_r. done.
case:(uniq s0)=>//. do 2 rewrite Bool.andb_false_r. done.
Qed.


(** ** bfsL
 *)

Lemma bfsL1 n: forall x lv, 0<n -> 
 x \in bfsL n lv [:: x].
Proof.
elim:n=>//=.
 intros. rewrite in_cons eq_refl. done.
Qed. 

Lemma bfsL2 n: forall x lv lr,  x \in lr -> 
 x \in bfsL n lv lr.
Proof.
elim:n=>//=.
 intros. case:lr H0=>//=.  
move=>a l. rewrite in_cons in_cons. case hxa:(x ==a)=>//=.
move=>hx. apply H. rewrite mem_cat. by rewrite hx. 
Qed. 


Lemma bfs_path :forall n  y (lv lr:seq V),
 #|V| <= #|lv| + n -> y \notin (lv ++ lr) -> 
[disjoint lv & lr] -> uniq lr ->
 reflect (exists x, (x \in lr)/\ (dfs_path (rgraph Adj) (lv) 
    x y ))  (y \in bfsL n lv lr).
Proof.
elim=>[|n hin] y lv lr hn hy.
  move:(max_card (predU1 y (mem (lv)))).
  case/idPn => /=.
  rewrite -ltnNge cardU1 /=.
  move:hy;rewrite mem_cat. case:(y \in lv)=>//= hy.  
  by rewrite addSn addnC.

case:lr hn hy=>[|x lr] hn hy hdisj huniq.
 rewrite in_nil. right. move=>[x [hx1 hx2]]. 
 by rewrite in_nil in hx1.

have hnI: (#|V| <= #|x::lv| + n).
 move:hdisj. rewrite disjoint_sym disjoint_cons. 
 case hx:(x \in lv)=>//=hdisj.
 by rewrite cardU1 hx /= add1n addSnnS.

case hyI: (y \in ((x :: lv)++(lr ++ enum
  [set x0 | Adj x x0 && (x0 \notin lv) & x0 \notin x :: lr]))).
 simpl. rewrite in_cons. 
 case hyx:(y == x)=>/=. 
  left. move/eqP:hyx->. exists x. rewrite in_cons eq_refl;split=>//=.
  exists nil=>//=. 
  rewrite disjoint_sym disjoint_cons in hdisj. 
  rewrite disjoint_cons. rewrite disjoint0. 
  case:(x \in lv) hdisj=>//.
 move:hyI;rewrite mem_cat in_cons. 
 move:hy;rewrite mem_cat hyx;case hy:(y \in lv)=>//=. 
 move=>hy' hy''. rewrite (bfsL2 _ _ hy'').
 left. exists x. rewrite in_cons eq_refl;split=>//=. 
 exists [::y]=>//. rewrite (eq_path (rgraphK Adj)).
 simpl. move:hy''. rewrite mem_cat mem_enum in_set.
 case:(Adj x y)=>//. move:hy'. rewrite in_cons hyx.
 case:(y \in lr)=>//. 
 repeat rewrite disjoint_cons. rewrite disjoint0 hy.
 move:hdisj. rewrite disjoint_sym disjoint_cons.
 case:(x \in lv)=>//.

have hdisjI : [disjoint (x::lv) & (lr ++ enum
                 [set x0 | Adj x x0 && (x0 \notin lv) & 
                 x0 \notin x :: lr])].
 move:hdisj. rewrite disjoint_sym. repeat rewrite disjoint_cons.
 rewrite mem_cat. intro. rewrite disjoint_sym disjoint_cat.
 rewrite mem_enum in_set. rewrite in_cons eq_refl Bool.andb_false_r. 
 move/andP:hdisj=>[hdisj1 hdisj2]. 
 rewrite hdisj2. simpl.  
 move:huniq; rewrite cons_uniq. case:(x \in lr)=>//= huniq.
 rewrite disjoint_subset.
apply/subsetP. intro a. rewrite mem_enum in_set.
 unfold predC. intro. rewrite inE. simpl. case:(a \in lv) H=>//.
 rewrite Bool.andb_false_r. done.

have huniqI : (uniq (lr++ enum [set x0 | 
  Adj x x0 && (x0 \notin lv) & x0 \notin x :: lr])).
 rewrite cat_uniq. rewrite enum_uniq. move:huniq. rewrite cons_uniq.
 case:(x \in lr)=>//. case:(uniq lr)=>//=. move=>_. 
 rewrite Bool.andb_true_r. apply/hasP.
 intros [a ]=>/=. rewrite mem_enum in_set. rewrite in_cons.
 case:(a \in lr)=>//. by rewrite Bool.orb_true_r Bool.andb_false_r.

simpl. rewrite in_cons. case hyx:(y == x)=>/=. 
  left. move/eqP:hyx->. exists x. rewrite in_cons eq_refl;split=>//=.
  exists nil=>//=. 
  rewrite disjoint_sym disjoint_cons in hdisj. 
  rewrite disjoint_cons. rewrite disjoint0. 
  case:(x \in lv) hdisj=>//.
apply: (@iffP (exists x0 : V, x0 \in (lr ++
               enum
                 [set x0 | Adj x x0 && (x0 \notin lv) & 
                 x0 \notin x :: lr]) /\
  dfs_path (rgraph Adj) (x::lv) x0 y)).

apply hin=>//=. by rewrite hyI.

 move=>[w [hw [p hp1 hp2 hp3]]].
  move:hw. rewrite mem_cat. case hw:(w \in lr)=>//=. 
  move=>_. exists w.  rewrite in_cons hw Bool.orb_true_r. 
  split=>//=. exists p=>//=.
  rewrite disjoint_cons. move:hp3. rewrite disjoint_cons. 
  rewrite in_cons. rewrite disjoint_sym disjoint_cons. 
  rewrite disjoint_sym. 
  case hwx:(w==x)=>//=.  case hw1:(w \in lv)=>//=. 
 case:(x \notin p)=>//=. 
rewrite mem_enum in_set. move/andP=>[hw1 hw2].
move/andP:hw1=>[hw1 hw3]. exists x. 
rewrite in_cons eq_refl. split=>//=.
exists (w::p)=>//=.  rewrite hp1.
unfold rgraph. rewrite mem_enum. by rewrite Bool.andb_true_r.
rewrite disjoint_cons.
rewrite disjoint_sym disjoint_cons disjoint_sym in hp3.
move/andP:hp3=>[hp3 hp4]. rewrite hp4. 
move:hdisj. rewrite disjoint_sym disjoint_cons. case:(x \in lv)=>//. 

move=>[w [hw1 [p hp1 hp2 hp3]]].
move/shortenP:hp1 hp2  => /= [[|y' p']] /= Hp' Up' Hp'p Dy. 
 rewrite -Dy in hw1. move:hw1 hy.
 rewrite mem_cat. case:(y \in lv)=>//. case:(y \in (x::lr))=>//.
 
move/andP:Hp'=>[Hp1 Hp2]. move/andP:Up'=>[Hp3 Hp4]. 
move/andP:Hp4=>[Hp4 Hp5].

case hxwp:(x \in w::y'::p');last first. 

 exists w. move:hw1. rewrite in_cons. move:hxwp. 
 rewrite in_cons eq_sym.
 case hw1:(w==x)=>//=. intros. 
 rewrite mem_cat hw0. split=>//=. 
 exists (y'::p')=>//=. 
 by rewrite Hp1.
 rewrite disjoint_sym disjoint_cons. rewrite in_cons eq_sym hw1 hxwp.
 simpl. rewrite disjoint_sym disjoint_cons disjoint_cons.
 move:hp3.  rewrite disjoint_cons. case:(w \in lv)=>//=. 
 intro. have hdisj3:( [disjoint p' & lv] ). 
  apply (@disjoint_trans _ _ (mem p))=>//=.
 apply/subsetP. intros a b. apply Hp'p. simpl. rewrite in_cons b. 
 by rewrite Bool.orb_true_r.
 rewrite hdisj3 Bool.andb_true_r. 
 case hy':(y' \in lv)=>//=.
 move:hp3. rewrite disjoint_has. move/hasP. intro H. destruct H. 
 exists y'=>//=. apply Hp'p. simpl. rewrite in_cons eq_refl. done.

pose q := (y'::p'). 
clear hin hn hy hdisj huniq hnI hyI hdisjI huniqI.  
have hp1:[disjoint p & lv]. 
 move:hp3;rewrite disjoint_cons. by case:(w \in lv)=>//.
clear hp3 hw1.
have hp2:(x \in (w::q)).
  move:hxwp. repeat rewrite in_cons.
 case:(x==w)=>//. clear hxwp. 
have hp3:(uniq q).
 unfold q. rewrite cons_uniq Hp4 Hp5. done. 
clear Hp4 Hp5.
have hp4:(w \notin q).
 done.
clear Hp3.
have hp5:(path (grel (rgraph Adj)) w q).
 simpl. rewrite Hp1 Hp2. done.
clear Hp1 Hp2.
have hp6:(y= last y q).
 done.  clear Dy. 
have hp7:(subpred (mem q) (mem p)).
 done. clear Hp'p.
have hp8:(x <> last y q).
 rewrite -hp6. intro. rewrite H eq_refl in hyx.
 done. clear hyx.  

have [a [Ha1 [Ha2 Ha3]]]: (exists a, Adj x a /\ (a \in q) /\ 
 (x \notin drop (index a q).+1 q)).

 move:hp2. rewrite in_cons. case hx:(x == w).
  move=>_. exists y'. split.
   move:hp5. unfold q;simpl. move/andP;rewrite mem_enum.
   move=>[H1 H2]. move/eqP:hx->;done.
   split.
    by rewrite in_cons eq_refl.
    case h1:(x \in drop (index y' q).+1 q)=>//.
    apply mem_drop in h1. move:hx hp4. move/eqP<-.
    rewrite h1. done.
  intro. simpl in hp2.
  exists (nth x q (index x q).+1).

 have hxq: ((index x q).+1 < size q).
  move:hp8 hp2. unfold q. clear. 
  elim:p' x y y'=>//=.
   intros x y y'. rewrite in_cons in_nil orbF.
   intros. move/eqP:hp2 hp8.
   move->. done.
  intros.  move:hp2.  rewrite in_cons eq_sym.
  case hyx:(y'==x)=>//=. intros.
  have h:= (H _ x _ hp8 hp2).
  done.
 
  split. move/pathP in hp5.
  have :=(hp5 x (index x (w::q))). rewrite rgraphK.
  rewrite nth_index=>//. rewrite index_cons. intro.
  apply x0. done. 

 by rewrite eq_sym. rewrite in_cons hp2 orbT. done.
 split. apply mem_nth.
  done. 
 rewrite index_uniq=>//. 
 move:hp3. 
 have [l1 l2]:=(splitP hp2).
 rewrite cat_uniq. move/andP=>[h1]. move/andP=>[h2 h3]. 
 move/hasP in h2. 
 rewrite index_cat. rewrite mem_rcons in_cons eq_refl.
 simpl. rewrite -cats1.
 rewrite index_cat. move:h1. rewrite rcons_uniq.
 case:(x \in l1)=>//=. intros. rewrite eq_refl.
 rewrite drop_cat.
 rewrite size_cat. simpl. rewrite addn1.
 case hsize:((size l1 + 0).+2 < (size l1) .+1)=>//.
  move:hsize. 
  replace (size l1 + 0) with (size l1)=>//.
  intro.  rewrite ltnNge in hsize.
  move:hsize.  have hsize:(size l1 < (size l1).+2)=>//.
   rewrite hsize. done.
  case h:(x \in drop ((size l1 + 0).+2 - (size l1).+1) l2)=>//.
  apply mem_drop in h. destruct h2. exists x=>//.
  simpl. rewrite mem_rcons in_cons eq_refl. done.
  
exists a.
case ha:(a \in lv).
 have ha':(a \in p) by apply hp7 =>/=.
 move:hp1. rewrite disjoint_has. 
 move/hasP. intro H'. destruct H'. exists a=>//.  
case ha':(a == x).
 move/eqP in ha'. by rewrite ha' grefl in Ha1. 
split. 
 rewrite mem_cat mem_enum in_set Ha1 in_cons ha ha'/=. 
 case:(a \in lr)=>//=.     
exists (drop (index a q).+1 q)=>//.
 move:hp5. have [l1 l2] := (splitP Ha2).
 rewrite cat_path. move/andP=>[hpath2 hpath3].
 move:hpath3. rewrite last_rcons. done.
rewrite hp6. move:Ha2. clear. elim:q y a=>//.  
 intros. simpl. 
  move:Ha2. rewrite in_cons. rewrite eq_sym. case ha:(a == a0)=>//=. 
  move=>_. move/eqP in ha. rewrite ha.  by rewrite drop0.
  intro. by apply H.
rewrite disjoint_cons disjoint_sym disjoint_cons. 
rewrite in_cons ha' ha. apply/andP. split=>//. apply/andP;split=>//. 
rewrite disjoint_sym.
apply (@disjoint_trans _ _ (mem p))=>//. 
 apply/subsetP. intros r hr. apply hp7=>/=.
 move:hr;have [l1 l2]:=(splitP Ha2). rewrite mem_cat. 
 case:(r \in l2)=>//. by rewrite orbT.
Qed.


Lemma bfsP x y : 
  reflect (exists2 p, path (Adj) x p & y = last x p) 
          (y \in bfsL #|V| [::] [::x]).
Proof.
case hxy:(y == x). 
 move/eqP:hxy=>hxy. rewrite hxy.
 rewrite bfsL1. 
   left. exists nil=>//=.
 apply/card_gt0P. exists x=>//.   
apply: (iffP (@bfs_path #|V| y nil [::x] _ _ _ _))=>//.
 replace (#|@nil V|) with (size (@nil V))=>//.
 symmetry. by apply/card_uniqP.
 
 simpl. by rewrite in_cons in_nil hxy. 

 apply disjoint0.
 
 move=>[v [hv1 [p hp1 hp2 hp3]]].
 rewrite in_cons in_nil Bool.orb_false_r in hv1.
 move/eqP:hv1=>hv1. rewrite -hv1. 
 rewrite (eq_path (rgraphK Adj)) in hp1. 
 exists p=>//.
  
 move=>[p hp1 hp2]. simpl. 
 exists x. rewrite in_cons in_nil eq_refl. split=>//.
simpl. exists p=>//=. 
 rewrite (eq_path (rgraphK Adj))=>//. 
by rewrite disjoint_sym disjoint_has.
Qed.

Lemma bfsL3 n: forall l lv (f:{ffun V -> (option V)})  x,
 (forall x, (x \in l \/ x \in lv) <-> f x <> None) ->
  x \in (bfsL n lv l) ->
 (bfs n l f) x <> None.
Proof.
elim:n=>//. 
intros. simpl. rewrite -(H x). left=>//.
intros. simpl. move:H0 H1. simpl.  case:l=>//=. intros. 
rewrite in_cons in H1. move/orP:H1=>[H1 | H1].
 move/eqP:H1=>H1. rewrite H1. 
 have:(exists y,  [ffun x0 => if x0 \in Nnone a f then Some a else f x0] a = Some y). 
  rewrite ffunE. case ha:(a \in Nnone a f)=>//. exists a=>//.  
  have:=(H0 a). rewrite in_cons eq_refl. simpl. 
  case:(f a)=>//. intros. exists a0. done. 
  intros. have:((@None V) <> None). rewrite -x0. left. done. 
 done.  intros [y hy]. rewrite (bfs1 _ _ hy). done.
have hs: ( [set x | Adj a x && (x \notin lv) & x \notin a :: l] = 
 ( (Nnone a f))).
 unfold Nnone.  rewrite -setP. intro. repeat rewrite in_set. 
 case:(Adj a x0)=>//=.
have:=(H0 x0).  rewrite or_comm. 
 rewrite -Bool.orb_true_iff. 
 case h1:(x0 \in lv)=>//=.  case h2:(f x0 == None)=>//=. 
 intro. move/eqP:h2. intro. rewrite h2 in H2. 
 destruct H2. have h3:(true = true). auto. apply H2 in h3. done.
 case h2:(x0 \in a::l)=>//=. case h3:(f x0 == None)=>//=. 
 intros. move/eqP:h3=>h3. rewrite h3 in H2. have h:(true = true). 
 auto. move:h. rewrite H2. done. 
 case h3:(f x0 == None)=>//. 
 move/eqP:h3.  intros. move:h3. rewrite -H2. done. 
rewrite -hs. apply (H _ (a::lv)) =>//.
intros. rewrite ffunE.
case h1: (x0 \in [set x1 | Adj a x1 && 
  (x1 \notin lv) & x1 \notin a :: l]). 
rewrite in_set in h1. move/andP:h1=>[h1 h2].
move/andP:h1=>[h1 h3].
rewrite mem_cat. rewrite mem_enum in_set.
rewrite h1 h3 h2. repeat rewrite Bool.andb_true_r. 
rewrite Bool.orb_true_r.
split=>//.  by left. 

rewrite mem_cat. rewrite mem_enum.  rewrite h1. 
rewrite Bool.orb_false_r.  rewrite -H0.
repeat rewrite in_cons.
case:(x0 == a). 
 split=>//. by left. by right. 
simpl. done. 
Qed. 


(** ** tF
 *)

Lemma tF1 :  forall v n, (tF v n) v = None.
Proof. 
move=>v n;unfold tF. 
by rewrite ffunE eq_refl.
Qed.

Lemma tF2 : forall v x, connected -> (tF v #|V|) x = None -> x = v.
Proof.
unfold tF;intros v x Hc.
rewrite ffunE. case h:(x == v). 
 by move/eqP:h->.
intro.
have hx: (x \in bfsL #|V| [::] [:: v]).
 apply/bfsP. 
 have:=(Hc v x). move/dfsP. move=>[p [hp hp']].
 rewrite (eq_path (rgraphK Adj)) in hp.
 exists p=>//.  
 destruct (@bfsL3 #|V| [::v] nil 
 [ffun x => if x == v then Some v else None] x)=>//=.
intro y. rewrite in_cons in_nil ffunE.
case hy:(y ==v)=>/=;split=>//.  
 by left.
by move=>[h' | h'].
Qed. 

Lemma tF2'' : forall v x, 
 connect (fun x : V => [eta Adj x]) v x -> (tF v #|V|) x = None -> x = v.
Proof.
unfold tF;intros v x Hc.
rewrite ffunE. case h:(x == v). 
 by move/eqP:h->.
intro.
have hx: (x \in bfsL #|V| [::] [:: v]).
 apply/bfsP. 
 move:Hc. move/dfsP. move=>[p [hp hp']].
 rewrite (eq_path (rgraphK Adj)) in hp.
 exists p=>//.  
 destruct (@bfsL3 #|V| [::v] nil 
 [ffun x => if x == v then Some v else None] x)=>//=.
intro y. rewrite in_cons in_nil ffunE.
case hy:(y ==v)=>/=;split=>//.  
 by left.
by move=>[h' | h'].
Qed. 

Lemma tF3 : forall v n, parentF (tF v n).
Proof.
unfold parentF, tF;move=>v n u w. 
rewrite ffunE. 
case huv: (u == v)=>//.
set l := [::v]. 
set f:=  [ffun x => if x == v then Some v else None].
have : (f u = None) by rewrite ffunE huv.
move:l f.
apply bfs2. 
Qed.

Lemma tF4 : forall v n x y, (tF v n) x = Some y -> (tF v n) y <> Some x.
Proof.
unfold tF. intros v n x y. repeat rewrite ffunE.
case hxv: (x == v)=>//=.
case hyv:(y ==v)=>//=.
set l:=[::v]. set f:=  [ffun x0 => if x0 == v then Some v else None].
intros.
have hxy : (bfs n l f) x <> None.
 move:H;case:(bfs n l f x)=>//.

intro. have hyx: (bfs n l f) y <> None.
 move:H0;case:(bfs n l f y)=>//.

have h1 : (exists v : V, v \in l).
 exists v. by rewrite in_cons eq_refl.
have h2 : (forall x : V, x \notin l -> f x = None).
 intro. rewrite in_cons in_nil. case h2: (x0 == v)=>//.
 move=>_. rewrite ffunE h2. done.
have h3 : (forall x : V, x \in l -> f x <> None).
 intro. rewrite in_cons in_nil. case h3:(x0==v)=>//.
 move/eqP:h3->. rewrite ffunE eq_refl. done.

have h4 : x \notin l.
 rewrite in_cons in_nil. rewrite hxv. done.
have h4' : y \notin l.
 rewrite in_cons in_nil. rewrite hyv. done.
 
have [p [z [hp1 [hp2 [hp3 hp4]]]]]:= (bfs7 h1 h2 h3 h4 hxy).
have [p' [z' [hp1' [hp2'' [hp3' hp4']]]]]:= (bfs7 h1 h2 h3 h4' hyx).
have hz: (z = z'). 
 move:hp1;rewrite in_cons in_nil. case hz:(z == v)=>//.
 move/eqP:hz->. move:hp1'. rewrite in_cons in_nil. case hz:(z' == v)=>//.
 move/eqP:hz->. done.
 
rewrite -hz in hp1' hp2'' hp3' hp4'. clear hz z'. 
rewrite cat_path in hp2''. move/andP:hp2''=>[hp2'' hp2'''].
simpl in hp2'''. move/andP:hp2'''=>[H1 _]. 
move/eqP:H1=>H1. rewrite H1 in H0. injection H0=>hxp'. 
clear H0. 
have : (p' = p++[::x]). 
 move:hxp' hp4 hp2 hp2'' hp4'. clear. 
 case/lastP:p'. 
  simpl=>->. rewrite in_cons eq_refl. done. 
 intros. rewrite cats1.  rewrite last_rcons in hxp'.  rewrite hxp'. 
 rewrite -cats1 in hp2''. rewrite hxp' in hp2''.     
 rewrite (fun x y => bfs8 x y hp2 hp2'')=>//.
 move:hp4'. rewrite hxp'. repeat rewrite cons_uniq.
 repeat rewrite rcons_uniq.  
 repeat rewrite in_cons. repeat rewrite mem_rcons. rewrite in_cons.  
 case hzx:(z == x)=>//=.  rewrite Bool.orb_true_r. 
 done.
 case: (z == y)=>//=.  case:(z \in s)=>//=.
 case:(x \in s)=>//=.  rewrite Bool.andb_false_r. 
 done. case:(uniq s)=>//.  rewrite Bool.andb_false_r. 
 done.
intro pp'.    

rewrite cat_path in hp2. move/andP:hp2=>[hp2 hp2'].
simpl in hp2'. move/andP:hp2'=>[H2 _]. 
move/eqP:H2=>H2. rewrite H2 in H. injection H=>hyp.
move:hp4'. rewrite cons_uniq. move/andP=>[h]. 
rewrite cons_uniq. move/andP=>[h' h'']. move:h'. 
rewrite pp'. rewrite mem_cat.
rewrite in_cons in_nil. rewrite Bool.orb_false_r.
case hyx':(y == x)=>//. rewrite Bool.orb_true_r. done.
rewrite Bool.orb_false_r.     
rewrite -hyp. case:p hp3 hp4 pp' hp2 H2 H hyp=>//=;last first. 
intros. rewrite mem_last in h'. done.
intros a1. rewrite in_cons in_nil. rewrite Bool.orb_false_r. 
rewrite Bool.andb_true_r. move=>a2 a3 _ a4 _ a5. 
rewrite a5 in h. move:h.  rewrite in_cons eq_refl.
done. 
Qed.

End BFS. 

Section BFS2.
Variables (V:finType) (Adj:rel V).
Hypothesis gsym: forall u v, Adj u v = Adj v u.
Hypothesis grefl: forall u, Adj u u = false.

Lemma tF2' : forall (P:V->bool),
 (forall u v, P u -> P v -> connect (fun x y => P x && P y && Adj x y) u v) ->
 forall v x, P v -> P x -> 
  (tF (fun x y => P x && P y && Adj x y) v #|V|) x = None -> x = v.
Proof.
intros P Hc v x hv1 hv2.
unfold tF. 
rewrite ffunE. case h:(x == v). 
 by move/eqP:h->.
intro.
have hx: (x \in bfsL (fun x y => P x && P y && Adj x y) #|V| [::] [:: v]).
 apply/bfsP. 
   by intro u;rewrite grefl andbF. 
 have:=(Hc v x hv1 hv2). move/dfsP. move=>[p [hp hp']].
 rewrite (eq_path (rgraphK (fun x y => P x && P y && Adj x y))) in hp.
 exists p=>//.  
destruct (@bfsL3 V ( fun x y => P x && P y && Adj x y) #|V| [::v] nil 
 [ffun x => if x == v then Some v else None] x)=>//=.
intro y. rewrite in_cons in_nil ffunE.
case hy:(y ==v)=>/=;split=>//.  
 by left.
by move=>[h' | h'].
Qed. 


End BFS2.
