(* In collaboration with P. Casteran.

    A serie of simple examples with dice *)

Add Rec LoadPath "$ALEA_LIB/ALEA/src" as ALEA.

Require Export Prog.
Require Export Cover.
Require Import Ccpo.

Set Implicit Arguments.
Open Local Scope U_scope.

Notation "[1/6]" := ([1/]1+5).         

(*  Let us throw two dice and compute the sum *)

Definition throw_dice :=
 Mlet (Random 5) 
  (fun k => Mlet (Random 5)
    (fun k' => Munit (2 + k + k')%nat)).


(* Simplification *)
 
Lemma throw_dice_simpl0 (f: MF nat):
  mu throw_dice f == sigma (fun i => [1/]1+5 * 
                       sigma (fun j => [1/]1+5 * f (2 + i + j)%nat) 6) 6.
Proof.
unfold throw_dice.
rewrite Mlet_simpl. 
setoid_rewrite (fun x =>  Mlet_simpl _ (fun k' : nat => Munit (2 + x + k')%nat)).
setoid_rewrite  (fun x x0 => Munit_simpl _ (2+ x + x0)%nat). 
rewrite Random_simpl.
rewrite random_simpl. 
apply sigma_eq_compat ;intros k Hk.
rewrite random_simpl. 
apply Umult_eq_compat; trivial.
Qed.


Lemma throw_dice_simpl (f: MF nat) :
  mu throw_dice f == sigma (fun i => 
                       sigma (fun j => [1/]1+35  * f (2 + i + j)%nat) 6) 6.
Proof.
rewrite throw_dice_simpl0.
apply sigma_eq_compat; intros k Hk.
rewrite <- sigma_mult;auto.
apply sigma_eq_compat;intros  l Hl. 
rewrite Umult_assoc.
rewrite   Umult_Unth.
reflexivity.
Qed.


(* Probability to obtain 11 *)

Lemma throw_dice_11 : 
 (mu throw_dice) (carac (eq_nat_dec 11)) == (2 */[1/]1+35)%U. 
Proof.
rewrite throw_dice_simpl;do 2 rewrite sigma_S_lift;unfold carac;simpl. 
repeat Usimpl;auto.
Qed.


(* Probability to obtain 7 *)

Lemma throw_dice_7 : 
 mu throw_dice (carac (eq_nat_dec 7)) == 6 */ [1/]1+35. 
Proof.
rewrite throw_dice_simpl;do 2 rewrite sigma_S_lift;unfold carac;simpl.
repeat Usimpl;auto. 
Qed.


(* Now we want to obtain 7 or 11 *)

Definition disjoint {A}(P Q:set A):= 
   forall x, P x -> Q x -> False.

(* fplusok : the sum is feasible (not greater than 1) *)

Lemma fplus_ok_carac{A} : forall P Pdec Q Qdec, disjoint P Q ->
                   fplusok (@carac A P Pdec) (@carac A Q Qdec).
Proof. 
intros P Pdec Q Qdec H;red.
unfold carac,finv ;intro  x.
case (Pdec x);case (Qdec x);auto.
intros H0 H1;destruct (H x);auto.
Qed.

(* Probability to obtain 7 or 11 *)

Lemma throw_dice_7_11 : 
 mu throw_dice (fplus (carac (eq_nat_dec 7)) (carac (eq_nat_dec 11))) == 8 */  [1/]1+35.
Proof.
rewrite mu_stable_plus.
rewrite throw_dice_7, throw_dice_11,<- plus_Nmult_distr; auto.
apply fplus_ok_carac.
intros x H H0; rewrite <- H in H0; discriminate.
Qed.
